(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   5294023,      94506]
NotebookOptionsPosition[   5282789,      94360]
NotebookOutlinePosition[   5283223,      94377]
CellTagsIndexPosition[   5283180,      94374]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Sample playground", "Title",
 CellChangeTimes->{{3.8601397412505856`*^9, 
  3.860139755017807*^9}},ExpressionUUID->"d0e8ddea-97d3-4359-93ee-\
9734776dce2c"],

Cell[TextData[{
 "This notebook is used for the processing and fitting of one sample. It \
requires the functions in ",
 StyleBox["Polydisp fitting functions all data.nb",
  FontSlant->"Italic"],
 ".\nIntensity units are arbitrary as the patterns are rescaled for merging."
}], "Text",
 CellChangeTimes->{{3.8601397453382463`*^9, 3.8601397964528313`*^9}, {
  3.8617669288125243`*^9, 3.861766945139561*^9}, {3.8617673062268524`*^9, 
  3.8617673066939745`*^9}, {3.861942912912383*^9, 
  3.861942913146066*^9}},ExpressionUUID->"7c1a7862-4493-4bbd-ad86-\
2d905071e2e2"],

Cell[CellGroupData[{

Cell["Select and plot the data to be analyzed", "Subsubsection",
 CellChangeTimes->{{3.854421099868669*^9, 3.854421101948415*^9}, {
  3.8601398442554398`*^9, 
  3.8601398549474306`*^9}},ExpressionUUID->"44c23e06-c6ba-4d87-ae3e-\
52595994b93e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Join", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Cases", "[", 
    RowBox[{
     RowBox[{"Keys", "[", "sampleFiles", "]"}], ",", 
     RowBox[{"s_String", "/;", 
      RowBox[{"StringMatchQ", "[", 
       RowBox[{"s", ",", "\"\<E72_*\>\""}], "]"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Cases", "[", 
    RowBox[{
     RowBox[{"Keys", "[", "sampleFiles", "]"}], ",", 
     RowBox[{"s_String", "/;", 
      RowBox[{"StringMatchQ", "[", 
       RowBox[{"s", ",", "\"\<MilliQ_*\>\""}], "]"}]}]}], "]"}]}], 
  "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"testsamples", "=", "%"}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"testsamples", "=", 
     RowBox[{"{", 
      RowBox[{
      "\"\<171_1.4002\>\"", ",", "\"\<171_30.9999\>\"", ",", 
       "\"\<171_9.99982\>\"", ",", "\"\<171_9.99999\>\""}], "}"}]}], ";"}], 
   "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.843296948142498*^9, 3.843296958212912*^9}, {
   3.8432972784145517`*^9, 3.8432973057271643`*^9}, {3.8432977131560783`*^9, 
   3.843297716018899*^9}, {3.843298309901671*^9, 3.84329834918407*^9}, 
   3.843298997733918*^9, {3.8432990321174*^9, 3.843299072004407*^9}, {
   3.843299122424327*^9, 3.843299133661518*^9}, {3.843299265884342*^9, 
   3.84329926858108*^9}, {3.843300103749148*^9, 3.843300112466827*^9}, {
   3.8527849855621357`*^9, 3.852784994200242*^9}, {3.852787417047249*^9, 
   3.852787424091958*^9}, {3.8527874789702*^9, 3.8527874801375923`*^9}, {
   3.852787728214538*^9, 3.852787778738393*^9}, {3.8527968489630823`*^9, 
   3.8527968515622187`*^9}, {3.8527969362639837`*^9, 3.852796936383173*^9}, {
   3.8527970088774014`*^9, 3.8527970089163847`*^9}, {3.853836617160633*^9, 
   3.853836617592147*^9}, {3.854421141973649*^9, 3.854421142035899*^9}, {
   3.8544211928939333`*^9, 3.854421193010366*^9}, {3.860120705408345*^9, 
   3.860120705446088*^9}, {3.8617632879814606`*^9, 3.861763304765732*^9}, {
   3.8617673092767124`*^9, 3.8617673185406885`*^9}, {3.8859734491964083`*^9, 
   3.885973455500765*^9}, {3.8859747794365234`*^9, 3.8859748137649736`*^9}, {
   3.8859750181935196`*^9, 3.885975018432844*^9}, {3.8859763176629515`*^9, 
   3.8859763198468237`*^9}, {3.8859770271978893`*^9, 
   3.8859770297569485`*^9}, {3.8859774963407874`*^9, 3.885977500029621*^9}, {
   3.8859790256696296`*^9, 3.8859790880678005`*^9}, {3.8859792862203617`*^9, 
   3.885979303353922*^9}, {3.885979636059869*^9, 3.885979636325242*^9}, {
   3.8859798673963566`*^9, 3.885979867979951*^9}, {3.8859802087472224`*^9, 
   3.8859802091063414`*^9}, 3.8859802670443172`*^9, {3.8859805336112413`*^9, 
   3.8859805370509305`*^9}, {3.885980676883481*^9, 3.8859806770585265`*^9}, {
   3.8860615694895253`*^9, 3.8860615965610476`*^9}, {3.8902035063775234`*^9, 
   3.8902035070815973`*^9}, {3.8914972133528996`*^9, 
   3.8914972138838634`*^9}, {3.9023888059468164`*^9, 
   3.9023888069662485`*^9}, {3.9023888909848557`*^9, 3.902388892984962*^9}, {
   3.902486811061257*^9, 3.902486811799328*^9}},
 CellLabel->
  "In[171]:=",ExpressionUUID->"288b6ba3-0e36-41d8-949e-a2c664f880eb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"E72_30.9849\"\>", ",", "\<\"E72_10.0001\"\>", 
   ",", "\<\"E72_1.5\"\>", ",", "\<\"MilliQ_30.9849\"\>", 
   ",", "\<\"MilliQ_10.0001\"\>", ",", "\<\"MilliQ_1.5\"\>"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.85278774182577*^9, 3.8527877823161783`*^9}, 
   3.852796852362589*^9, 3.852796937189692*^9, 3.852797010008708*^9, 
   3.8528624946560097`*^9, 3.853381366643115*^9, 3.853381473062273*^9, 
   3.8534022376061707`*^9, 3.85346909236896*^9, 3.8534962759553757`*^9, 
   3.8534996218158073`*^9, 3.853817842919454*^9, 3.853818242802884*^9, 
   3.853824682294836*^9, 3.853824869851644*^9, 3.853833074084684*^9, 
   3.853836452539434*^9, 3.8538366226871643`*^9, 3.8538385385329847`*^9, 
   3.854072553810278*^9, 3.85409167434895*^9, 3.854098459654634*^9, 
   3.854420757546021*^9, 3.854421148417843*^9, 3.8544211935109262`*^9, 
   3.8544236425084476`*^9, 3.860120714271991*^9, {3.8601208146323557`*^9, 
   3.860120817823097*^9}, 3.8601209904370317`*^9, {3.8601401966367846`*^9, 
   3.8601402016808*^9}, {3.8601411929801598`*^9, 3.860141197066132*^9}, 
   3.8617633119613857`*^9, 3.8617673196071157`*^9, 3.861941017862147*^9, 
   3.8619433170388165`*^9, 3.861950007077615*^9, 3.861950097594084*^9, 
   3.861950313053934*^9, 3.8859734561647086`*^9, 3.8859735723144336`*^9, {
   3.8859747343360167`*^9, 3.8859747430702314`*^9}, 3.8859747970713787`*^9, 
   3.8859750198706293`*^9, 3.885976323503401*^9, 3.8859770304553003`*^9, 
   3.885977536755321*^9, {3.885979057328891*^9, 3.885979092434539*^9}, {
   3.8859792905705223`*^9, 3.885979306593282*^9}, 3.8859796400840683`*^9, 
   3.885979871667265*^9, 3.8859802113912177`*^9, 3.8859802706713324`*^9, 
   3.885980540538966*^9, 3.8859806802452884`*^9, 3.886061601230296*^9, 
   3.8861522211573744`*^9, 3.8883109765610237`*^9, 3.8890022652170677`*^9, 
   3.8890603226490602`*^9, 3.88906456673145*^9, 3.889081912662714*^9, 
   3.88908274923429*^9, 3.889084479032218*^9, {3.8895035587135143`*^9, 
   3.8895035763897266`*^9}, 3.8895042359682283`*^9, 3.889668723612721*^9, 
   3.890203509837488*^9, 3.89020358352724*^9, 3.8909804837292213`*^9, 
   3.89098153769302*^9, 3.890982738443742*^9, 3.8914160072605443`*^9, 
   3.8914972154035673`*^9, 3.8914975432719035`*^9, 3.891498587225662*^9, 
   3.892613775368435*^9, 3.8926144482288322`*^9, 3.892695999633297*^9, 
   3.9020371032316065`*^9, 3.9020419939951*^9, 3.902293358308179*^9, 
   3.9022934769339275`*^9, 3.902296666667019*^9, 3.9022975254696093`*^9, 
   3.9022975853820953`*^9, 3.9022983612995796`*^9, 3.902388894211306*^9, 
   3.9024868140543785`*^9, 3.9034207990904484`*^9, 3.9034300918427706`*^9, 
   3.903592074571635*^9, 3.904034454908347*^9, 3.904110436421341*^9, 
   3.904123923628447*^9},
 CellLabel->
  "Out[171]=",ExpressionUUID->"61a06566-e3cd-41ae-ab88-ed3c909e668b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"dataToPlot", "=", 
   RowBox[{"scatteringDataSampleAveraged", "/@", "testsamples"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"plotDataRaw", " ", "=", " ", 
  RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
   RowBox[{"dataToPlot", ",", "\[IndentingNewLine]", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotLegends", "\[Rule]", "testsamples"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameTicks", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",", 
    " ", 
    RowBox[{"(*", " ", 
     RowBox[{
     "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
      " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
      "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"5", " ", 
          RowBox[{"10", "^", 
           RowBox[{"-", "3"}]}]}], ",", 
         RowBox[{"10", "^", "5"}]}], "}"}]}], "}"}]}], ",", " ", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.01", ",", " ", "0.1", ",", " ", "1"}], "}"}], ",", 
        RowBox[{"{", "Automatic", "}"}], ",", " ", "None", ",", " ", "None"}],
        "}"}], ",", " ", 
      RowBox[{"FrameTicks", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
        "LogTicks", ",", "LinTicks", ",", " ", "None", ",", " ", "None"}], 
        "}"}]}]}], " ", " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"FrameLabel", " ", "->", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
      "}"}]}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
      "\"\<DataRaw.pdf\>\""}], "}"}], "]"}], ",", "plotDataRaw"}], " ", 
  "]"}]}], "Input",
 CellChangeTimes->{{3.84329809635746*^9, 3.843298105573452*^9}, {
   3.84329815837682*^9, 3.843298163080853*^9}, {3.843298211914578*^9, 
   3.8432982378108053`*^9}, {3.843298288845417*^9, 3.843298291452414*^9}, 
   3.843298361191868*^9, {3.84329871517915*^9, 3.843298719649724*^9}, {
   3.843299850907208*^9, 3.843299962957724*^9}, {3.843300008752656*^9, 
   3.8433000099440603`*^9}, {3.8433000666678867`*^9, 3.843300081842258*^9}, 
   3.8433001270605783`*^9, 3.852785029476323*^9, {3.8527875156086903`*^9, 
   3.852787529623748*^9}, {3.852787908039447*^9, 3.852787908637274*^9}, {
   3.88951548143122*^9, 3.88951548156557*^9}, {3.8896687353498526`*^9, 
   3.8896687417207317`*^9}, {3.8896725688232393`*^9, 3.889672590126113*^9}, {
   3.889672623190502*^9, 3.8896726983115826`*^9}, {3.889672740640524*^9, 
   3.889672758876796*^9}, {3.8896729834503565`*^9, 3.889673069010479*^9}, {
   3.889673142722207*^9, 3.8896731964734883`*^9}, {3.889676349237294*^9, 
   3.8896763709122796`*^9}, {3.889692253576544*^9, 3.889692254563936*^9}},
 CellLabel->
  "In[173]:=",ExpressionUUID->"6ebf2b6c-fd73-4115-90fc-264fde664a3f"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUV3c81e8Xv3twjetaUUqkjb6EBs+jNJSSKJWGEZKRkZGy22hIkkop0qAU
FSmfY2QkuyI0RSJ7j3vv7/P7y+u8znPOe5xzPq9L3fHIdmcahUKJY1Eo///r
v1nu+ZbLypC19LOkiVgDr5xJCyuzUIZ3uoV1zj1z8ajztfZYnjK4d904ns6Z
izOuhg2r1SpBZck7l7p16rgq7K+L9DUluDYzYtGFh3PwC5/mOVQHJRgpWRic
oTwH34x98uHhUiXo73hwY3L+bNw7h6laOq0IQWo53Dk2ari537JhZrUiSNiY
vw9InoX397zRP5GiCJ+c179IGJ2JX/8Ql+UGKILXZ5NnaQ4zsdJA09qMLYqQ
N11dX1ilihcs/l2rr6UIE0qZUyr2qvje89t79SmKQOSec6gYVMF6wm/sSy0K
0HZlr4J3hAr2EpnV6+QqwLfGyDX/tMi8OktadFUBDF/3VEs1zsBXs1y0/xxV
gCeL2Y2XImZgk9qSE19sFGDhveR9zCUzcNW98O8lyxVge+i6kbQuZTwp2Pow
SUkBAgqsc9ZnKWMjvTi3LZPy4OvhU2Z3XBl/9rT5UftVHt7FdxqwNivjtm+L
8mcUycOY+U6pIXllHLk/MG5Wujw4LfqRG/pXCauO1VbWx8hDoUvOSlymhDl+
Aad0/eTh93nBAiJPCS++sPak9h55uJpvnffimhJeVtas9s5UHkr337zn5KeE
Bc7ha3sWysPapmzKlL0SnhDe23JHTh4Iw8K2sPVK2Ld3SLppSgDzNxy692Cp
Ej7f7wMX2gUwt028tEWghDfw0iYKagSgskSSm8xSwj9SXj5wei2AKin6bZ1x
RVz0S40dlCaAJeejo9+2KeIl53emjl0SwIbTCzWfVyti2zX71n87IYAHl2Uk
tEsVcUvHu5H5bgJYVLzg+PVcRTxkmzlcu0MAvoX7/jzNVMSLlga8/rRGAN8t
Yh8dvquIy2r/9P2nK4By+v7PrdcUsd2e++7tswQQt/rTp12XFfHG6gntLkkB
GHimBRtEKOJT51odTSblgL0z8ZjNMZJfkvmO751ycP/Z4w+VXor4SFj9kfeN
cjCyqVJp8Iginr8fWwlL5UCuNfPtiYOKuFIiOMX/pRwsWM25WrdHEWsYv168
7L4cvHr+2M1jhyKe/vb609IEOfitvnnopLki3oAFyW6n5cB52fLFMzYq4oUT
L5J+BciBdFyGSoKJIpa+Fz2W4CoHqcyCRT1Gijivdf7IyV1ysPbGWQ9zfUV8
3jLhzyNzOTg4xyzgrK4ifnvfeDl7lRw0C7u6uPMV8cVbn3ckLpEDdd3D3XcW
KOI1gf51e9XkYGWfIW6dTfqxLxVZy8rB8dNKC9eoK+KEiL84mCYHG8+ka/bI
K2K9EynxtcN8mHtUxElTUMS58/RHbf7w4fxwgs5xOVLfOR09VjMf7DJECeul
SD/m9mi2feCDZY/+X1dJRbz++/jTLoIPHyYFd1JpijjsRUSxajYf6mf91ZYU
KmBZ2YZd/vf5oPo72SF/UAEvDvjsO3qdD/qDK2qsyTiu+uas5Fg+qMt5Pqzq
VcDFL3o93SP44Hvs2NXIvwoYXNrC9/nzIe2W4qljnQqYVxhy3M+NfO9hdtfq
mwJ+L956PmMfH86dPii/q1UBL4k40MrezgfnL5v9mF8UsJ55x4uT6/lQZf8h
d98nBTyouNN67io+BD/Reu1Yp4DHb66Y/q7DBwfPiifuHxRw+KY5ojeafEiR
373u4zsF/HjaLiN3Bh9YT1K9Vxcp4IWGRQfqpfmw5Hpd1J9cBbzxsXcAl0Hq
u6B0cf4LBXy4Kd5634QsfFh34lV8hgKuijc4UNUrCx3LD0WcT1fAClZM1u7f
svBUBKb/3VXAmv/m54m/yEIJsT5NKkkBj/RJ90KNLPwSOebUJyjgp3Lmajff
yUJs9dy/ZlcUsE8mLr6ULwtXQp23UqMVMNUoyiX5mSxEmPh9PnpaAQcs7Dhb
ki4LO4XXbWLDFfCCub9e0pJlYWy35vtTJxTwlXM7j+6KlwUda7VnfwIU8Cra
YZt358lYL6V4xEMB2812+LsxQhYsvxm173VUwC++fIFfgbIwOqbxS34/6W+Z
T2Sclyx8X9WqemmvAjZ97lFo6ywL2/Y+4/jZKmDj8AjV//bKQu39Pdb9mxXw
Chf6MnVrki9XvvTzOrLe732q5iZZoLI7Vx4iY8PZs2auNpUF3UUB8UGrFfCz
+iQTVyNZ8K69MF2qq4CX7Zr/Mk1HFnwXHXeQ0lbAL5c2ao9pyYJb9M4d7Hmk
noetO+3USP9GlWzezVLA1zv9v9UpyMLMUT2JtfIKOPJ4S+AeKVloLVWLe8ZV
wPPe6zQOM2RhwjdLeI2tgHds+HbQdEIGTn/6V+dNVcAJHRCZ3ykDvj3zNA+N
y+MzGlLHbZtk4OjX7be/9cjjcVvNEvlyGeBIyc22/yuPs448aBx8Rcbc3Z7p
X+Qx/6fDfwPpMoAKtg/t/CSPFR5o2cgkysCKmV33lGrlcbFhEWFxVgZGVPUa
O97J45qd3yYfBMmA6owZb41eyeP7rf9iNdxk4GSkOD3quTz+aibHeLNbBnLm
AV+YLo+tZfjdPptkoC/K7chEijweblveYLZKBo4FaTquvCaPQ3zMLPWXyICD
kkkGcVUe6w4u6USzZODnqrNNM87L4ya9gS2u0jIgJbnZvixEHjNlxVKPxNKw
qHK8iX9MHn+PNithD0jDyj/Zn1iH5bHzQK10+C9pqL8saJlwIOt93sXKfZQG
uY2PljzYLY+LrNa3FbyTBsfj1/d128rjT4ke2SdfSQPV/c2cyxbyWA8bpTo9
lIbhvh1FCWvkcceXyH12N6Qhc1vNmqP/yePEjMGz7rHSEHSrOve/hfL4i0lv
3ZUwaeA3PwvpV5PHblsutTf4SMPLqeo5R+Tl8eYFN30XH5SG1dMrUtaw5XGk
r+/CpJ3SkBDpf/zwtAAnYNab2ebScCJw3PrOlAAviKv/mr9KGnRFwbsV+gSY
q1G71ktbGmxVjxCOrQJ89JJ7qoG6NPiFdhue+yjAmjXHX8nLS4Mou8LB8b0A
G/cZGXDY0uC8yaJZSAgwY7Fei+ykFGxe+vhwcq4ApxlvctTukQLz6ESJo48E
eLU49az9Dyn4nRNf/vG+AKesfchLb5AC57R/KYsSBThoYiiTWiYF1SsT5PVj
BXjmGaul3q+lICA1fKZKuADrOL20GMyUgpnjC/IWBgnwn5X8d2dSpCDjv9qu
nsMCPGdDr5fuVSmYM1H37dQBAX4dupv576wU5I0UNizfLcDuvSlbX5+Qglfq
T9YomgvwhbaZcje8peC87mhPkakAjxGzlS8clILlmvfHZxkI8MTUxMIru6Sg
p0bn+rUFAiy9o4//yEIKjrjFLBufIcDn5/93ox5LQe71tIA4vgB/H/h6mbdc
ChgUqWMPmQIsSxkssl0oBbNOut/5MSyHW40tprNnSUHW2BULo1457KWdylOX
kwJ3Jbn9Ob/ksCHndHEySwqYCVjv0kc5/H5oy8CSKR4kO4YbXa2Rw2c8NFwr
+3jgEf268uE7OTxRODx67DcP0JW2n67P5XBDrq+f0RceSGe0Vcimy+HITbws
VjUPXt21qhXdlsO2kV3hv4t40OC/xlYjUQ5bBv57XfeKB5eubi3dcE4Oxzjc
06vO4MEbxZLWayFyOP391sIvKTwQyTodH3GXw92NTSuHE3jgGhZZvspeDhdk
1gfOiuGBrOmfT6UOcnhHt/e2HRE8mC+b9sR0mxxmmZy9dSOAB+OP8+/dM5PD
bpLnjfrdebDUJNEu3lgOz31QP7jdgQcV7r+EKXqkvkL33OKdPEir9j1oO0cO
a6fX2K2x4JG/R8IW3ZWRw2MjRbnVpjzoaTs1e5oth03jrz0+ZMgDq6zCgfcM
OcxrXMiXXcqDNvfODzfG+dgj72tpyVweaGndPjtnhI+/zbv56LQyD75RhGV1
7Xz8cVtt0g5p0o9Xt5aNfeJjOU3ngGUMHpj0G8+pquLj7a+LZqpMSkJTJ/9F
RREfZ3ZVesr0S4LA8pjBhud8fKCtxZzfIQlGGUbSmzP42Luh+PLsVkm4LdM+
a1UKH3+4W661sl4SlEvf/W25w8eHc+902ZdLAutR3xj9LB8rVPsQVwokweq7
ybbycD5WrWsIq8+RhLNPfairffhYFFyiNuuxJNh1zz2h7sDHqw3uB/qlSMK/
3dz0d3ZkP6sNXp+uSYIetYxqY8nH+ttaOtZckIQDJ3PTi9fy8XLuxLv8k5Lk
71/lhWUr+Xi0OrEfHZeEh7tEVS0GpP57chY1PpIguWf9H/p/fOweNLPA7ZAk
rAu0pS6Yy8frj5YvkTkgCey3Mp/mSPNx7MaoUGKHJBwNrDAJY/KxV4xcUrCF
JHAW1RIGdD4emHvFBa+VBC3BnINvx2Qx91FgpexKSUg8RRsN/iuLLw2ezurW
lQTDU4pBId9lMSWiWVg7n8QrWh7/uFoWpyh+vQFqkrB7MerXfyeLaWvN/V4r
SIJHiMeSNEIW+wjnexbwJOH3s4ye1VmyePv6Gt8PdEmg1PrFVNyXxTK1Pzx/
T0rA+0G9CxnJsjjg6caNrEEJSJccPeh4SRbvEqz+t+yvBGTOvdxmckoWL6Mb
mbn+kIAdxTpKlEhZnKFJWXW/UQL21y66fSdIFreeuZXfWy0Bzx03uJl5yuKJ
Y/ue4VIJ2Hs2O6nPURYH769l33wrAeFv+2TV7GXx/gvljygvJKCcbSu910oW
nzTefdorQwJoCY67J9bL4jbnT6fb70nAioiC4NemsjgytzrR+YYEpN39uvWB
jiyWjJd/2BsnAUZKee+xhiz+SMlODT8vAf8185maCrJ4+fOBINVICXhj4mTL
l5fFc6WsBcQxCbjGuOShy5bFhXpXHNx9JKBz4fedhFgGMxXTrea4SYCIZaap
/EsGC87k1321lwDVEsNI1icZ7GCrX3tvlwS8KN+ZsrlCBnv6PV7lu00CJNo0
2Iq5MriP1U8z3ygBZ7fTFOOeyGC/VKbCAiwBNTTPkTvnZbC+j4aDjBGpn2Cc
7I6SwfN3ZH8W6UiAu4GRffthGaysY+U8Ol8C1G3Cvg3vlsHlvPfTI7Ml4PHD
/3i3LWRwh4tqrFBJAsZTU5RzV8ngr/a+LClZCZiv8da+b5YMtuEt3q3JkYCl
8w4Sq5Rk8NasGv+1FDLWYOc78WRwk0B5y+FxLsDgIrd5Ymms9aGzJrGfC+2D
uxt5v6UxvhT3q7qTCwv5yScW1Enj8davF3k/uWD3qCYp+rk0bl3p/MbqCxfc
Esu87idL47ayvN3JdVzIWnZCUfmmNJZekLB7sIILSovrRwLPSeO8jq+ZW4q4
sFp2usLcXxp/b765Mes1FwKaQ7Ku7CbxLrBmqmRz4fPaIQftndLYNt1fJfox
F5xGXZKe6kljwU53A3oqF6in3rMvL5HG64svOEbe5AI7fTHVVyCNsyMzLnOu
ciGBf+znfp40fsl++fJqLBfkKuN1UI8UdptZWLLwNBeC3i4rn9cuhbfYsZ+W
hHKhfv1KhYJWKWz7uP2QSyAXLJpCJNo/SOHdBS3t0t5cMGk6pP6vWAoXXY6e
UXCIC1dddHbOyZDCNwdyx/wcuGDesmPh9GkpXCLceFR3DxcenI+Tso6Qwluf
mUYNbefC1L5wWjQZMz0qlN9u5sKFNBnrcX8pzAjVWhhrRvLXPzJ74UES/0XB
AydjLqhobwEXCyl8tUcxBhtw4ciqbxuPmkrhwJT6Mg0dLhz/yGvIWyqFrUKz
t0kt4IKLZXx3oQ6pbyJRVTiHC44pO8OOSUnhJX/CZg3N4ELXrbj5S6WlsKZ8
5OY+OS7MXCfb0c6UwrnfPyUNSHLh40Ve1anfPJzcVEWZZHDBPROzS6p5mGXX
5MsRccD7nwg2vuNhJ92wjpljHLjq73bU/C0PN+u6Whn2c+Dawx+c9BweNu2w
fGj7lwN530SN0ek8nKUr+B3yiwM7Wfol9ed5OOlf6tjDFg6cDvptphPKw/uS
5JpbPnIg8kWpY4ofD9uwoyIE1RwIvuHD8dnHw5vHl//eVkbWl7xUV9/Aw4c+
RY1fAQ7oNWxQqlvLwx62X3Na8zjgr5DZGWLKw9YGlTKLszlgdp5xlmXMw2Zf
esShGRwYTTgS4afJww1s4fGmNA5YVd66qK/Cw5E3y4INb3PgIWvpIQcmD582
0hu6kcgBrwruqbZBSVw+vqqVGceBx1GXx30+S2KlJcNL/KM5IEgskjaokcRn
JE62/j3JAcuuazadhCQe91z4yymUA/MPJ2yofCaJ30UbLm8L5EB0uEXv9nRJ
fPapYpWrDwe+L/t3TO+uJJ4cXZsycJgD0udDXDxuSOIOaauH4Qc5MMVfOB4R
I4lXz7Wvl99P8tf4OqgVJYmXrlq18IktB+Qtd2ZqeUti/l+NGxZWHHh5cvXT
hc6SeE301Oz+TRyoLPz9p2CNJDatffk00YwD2xYs0RlZIYmfB+1bs96EAyNH
YvW8sSQ2VpWoHTfkQEub3MBbbUl86O/fbVnLOMDC/85ckJXEFv6r33os5sDX
mBReqYokNgiyltKex4EHlTjKgyeJNZLiVgyrccA5/+Kp8WkJrLryyEpCmQNq
O/c9LR6UwPsNvTkX5ThwcTRhaPlfCeyev/SmE48Dc/xfBet+ksC1DKve1SyS
L9FC/XpfApf+Fz+mQiHnd6GATnkpgVP4RVnCCTbozQnzzHklgQf+vJBrH2LD
MA7uME6SwAFmdop1PWz4YW9jYXqSrP+QmVP4hw22slJvYsIlcA4vr+PlTzbQ
fHvZ3EgJ7LY+MS2rhQ1Izexqc4AENlgb0PXkExvSsf7RQFcJLD8v9smzGjaE
MmiE73YJXG2k1Z1bwYaMqG5xPRm3ll+/XlLMhg0sdvwRYwn8u39r9se3bDi+
NjY6C0ngFp/8ZX9fsYFrVKSssVQCV552kqY9Z8N2yt/bjeoSeNXrL2tmZ7Ah
2MkqblJBAi97U1CO77OBXSW2Ps+SwGVGhddd7rDBk75hdresBHZ6euvppSQ2
XIp1MbrJlMAnNqkxiHiS31nxGfW/XNz/SuXywAU2VCkdbNn+m4t7qEHbFpxj
w8zmrux937jY9dCC1U5RZP+wwm6fr1ystGrx1rshbFAb1qXsL+NiUXZMeHsg
G277Tadcf8DFwfXOVUt82aA863ZATBIX1xm0agd5sOHpy9RNC65z8QaR+u0y
FzYkLCL2Z5/j4qzb/sqqDmzYVBOcsOECF4eWq1/1tWPDOhmng7zjXGyxMkSm
egcbItR/DEp6cXHHg66IpdvYkH+r8+E3Ny5+k9jUcWkTG1L0n4n693Fxi3Gh
0bgZG6r1zjmvW8/Fm+0W+TohNuzoTGMINnLxn7lpsfUr2CDwa3XlanPxHYXq
U+v02XD9dvSL4HlcrPPbYscbbdKf4i3jg6pcbLjt46jBQnJevg4L187k4kqp
uc4vNNhgxt4veKnCxQfSREmGamwYv1r3dJYkF8/daXzlrTIbmnTVXvSOcfCb
BxVog4ANcWFHhsx7OLgzPSDzoxQbzmm/UQj4wcFmN0yqnTlsENEeHHjzjYNX
nlC7NUljw8Air95Znzn4mMcshStCFig5F3WM53PwxSSLZTrjLLh9d3pTfw4H
d2mV/aseZEHfUW/bkQccvIT7fI1vDwvUJfa0PLrPwa0jq7RndLJgcw+jLTSW
g93Nbj0q/sUCI5/jWx3jOTjhk1K2z1cWzIqNbnrsycGCydE1Gk0saEvKymw9
ysG3dl/c0VTPgjsnLHet9+Fg82aTjktVLCiIeJD4LIKD9c569FuUs6DOsjeh
wY6D/UPOHuEVs2BO9yH2LRsO9nsveaDmLQsStM/khVqT+PuDXl/NZcFoR/TU
c2MO3t+/K+RANgte7/PyoCzg4FWd+N6SJyxoOWdOcOZysM3GD/OFD1hAKaM6
nNHg4LnXbrPq7rFAK/B08wcBB2+scF31IJkFFixi3hoOB/9Z3FwYeZ0FDlOV
Ox1kOFjHMueqfTwL1oerDb4fZmOjgfznphdZ4DFw6GPeIBvP+Vsgr3WeBfSf
GTZlzWzsKnflldQpFhxeGP1ZqoON44wUr42HsWBDoHx76Ac25tK1n3YEs+C+
dWnKPoKNV/8sm2r0Z8GjjDP/ul6wsXC0KeiDNwskrfaU6d8n+3P3zy1xZ8FI
ZZAw8iIb7zhsN1zgwgLtl3VXwi+w8crO1q43DizA9xiOqZls/Dx3hFqwlwX/
AjvWep1hYzdXWF5kywJR1q/dttFsnFy8P7JiOzm/isaVp8PZWLV6oq1hCwuU
Y1ad6XRjY8/0wp0/N7Jg2LFiuacNG28L7fk8sJYFgSUj71ftYOPNofn2TMSC
Q583LKneyMYXCrz7VVey4LvEZNf8lWw8qrs7cvlyFhRbsjw7l7KxzeUyue26
LDhltBH9WMLGX2wUkn0Ws8DmhbOZpgobv7l+d068FgtmFlGV0Xw2llf6nJCn
zoJ9zo+7fvLYuJE3S/hzJgsKPSwXmE2w8Ez9bkspZRZQW5/K9Y6z8LGnr6NX
Ccj9eD8A7AEWvjElmekhzYKNWNdmdgsLS/9wzrrDZYG7rsX3kCYWXmS/I66R
wYKO9ati931k4WUZnpZ8Cgu+vnP+VvWehW/Lbfy9ZYoJM85Jfil4w8JJA1Fb
YkeZ0FOcDd4ZLJz4oPRMzQATPC1Hy3+ksfDi8/kX5XuY4DFuJwi9zMIDVQLH
vZ1MmNMTuSfnLAu/jTw9db+NCR07Nu76fpKFP4fX7hr+xgTQrOqYd4WFPffm
BJg1M2HqhUtHSBAL6+yatLr2iQk1pqai6L0szNvl/edfLRN+dPx02GDLwvIf
/+qt+8CECz8Wq62yYeHzlUj/ThkTJB0nJSJ2sbBU7rZ2YRETml+YVhruZ+GR
cIrZ/gImKJ+QpiivY+EPXkZbCvOYcFq5Ykbschb+q/ZHqPWCCYeW7kniKLCw
fiDF+mIWE/40VdmsXsTCMkkh5pOPmbDYxGjJAJm3bd77zTWdCYsqSiJyVVj4
ytMU6aa7TFjg+HjeCmUWNn5k07gpmQkB9x1Fz1mkv4eilsN1Jmi1sWmjNBY2
OIe1jK4yQSa2MWjxABM/u3fv/vNLTDhlOHU6vpmJfVdUZOvEkHjvtwQ01zDx
rYz6TU/PMCFm/csx3womztfvOLQsignxZVMSb14ycXuDtuTLUCawNqsuSXzL
xByLVm3jYCbMWyxf1glMbNUdVVTqzwSNBcKK3odM/Gl92o/tPkywd/A/zU9k
4rKqz4E/PZgwM2NvRF8CEz9v2nPK9xAT5Gel0necYWI1iyAW6yATvtc5Bav7
MXHsheDxGweYIOtU7nKcjE+FPtulb8eECsVj/sLtTFx6yEezZicTrpQM9Yxb
MHGMSG63x3bS//U5+0q3MfHo5qEhya1M0GZLqG3aysQnn/gNZpoz4fL2oOSb
65g4o3LCavs6JgQJ+18qkfXRZ/pkJjDJxzSpMUWPibOnihbeXU3616hYHmTE
xFyvjptbjJjQsNbDI4VP4m+odZnSY8JdSPUun8PEp3lTJx/rMOGtv6F8jyQT
B1m1D+9bzASz529KPgwx8O0cfo7cfCZwt/82vitiYN2PLKiYy4TVnTqh1ZMM
TFtvqRilxgTKwJ7N17oZWOnisRwTFSboBRjcLiDrTVSVE6cVmOAjL1yQ1cXA
ZfqFBW/45D5+hGvLPjHwlmlprTApJnS3lqcx3jPwDfvblWu5TEDhi069qmDg
e4rymRJMst+i4cL3hQx85rJceQOFCQMhOuN/chj4zeRaldvTDFBx2ziR+4yB
0aIdKR7jDGjujXrQlcrAP5JH96weZsCvsr1RRtcZ+E5Aq5l0PwN4fjO/m91i
YHXXgr2/uhngNhfdrzjLwMte2t7J/cOA491z62ZEMLDdf65Sl9sYMDUS/jX1
FMlv8dMU9+8MuJFzxIzmzcAqHiN7NrYwIOvo7ydvjzAwdRndcH4jA4wf3vV6
b0PWa6TpcRoYYCpO8pm9loFlrB5v7a5mgOOOTa1sUwbunPf3VO17En9t7jDf
kIEzDy5vfFXKgCfsonhJTQbePucwTiligMRGRVrvEpLfi4NETAEDdJLNjmmT
8b4i5vbg1wygFA7GmOoxsHjuslG3lyTefe1OjRkMXP6n6qHdcwb0ZGT3x7MY
2Htb6WHLJwzArC5ewQQdb33HNlz3iAFR7/60zqUwcH9tJM/4PgOusg8yLPrp
uGnG4r8Gdxlw3XkuhdJHx/p7x97/l8yAYzFLO7cM0fELp59PdZMYMNdGrc/m
Kx17MTuu6iYwoPVKzLPgH3RcOoN5/L84Bjx7KM1Cv+jYP8B0n8EFBiTk2S8K
K6DjS513Vq4+z4A51emJdvl0/ER7Cd/sNAO8Ch7zy7PpmDvU+21LJAMCGn7d
fvKYjuHdWMruUJJPTJdu/gM6VlXatcs1mAGvf/y3gR1Px23LNCmBAQxQPOx6
riaEjt8t97t21pcB5rsU+8eO0XEJ/8DMm14McM28V/TBl45zQxmxzw4z4AAl
25F1iI6/TUT+KXdhQG3g9iXPPEk9xPTCX44MSPNxlo8/Ssdr3yVsF+4n96NK
aR/hRcdxL4IOqNiR+lum43aS+Ud/P2xdYcuARZtWm71ZT8fEQVDbY82AKvuj
O/6zoePy6siqE5YMWHaqmb6KjF2OrN+dspkBH2KOdCSZ0PHHBRjKNjBg31du
k/N8Ou7wTaf0r2WAZODNj0ladKyy86WyCmZAGOfwq8QZdJzu8pC1fjUD9NSf
j1WokDFBlPsZMYB2YmKOJJOOkWjlvnv6DJh5p5gZLEvH31cfKPqoy4COzebh
QhodR0r7jbKXMmA8jz+SPU3DtGBibPVCBoQ8zjBu+EjD3iMXS/zmMeDun+nn
G1poOMThP7sMdQbkM1rvh/2h4R7GWF7HLHI+Rjs/QwkNS53V/T5XhQGq2/W2
TZP1uF+vwl6RAZsdF12/mUfDsTd2BdyRY4DsT+9lkhU0vGL1+O+f0gyA6cak
45k07PPRSzBPkgEN8e/Spa7S8OgzFcphNqlnmJIbmkLDX9z2PsyiM6D3lHPP
3AwaNvmYIDUhpkO3zC77w/doeBFHZ/HaaTo0s9ebH42n4T22MZSL43Sw2si9
818sDWttUo5pHabDuP3Aqp2XadjlhsmHxQN0qDoaX20aSsNH9D2JEz10cAzb
hWYE0zBrofzBmr90ODq2bt26/TTslZ2Wq9FBh139noS9Bw0f1U3IP/aLDpm6
83dY29PwedW97nXf6BBdvf1y5Voa/i3hXbqohQ4HDz4a/7KehtMfW1SeaqTD
xK6GbWaYhmcUeAX9aqCDq/lYrNxqGv7O3/EB19LBO+A2ZZUaDaPI8Hd3PtAh
xcl/X/5MGnYf9HOkVdDhQ16SYrc6Dbea56Q4v6ND5TGvOhs5Gn7oXR7xvpAO
M/4ePDuLrO/fvIK6rIAOkkzal60cch6vL6tdf02H5KLDI4/HqFiJe+sD7RUd
jizeKrWWQfpn6avulU0Hy8TU6Jx/VJx7tEWm5Skd5M9lBBeSsaSqe4J5Bh0E
J61vy0xScVDli+y8B3T4+lLv0opOKhYPWbksTqPD5+xIW5cmKv7X1piRnEKH
dWrFsQtLqfhU+c9TgmQ6BKwYSWiuIPs/lOw/l0QHi0jTuNZ8Km52GfpLvUbi
WX/IGSykYudsI9/jV+hAsU69ca+aigsFIWdGL9IhZPRO3j/yvXyz0wK/GDr8
uMx+8jqb1KMRZz1wlpz3gi+fLt6k4pH6J2yfU3SIL9LjZZ6j4iVxjmsHI+iw
QP67yvtTVBzy3pbpH0r6G7r+wfM4Km66t9JiIpgOD251FPYfo2Jbap5iWCCJ
9+l9RZcfFRuHRjqxjtJhTsUK94NRVDx1eOOyi950OBVNnJXxouKV79+GzvCk
Q/vygFNx+6m4b8u1TWludMidvlX0aDMV+9tEX/nPhcRfdygm8AAVP2i32lXo
SIemicTfNEvS36zUa1YH6KC03kvhkDUVDzPRtjY7OuA/sxTmbqPit81fwwN2
kfljAYXBOiQ+gRZI7iDnuUdr5w1NKs77pbkuxYoODr4XRLHqVFzAsfxstJUO
3w+ptayZQcUNsRHNdZvoMPI8zYwzk/TPIWKbxwY6ZO+OP5k8n4pNaQqGHDM6
1EWGPx+VpGLVMEZsGqYD094/7CeV9N97hpWZMR0au55s/skg/Z5Qi/y9gg5a
L0ZD/rGoWBd+qp02oMPS46OpzUwqfj2go7VQjw62Ty2EpVMUfHzll4QqHTp4
fl/3PfgbBRe/e3LEbwnpXx9Pc10zBQ+vjHqqspDku2lO9IpPFCx+vWhH8Tw6
3K6HS74NFDz6NfiA51w6jLV/PfCQoOCrWZuqlGfT4XFAwomgUgpueeZ7650q
uQ/slqJyst+d2g/Vfsrk/iVnWXjeo2ADN317DQU6XClAXJ0sCpZce3rbRz4d
Sofo7hIZFLz9wp3k09LkPc5eK+mdTsFPfzqar5SkwxYbf3z8EgX/NXxi2cem
g4pU86tfoRSc2nMwK41B7qej4VN+OAUrEocP76PSYf4D9Y3TZP7Du9QTiiIa
EBaHlP45UrBHwER77SQNxkQvX2JvCg5L3pYWM0YD1ZGsLE9/CkaOV/LMh2mg
Hrv4VO8RCnZbmaHOGaCBYZGq+vUTFMwfPN1a1kODuRJ8jbS9FByRKvv3bBcN
tuxfZf1wKwUr5Buu3/yHBhoayzTCrCl4dnf3oPRvGgTNOiCXo0PB9XpqvQ0/
aOC7dm+P9GIKXtgKBklfaSCO/i/2/gwKbvYuq3RopsGngdVmmmR+c5FWxqJG
GmRErbr7V5uCz/36+Hm4gQb//dgvcVRAwWs1KjZBLQ2Cr306zVCi4DrBNCu2
igayUtXn/dQpWCfMVcLuPQ2Otdrcm6VMwdKHWTaLymhQpnjvZBeDxJP99Guy
mAZhD7ffPSdFwbXttS8+AA14tMaozRQKlro4Xnn7LQ0GPaYyvlIp+NHvzZpH
X9PgirMt17FcjD72Vr41f0XyzYh/6XBOjHrbgq/NyaFBpnJM4cUMMcrR2ps1
nkWDjgFfq3YydjA7yq7PpMEhgYF44qIYfRksv5HxiAZ3F9749fOqGDVJO3ic
TaeBgPb8zU1LMZqXZBbknEqDLONw0XMHMSrKO1GwNoUG/3Ype1Hui9HiHIGJ
RjINdLiONItYMbrQJz9Kv0HOu12J7+4rRlL9Me3t12hQePfcrAonMRLuOCdZ
EU8DpQ8iLaOTYqTXquyaeZkGF0o8rVQ0xWj9zs1jcRdoEPXJM7Luhwj9fLIs
/1g0iccJGVg8W4zkO74+czhLg0ZZ38bHimJ0T8apedMpcn9uD53tnBIhB6tP
essjaWB6cmydyTsROvPT/O2cMBrc6SkzdhgWIXlmo7/UCRo43eXsbU4ToUXS
8XungmjADv3oMJgsQv57rnt3+ZPxMZ1f//JE6KIV5VmzLw3QUr/jllkidMip
beaHI+Q+mWe8MH4qQnms/dkFHjSoH339j3FWhNxfxfg9d6PBPcErxaLzIiQ7
ErM33YUGXO9fimrHRcjWNMTzlhMNZvXv7dgaJ0IRaiFp8fY0oAx2ULsiReiX
VCY9dh8NvLZf9L1mIUK7L2ifOb2HBs0Dj7cprBChJhVNnQhbcr7XuD2tiPRn
wbPJEzY0eNI+WL1ficSbP9l5zIoGcevVxkLlRej+cc2JwK00WBG+7sRtpgjx
o3YuCtxMg01VvS19M0So16DNJ3AjDXI0zSxre4SIZXT7V9A6cv96b9dd6RAi
9KLF5/gach/ar15+UitEgZ+K1MIQDZSHXpZJfROilCdhnVGrabBaMuYg87uQ
3C+T6nMraPDge3OI8LIQPTi9uOaSAQ1su8ojdB4J0Z5t/l2JejRYO0jxXpsj
RH3Om2bf1SX9jAkxnRsmRMpHmz0yltLgIO+8sfCMELlL76x/tYgG32PkJS94
CZHkk96tJfNpkD3yelVFpBDtzvr8s06TvOf/eCWeO4To7g7T8z/UabAm2af2
i6kQfSQcN/Sr0SChytxs52Yh0h44okydSQPtg92yDmuEaPp98rTcDBqcM3l1
ctVaIbLiaQ3NUyTv16BBomm/EME246kVAhq0XNdKN1ASIhWZWfKWsjQwMh23
X905jf5LFK12lqJBt+bK709/T6NkhZn+JyRo8LXaO/Zb8zQKOZuVH88m7/Xl
m8tG84RoVfmYzBMGeS+LeJZuT6eRQ4S2TzmVvP9rbQfnZE6j3fpx39pEVFjw
Nn5c6c40WqPvYEuZpkKSqzd79NE0Kkhrbp41QQVV3YPfr5L5khCTQ6tHqXCs
7bVsR9408g+vEtkNUUHqgMHO1FvTaABV3DrRT4UDlgEvNT2n0TLVo2bJPVQY
7vxrUn9lGv1azR+ELiqYBpqKcMA0wkm/037/oQJtG19yyZ5pNDLw3wFuOxXM
7K2MDa2mSb9MZ+n8osIUM937DppG4X6233d8p8KXQE+rxaYkH/Hr1JBWKtyN
PjPn+pxpxDbP8bj/hQqrwnk9K1Smkfe/aIPaz1RIudh4JV91Gg2ZR1OnGqgg
mGXs6jk8hcyipj9o1VGh6nn4g8CRKVQYvCjRupoK/GUjJhlk3qne3jGikgpD
voeRafMUetbVvSirnArWiSa/Ho5OoeyfygPf31FhH/ubdE/9FOq8vDxHtpgK
DszCuzvI9yaXL/mtASoY1jyv+JI6haR0j2n7v6VCyT+q3KfoKSQdhH4/eE2F
5Dg16aYtU8husX7811dUqHlTEhpA5o8UPzAWvKDClvyT1sVhU2iud9938+dU
EMfsW1HrQvJRtAuOeEqFNZbPPWoOTqE32xDvdQYVdB8qWgiPTaFt7v3xQw9J
vk1Pn+/lTKEe52KBdjoVbkkcuPiIfH9pQOqsWyoVJFZ6H7luOIXyj2gNpKWQ
fiwSscuWTqGTA05b25KpsNri4K0M3hRKMVC7rX6TCvfyK0cNlabQ8YzMX/bX
qcBylVaF5km02tNdOSWBCkuspEVSzCn00+QZ+nWFCiNHdO6VK0wh67gvtpqX
qTDqWhxeUz+JjkUie9cLVHh0OXaX69dJZNVgsutxNBW2JuvNPa08hbgDeqj/
LBUuiTxprwonkUrfcXmD01SIa58+NPvUJHI6c7TxRBQVPm5zpc7ZM4k2zjhx
piScCvbvD5+1851EdQ8GNKRCqaCfs+5a3fVJ9P6rfsbO4yRfjboZXmGTqJ12
f3ZKEBXa96+WCTg8iX4y7of886dCzLPw+l/Gk+iBT8I7Iz8qlM/6wfpExiGB
X0ZPeZP7bt4gMLebRHN+18l+9KTCf22r6L8PTaIxjTY5DXcqLPqm7naVTfph
6jPte4jU96ovLqljAs1r+/Gh2JkKRk9yY6vpk0hhy7UoBSdyHtTWpuP1E6h8
3+TsQ/ZU+Jb3hOlAmURnL3in5O+jwmGXTslxjUm0e9CeLWtHBfeVOlnNExNI
Z7melfMuKpzIj6+V/zuB1G9YhubvoILdebbApXcC3ROrXZCzJufVf+FDe8YE
evlRIvzwNiqM0Q64s/7PZ26IdfEWKtjmpVd5FU+gtyd/sGdtpgIRmuu2+tkE
il5652bgRtLP8DONzSkTSPbnfH7DOip8VsZ71a9OoHOjbQd11lLBeLiqTf/D
BNKyNb0Wg6nQudh2Y/muCbQ5JDO9y5gKkRXXjxaZTKBPfglXzVdR4Tjlz4o+
lwm069Nh+4dGJD/7/F9RlhPIpfI6W8KACt6Pwi3dHCdQtdSV8+56VHC7DYZH
N02g7p+lnVW6VGB2P904vngC/Z5xX32ZNjkPufqBwKlxNCy4q391MRUOrZXc
z9KYQHl5S9QnF1AhD5cljq6YQCfCcjsOaFFh4rbFHadlE+iYU+7JUg0q9Pr5
HSOkJtCyntuTS9Wp4HvV1UaxfxzlLmnbkKBGhZC734Zm148jyutRd7EqFbjc
pT9jhsbR0hxLF7cZVLijlHH1QPc4agcng4+KVDjl/Ljtfuk4uiv5sAXJUyF8
nqN937NxNGeV5pYMPhVc6nWjox6OIxNLvRszZKigovzAuqR2HNmZfHlzhkf2
v9v6Jo0YR1fMLjwb5VLBXKvshW7MODozpzLIhU1+T9Roe04HjaNncly5RgYV
5GqWGddZjyOitfDERhoVZmh8nnczfBwNwJHc12IKqKfvavMMHEfeEbElS4UU
mGrIXC7hOI6eHEi4kzJJgRNLuLjfcByVqLIsFMcpkNF1NPiWzjiqG9pVGj1C
gT/UDbxrjHG0556kDG2IApsTCth/f4yhR4435h3rp4Aw/mEBkh5HyztOcQd6
KLB44xU16vAYEu4zf+3WTYGPVO96/tQYGjh60LCtkwIKMWyu5M8xZLttZ/i+
DgpI5RhOtjSMIZ2LyfFNbRSgOLjl3y4bQzfM3/rZ/KTAlsbrou+1Y2i9rN6s
um8UcNhlotnWPoZqusMvbW2lwOktrQe8WsaQ9t4FVR++UKD95gut6M9jSGPX
4/rNjRSw4H1X7no6hlIsYu5UfqTA8bczCn4ljiGjmVsNLOopsNRYpCObO4ai
1I5eqaqhgN9hO9XZwWMocXbkK8sqkv/K4nznlDEUcGA6pf49BS6dQPF1TmPo
6GXX7TvLKeBSem3Wj4Nj6HnLxvLmdxQY2tB0ddJkDF34PI9uX0yBfl2/E18O
jyF+zElaB1CgeTf5r+H+MXQosPudRwEF8rMC2RM7xtD2kz8thvMpUDV1e2Pq
BlK/dG/CiTwKFGd1fztrOYYu/Uy8x3xFgRK1bvNCDolveNj3Yg4Fll3bup/F
GEOTuV00leek/t2cNWMSY+j1iXs2aU8pEHvymemGv6Moi6XmuiyTAtahnq77
28l4w+8VBY9IvCc/nF5zx1DbzfAPmx9Q4IABb10c2W9dTYhacxoFMjs1Wnq6
R5GawFXH7R4F0k6Ld15rG0UR7HLR+B0K+GeU3nv9chRpX1gQfy6ZAmYXL0xn
pYyiGZfVG1VuUqD8zBF917RRFOe/6E/GdQrs03QOTLw2ilY/7LuHrlHgW5R7
4qkDoyiF+XlJQzwFwkZX2C49M4ouzUh2cI0j9d0N+h11eRSZbkxymL5IAfbO
HgsDMt634DYvLpYCh+Y5m0yHjqLZb/5FLIimQMPTLUTenlHUddY9hThLgV9N
jG3pS0fR9YSIYNvTFMiLjj552HMUsS0iZ/ZHUeDkAz79mvsoUu7wcz0XQYHu
m115T01GUWXtoWCNMAroDx67YrhwFL2ZCF5ecIICfX9pWZXlI+joi0evdgdT
wKb1wNPOsRFUeW7ez5FAcr83NPAaNUbRyfIvtXH+FHiu9Itu9HEEHQzkuOr6
UWCu+4p78rRRND4RW1TtTYHtuZkGTZxR9PltQbGnFwUuGPz5vU80gsDC+ZyU
BwVs6y6GPB0cQVoH/w5lulEgafZvg+qbI2hLOX2upSsFkmdv6naoG0G5XjrD
/QcpYH5H7P/7xQjadVhw7oojBWYeoXpbXhxBC+uMCw3sKbBbMSFHLn0EVSub
5Tfvo0CBARq5VDyCttmX2YbZUWBVhN5gXOQI+ntl8wvN3ST+beX2O74jyK3k
ZM77nRSoful+0f/qCHI91O7nY0OBNWoT+x8fG0Eu7voflbdT4FhxjIaZ3Qia
/Fk/BJYUSNQ9ejrebQQdPp6U7baFAgNFFSmT+iOoVti8TLCZAsF/D8sf1xlB
vu/CLd9uJO//ht2lMJsRtHXf+0WH1lPANyfLwcx0BMnnvkwVmFFgZ/1bn9LV
I6jbyK+FMKVA/Iaq+cu7hlHQdn6WB6LA8nWzOE70EbTMOhOrGFPAK7bG11CK
xFdy9ypfSb6nZBhH9g+jru4dtoFG5PdD3Ti2XGUEXaWktmoZUGAE1C50tw2j
Q9mWMxv1SH8fHwk9VjuM2nxSxs4sI+fZ8rLA9P0wEr2NjFmhQ4GH1uGJdonD
iLl065vuJaSfn3vP3fIcRnGBranJiygQurm/pcRjGCmsS5q/fQH5fRwprbU7
NYx2XrN0ZGlRYHKPWEYybBi5yR03yNeggMdsZodawDB6LPhY6K1OgZdBN+aF
7RlGJ7S627VmU2DwYue97f7DaKaiK3ydSYEXzesuLg8eRjTc9d9VFfL7nfuB
0b1pGEX0SdhtUSbvQYO1vWPZMFJBISosRQoQWtfi/dcPo3W8sguEgALORGau
ltswSp3x5PoxPgVq1DZp1a0ZRhWd6bv0ZSjw+8v9zU1Lh9GrmujMPh557zeu
RGZZDKMeJvHisQQFJJzu95WR/PXsF1kf4lDgrdO0ds3KYZTzde69eSwKaKUV
3f06fxiFv717po1O3veW2U6sWcOI19Q76y6VAn/VNx1f1D2Eck/Ou1QkEhPN
czqM7QTDyDns9Po1k2Ji87jhJeWuIfRky0qN4hEx8c8tO1WZOYyOe523Xzcg
JkZzbex7U4dQRVd9Ufk/MbFKys9tU/UQCt5rfHJLp5hIucR88PX9EFKnbHRr
aBMTVq13KVXtQ2gyY/rxnu9iYujks2faTUMo5fGUbFuzmFA/2WHTXziE6v/T
qff4LCbKtwbZWTkPoY4ju3PG6sTE1VTBn4trh5C06rqBqCoxMattsEL36RCy
m/15C79CTMQeL1m6234ILWx6Rb9TIia0vpvfd1ceQqfL+hp1QEycdpHhPrAe
QmFSEozCfDHRv/lbfKztELp5c+kW61ck3ubBeZjs3x9c9q/juZioeWmodoDE
X9M++8HxJ2Ki9WPgUb/9Q6i882Qu/5GYOFlrLr9Uewhd6DjQ9iBNTGjWBUwU
LB9CDYIfDqYppD+x/W5fVYaQfu3FieabYqLYT0nzr+IQyroe1uafKCYWqgoU
KoYG0cSDPe38eDGhYNKY7CE7hLa3yxk9vSgmsi0WJp37Noi2rDqasiVaTGSk
PTux7scgIlS37+k5LSaebHgyFdgxiDRp1xdciBQT/zXfKRj5NYhEHJGZbqiY
KJFfsq5jeBBNK1zwbzgmJuwcgm6a1wyiFVI/BgP9xYT9+qsa3/4Mopkq6lGz
fEh+3+MOr60aRPIS7/eXeIgJ5d/rc3enDSLGogUWHofExMDnKNMDUYPIaFtC
lMJBMZF5pb0roGEQ8csiKokD5PzC9TSKbg0iXuz8ve52YmJn0qORisuDaFOp
/LSSrZgYWV9qqkzW38s91PZuu5hwr8x28IsYREdMapuObhUTM9rcPxABg6iJ
vkV+3iay3xlLuXDHQTQ/4PHez+vExGK3pe/Kbg+iW6U1f8+aiomgvdp7tr4d
RK71aZGrjcUEc9m6kyKnQRToNbx/wEhMvF1zN3J04yDivitdl64vJvYmbXzT
7DKIFnmWeu3XJef/o+TZsckBFJM/K0VxCbkfOzpktf4NoLj5u+Vr54uJmePG
CxarDiK2dNHF8xpiYkdpgU/IvEH05HfZpvWzxcSNA50nVxoOovW99Ty6qpgY
M5CwUhQMooY3y6UKFcWEPpjftxoeQDNsAwXhcmIi8aCV6g/6IJp8378SS5Pz
lX2VHpY9gEqnviZTJcTEu0vDaT5PBtCexiFWCZPcr+z7OeYlAyjH0PjRGaqY
uNQzYfn61wD6Ehy7zUIoIjQHzssYFQyg/0T1unITIqKvz8L76M0B9M5LLPdl
WETQTOUSUMYACnz/e2lKv4hIGevzfe00gPb9izM//E9ExByfrlp3fgCVXCRu
6neKiPxDYa+nEgeQ9K3EPnGbiDhx0/VAeNQAevLwVdCH7yLCWvVLJvv+AKo5
f4iS1CIi5ut7fVbbMYCSPix4e6hRRKhQnF+5eA6gLFnHQKMGEXF/V3HNXmdS
z6i/M7dGRDzfkEP3MRtAsZXdli3vRcTZbs2ft4wH0MB+rueTUhHxSfj28z65
AdR53u9UZJGIeLx0oXaY0gA652ZTY1sgIt5VFtNbTQdQj6mXQPu1iPjv89wE
K48BFHW15gzzpYjIuK5RdWwJyWfcduTrMxEhYDdpTfb3o1dHJi+/yhQRU95T
dzjf+hH/bbZW3EMRofivobKgvB99ibL765kmIi7Kab+Y97UfSV+VvLcpRUR8
m4qZtVJtAAm3hJ9bcEtEqFpYKCQO9aOII/3O7Osiwn9XcuD39/1owxKh5594
sv+0R9vFlH60TXHycPklEXG52uVSYXg/Kt7mGfcohvQPPRJ5Pe5HxnPKMmPP
ioiorqXRUr39aEe276DPSRHxcaDyV2pqP+r9Nb3QNlxEvIyxX6AV0Y9a6C/P
GZ8QESXXYhpsYvuRqvOGFs0gETFjnt6Lwfv9yOVmh7XUUVL/xLzFjav70c9t
u9+OHhERhzZKv3v/uh/d9Xtt8dNdRLy/XXKw+Gg/WtbRXfnBVUTktqSaPlvS
j3bL9B7JcxIRvb9LLArt+pFbTwEt/YCI6JjJU/Tc048UA83yrtqJiO5tnnlT
e0l/HiXuO2VL7kudp23brH40qnVGM8CanHep+58YrX6UUrWuydVSROz+52n7
6XA/iqadztyzWUS8wP+uPtnQj5IPX/faukFEsOLPemrI9qN/G5S2rV0rIhaK
RUvqFfpR4h+PmSuQiIivezczdBepJ1KJo7uK3Jczc29uS+lDvoO3v843JPdh
4T8n864+pBPuVjdHT0RMe/RtiOzoQ4V+yk9UdETEhdYFeuo2fYhqOpqusFhE
1O//b+/Dy73ILLLoHH8+ud9GzUeU9/ShkN6MM9IaIiLkz6WxewV9KHznJQ/e
bBHxKHa+aNq1D7lURXpIqooI0bQtnR3Wh0JNgrdLKokIbZr1v/Cbfahrmd92
nkBENMzxZjt29qF7l0MNpWXI+1BbcVuY3odi/cKW8yVFRLh98d2HDDKfmqKk
wBYR5UmhklNqfWjxzyd8FbqIMNi94Hr7zV50521P72yxkFhy8VK0fH0vmvNC
uk1rSkj4LNmwYDS3F1lz/PK0x4TE1+y0RD/jPnSW+zzNcEhIzLnlmvu1txc5
n9/gZ9onJEwsYryemPWhmx+e7bDoFhLnShm7/1T1okalM8q7/giJfKf++J35
vWj5iyV9B9uExKYQ3ndxXi+K3mCd5vtdSMRnp3kknulFuw03eEW0CImoR6G/
8id7UL9rg8LlRiHxps8mZ41fL5oMWlyT0iAk0hOqy8IiehHhp++SXSMkKFvU
eIH8PlSwnitdWikkit8naURRelET62HclzIhsSXn/sZ/dT3oH0dxfm+xkHiy
aEonpqAHYWu3a3QQEuN5vxnXb/aggNwYRZU3QkKv8eau/PoepKOY7b0sV0g8
f2wdm03mFT9mNpnnCAmpXy+vS/B7kWlshYpTlpCwnNP2Ae/oQTE7CLeQDCGh
XxnI5Gv2IMJ95HLiAyFxUDOVcdaE1HOfV5qTKiQWan3nqaT8Q/Tak/V1d4SE
033BH6ZGD1qQ2PG376aQEKveSE/zIt8bVTZJXxcSNw2VXk2QeQ+be3XaV4XE
yiupD3rCelDscfUUy8tCYv66+zt2GfSgLtvkYz6xQqL3QpbMubZ/6Hlu+/z4
c0JikvJ5ZOjMP3TK2ejbq1NCYvGbA0q/VXvQ/yq27nis/i+eklSIklGErJBV
qYw6RqkIJUJmGQ0RRV8hWVFpiEhGMiMqRWR1zGxCyN6bJHqe+wz1u78/z+u5
n3Pe5/1+n3M/94+n2djncl/ACprzbmX2rp2HZN8uBovfCnYUpS3U0OegaVTv
wi7vFdTw+9fAITkPQi0TzUY3ST2eD3y8LjcPG/dWcHldX0HPqgr+W85zcKyg
80yS6wqm9rsNhhTNwWU5E+eGKyuoucS5Kyl5Dja8EwqlOJH8nOQaGjo5B56t
Xh477Vdwq4hdherlOeDT2utoZLuCUEgk+PbOwmvVt1K3LUn+PcQv0bNmQWV9
7EyWGYnPmstBeNMcoN8Nv94zK5h/ZqwnaO0cbN3STd94agUTjHht5DznQOGz
sdehkyTeJwoH7ONmIWPWr+ra8RU8ynbkyNS/WYj/1cmdcmQFvxTFaE7KzsHe
OB65Ls0VnOMSc56YnIV7Qk+PcBwi/emzNPOjaBbSQiXktFVXUOD9qvbHObOw
xM3PfUtlBf1eMEQdjs7Cj99G5TnKK3jvYqkY399ZUPRe4zYtv4K5QdT7YuTz
5xaVZnbKruDX4Yx1z9Vn4XPbHztrKTLfsbNsDm9n4ML5y8kxO1ew9GGnU0zM
DMicixj8vmMFnT+2cdnJzEDFcOIEz3ZS/+EifMMxC0c4AqeM+Few7Yx/F4fQ
LKyuu5P7eMsKJiromnkPzgBPzHWv5k0r6IjOV7dJz0CwUOHaTRwreNGAS+S4
4QxwmvE9PMW+gtmeMlYa6jNQGbqqJ4J1Be+8edMyIDgDN45IiHauIvkSa/C0
75qG5DOb5LetMPGY+uUmS+cZiF02U7alMVHE921L3d4ZaLdOYaT+YWKByKau
wDszYPPQvWR2kYkl+nIDv5jTYMh9R3vvTyZm90/W7S2YhjefVb74zDBRsj3E
7KLqDIyaX/5bNcHEHXLqBEV0BtjTXfZuGmXiG3P9CxeFyfyv5HefG2QiT6mP
VuvkNBgTEwLpvSQekJRo8ZmGR1Vxtb+7mGjcz5cjR8bOFTecNb8zUcooa3F9
4xS4bLz37fE3Jq5/HiTfaTwNW/1mpAcamcgZM/k0SXoaEkQaNBXqmBhWqyf0
+P00NK2R0r9TTeJdxSO759o0rKzV5mstZ2JQIVNrS84U1ASubRP/wsRHia/8
aHlTIMnXbPBfEdlvdKS0mdM0ULyuFjbkMzEgKrvjqeI0/PfbZEw0l4l6garl
LKnTIJml/ffmeya6swf+vP1rCrT9yzqbspgIdXvEZaymQFrYI0Eyg4lup+b8
G7dPA3Xwr5hfKhOrHr9lrTo4BTwbFiO7XjGx+cUxg32vp8DDcXWlcgITE+Nf
TnSQ/Yb3vR14+IKJ7wUjln/qTYFFeHn+VBQTxzJaiMyHU3BMOsX7aATZ3+NN
RR/4psCL9QA9+TETDSmpNqg8BUcTmhxYwpg4/OKxkbLEFJwMPP/ALpSJjmfV
yizspiB0g0JsWRATo9b6hNvIkPGgjoOYPxOXhvhfl1+YhKcn6/iDfJnIhV7j
UryT8PHfWPC4FxNv8aXd82yaBC79jJ7jnkyU6+Glxu+Zgp5Go+lsdyZa6jfo
LFZMwpNfXYM8rkxsLdIQWNGcAkOlyMf/XWEiI/vb+JTTJBwXvywx4MTErOJ9
XsdDJ8FtY4X7UXsmst88fXJd4iQslbqlvbVloli3yai+9SREKC094bMi9VAv
GXI4MglZ99bZ+ZszsYlNQfeW5CRMW2pNzJgwUWfv36GuyElYUNY7ffY0eR67
dylLTELo7gb3CgMS/8cxPpecSUg8ZnFTUY+JPbXzb7R3TcI14VzFBF0mmtuP
3h2InwBBJYvGjTpMzHxzpfnUlknI8RMR9gHSn7pmb+MbJsBa/PqpWXUmXha0
Ezt8ehKeuaodsDpI9uN6vO3e8gRoS3z717SPjM9vyty8fxL62pR9NJWZKJ99
5pGQ5iR8piV35cozMcL6YLv84UnYaHxgQlqWibveXyptgUkQ3bWjI16KnB95
Bb4fLhNQcdLfc7M4E3M3Shs8uDQBWTNef+6JMPG6Ort4fdcEyHYdlVolxEQf
/T0ajU4TULf7p4qXABO/D990KBmagEsfq/784iX1Fd4X71kyAdlBJZFXeMh5
co+o4to3Abt0Dw2PcZJ+OOjop64zAa3SUhx2G0h/zbUJUfdOgHzs0ngvGxMf
Bi1+u+owDok/3eLN15D6r43gSmIfB4qRIkvnPwaaaTyULbQcB64jE1omTAZ2
lMo5VvSPg1u8ulI7wcA7irb8Ai3jcF6inWb8h4E726kyKebj8E7rolv7IgP3
dYcXr/YZh8mt98pNfjJwbjSg5FzaOJTeY8XOGQYW76+vqH4yBu07LaItJhko
OzA/83nzOHipXxbsH2XgEL/DQIbFOPC1J3ieH2JgwV4nMcsssv7Ln74TfQzk
NWiiXP8zBsZSH6yudjOQhytznEVuHIauLE787mDgjj4JzYyRMWh7tHjcu42B
XU2CYf3DY5BT22qyuoWBr0MyaJm/xiBiouxAWAMDxZgt6Ze5xsH/+FIlby2J
P//J/jrBcTC+ESyVWMVArxPRs7IhY1DdX6IsW87AWofR1D37xqC4M3VzfikD
F5Y7Xia8HIPFHzFx2kUMjBhevHelbhTg4+JISz4DJVQPv7TPGYX04eW/1rkM
PCiQWcypPAasNUIVc+8Z+MvX6hM75xgQv7QsfLMZuHR487qC0VEIfv47miOT
gdV2yb+vmY5Bof7y64Q0BurtXOSR/jIG5hzTNorJDDxzpcVvqwvJp2/QVPlL
BkptWNojzT8Gdqdv8ZvGMTDQxsyjkjkKb42uCEw/Z2C96wPbv7GjoPRN5Mvt
ZwyMa3C429w8Cgn1UipbnjJQ3SBEL2huFB7IWp3KfMTAduVNh23lxsBBRk1D
8wEDdZze+Lqoj0H/vg8NXSEMFN9tk/PyyygUde2ScwtioPYL6yH+nlHo+JUq
v96fgVnBB1TnjoxCv7P3v2RfUv9+oZLXw6NAhJbdOHSLgS9FoiM4yfhAUmH+
D08GcjUKcL4jRuGEbnicx3UGhvR586lGjMK6Mx6GPNcYWHPG3knlI3n+WUry
O2cGMviKXi8Lj5LfL+pVJy8xUOX9r1endoyC+J+HIbMODGwOXv86V3kUfARS
toadZyBtQ0m1ucIoxNKHj8jZMHAsaWRbtdEoXDbW1mw8x8BNndcqy86OQI6u
eq+LGQPT6gK6JthGgVU/V4vbhIGNTav8HVlGQTho37HcUwx0EyiUCWocgaMK
kfxmBgz0O3/PvEJ4BIatroYwTjCQrbZi2+68EZjaFYivdBm41vO457nfI6Bx
JzhaV4f0r6fpWHvZCDjYix+YB9J/U/kdK9EjkP5YzPOZBgMr1diOHhAdhTmm
kK+GKgPd00rq1vaNQK/4rMi4Cpn/pAdx8OYI+LMJPHy8h4HBp0rS+3JGYPZr
2LODigysW23Jt3bVCPy9XeYwKsdALafex5v0RsBsJufb410M9LjFXUc7NgJ6
J6rXqEsy8K6QmlaYyAioTmxomxRjYIXp6VDL4yPgofzDKWoHAw3tfm87/m4Y
ri+djNbZzsDW85brWhqHYbn/bdhvflIf7e0P4snfx6XktyfzMnCGf5ektPQI
jLasXDPmYaBDd1yn7YNh+HLVwWYNFwMTeWL0uv8bhhPWgTyfNpB+NBNlLxQc
Bgx6Z31xHbmPMhMzbA2HwSWbcNnGSuL/NTfZ9XsIook6vuZVDBx/s1+jpW0Y
VN6LBgWu0DG0zm3bjV3DoCPmFXqATkcNjbcila5DELaj1HCeQse8LQP32ViG
4bbA7bcpS3QMU+pnT20fgnrPyOZzv+g49PgLd2ndEMgXJoZsnqfjYzmR71XS
w6D203lVwzQd47+smLj+GILxF5ncwRN0jDD7q7xsMwRR3jwjh0bpqKvP+3HJ
aQhc2S+eIAbJ2CPi2sHRIXhYcdo9t4+O+51MDU9ZD4Hx2tcK17rp6HA23pxN
aRjO71jJkusk6wXUOsRKDMEtUP8y1UZHLSpmGyYNQUDExJP0Fjre4jUWLxok
8W4i/jg00lHYlS5uPUDibRjdJlFHR9vzIc2dHgPQ4ZHXPlpNx/Nfk7XnBYdA
TqBJL7WCjj+1Qnlq8gfgPpeeqSPSUdrfxXdn/iB4XbotLF1CR4lPU72ptUMw
LxjlNf2ZjpTUE75GhkOwSbctPPsTHcutntQdTBqAmase6m4f6ai6rKEx/WYA
clqzkve9J/Md667hLRmArdfr4mhZdMy+5Bq082Y/fPwydwoz6Jj6y3ThydN+
CJbwen43jY7hZuMqkvsHoM/Q+8XJZDo+ELvb9apuAD5svLibN5GORPMRtkW/
AThpqOHdF0fHC59e/JT3HwDbA3fM02LomMT5Zi/vqQGw2iS86BpF9q/Kfnv9
10EIVc8WVI2g420L37iA0CF44bSeueYJHZdWj4QTRoNwanefS0sYHePOqZ0Q
XNUPpem/YuLu0bFPjf7uhsUA8MT+M750l47tJaZyh8L74VN8VbVKIB032X/P
87vbC6aP1tesuUNHnpwV9TNnBiA97JZ/mw8dvXZUvB1M74O5wIWaJC868nvf
+e4gOwDrZNhq3D3paFQSMzLJ0w+rLmWe0b5OxzuHX4TKGgxAYYz98y3X6Giq
sDX4s0AfHIhWvjTuTMcnVrlph471gtTlRwsFl+iYfm/GpaClD7pagteEOdLR
QHe5utaoF248CWiyuUDHuspETh+jPvijniy+15aOhzI5/fWMByDLXlOR3YqO
avTNTvln++DNhbCv/eZ0POubKxHJ0Qd/4xs355mS/joc9nFKeACMZY7MPDCm
42Jw3RpVoV5gGsjdvGBER51Xh8cY2/qhpbntodpJOn4N80/qUe+FJuon7S0n
6Pjovv0Xluke+D4J2XNHSf798rr2hfXBHYOexK/adGwJNLgzodkLGpbRuklA
xzL/+bPp6b1wS//nTV8NOoodfT4e+7sP7GxGLcxV6cikf9HnbuoB5slVX/ft
p2Owqab0W98+8HXfP8azl44bNhcENdX2gQ1FNGxBkY7m5/N2rub7AVutkkab
dtNx4ajlke8fOuGWsn1VtgwdL14orWvm7wFnmYNnH0rRcWrxBk2O5FtQtu/a
VXE6Khw9nrxpTz8sSvCoGYiSeiydiRvr+gHeeilhCsJ03OWnHGgT1QOVnUce
cW+j43iW050/mj3w9UDb1iU+OpYIFIFdQS/sX/XToHMLHV1Upvs3c/VCUnMw
RxE36Rdp3RPWVr1gFiPj/ZKTjiG104W07G7IFel2CdpAx/U9j/2N1v2A+7V8
3JfXkf1smZIM9u8CrasLB4xYyXniDt0wUdgFPNOdnPtZyP11+taxwqkfUL1z
5pLwXxrac7y9y6PdBeW3H7mvZdCQ/1RI4efQbojqnf87T6VhuxnHgtmqbni2
x061a5mGCqflAyw/90CIqRhRtkjDWIn2I/9Eu8Hux037rJ80vBlbcGnxcyck
XX9rHD1LQ8eIzWWpDzoh9DxjPmCKhgec2+RPpndC175SDtdxGq5OKC4zW/kO
OQOCXedGaEhEFu/Xv9AFRUW3JY4P0nBjsd5Dn0+dEOSzSnh/Hw0vvXFhv0Pm
19HYESPRTUM1V43UsPlOuOEzWLqlk4bLe3cZ/1vpgJh13xzXtNMw4O0D0Qa2
H3Bv/3TBUgsN77O87x2Zb4f+21/DxhppmHD/ku2awg5Q4jNe31lHQyteiRiN
yB/Axn2AvfYrDeti1fqi9LqAP+JUTlElDUvZk9pydndDvrpF99syGp6dNrjC
wtcFrPLCWUmlNLzsuGS5/W0HbLvntBJVRMPF7wcN2p07AN1/Ux8U0HAwRaWM
MO+E9sDY6/55JN8me9tT5jqAWOCIuvmBhsf55MT1tDphtGTPAZd3NDwVHThj
ntUOqqpZ/g5ZZL7h+xtPn+yAVzWuJ6wySH7vsNfESHXAj37OQpM0Go63Crke
8G2HTOXw1wbJNHzkLP26XK0LiMv/aRxLpOH+o1vrNht3wERQj5FWPA1T7p06
9pzEG3hh93qNFzRyw0+1/jP4Dg8PR2oeiKZh8E1x1oLP7aCsfUN4byT5fM/4
kY8kPslOFi/FcBp+rNNN/EnpgPibz/7b/YiGtRMsIdbWJL6ca8syD2h42iJm
Lz+lnXxf92zdFUpDGyXHJ9JRneC4c1eeVDANI+qOphh/+A7lmk8pkgE0bO6M
bhpg7QAXZ69Pkn40nInp1cft3+GD6ToBKR/SL0oT7CNk7Jj3niLlRcNZJcLj
/pp2YPv80GuXJw2veTLjWjhboWWjyE3Z6zQ8TGefrT7UDkKXbvDJX6Ohul5N
37337SBvL7hH6SoN/QqeyI0FfIfRY5t+7b1Mwyr3mIgbzA7Y+3Bp10EnGrqe
k9PsXGgHPoH8NYfsaXj31/lo047vQFFhtdC2I/mWlTxpI9YGbp5odNyahr3s
aQeAoxXkZlLKDM+RfjtH3SFq2grTHcFtpmY0lC7ysHyS+B0cNsjbWJvQMFzW
Jyen8Rv8uXv+geNpGqrGRkbq1n2D000MRVdDGo4V2ttpN7fDt7SPnv/p01Dp
HJ8J06EFNmm47gs4TvJrLNdQsukbVEp1RYQdpeHXevEFab42cFccuxytTcNR
sS+OUiLt4F2rOJQENOxQFW3mPtkKJgbY/FaDhlzPBDnH8xrBlE/EqkiVht5U
MTv9K9+Attb+fM1+Un+VIkbmXCN8dVi/tmMvDdkFWpvjV1rA7uk+0VElEl8t
Z+Lq69/gXbNJ96I8DVXW/32Qrd0MWXOx61nkaBgn3f36xOVvULHnchf3Lhq+
OGSosO15KwR2/d0uJknDelPpy3Y7yP6VclaUd5LzXtrtndfdCgGt9aY6IjS0
PcEWteDTACPSUXqmQjR8qfqkx6+tFTL4nT9dFKTh28Id7vNzraCz526JNx8N
DeilMp3366EpyUD18Rayv0kWub2GDeAosXA6mZv036UjfNGnvoGA6MhgPicN
NWNMVC6LtkLKfZ31jRto2JnAppV3shnuEC9eD68j58/0TK5CaAvMJC0PUVnJ
/TarfODYSiucODL1mGs1DXWrOqpXFL+Bqu3NLsl/BGZ7s+2/+LcFYpq0nh1i
ErjmwJY7HT7fSL8dnjWlEVh73CE3sqYefnII57tSCFRh1xVretoCb2JL191b
IvCQjBz/laRGqJL6/TvpF4FZ9zopL1magJnmf7pknsDt5b/DrLe3wLZptRNd
MwRWt8n9ct7QDOL9y7m/JwkMtz5dGkTyzV13vYBrnEARG/2jfu5kvdBoebkR
Akd+vtmyvroeQob4NI4PEpi0jqVrtUsFFD0dLXHsIzAhMKO63qcaimbTOoK6
CRS6wvqVzbMeeEMt7ZI7CSyVJ67L8DTCgu6rwPJ2st6BL9VT/zWAU+QdvuFv
BPbPPn/st6MSBOZCtViaCfyTVV5pFFIB8X5t/WINBH5r+mp9Qr8RAt2GuHVq
CawSen34yt1G6H7zI8+hmsB9mZnh9IP18Hi14kJIBYHtlzmWlm9XgexmgdhM
JPDwly9WmguVYH2R3tNYQuKNZu1/1V8DGkcEHv4qJJCuU3vR72YTRBH1bbwF
BDaLM0WtTGtAxOHCfdU8At/dMeGwvl0D/MmyHTYfCJTPdr5XPvEV/koGhAe/
I7DwTEj0kH0tfB1MHXqTReDla1vjY5/Vw3TjqletGQT65nG7Mqyb4WTx1yUi
jcAf2VWH2vTrIH7XtXzRFAKVd0YZ3M0ohcm6HZwnXhHI5f7qv0WWZjCMtGxz
TyAw2cZhzvpHNSjLHpKLiyXQqPK82ckdNeC9cPZ31XMCBT233N7v+RUYAbkn
F54R2FSRH7/7VzWUpi3xbosg0PXrFjGNgSbYzuR1O/qEwF/bd3X8ZlZBWnL1
QfeHBOpYD62JKCqDk7qUyIT7BN7TFb5/ancFRJpcsKoPITBvLfOBvGAdsD+Z
z6cGEWhTFeTb974KYjPt/CQDCKyR1RmlcH8G56CIrjN+BOZK6P6x1kKw5rRI
CPQh0JGTQ/euVzUIGvgtf/AisOQ+62xy0SdYcRovGPYk0G7TFZOHQRUgHq7P
sfkGgQ7DPFsknpfBKv6kRm03kn/NiEIGrRbol6KFPVwIDOGjfX2aWA+H/+zq
SbtCoNq7lfLB5Qo4d4Up9eMigV80EjFctBJ6DLcPbnAk0L9Zpy13qgoOxwlJ
H75A4I1nj1S+vPsE8mP8Pe62BKJnomueXjP0eTwXSrcikEeh92ZE3meon8C6
HgsCFQRiVU02VEHcEBcbtxmBnW792osmleBO/ZR91IRAD8YN7qW3lbBlv9SI
z2kCjR+3GXe1FIGAxMuAj4YEWm0XGlw7Xg2bVQPfT+sTuDk1UY7TsQCmx4WP
iZ0g6x86ea71cznE8dddtdAlcIFjrf7K6zLQE+ljPNUh+TijfjtLtwYoF5MF
GjQJfM3x4PT9j2UwIxjwkvUwgVLOYeXtYWVQIFXw4bA6geLCNTFv/KqgMThf
/tZBcv4cVyvlna+Ab3kf9uepkPXYe3ydY8vg3HXpjIU9BKacsON8OZgHqR2H
0uWUCCz3EPd7olcAt876c1ySJ1CR90ck6w4E4bfs/1JlCfyQ4yJWq/QRUlmv
WYxIE3g3iHE3/t0H+FpaBqKSBAoPyiWppVUAy7vkRzY7SX+X+RvEfkKYmNh6
MUGEwMwzPNxtSZ8hZLDhdZ8QgaHpUk8dinMh5ULhDaFtBPn+rg54XlIOW/3j
0634CdR+XSrhczAbxKusHRJ4CcxYVtKzPuqLGc019wZ4CCzmNfs6oJULBX/y
D4huInDD3LEcrZufwN1utcEFDgLfOB8+QYQ+AuZ+77nU9QQ+tNEc/i89BzhF
Vv+eZCNQrFDt8LxJGfBstwmQYyXwukdx0dfiKsjS9bt5jYWMC65tE3Ivg8qQ
bX9y/1JxmXVuu6RmFeg6KHYTDCpqx62TNln/EfDdJd3DNCq6ZB9/kS6TCd/O
tAgEU6i44dNfz8HMbKjfusajfomKL5+tqjk/mwcehwX38SxSUalE4/rvjDyg
P0jzNf9JxUS/6xwKQelQE1Mn82qWipdctrBUQBn8lua0nZqi4rV9yaeKckqA
Q+wloTRBxWbtP9fVG4pBzIgQ9B6lYkakhu712By40W+aWDlERfNTa6V//yoB
1jdS2ZwDVFxohagbvRVgve2DkHkvFR1DRLwFNn4CF2kL3pQfVBxxOzTper4A
ki65X/vZQUXhWC2/D+PO+JV2+rRaOxX/Na09NbEjG7riLKJDvlFxe57Sxdn0
LHSI+n6+vYlKXltLvKNj32FqrXy4aAMVR9vOLtj6RUPTu7QjrrVUZNO21Rjz
fw7rdXItS6rJ/DUttrqp74BLNYzYUEnFpvNRq5p1UqEgPodqUUbFrufmlexY
CkEDGVcyS6n4V1wmRkaM/AZKmb9AK6Ki/1KYsGluFoyv4i098ZmKg+FOt/Vj
w2CL7d742E9k/2bRlhdvZUJRy1zf7Ecq0jcb5j/TuwDPuE8mH8oh+fXp0nP9
E4kh0n9rn7yl4ndTrbzw+QQsUlzjMfKGim6Woi2ZMmmwaTuvv0oGFX2bbse/
mHwFTZclue+nkfrqmfhwxucCLjJW9SdT8b1tmk5eSTAsJPp7Kr+iommO4YFD
+0uBXSpYLySB1Nsv+6ulVA54jY8m98ZSMbBIkzKb6Ab19r6WyjGknnGuL/ob
k8DJT+R5aBQV2+af33ZMfgOlIZ/2DERQcStP8rg88QGr+llPq4STeDJTN/y4
GodDMSwtDx+R+jS/5mjySgLBVKeWsQdUbFV0YG9kzYHhb3sVD92johqMqEcr
fSLvLQI80XepKPKPe4PKdBI+Cxc1XgikohmfOiexMQHqyxd4T/hTEb68KpPz
zQdH+4T9KbepeDA4nOKTHADPFSu6V7yp6ARrbTnepUMT07/X3IuKIZrjXZZ3
ykFW4aJNnicV/zttoHXGOxta9qcA9w0qPpQQ272mOhz2yBYkXXUj+dX71o+s
eeDC3X++zoWKLaoGdVqy5D7KC0uWcqaig6TX5nd5abA7m10r+BIV19x6RVwx
j4E9AWg74kj6z/il4A2DjxhhyNKnaU9F+bhHH5/ALWh1UPiRaEfFp+M249eX
3mGmVYryP2sqfrZvqz/9zx81TD5tsLWk4n4PixMZ6dEYdK5RE82pKJNQqXk8
IwJvX9hDETlLxWdBPMcc1p2Dqulz7AFnqFgs/vIoT3gpXsfgFyOnSD/JFdeY
vy9E+VqF0COGVNwo8JE2dOMCnMt/uJSuT8Unpk+2XLlYBuLNu0rWn6CihvPB
af3xPHTMllvjokvFEzX7GsI9I/HovGz6Nx0q2vrI8g51miGIHKnZp0XFxRvM
mxyz95CmIHDkxWEq3vQ4dCdsPgMyUwoP/1WnouifvguTvpmwKvf7M3tVKtqY
HY/Q4iuGdWNul+r2UzFcL7l9musVcL47+lxxHxVvp6z+vkbvI/59aaQTrUxF
3g+G//gzksh77mm9FQXSH9blATYPipAtXaPZYTfJr1dQTx9/KZ7RGMxulCHn
MWfyvtTPSuTsE2FXkaYiK88VomB1CXJFdZUmSFAxW9PJ3bn8PXLuG1lg20nF
oFPtIs9+fQCeeXFfNxGyPtfjIDWRSMh77xLcI0TFx32ReIERg0ON7yaObKNi
3M6yx3o/E5DF5m3Ve34qFnk0vn8kkA4pdfbMbVupeOqcc9orsbcwa/Hofchm
Ku6VVbyjlV6GjUGKJb83kfvFqW8iT7AG2eroOracZH7dd8XXnN8jpv2TaNxA
8j1b0uo1lYQKPaP+quzk/LhMuW08+w79RipUXq8l+1N4mqiglYfKVQcct64h
/bB+tULlcjqeWr40H7SKigWaFpPK28LQu2pi4fcKBd3lzh+zUEW8GTeid4FB
wcigpLFRpy9YLTwi0kZQ8OtIQ8yZ50XYES9moE2h4I1fuiw1RAE28gktf1yi
IN28zP3PO8S3ZQJL4osUHGPuuM8qVYYrRKhz1E8KFi4UP3ndVIT6rcXq6+Yo
SHVjU+x1K0XFTdvu3pqm4C+5gOK1DYVY/uKf5NwEBdtCBlJCblTiudQasB2j
oNqXaL3tZeWYMNad0zZMweRoIct6wxI8tTo0VneQglufSfqqCd/D195avUV9
FHz+b12bhUMR/udm9Eyxh4L3lYKWTSQrMVZMITW1i4JvNiR8ipJ6j2F7BHdv
66Dg6OaU1df3VeNobMyG8DYK7tt59Un9SgVahvbbsX2j4KP4Kx0Lj6LBKdmb
83YTBeujD8YG5JbCg9fRysv1FBxwNc9gj8tHtfnmLOdaCvIp3jEQ1MhDkypI
GK2mINFqQ7lfV4ieu56OWVZSMGmTd+6TY6VoytaR/L2Mgv//k1OE9muYp5bm
G3yhIEdUsNnJNwl48uEZrZpiCkafHfw8RC9Dlj/GYlqF5Hkpd+vi/kSYvlz4
X3E+BU0iC0Q5kvzg4ltD8f15FBT4EOGR9xbxefraox8+UFDlmXBd8Z5WpCTl
FO9+T8G/rpu7WHfl4gmNgxkZ2RTcmV7Oxbv3C14/emta4g0FJTsaZM/VZuFx
PuNXSa8puKolWCuKPwcuMDKzdqRR8MjNFhmDqAZk4zbdHZ9Mno+6GsLFUY99
fEdZtr2iYIOKVFmD6hAuLunoxySQeN2MoiPkS9C622CaL46CBltXyfH9zkVq
Rf5sVAwFDdVe1nU5FGOse+2FrdFk/+Y9W/7TKcSDHx/LR0VSMJa7eDPb5zC0
phde3fqU1LNoYKqZpxCXPe3+RT2moEXKuJ39mma0urWLjf8hBTdYHVISvYI4
e2+PXcx9CgrOinwIdcpEnoFtCttCST16WHkOvCjFTUYcRvHBFDy+RSHxGC/p
r1UvRncEUjCAP2PGNaIJnXgp9Ul3KDie+VRwZ2c3Jr3KkpS8TUG/GltJNYsG
nN5Ia8vwpmB59IdbuyMaUNTBamm3FwWlPrxxbif9cMFQxOmDJwVbHOuXC3Y9
RcfOT/r7b5B6Tlk2/GLJR9PuG0HFbhRcW+G4JVSpCgedKuW1XCko0X34a9vm
Gux/tFq2xpmCI1XBy8va1ch96WmMwWUKLkXSU87ub8I4xR/m350oqCn/1iTO
7RU6c8mHWTpQcIfnf98fdXZitP3qTaPnKbj+ssXN97c68ci1VFZnWwomTI28
bimIBJn3T/SXrCjotiaQ96DYU/x8h43V9xwFD+V7awQbxuPizSeca80pmLVb
fOHGYhPGbLG/99iU9LtAYL2leiPmrfCYCJyhYITs3KFk3q9o0VcfnnyKghqz
yVGMc7fBxH7XDnlDCup6TrjKvShG1ktGQp/1KXg3f8Lj3fth/JIydkXnBAUn
D36r3Z1QhRKia2RbdEm+Bm7y7/tYi31RFqqWRyjoGrO72YqrCkuP0z5PapHz
G93v8oIlEMNmYu95ALmfxMe2yEn14qF/R2tZDlHwQm+QxIugHnwoV2r2RI2C
vbTYRCr3D/RU/XtW+CAF90Dmh15mHd4p6kjLUqGgcPcamfQ91fi46oCD2l4K
mg3GH/vS1ILdLXT3OiVyH6pPh+ylduHaI+sXzBUouEb21c5/803YIqLVMCVH
QeXA9wYf/PowRekBxUuG3IesDsZMSgEmxtX4r5emIHfil8HZGcQdt/sux0qQ
/JXBw931VWDYHdkqt5OCn60Vdqv4dsGEOfO/UhEK/uhTDO+MqEbv5XFfI2EK
+hzbdtM4qQsnmXuHhreR8y5kq9qwsQvlTr8s9xCg4LMftk+X7laCXui54XV8
FJztmengeZMGd69K2sZtIZ/P61i8o9CDZXdH1BR5yP73hnZccG+C9yn7n1Vy
UXCTcNQP5ucq0NvmJ2fOQeJf7TFVCON4M/mC6Px6Ev+AwxnJxQhIWK65HriO
5DfDWEahjgr/A8UimDA=
         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUV3k8VO8XHvu+k5QWabEvKX2LujchSypLhZKtSEK2kiWFlIgKaRNKhKhI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         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwU2Xc81V8YB3B7z3tDJSNFJFmViB6kZKVIVH5KCpFUtJQRpRClVCRbZSRb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         "]]}, {
        Hue[0.37820393249936934`, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.922526, 0.385626, 0.209179], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUWXk4lV8XvfM8G0MihSISSUX3ipSQKZGhSUgkYyRlSDSJJJWkVH6pKBVR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         "]], 
        LineBox[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAAVJuUuqUW+b9TnJQbejEVwEMyhbx6
Fvm/J2D2KhcTFcDNoU05jhP5v6W1jUu4zxTAZSTvUaIQ+b8M/waFg+kSwBgg
4t+2Dfm/i8lzT5sCFMCjiUMJzAr5v8ZIz4C3ghPAf/iZp+EH+b8kTUvHpKIS
wOqh9OD3BPm/oWenMp+NEsBJROiODgL5v9X/x1vQpxHAOV921yX/+L8FttZr
8osRwJjNQZQ9/Pi/SUYxfTVNEcAtYz7rVfn4vwDtWmp4jhHA7gwdtm72+L/3
jO5LhyAUwKqavQeI8/i/Zb4fzYZmFMDEJvLyofD4vy1GAwA9mRHA/KWAUbzt
+L+HFKN0gUMRwBrpOknX6vi/SvL6qXaoE8Aj3fSz8uf4v+MMl4sA2hLAEMly
tw7l+L/aDjekAkgUwO6Hli0r4vi/9ZaVBHMsEcCG4BY8SN/4v7oZxeZi6xLA
upHjvGXc+L8hwyCmNn8TwLrrpdWD2fi/lF6S7iFWEsAUh1tgotb4v0ab8XUU
VBLA70aggsHT+L9CEy8QL1QSwAUzekm90fi/U5yUG3oxFcCqs+Dx
         "]], 
        LineBox[{{-1.5507840121071017`, -5.298317366548036}, \
{-1.5502941665461147`, -4.5921832849995985`}, {-1.5495928444796965`, \
-4.547153930041596}, {-1.5488920840498683`, -4.697348801576042}, \
{-1.5481917442618196`, -5.233753760444834}, {-1.547491964636865, \
-5.200163232875682}, {-1.546792604379457, -5.2388203150413135`}, \
{-1.5460938028176863`, -5.043085823279447}, {-1.545395419354704, \
-4.692603409258288}, {-1.544697593125908, -4.956153854252358}, \
{-1.544000183732585, -4.555434783236512}, {-1.54330333011797, \
-4.293750065914779}, {-1.5427953501221112`, -5.298317366548036}}], 
        LineBox[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAAT6eL5kKt+L9TnJQbejEVwMbfpOCq
q/i//JrSHmJNE8DpzACg0aj4vyplNcm+9xLATLvG8/il+L9y4iu61XMQwJwo
b7Ygo/i/fxpG0BAXEcDnyR4NSaD4v17gvMAC4BDATpNb0nGd+L9UCbTJoOwR
wDEqPSubmvi/XDER5DN3E8B671byxJf4vx+TNxlCmBTA+4GzTO+U+L9eX1Ys
aOkSwL2l8xQakvi/VFNWfpvGEsAb/BRwRY/4v2so+LwSWRLApaLFOHGM+L/K
3UBz/PsSwExG9pOdifi/McgZvoo9E8CTVGJcyob4vwR4xmjcChTACI/ttveD
+L+RVmGW/lISwJqpYH4lgfi/exhMejR5E8Brg5LXU374v+az1sZ4bRHAXQ1Z
nYJ7+L/iZNCsbbQRwNtGpIfqePi/U5yUG3oxFcCP36/j
         "]], 
        LineBox[{{-1.527657696807036, -5.298317366548036}, \
{-1.5274074548082694`, -5.116739367703919}, {-1.5267220645678763`, \
-4.707969339984921}, {-1.526037075221509, -4.606028635557705}, \
{-1.5253526232615031`, -4.835433229283427}, {-1.525015699551366, \
-5.298317366548036}}], 
        LineBox[{{-1.5238297641995628`, -5.298317366548036}, \
{-1.5233019370337033`, -4.678147730884797}, {-1.5226193539486337`, \
-4.779313694174438}, {-1.5219371682018612`, -4.364742048698959}, \
{-1.5212555157322984`, -5.190171354426918}, {-1.5205742594257254`, \
-4.936554603781768}, {-1.5199108241558215`, -5.298317366548036}}], 
        LineBox[{{-1.5198854854430557`, -5.298317366548036}, \
{-1.5192132056420231`, -4.51095580478532}, {-1.518533406811518, \
-4.990891304235465}, {-1.517854001808127, -4.95234953497288}, \
{-1.5171751260217892`, -4.551712829010574}, {-1.5164966429019437`, \
-4.714431840315899}, {-1.5158186876565174`, -4.6900231971052735`}, \
{-1.515141123921803, -4.908711414561605}, {-1.5144640867242012`, \
-4.784751307742976}, {-1.5142368453741228`, -5.298317366548036}}], 
        LineBox[{{-1.5132522723918485`, -5.298317366548036}, \
{-1.5131113182535962`, -5.030810195782161}, {-1.512435585834416, \
-4.092387892637755}, {-1.511760377293606, -4.276554556520233}, \
{-1.511149070204582, -5.298317366548036}}], 
        LineBox[{{-1.5110233633777153`, -5.298317366548036}, \
{-1.5104112589131724`, -4.253508619955745}, {-1.5097373479368708`, \
-4.950442667771747}, {-1.509063958201169, -4.722518902266075}, \
{-1.5083909542689755`, -4.624378188334795}, {-1.5077184702662918`, \
-4.524228426428004}, {-1.5070463709398338`, -5.083463867320748}, \
{-1.5063747902369549`, -4.589900153781429}, {-1.5057035930876783`, \
-4.713982167573609}, {-1.5050329132611828`, -4.699871823138731}, \
{-1.504362615870301, -4.064302931903678}, {-1.5036928345065073`, \
-4.588989208341382}, {-1.5030234344649467`, -4.161724734392498}, \
{-1.5023545491598602`, -4.4004387405303405`}, {-1.501686044068211, \
-4.079959404780386}, {-1.5010180524274725`, -4.935041413981877}, \
{-1.5003504398959346`, -4.581608666964016}, {-1.4997861083977115`, \
-5.298317366548036}}], 
        LineBox[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAAgXxmtmT+979TnJQbejEVwEZkL9n4
+/e/QRtWEwwcEcC/rmhGPvn3v7C2XJOM3A/A0FPPGIT2978RedhCs8YSwMoV
A3TK8/e/gIk+zo48EsB0Phk0EfH3vz1+a6m6XxHA+oqlfFju978Z/FNnVxAT
wMeYySmg6/e/QDLfuoo0E8DyJw1f6Oj3vz8x5x6IMhLADCGe+DDm978t/Iur
G8IQwCFP+Bl64/e/TRQSSgmFEsBz3VWfw+D3v3VZxZ2qMBDABKomrA3e978N
/Zvck+sSwF0asRxY2/e/xR0WkWtAE8BtJ1kUo9j3vzIGKVt8URPAoWhxb+7V
97+2WmGHhVMRwMb5UVE60/e/lNzf949DEsDXm1mWhtD3v3exHU10CRPASyGW
/dXO979TnJQbejEVwBxDoQE=
         "]], 
        LineBox[{{-1.4866920886593822`, -5.298317366548036}, \
{-1.4864332849055473`, -4.3918179115924225`}, {-1.4858045682954013`, \
-5.298317366548036}}], 
        LineBox[{{-1.4857516724374533`, -5.298317366548036}, \
{-1.4851178845161175`, -4.169416645040039}, {-1.4844607997309092`, \
-4.87702247400595}, {-1.4838041464226144`, -4.22130603999675}, \
{-1.483147989691325, -4.039931797929089}, {-1.4824921975960532`, \
-4.356365828018767}, {-1.4818369008625651`, -4.109413488067897}, \
{-1.481181967724281, -5.028691992653523}, {-1.480527528737217, \
-4.863275791882381}, {-1.4800243232795398`, -5.298317366548036}}], 
        LineBox[{{-1.4783772978222731`, -5.298317366548036}, \
{-1.4779139166554274`, -4.06100099447116}, {-1.4772615469401982`, \
-4.7870782417446165`}, {-1.4768453148135954`, -5.298317366548036}}], 
        LineBox[{{-1.4745639936351498`, -5.298317366548036}, \
{-1.4740062621348442`, -4.673739932584508}, {-1.4733564358543128`, \
-4.4089279142673865`}, {-1.4727070965580973`, -4.436101775942695}, \
{-1.4720581136876305`, -4.448686905631951}, {-1.4714096166228556`, \
-4.652351057481545}, {-1.4712095625160921`, -5.298317366548036}}], 
        LineBox[{{-1.4703488292944646`, -5.298317366548036}, \
{-1.470113817960614, -4.4742992363593315`}, {-1.4698702826940921`, \
-5.298317366548036}}], 
        LineBox[{{-1.4680967715761266`, -5.298317366548036}, \
{-1.4675272470658223`, -4.774004413713747}, {-1.4668816160554343`, \
-4.34418097050364}, {-1.4662364661807126`, -4.937991012721922}, \
{-1.465591667732429, -4.6197197757908715`}, {-1.464947349263309, \
-5.291270906871537}, {-1.464942369632365, -5.298317366548036}}], 
        LineBox[{{-1.463207795446612, -5.298317366548036}, \
{-1.4630167522798372`, -4.7631462538620815`}, {-1.4623740902098459`, \
-4.1214939872597505`}, {-1.4617317766141338`, -4.49778673757723}, \
{-1.461347073847317, -5.298317366548036}}], 
        LineBox[{{-1.4608424845778605`, -5.298317366548036}, \
{-1.4604484499921375`, -4.446295392879959}, {-1.4598074358266464`, \
-4.19635992360772}, {-1.4593934287254204`, -5.298317366548036}}], 
        LineBox[{{-1.4589457635026102`, -5.298317366548036}, \
{-1.4585265748084162`, -4.154014380736109}, {-1.4578867269870992`, \
-4.159351872824576}, {-1.4572473522966587`, -4.004606702398984}, \
{-1.4566083221984727`, -4.631969906558996}, {-1.4559697641046996`, \
-5.217820571156017}, {-1.455331549642218, -4.6423320478767796`}, \
{-1.454693806061891, -4.934153709426701}, {-1.4540564051556697`, \
-4.701284012402912}, {-1.453419474013529, -4.941133689384942}, \
{-1.4527828845920665`, -5.245224678301499}, {-1.452146763820773, \
-4.668999336793717}, {-1.4515109838204694`, -5.016033956895118}, \
{-1.450875671360565, -4.604789018227504}, {-1.450240698725682, \
-5.066292174657704}, {-1.44960619252555, -4.867855223306465}, \
{-1.4489720252081706`, -4.3424908048139965`}, {-1.44836756025333, \
-5.298317366548036}}], 
        LineBox[{{-1.4483096030706462`, -5.298317366548036}, \
{-1.4477049591839843`, -4.325000781703364}, {-1.4475026054861992`, \
-5.298317366548036}}], 
        LineBox[{{-1.4447216046243911`, -5.298317366548036}, \
{-1.4445443318354423`, -4.388152461132473}, {-1.4439133654639633`, \
-4.843372601766611}, {-1.4432828600600944`, -4.242749857022241}, \
{-1.442652688882483, -4.358979397714473}, {-1.442022977591132, \
-4.217666553446065}, {-1.4413935996055782`, -3.59983078347606}, \
{-1.4407646804289143`, -3.808928764220794}, {-1.4401360936411576`, \
-4.443740408897002}, {-1.4395079645888802`, -4.308736075475107}, \
{-1.4388801670121718`, -4.227885274502009}, {-1.4386821892322432`, \
-5.298317366548036}}], 
        LineBox[{{-1.4377587694791105`, -5.298317366548036}, \
{-1.4376258157565367`, -4.673589042106624}, {-1.4369992610120605`, \
-3.569012752744541}, {-1.4363730359270597`, -4.576794422987429}, \
{-1.4359510751815578`, -5.298317366548036}}], 
        LineBox[{{-1.4355737861083837`, -5.298317366548036}, \
{-1.4351218235913639`, -4.390375619373803}, {-1.4344968352829026`, \
-5.247413968331848}, {-1.4344390840549062`, -5.298317366548036}}], 
        LineBox[{{-1.4336763395247736`, -5.298317366548036}, \
{-1.4332479668078684`, -4.2052928963942735`}, {-1.4327392302783033`, \
-5.298317366548036}}], 
        LineBox[{{-1.4321366048448723`, -5.298317366548036}, \
{-1.4320006560601077`, -5.22932548184958}, {-1.4319539020781844`, \
-5.298317366548036}}], 
        LineBox[{{-1.4308457863702009`, -5.298317366548036}, \
{-1.4307548991585208`, -5.152956474284965}, {-1.4306753845814615`, \
-5.298317366548036}}], 
        LineBox[{{-1.428292624396038, -5.298317366548036}, \
{-1.4282680314418295`, -5.004515793841199}, {-1.428034456890112, \
-5.298317366548036}}], 
        LineBox[{{-1.4272353854037358`, -5.298317366548036}, \
{-1.4270269129366706`, -5.051787807372178}, {-1.426406899825161, \
-4.277916817665166}, {-1.4257873328974344`, -4.298107198403217}, \
{-1.4251680876278896`, -4.117921917704975}, {-1.4245492875147385`, \
-4.996745675320322}, {-1.4241695362152778`, -5.298317366548036}}], 
        LineBox[{{-1.423858650792635, -5.298317366548036}, \
{-1.4233127729933317`, -3.8641187524902656`}, {-1.4226950577163084`, \
-4.578182938306545}, {-1.422307611220961, -5.298317366548036}}], 
        LineBox[{{-1.4216384608539723`, -5.298317366548036}, \
{-1.4214608324396025`, -5.125603506685006}, {-1.4214159237699004`, \
-5.298317366548036}}], 
        LineBox[{{-1.4204445274583402`, -5.298317366548036}, \
{-1.4202281285973302`, -4.108419355434461}, {-1.4198836084002615`, \
-5.298317366548036}}], 
        LineBox[{{-1.4177672702445512`, -4.42451757998899}, \
{-1.4171530314522605`, -3.7007830017060748`}, {-1.4166190730528825`, \
-5.298317366548036}}], 
        LineBox[{{-1.4156586186515971`, -5.298317366548036}, \
{-1.4153124528526964`, -3.2669096227498806`}, {-1.4146997195939561`, \
-4.004628231392718}, {-1.4140873002628984`, -4.348435719040792}, \
{-1.413475317006711, -4.417030960796162}, {-1.4129355184007053`, \
-5.298317366548036}}], 
        LineBox[{{-1.4111497226331773`, -5.298317366548036}, \
{-1.4110309390627105`, -4.530198262322827}, {-1.4108320439977735`, \
-5.298317366548036}}], 
        LineBox[{{-1.4099919077746101`, -5.298317366548036}, \
{-1.4098110175758594`, -4.628550312895307}, {-1.4092016449499942`, \
-4.994552443614887}, {-1.408592582484341, -4.399918752601123}, \
{-1.407983951661553, -4.647926518537731}, {-1.4075528388521383`, \
-5.298317366548036}}], 
        LineBox[{{-1.4072023621087235`, -5.298317366548036}, \
{-1.4067677393468678`, -4.627719079937941}, {-1.4061601570295124`, \
-4.540392490081494}, {-1.40575930451822, -5.298317366548036}}], 
        LineBox[{{-1.4039910402729814`, -5.298317366548036}, \
{-1.4037336339141793`, -4.292470002563744}, {-1.403127952330942, \
-4.544327336325885}, {-1.4025225767960212`, -3.848468552688865}}], 
        LineBox[{{-1.4013129845633252`, -4.463341699545218}, \
{-1.4007087669074316`, -3.798031303944849}, {-1.400577617009055, \
-5.298317366548036}}], 
        LineBox[{{-1.397090926860967, -4.534369996282874}, \
{-1.3964891938880408`, -3.790332725479682}, {-1.3958878829591637`, \
-4.821278745002173}}], 
        LineBox[{{-1.3944731682072966`, -5.298317366548036}, \
{-1.39408599644067, -3.866784774349068}, {-1.3938881328929287`, \
-5.298317366548036}}], 
        LineBox[{{-1.3904919944895109`, -4.008764117333086}, \
{-1.3898942778759669`, -4.4185632288682175`}}], 
        LineBox[{{-1.388699855629594, -3.63144773955341}, \
{-1.3881031492161637`, -4.836412464546969}}]}, {
        Hue[0.6142719099991583, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.528488, 0.470624, 0.701351], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUWnc81d8bv/Ze936kiIhKZkYaiISMhJBQyWhRlJWSyF6FrJSRnV2kQXlO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         "]], 
        LineBox[CompressedData["
1:eJwBkQJu/SFib1JlAgAAACgAAAACAAAAy0odFrra3r9TnJQbejEVwB1EWDHl
zt6/GrM45nHRFMBqWgTyqsLev2pGXSCuehTA7sW1b3O23r95XekOQPIUwMFP
n9o9qt6/6DRg+RdvFMCs9VuZCp7ev8VmSyi+XBTAb7kIq9mR3r+DiGoDUgwU
wAUn33Wrhd6/5PU6/WZOFMAZl7Eqf3nev2FV1K24ThTA7jnOL1Vt3r/dBtCJ
6xwVwHAVVIQtYd6/vq74zK3CFMB9ejCOCFXevwTvgSJHyhTABlzUfuVI3r9N
mJMx8m4UwGSOQbzEPN6/ymSZt2r1E8AMgCyspjDev1s3yRgBnxPAp3d8gIok
3r9KTi1cE8cUwL9O+p5wGN6/K6rnsJghFMDqg8gGWQzevzzhZtn6rBTAbw5Q
HUQA3r+v9TLOppIUwEInFRUx9N2/ONk44Z3sE8B5EJVTIOjdv8WLHafbyBPA
Rjz01xHc3b+y38zPSBwUwGyZUAcG0N2/b7iPnlwAFcDfY8oU/MPdv6DQErGU
iBTANLWTZfS33b/bK37ggEIUwPt9kl7vq92/It7EH8v9E8BZYFsz7J/dv12C
jqbliBTA6V/oSOuT3b+YAJinYcQTwCtLYZ7sh92/rXfuo255E8CIyWGY8Hvd
v7eNlranARXAiuIYa/Zv3b8QzHdYIfMUwDMxNnv+Y92/8nnWbr0LFMC8Z+PH
CFjdv2lj5bn9GRTAgVBytRVM3b9kERBhZBQUwPpuq3gkQN2/cNRqOg1WFMDx
YfR1NTTdv/jxN25UfxTAhtRnEUko3b+FrX0BwbEUwNfOQIBeHN2/9mciwLzS
E8BDua0mdhDdv/Lh88PvXxTAqVIWYa8F3b9TnJQbejEVwOkNUxU=
         "]], 
        LineBox[CompressedData["
1:eJw9U2lQlHUcXi6FFcJ6/8SCgi3RSFpy5YAsLKwJSFwFQg4uiIIgh6uxcohx
jE44yU1xLKJDEcaxgoBgI+z8fpjBxFG0EAzv+y4CEwWooDC7KjDQ9qUPzzxf
n5N/+nzIGV0OhyPU4j++diNor7meCkJrvt2V6WiGot4bl+WvWOjv/CbcsJJg
6PHenweesvA1Ey/esiI4J3X0ejLNwu7LNW58EzPsYCyfm/zJwomiNd1yD4LH
ore5OP/KQnac9Um9IYLdmkj/CAUL7gdm04qjCHYtK0qutrEQ87fBgJGIYMp4
RmJrPQtS07kIyQ6C9UEJpioZCxnlK4MP7xK0CFTPGhexwGsrsynIJBiLQX8J
r7BgsflVVO13BNWOuWnSNBY8b86+qGgmuBtfjzQmsnBBuS8vHghuek6Gz0ax
UGspdo3YoLAhazXRKpSFqRRrATeAoAHfzjvClwWRQlbyrIbC6v0nj8oELFRV
ehi/95TC7u+HpbQ9C8U+7V31Wv29+jr7rG1Z2JJN8o/5EQx7nlwXw2Ph5ZYf
j8s1Q3a97XCzMQuNfoHrL2mCkoVt29UcbZ4dZQb6UoLJwe0hIjUDHyoC5Kv6
BA/NP4gqXmCgr+CdguH7Wr/emYWPVQyodDTOfl4EJ3bqipyUDIw4VLz4+CGF
vYN97Xl9DAxNbh2fGyM4bvDsiOoBA5lrVeOyZQqjc1o0B1sZuH9quvqOlMID
zePvl9YxELEc7CUeJFjdlMRbqmRAflCaXhNDofonf9vAAgZWJm+JXTUUFnm3
B7TkMqC8UKi+t0jh7SXb1TdTGZh+wyk3Lo2gstYtJD2BAQuF4ZmNc9o+bucP
TkUyYHytpetiKEFeTgIeDWHAzr2lwlzbp8R2IumeDwMp5RXCjgqC3Duu9jYC
Bsxsftw1sN0MacmQUZk9AwL/pLOLeQTf7r0l1rdlQLcp9rxTOMFOjSgmg8eA
b3jxK7cjBCdnxrKXjBnQqGb0uVcIumdWtsTpaPPLWOSE9RAcDP4sdEZNAz46
IYnzJ8gXvtsYuUjD75es1vvlBD//6J+d7BQNpYp4iUGjdt/Jjk/EozSYXnd+
5ENTuLyn8OLjfhr2Kn87LOFTWDVaaxLbQ0PIQh62f0DhSlBr5+JdGqZKu3NM
lRQq5YbD0noadD7N99xvSrDU55eSTRkNDtd7nDbqKHSJ8z2VX0SDwvoPc7mA
YNbZUQ/LqzTkJ/VdUs9T6NCQmtecTsOXe1pjDnEIuiiVGcJkGr74YYJ7uonC
nDCj1NFoGt4qeZ2Vy1DIrq3QiWE0eDuUnRMGExywuzmv9wkNY+mCHUMNBKns
keF1T/r/P/8LgG4MNw==
         "]], 
        LineBox[{{-0.41001972214396826`, -5.298317366548036}, \
{-0.40937712252184, -5.075838103589565}, {-0.4086827310440603, \
-5.1734550864786}, {-0.4079887317783496, -4.991432056280774}, \
{-0.40729521381361655`, -5.113718232322157}, {-0.40660226599143273`, \
-5.259203191291901}, {-0.40590970856671504`, -5.053850667346841}, \
{-0.4052176304458575, -5.056243312873504}, {-0.40452603096588763`, \
-5.212435804803112}, {-0.403834998726546, -5.131899424730552}, \
{-0.4031443544833012, -5.054201678891958}, {-0.4024541869003435, \
-5.14411194215134}, {-0.4017644953201755, -5.242247262713513}, \
{-0.4010753681020095, -5.000635048586455}, {-0.400386626499076, \
-5.127267571632647}, {-0.40016652944996167`, -5.298317366548036}}], 
        LineBox[{{-0.39915302881032083`, -5.298317366548036}, \
{-0.39901065358844834`, -5.203325303085166}, {-0.39832333208515147`, \
-5.025371518845597}, {-0.397636482668247, -5.036633074576259}, \
{-0.3969501046896754, -5.136880955563814}, {-0.39626428609082914`, \
-4.889052833661695}, {-0.3955788489893746, -5.010818417650474}, \
{-0.3948938813901442, -5.17756856313207}, {-0.39420938265039057`, \
-4.9481851544913455`}, {-0.39352544047450655`, -5.159303115604214}, \
{-0.3928418774703672, -5.140712675761626}, {-0.3921587814054443, \
-5.031097371974163}, {-0.39147623980721286`, -4.984839898574876}, \
{-0.3907940756494252, -5.1382310797038455`}, {-0.3902730485454581, \
-5.298317366548036}}], 
        LineBox[{{-0.3900037578533958, -5.298317366548036}, \
{-0.3894311417924463, -5.038065935624581}, {-0.38875045875234576`, \
-5.273496560337357}, {-0.3880701508613091, -4.817757358833875}, \
{-0.3873903054744716, -4.973381661989222}, {-0.3868132999153259, \
-5.298317366548036}}], 
        LineBox[{{-0.38658548991096664`, -5.298317366548036}, \
{-0.3860320873872211, -5.043952877018935}, {-0.38535362568801296`, \
-5.201120833517003}, {-0.38467562398700855`, -5.255381588116801}, \
{-0.3839981691689949, -5.0190105291487495`}, {-0.38332108553642424`, \
-5.012751310511403}, {-0.3826444600359229, -5.036746700016793}, \
{-0.38196829204794225`, -4.87924313679494}, {-0.38129266822587987`, \
-4.952804269428501}, {-0.38061741335040467`, -4.991125636969703}, \
{-0.3799426141364059, -4.917727626601616}, {-0.3792682699693383, \
-4.967509806245181}, {-0.37859446727243, -5.276974100242555}, \
{-0.37855025897836864`, -5.298317366548036}}], 
        LineBox[{{-0.3773653847733505, -5.298317366548036}, \
{-0.37724804854230726`, -5.234167098969413}, {-0.37657560524486594`, \
-5.189294528369744}, {-0.3759035270209255, -4.928369709188706}, \
{-0.37523190018277464`, -4.943473878615325}, {-0.37456072412449454`, \
-5.03046477783649}, {-0.37389008486942527`, -5.254396081652607}, \
{-0.37321980849995895`, -4.957112531564155}, {-0.37254998109998727`, \
-4.94786237552386}, {-0.3718806885225928, -5.007995949708665}, \
{-0.3713327467566615, -5.298317366548036}}], 
        LineBox[{{-0.37096181488194035`, -5.298317366548036}, \
{-0.37054327305104834`, -5.190969943898945}, {-0.36987523547282714`, \
-5.206893986139676}, {-0.369207730094264, -5.062288923574545}, \
{-0.3685405838160627, -5.071562115272871}, {-0.3678738823252961, \
-5.280519358965054}, {-0.36720762502927845`, -4.842685923038159}, \
{-0.36654189733032133`, -4.856151604555818}, {-0.3658765265932777, \
-5.235922689969312}, {-0.3652115982800922, -5.264784508084646}, \
{-0.36488529084179916`, -5.298317366548036}}], 
        LineBox[{{-0.36443653976959745`, -5.298317366548036}, \
{-0.363883152340071, -5.124566452129568}, {-0.3632195477184303, \
-5.245735104842828}, {-0.36255638317586103`, -5.250310794639897}, \
{-0.36189374372408906`, -5.268044595142003}, {-0.36123145753424346`, \
-5.23305811459104}, {-0.3605696096771094, -5.090345503992386}, \
{-0.35990819957285153`, -5.105103873189998}, {-0.3595088036284875, \
-5.298317366548036}}], 
        LineBox[{{-0.35880541990016035`, -5.298317366548036}, \
{-0.3585867756218045, -5.235726143064527}, {-0.357926675252349, \
-5.192310537061682}, {-0.35726709552789476`, -5.105392751534707}, \
{-0.3570232447336291, -5.298317366548036}}], 
        LineBox[{{-0.3555214585564236, -5.298317366548036}, \
{-0.35529070752149156`, -5.286060705206449}, {-0.3552048213947868, \
-5.298317366548036}}], 
        LineBox[{{-0.353678845995094, -5.298317366548036}, \
{-0.35331830278529547`, -5.204758070059427}, {-0.3526616698530934, \
-5.140355739239991}, {-0.3520055525576013, -4.988692421370363}, \
{-0.35134978077249707`, -5.022235170826393}, {-0.3506944387422213, \
-5.241737447395773}, {-0.35036795415431843`, -5.298317366548036}}], 
        LineBox[{{-0.3498966433728553, -5.298317366548036}, \
{-0.34938512622666607`, -5.094729302109323}, {-0.3487310700326, \
-5.135010674774931}, {-0.34807744134843865`, -5.203930560187747}, \
{-0.347424323981117, -5.151698686111942}, {-0.34677154858730375`, \
-5.219341189050169}, {-0.34611919903124394`, -5.223885540048615}, \
{-0.3454672747577096, -5.262386033973706}, {-0.344815859358216, \
-4.890211359920159}, {-0.3441647839336194, -4.681333876620705}, \
{-0.3435141321324354, -5.196505405423853}, {-0.34286398738533647`, \
-4.720279419276539}, {-0.34221418112478497`, -5.124765542215123}, \
{-0.3419283038581687, -5.298317366548036}}], 
        LineBox[{{-0.34135409492566055`, -5.298317366548036}, \
{-0.3409158339779603, -4.839302596632534}, {-0.3402673757611629, \
-4.884222122462565}, {-0.3396192540604129, -5.203886728541666}, \
{-0.33897155214934177`, -4.979573121696786}, {-0.33832435308569936`, \
-5.216881514744276}, {-0.3376774890706439, -5.181383939973773}, \
{-0.33703104321816263`, -5.022754172191943}, {-0.33638501498796586`, \
-5.2434120932945385`}, {-0.33621631042832184`, -5.298317366548036}}], 
        LineBox[{{-0.335274065029528, -5.298317366548036}, \
{-0.33509429257009055`, -5.238376821871993}, {-0.33444951392174715`, \
-4.9857812660601075`}, {-0.33380515074503625`, -5.047117500311255}, \
{-0.3335420956217123, -5.298317366548036}}], 
        LineBox[{{-0.33249706896587167`, -5.298317366548036}, \
{-0.331874631762742, -5.003211191879992}, {-0.33156685299097827`, \
-5.298317366548036}}], 
        LineBox[{{-0.33033168703121707`, -5.298317366548036}, \
{-0.3299478325041446, -4.870135747820809}, {-0.3293063625978334, \
-4.836619051094616}, {-0.3286653867089731, -4.980299056497535}, \
{-0.3282845942217019, -5.298317366548036}}], 
        LineBox[{{-0.32730340021751403`, -5.298317366548036}, \
{-0.32674467254610184`, -4.632479991069215}, {-0.3261053360133644, \
-4.785191605654108}, {-0.32546632543754356`, -4.872495851593134}, \
{-0.32482772293548917`, -5.263975621798021}, {-0.3241896104141659, \
-5.218723631720301}, {-0.32398102997599965`, -5.298317366548036}}], 
        LineBox[{{-0.32327534560922144`, -5.298317366548036}, \
{-0.32291444099107586`, -5.084518041587813}, {-0.3222774655330069, \
-4.805054694198378}, {-0.3216409777724205, -4.946619905398182}, \
{-0.32100481270509507`, -5.004979902089017}, {-0.32036905208648003`, \
-5.1603250873207145`}, {-0.3197336954026369, -5.061694314124709}, \
{-0.3191547858044055, -5.298317366548036}}], 
        LineBox[{{-0.319025769267899, -5.298317366548036}, \
{-0.31846427374565256`, -5.122511281809796}, {-0.31783012574031566`, \
-4.854478695068605}, {-0.3174310225263395, -5.298317366548036}}], 
        LineBox[{{-0.31698269419347935`, -5.298317366548036}, \
{-0.3165631166887025, -4.786321132372309}, {-0.31606746010635556`, \
-5.298317366548036}}], 
        LineBox[{{-0.31574474220394927`, -5.298317366548036}, \
{-0.3152976292197342, -4.956375470877533}, {-0.31475837621201863`, \
-5.298317366548036}}], 
        LineBox[{{-0.3143948120563273, -5.298317366548036}, \
{-0.31403382278039155`, -5.219853872141553}, {-0.3134993530506005, \
-5.298317366548036}}], 
        LineBox[{{-0.3133630959492316, -5.298317366548036}, \
{-0.31277153003994673`, -5.084682017138471}, {-0.31214106212659154`, \
-4.959186709376533}, {-0.31151091006324055`, -5.160321569526073}, \
{-0.3108811548414551, -5.089425411574614}, {-0.31025187724866177`, \
-5.099280241931444}, {-0.3099577340092635, -5.298317366548036}}], 
        LineBox[{{-0.30940684104230937`, -5.298317366548036}, \
{-0.3089943464198682, -4.865799588663667}, {-0.30836617352766066`, \
-4.766816080905805}, {-0.3077384760718143, -5.071860256090629}, \
{-0.3071110913408765, -5.213186574073794}, {-0.30648409997476106`, \
-5.2796397682889475`}, {-0.3058575824110274, -5.077699108629052}, \
{-0.30523137624592867`, -5.212000988423537}, {-0.3046055619696008, \
-4.958684822318291}, {-0.30398013909185134`, -4.494015755496319}, \
{-0.30335518785166304`, -5.101531711213919}, {-0.30305074028818557`, \
-5.298317366548036}}], 
        LineBox[{{-0.3012150732898539, -5.298317366548036}, \
{-0.3008590396432461, -4.89807853693029}, {-0.30023595481391935`, \
-5.242232071064322}, {-0.2996132579775571, -5.084195546034692}, \
{-0.29899102902796887`, -4.713276247024534}, {-0.29836910667975425`, \
-5.035090205384204}, {-0.2977475708785571, -5.215503979427777}, \
{-0.29712642114417015`, -4.833901569691332}, {-0.29650573717448175`, \
-4.781940767581914}, {-0.29588535808694383`, -4.797123271025233}, \
{-0.29546340653097924`, -5.298317366548036}}], 
        LineBox[{{-0.29491913001259634`, -5.298317366548036}, \
{-0.2946457533300461, -5.112581889772385}, {-0.29402660668696257`, \
-4.705272077869029}, {-0.2934077632200533, -4.801218409448378}, \
{-0.2927893024835426, -4.7590458305239896`}, {-0.2921713038347462, \
-4.692188292991289}, {-0.29172411513795976`, -5.298317366548036}}], 
        LineBox[{{-0.29066933846516735`, -5.298317366548036}, \
{-0.29031935707505135`, -5.022868850415636}, {-0.28970288249581716`, \
-4.892542237671947}, {-0.2890867081387889, -4.932006940657151}, \
{-0.2884709132188115, -5.136005347470265}, {-0.2878554972688618, \
-5.039297219410125}, {-0.2872405392605525, -4.858663969687312}, \
{-0.2866258798042207, -5.298084947448538}, {-0.2860115979220686, \
-4.886262742345604}, {-0.2853977724420307, -5.058458865467702}, \
{-0.28478424426969073`, -5.104963203952636}, {-0.2841710922833801, \
-4.653102924591541}, {-0.283558316022063, -4.902880116520632}, \
{-0.2829459941229075, -5.056056681140317}, {-0.28259268732956166`, \
-5.298317366548036}}], 
        LineBox[{{-0.2808902557872799, -5.298317366548036}, \
{-0.2805002123215746, -5.143665596829374}, {-0.27988968067943837`, \
-4.96195574983992}, {-0.27927952155876357`, -5.052697473251985}, \
{-0.27866981326507706`, -5.176952326021949}, {-0.2780603977772203, \
-4.74648574479142}, {-0.27745135345042055`, -4.484847026841345}, \
{-0.27684267983284594`, -4.896703520392129}, {-0.27623445504175836`, \
-5.139852516452463}, {-0.27608880639966926`, -5.298317366548036}}], 
        LineBox[{{-0.2750257737835902, -5.298317366548036}, \
{-0.2750189572023376, -5.292610328154009}, {-0.2744118402973715, \
-5.194123273125413}, {-0.2738050133820808, -5.12259210946279}, \
{-0.2735378116935827, -5.298317366548036}}], 
        LineBox[{{-0.2721758383754921, -5.298317366548036}, \
{-0.27198681718142625`, -4.862580875826672}, {-0.27138145960779586`, \
-5.220585313533064}, {-0.27077646827026486`, -5.138583422492289}, \
{-0.27017184272596173`, -4.9461812686097835`}, {-0.2695676605790309, \
-4.384214909814881}, {-0.269010922062058, -5.298317366548036}}], 
        LineBox[{{-0.2688379489987124, -5.298317366548036}, \
{-0.2683602343877711, -5.004335971873194}, {-0.2677571454617259, \
-4.410551975158234}, {-0.26715434217462763`, -4.930385070743537}, \
{-0.26655190204043355`, -4.6457626002089425`}, {-0.26594982462185124`, \
-4.924069909985225}, {-0.26534818719997055`, -4.835295952126169}, \
{-0.26474683385716874`, -4.948782375590683}, {-0.2641458419228865, \
-4.890962681231265}, {-0.26354521096297745`, -5.293558416644897}, \
{-0.26294501807512577`, -4.929967754040944}, {-0.26234510771815195`, \
-4.857014899311082}, {-0.2617455570378515, -4.975498490788005}, \
{-0.2611464429949226, -5.027449541254587}, {-0.2609496170284911, \
-5.298317366548036}}], 
        LineBox[{{-0.260155247902088, -5.298317366548036}, \
{-0.2599491360496791, -5.007698454407691}, {-0.25935101972728264`, \
-4.6374515079542125`}, {-0.25887194125011787`, -5.298317366548036}}], 
        LineBox[{{-0.258074852379497, -5.298317366548036}, \
{-0.2575588913425385, -4.423243881192712}, {-0.2569622025313442, \
-4.233443083645494}, {-0.25656682265852787`, -5.298317366548036}}], 
        LineBox[{{-0.25548615136134645`, -5.298317366548036}, \
{-0.2551743462843094, -4.913181426065788}, {-0.2550226219089729, \
-5.298317366548036}}], 
        LineBox[{{-0.2541297341984292, -5.298317366548036}, \
{-0.25398424106146156`, -4.933891573606496}, {-0.2533896807635232, \
-4.049908060176462}, {-0.2527954737574898, -3.6294401048943437`}, \
{-0.25231625861186985`, -5.298317366548036}}], 
        LineBox[{{-0.2511150381143798, -5.298317366548036}, \
{-0.25101504491007626`, -4.273096338792829}, {-0.2506274294166978, \
-5.298317366548036}}]}, {
        Hue[0.8503398874989481, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.772079, 0.431554, 0.102387], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUXHk8VW0QRkgky00UpShCJVQqy0SkLJElLVSSNtLCl5ItSklKCCG7lCWK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         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {-6.465062156062651, -5.298317366548025}, DisplayFunction :> 
     Identity, Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
         TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameTicks -> {{{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           
           TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           
           TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           
           TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           
           TemplateBox[{"10", "5"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.465062156062651, 
      1.5340848993218748`}, {-5.298317366548036, 11.512925464970229`}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {0, 0}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], 
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0]}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"E72_30.9849\"", "\"E72_10.0001\"", "\"E72_1.5\"", 
       "\"MilliQ_30.9849\"", "\"MilliQ_10.0001\"", "\"MilliQ_1.5\""}, 
      "PointLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #4}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #5}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #6}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.560181, 0.691569, 0.194885]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.922526, 0.385626, 0.209179]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.528488, 0.470624, 0.701351]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.772079, 0.431554, 0.102387]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6}], "}"}], 
           ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "True", ",", "True", ",", "True", ",", "True", ",", "True", 
                 ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.843298149991452*^9, 3.843298203872168*^9, 3.8432982736696587`*^9, {
   3.843298384765218*^9, 3.843298404726954*^9}, 3.84329873022256*^9, {
   3.8432988004009867`*^9, 3.843298803824133*^9}, {3.843298872108584*^9, 
   3.843298895599083*^9}, {3.8432990149186*^9, 3.8432990770538588`*^9}, {
   3.843299137189081*^9, 3.8432991407725573`*^9}, {3.843299840648491*^9, 
   3.843299921480537*^9}, {3.843299960469057*^9, 3.843299972052854*^9}, 
   3.843300012041739*^9, 3.843300096769802*^9, {3.8433001291250687`*^9, 
   3.843300174678563*^9}, {3.852785009054036*^9, 3.852785030774148*^9}, {
   3.852787502594598*^9, 3.852787530539609*^9}, 3.852787791379717*^9, 
   3.852787910287105*^9, 3.852796869163835*^9, 3.8527969417886457`*^9, {
   3.852797012104776*^9, 3.852797018397952*^9}, 3.852862497566475*^9, 
   3.853381366813589*^9, 3.8533814753005857`*^9, 3.853402239868787*^9, 
   3.853469094796208*^9, 3.853496279768393*^9, 3.853499624685063*^9, 
   3.853817846160879*^9, 3.853818247955379*^9, 3.8538246853293123`*^9, 
   3.8538248725516987`*^9, 3.853833076731237*^9, 3.853836454739139*^9, 
   3.853836627576047*^9, 3.8538385410146437`*^9, 3.8540725564096527`*^9, 
   3.854091676757815*^9, 3.854098462801889*^9, 3.8544207604946127`*^9, 
   3.854421164446437*^9, 3.8544212040376797`*^9, 3.8544236563123503`*^9, 
   3.860120820146564*^9, 3.860120992755413*^9, 3.8601402097736197`*^9, 
   3.860141203197979*^9, 3.8617633271887465`*^9, 3.8617673254490795`*^9, 
   3.861941023959653*^9, 3.8619503178258157`*^9, 3.885973462316798*^9, {
   3.8859735791689806`*^9, 3.8859735863327785`*^9}, 3.8859747465859413`*^9, 
   3.8859747986681952`*^9, {3.885975027787902*^9, 3.8859750393330336`*^9}, 
   3.885976328509342*^9, 3.885977032989354*^9, 3.8859775404716673`*^9, 
   3.885979060483423*^9, 3.8859790972689905`*^9, {3.885979294595189*^9, 
   3.885979310657553*^9}, 3.885979644422537*^9, 3.8859798767472997`*^9, 
   3.8859802200758305`*^9, 3.885980276257719*^9, 3.885980545153112*^9, 
   3.885980685497188*^9, 3.8860616074751854`*^9, 3.886152225682108*^9, 
   3.888310978040262*^9, 3.889002269915166*^9, 3.8890603306392736`*^9, 
   3.889064568176372*^9, 3.889081913918378*^9, 3.8890827504249163`*^9, 
   3.889084480239011*^9, {3.8895035588509493`*^9, 3.8895035673865147`*^9}, {
   3.8895042405971904`*^9, 3.889504241091606*^9}, 3.88951548578316*^9, {
   3.8896687291557455`*^9, 3.889668742820923*^9}, 3.8896725906682463`*^9, 
   3.889672649616415*^9, 3.8896726992702703`*^9, {3.889672743456319*^9, 
   3.8896727596135435`*^9}, {3.889672989005809*^9, 3.889673014473555*^9}, 
   3.889673069643585*^9, {3.88967314352767*^9, 3.8896731597222066`*^9}, 
   3.8896731975865993`*^9, 3.8896763716560993`*^9, 3.890203528371027*^9, 
   3.8902035960444994`*^9, 3.8909804917392635`*^9, 3.8909815443374186`*^9, 
   3.8909827436668806`*^9, 3.8914160422882376`*^9, 3.8914972309806986`*^9, 
   3.891497552617916*^9, 3.8914985996710963`*^9, 3.892613780418276*^9, 
   3.8926144542256045`*^9, 3.892696025955387*^9, 3.90203710877135*^9, 
   3.9020419144279413`*^9, 3.9020420016973553`*^9, 3.902042180923932*^9, 
   3.902293482175687*^9, 3.9022966719387836`*^9, 3.9022975312223053`*^9, 
   3.9022975902341137`*^9, 3.902298365560647*^9, 3.90238890053325*^9, 
   3.9024868208198614`*^9, 3.9034208019846087`*^9, 3.903592077708664*^9, 
   3.9041239269086*^9},
 CellLabel->
  "Out[174]=",ExpressionUUID->"1944a1b5-c873-43bb-94c8-3c23eaa4be6b"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2023-07_\
new_data\\\\Analysis\\\\E72 gibbsite - intensity \
weighted\\\\DataRaw.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.843298149991452*^9, 3.843298203872168*^9, 3.8432982736696587`*^9, {
   3.843298384765218*^9, 3.843298404726954*^9}, 3.84329873022256*^9, {
   3.8432988004009867`*^9, 3.843298803824133*^9}, {3.843298872108584*^9, 
   3.843298895599083*^9}, {3.8432990149186*^9, 3.8432990770538588`*^9}, {
   3.843299137189081*^9, 3.8432991407725573`*^9}, {3.843299840648491*^9, 
   3.843299921480537*^9}, {3.843299960469057*^9, 3.843299972052854*^9}, 
   3.843300012041739*^9, 3.843300096769802*^9, {3.8433001291250687`*^9, 
   3.843300174678563*^9}, {3.852785009054036*^9, 3.852785030774148*^9}, {
   3.852787502594598*^9, 3.852787530539609*^9}, 3.852787791379717*^9, 
   3.852787910287105*^9, 3.852796869163835*^9, 3.8527969417886457`*^9, {
   3.852797012104776*^9, 3.852797018397952*^9}, 3.852862497566475*^9, 
   3.853381366813589*^9, 3.8533814753005857`*^9, 3.853402239868787*^9, 
   3.853469094796208*^9, 3.853496279768393*^9, 3.853499624685063*^9, 
   3.853817846160879*^9, 3.853818247955379*^9, 3.8538246853293123`*^9, 
   3.8538248725516987`*^9, 3.853833076731237*^9, 3.853836454739139*^9, 
   3.853836627576047*^9, 3.8538385410146437`*^9, 3.8540725564096527`*^9, 
   3.854091676757815*^9, 3.854098462801889*^9, 3.8544207604946127`*^9, 
   3.854421164446437*^9, 3.8544212040376797`*^9, 3.8544236563123503`*^9, 
   3.860120820146564*^9, 3.860120992755413*^9, 3.8601402097736197`*^9, 
   3.860141203197979*^9, 3.8617633271887465`*^9, 3.8617673254490795`*^9, 
   3.861941023959653*^9, 3.8619503178258157`*^9, 3.885973462316798*^9, {
   3.8859735791689806`*^9, 3.8859735863327785`*^9}, 3.8859747465859413`*^9, 
   3.8859747986681952`*^9, {3.885975027787902*^9, 3.8859750393330336`*^9}, 
   3.885976328509342*^9, 3.885977032989354*^9, 3.8859775404716673`*^9, 
   3.885979060483423*^9, 3.8859790972689905`*^9, {3.885979294595189*^9, 
   3.885979310657553*^9}, 3.885979644422537*^9, 3.8859798767472997`*^9, 
   3.8859802200758305`*^9, 3.885980276257719*^9, 3.885980545153112*^9, 
   3.885980685497188*^9, 3.8860616074751854`*^9, 3.886152225682108*^9, 
   3.888310978040262*^9, 3.889002269915166*^9, 3.8890603306392736`*^9, 
   3.889064568176372*^9, 3.889081913918378*^9, 3.8890827504249163`*^9, 
   3.889084480239011*^9, {3.8895035588509493`*^9, 3.8895035673865147`*^9}, {
   3.8895042405971904`*^9, 3.889504241091606*^9}, 3.88951548578316*^9, {
   3.8896687291557455`*^9, 3.889668742820923*^9}, 3.8896725906682463`*^9, 
   3.889672649616415*^9, 3.8896726992702703`*^9, {3.889672743456319*^9, 
   3.8896727596135435`*^9}, {3.889672989005809*^9, 3.889673014473555*^9}, 
   3.889673069643585*^9, {3.88967314352767*^9, 3.8896731597222066`*^9}, 
   3.8896731975865993`*^9, 3.8896763716560993`*^9, 3.890203528371027*^9, 
   3.8902035960444994`*^9, 3.8909804917392635`*^9, 3.8909815443374186`*^9, 
   3.8909827436668806`*^9, 3.8914160422882376`*^9, 3.8914972309806986`*^9, 
   3.891497552617916*^9, 3.8914985996710963`*^9, 3.892613780418276*^9, 
   3.8926144542256045`*^9, 3.892696025955387*^9, 3.90203710877135*^9, 
   3.9020419144279413`*^9, 3.9020420016973553`*^9, 3.902042180923932*^9, 
   3.902293482175687*^9, 3.9022966719387836`*^9, 3.9022975312223053`*^9, 
   3.9022975902341137`*^9, 3.902298365560647*^9, 3.90238890053325*^9, 
   3.9024868208198614`*^9, 3.9034208019846087`*^9, 3.903592077708664*^9, 
   3.904123929078861*^9},
 CellLabel->
  "Out[175]=",ExpressionUUID->"56b4168c-5f41-4b33-82c0-85ea87acf373"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Process data", "Subsubsection",
 CellChangeTimes->{{3.8601399392765074`*^9, 3.8601399407209606`*^9}, {
   3.8859798317515917`*^9, 3.885979836205883*^9}, 
   3.8896895105228753`*^9},ExpressionUUID->"c68dbf72-8a8c-4c44-a3ef-\
9c60b7918969"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Subtract", " ", "backgrounds"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"dataToAnalyze", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"scatteringDataSampleAveragedSubtracted", "[", 
        RowBox[{
        "\"\<E72_30.9849\>\"", ",", "\"\<MilliQ_30.9849\>\"", ",", "1.02"}], 
        "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"scatteringDataSampleAveragedSubtracted", "[", 
         RowBox[{
         "\"\<E72_10.0001\>\"", ",", "\"\<MilliQ_10.0001\>\"", ",", "1.02"}], 
         "]"}], ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"wat", " ", "doen", " ", "de", " ", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", "0"}], "}"}], ",", " ", 
             RowBox[{"{", 
              RowBox[{"0", ",", "4"}], "}"}]}], "}"}], "?", " ", "--"}]}], 
         ">", " ", 
         RowBox[{
         "vermenigvuldig", " ", "alle", " ", "intensity", " ", "waardes", " ",
           "met", " ", "4"}]}], "*)"}], 
       RowBox[{
        RowBox[{"scatteringDataSampleAveragedSubtracted", "[", 
         RowBox[{"\"\<E72_1.5\>\"", ",", "\"\<MilliQ_1.5\>\"", ",", "1.02"}], 
         "]"}], ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"plotDataSubtracted", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
     RowBox[{"dataToAnalyze", ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<31 m\>\"", ",", " ", "\"\<10 m\>\"", ",", " ", "\"\<1.5 m\>\""}],
         "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", 
         RowBox[{"{", " ", 
          RowBox[{
           RowBox[{"10", "^", 
            RowBox[{"-", "5"}]}], ",", 
           RowBox[{"10", "^", "5"}]}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<DataSubtracted.pdf\>\""}], "}"}], "]"}], ",", 
     "plotDataSubtracted"}], " ", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.852787913735702*^9, 3.852788081126293*^9}, {
   3.852788124237091*^9, 3.852788221803185*^9}, {3.85278830511749*^9, 
   3.852788314820683*^9}, 3.852788353883409*^9, {3.8527951901832237`*^9, 
   3.852795266554426*^9}, {3.852795790301991*^9, 3.852795801188776*^9}, {
   3.8534052664208517`*^9, 3.853405359776355*^9}, 3.853405404221602*^9, {
   3.853409748113482*^9, 3.8534097682258587`*^9}, 3.853410243789892*^9, {
   3.853410568646674*^9, 3.853410593142272*^9}, {3.8538366552098618`*^9, 
   3.853836688425962*^9}, {3.8544213058580093`*^9, 3.8544213392155523`*^9}, {
   3.854421399974036*^9, 3.854421487835609*^9}, {3.860120980130918*^9, 
   3.8601209825914593`*^9}, {3.8601399447486825`*^9, 3.860139952932967*^9}, {
   3.861763386455724*^9, 3.8617634066433244`*^9}, {3.8617636721585855`*^9, 
   3.8617636911551275`*^9}, 3.861763753820904*^9, {3.861763829259494*^9, 
   3.8617638295877748`*^9}, {3.8617640171756115`*^9, 
   3.8617640685814066`*^9}, {3.861764108969255*^9, 3.8617641095314784`*^9}, {
   3.8617641469152203`*^9, 3.8617641470504246`*^9}, {3.8617642667147017`*^9, 
   3.861764269211673*^9}, {3.861764301965845*^9, 3.8617643679072943`*^9}, {
   3.861764616394006*^9, 3.861764629873103*^9}, {3.8617647074999027`*^9, 
   3.861764707889408*^9}, {3.861767331688716*^9, 3.8617674531915107`*^9}, {
   3.8619430250008717`*^9, 3.8619430252780623`*^9}, 3.885975125250722*^9, {
   3.885975162956421*^9, 3.8859751687928877`*^9}, {3.885975253564953*^9, 
   3.885975292171652*^9}, {3.8859753684038987`*^9, 3.8859753944654756`*^9}, {
   3.8859764080472107`*^9, 3.885976444462107*^9}, {3.8859766205505714`*^9, 
   3.885976701234559*^9}, {3.885977061431158*^9, 3.885977105613533*^9}, {
   3.8859775666625447`*^9, 3.8859775972455435`*^9}, {3.8859793109661627`*^9, 
   3.8859793451759176`*^9}, {3.8859793845178595`*^9, 
   3.8859794119426813`*^9}, {3.8859794524741387`*^9, 3.885979469919469*^9}, {
   3.8859796644128475`*^9, 3.8859797943053474`*^9}, {3.885979909660304*^9, 
   3.885979925707234*^9}, {3.885980058912956*^9, 3.8859800719340887`*^9}, {
   3.8859802956113253`*^9, 3.885980299515154*^9}, {3.8859803946280155`*^9, 
   3.8859804083447933`*^9}, {3.8859805548112154`*^9, 3.885980558763019*^9}, {
   3.8859806884189878`*^9, 3.8859807559686003`*^9}, {3.886061779883998*^9, 
   3.8860618911826696`*^9}, {3.886062270796764*^9, 3.8860623299442167`*^9}, {
   3.88606290416301*^9, 3.88606290438365*^9}, {3.886152279651626*^9, 
   3.8861523073398314`*^9}, {3.8861523706298904`*^9, 
   3.8861523714286704`*^9}, {3.888311253563958*^9, 3.8883112815379667`*^9}, {
   3.8895154757176466`*^9, 3.889515521326418*^9}, 3.889668778999714*^9, {
   3.8896725208785334`*^9, 3.889672555662263*^9}, {3.8896761687511916`*^9, 
   3.8896761875813046`*^9}, {3.8896762430656424`*^9, 3.8896763228575*^9}, {
   3.890203680281665*^9, 3.8902036879233007`*^9}, {3.890203721626855*^9, 
   3.8902037336503353`*^9}, {3.890203765562109*^9, 3.890203784550714*^9}, {
   3.890216653073305*^9, 3.89021672873991*^9}, {3.8902167682576685`*^9, 
   3.890216804044831*^9}, {3.89021744880861*^9, 3.890217482686234*^9}, {
   3.8902177558058324`*^9, 3.890217761492506*^9}, {3.8909816465407667`*^9, 
   3.890981653810565*^9}, {3.8909826260035453`*^9, 3.89098264917115*^9}, {
   3.890982718701262*^9, 3.890982720715917*^9}, {3.8914972861846867`*^9, 
   3.8914972916516743`*^9}, {3.89149732190543*^9, 3.891497325080738*^9}, {
   3.8914973608592787`*^9, 3.891497387301942*^9}, {3.8914981362303147`*^9, 
   3.8914982511085134`*^9}, {3.891498313222266*^9, 3.8914983218384113`*^9}, {
   3.891498500855095*^9, 3.891498501109005*^9}, {3.902293403750101*^9, 
   3.9022934262445173`*^9}, 3.902293761601369*^9, 3.9022937955237455`*^9, {
   3.9022959828127484`*^9, 3.902295995749625*^9}, {3.9022961816469045`*^9, 
   3.902296183148714*^9}, {3.902296613680443*^9, 3.902296659428668*^9}, {
   3.9022974286181245`*^9, 3.902297523060432*^9}, {3.9022975813047495`*^9, 
   3.9022975816086473`*^9}, {3.902298249355943*^9, 3.9022983180114884`*^9}, {
   3.9022983493393493`*^9, 3.902298349806218*^9}, {3.9023034979806356`*^9, 
   3.902303498185611*^9}, {3.902388924727709*^9, 3.9023890530627127`*^9}, {
   3.9024868261714544`*^9, 3.902486836515318*^9}},
 CellLabel->
  "In[176]:=",ExpressionUUID->"5cc1674a-6b09-4f41-a48c-1487561a3f0f"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUV3c81e8Xv3vYXFeFpr6EMiJp8DxKQxGS1VRCRrKpyAwVGUklDUlaSlvE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         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUV3k8lN8XnjH2fU9SWUvWUPoWet8WsqQiZQshSrYWlULZkq0kURIiS2Wr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         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUV3c81t8Xlz3KTDzm8yiJhpUviY6MlBGVGSlaiqhIVEaUspJRkZJVMioi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         "]], 
        LineBox[CompressedData["
1:eJwVUmtQlGUUXqkgJEhFRhZk9/t2MTdnhUiKldsBV1wuIiJYCwgruBDEXQsY
MQgsDBQBM7lMMAkkLIxMxC2Jy9kJEYyCHVJusg0QiMleROl7ccTafpx5fjxn
5jyXQ8ekHos1YrFY7ob5H5uqgttmpxmIaKrdU2O8G3PzMu7bPmBAtLf4WZKK
h5aPum1r1Qys6H9pUHbRGGel3iGYY+DYrYcvxzbRuNv3nZabCwywTDON/x6m
sPWqSv3uEgN7BZdKinp4qB8WFHctG/iAlGxFCYVmIyOrbo8ZiHpRtLz5CRen
b3Of9msYCKyT79l8iMKIy96XxXoGZKai+JYgezytbGoYXGXA2tanSR5FoUD3
W5bfGgOjDxS+DWwafay4i78yDKSFVRaHVFC4YmM/FvicAWVccmqiP4Wuqc5n
Rl8wMFHofa1xP4WNMlXr0X8ZyPvYXKnuofF5uM0l1SYCd/jDHSIdhYvaG4vB
rxJYmcrSVbTRGF7QxKiMCXj+7OI68w8HfW1/+j7YlMABcdrMxnUuts5pdWNm
BIz0Dh29P9LII8ytIAsC+SlTYmkahZWr8+6/byEQIy/dpvqExs7o0BOHLQlc
+SrB3dmgzx8Sre9aEYjGH3zjhBS+tWs+VGJNYAHiwnJzaPTcqPcfsCGQ6/JR
0Z1eCr2nEma97Ais1cm35lfTKI0m+h4ugf7JLRlCJxr9Zuk+EY+Awm5dvmZE
Y0q6QtBub9gXxrPj7/JQ9p1Jt+JtAoXnyhaPfEhhh33sBl9IoJTePmc8QKMV
VqmrHQjcK1AlS5x5KBwdjNzhROAUt2ao+yqF/aXjUaX7CLCf1Zc8tODiqT8D
k9ZdCcQdFUuqL/LxQtSTpTQPAtLrmmSxDR/HlTf0UQcInMndfkEdYo/eM12S
ewcJ1I7ORjp78TBz33JYgMSQj0noSHo6D9Mr3cyUfgQkh/5q61vi4zecPsfm
IwY/uvaKORYfE8Oc+rnBhvvmGeXEh0avSE/t1yEEhoriLS8a/suuy6jX5AMC
Zbowv6UgGstrGt/MlhKY3tYVeDyVi7ITIo42nEDzl5ni9iAOVg5MjJyMJPAy
e3/2tAuNDg71tuMyAljoZkWuULjeMqk9GEOg87Xssxb9NL4hjMjplBv6Oxk7
LR3nIZuq/eP1JALD3zqKPNZo1MgChgY/JfB5copm0IODTxUC2XtZBNzuh0/k
sznY6n66vO4sAR2bM/HKTg5qBGXHt35G4HyzpmOSRWNBlbkqJ5fAfJ0jzpyj
0DHksPZxHoHK0gDlbaedGLOQcFP6BQHH97MWHw3Z4X/c5OlE
         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {-6.210316753436899, -11.512925464970204`}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameTicks -> {{{{
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           
           TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           
           TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           
           TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           
           TemplateBox[{"10", "5"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000], -10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 3]], -10.41431317630212], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000], -10.126631103850338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000], -9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000, 3]], -9.721165995742174], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 7]], -9.567015315914915], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500], -9.433483923290392], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 9]], -9.315700887634009], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000], -10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 3]], -10.41431317630212], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000], -10.126631103850338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000], -9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000, 3]], -9.721165995742174], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 7]], -9.567015315914915], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500], -9.433483923290392], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 9]], -9.315700887634009], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.210316753436899, 
      1.5323111318559417`}, {-11.512925464970229`, 11.512925464970229`}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {0, 0}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], 
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0]}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"31 m\"", "\"10 m\"", "\"1.5 m\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.560181, 0.691569, 0.194885]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.8527879438310833`*^9, 3.852787964921023*^9}, {
   3.8527880302138367`*^9, 3.8527880537745132`*^9}, 3.852788084697062*^9, {
   3.8527881270170593`*^9, 3.852788224333301*^9}, 3.85278831785238*^9, 
   3.852788361683811*^9, {3.852795206034478*^9, 3.852795268644823*^9}, {
   3.852795796660235*^9, 3.852795803347172*^9}, 3.852862499690114*^9, 
   3.853381367103548*^9, 3.853381477275778*^9, 3.8534022418114157`*^9, 
   3.853402534499599*^9, {3.853405270422613*^9, 3.853405324836055*^9}, 
   3.853405407395211*^9, {3.8534097505906153`*^9, 3.8534097703076878`*^9}, 
   3.853410187279647*^9, 3.8534102457215548`*^9, {3.853410571397106*^9, 
   3.853410595830978*^9}, 3.853469096590513*^9, 3.853469303037784*^9, 
   3.853496283640119*^9, 3.8534996296665163`*^9, 3.853817848440113*^9, 
   3.8538182517655993`*^9, 3.853824687596098*^9, 3.85382487471694*^9, 
   3.8538330798017387`*^9, 3.853836456463883*^9, {3.853836638285132*^9, 
   3.853836690462969*^9}, 3.853838543040962*^9, 3.854072558224156*^9, 
   3.854091678576386*^9, 3.8540984652252827`*^9, 3.8544207625736847`*^9, 
   3.854421344558304*^9, {3.8544214059054337`*^9, 3.854421491046699*^9}, 
   3.854423662477191*^9, 3.8601208220618477`*^9, 3.860120994483048*^9, 
   3.86012125099901*^9, 3.860140222318944*^9, 3.8601412086662254`*^9, 
   3.861763743975759*^9, 3.86176383617095*^9, {3.8617640582820826`*^9, 
   3.861764074747286*^9}, 3.8617641740186996`*^9, 3.861764274902935*^9, {
   3.8617643353175488`*^9, 3.861764372253722*^9}, {3.861764623510527*^9, 
   3.8617646348513403`*^9}, 3.8617647132308836`*^9, {3.861767375375707*^9, 
   3.861767457590822*^9}, 3.861941029316691*^9, 3.861950322744031*^9, 
   3.8636862718685603`*^9, 3.8636872310576773`*^9, 3.885975309403617*^9, {
   3.885975375253332*^9, 3.885975398991347*^9}, 3.885976450290474*^9, {
   3.8859766273930984`*^9, 3.885976705321181*^9}, {3.885977079657692*^9, 
   3.8859771107489624`*^9}, 3.885977602788784*^9, {3.885979327503832*^9, 
   3.885979350000666*^9}, {3.8859793893365097`*^9, 3.8859794164248023`*^9}, {
   3.885979462547427*^9, 3.8859794743961115`*^9}, {3.8859797044283705`*^9, 
   3.8859797993350043`*^9}, {3.885979917813003*^9, 3.885979931062524*^9}, {
   3.8859800636906133`*^9, 3.8859800779593983`*^9}, 3.885980312698554*^9, {
   3.8859804016551037`*^9, 3.8859804126591787`*^9}, 3.8859805640552745`*^9, {
   3.885980715872667*^9, 3.8859807602126627`*^9}, {3.8860618090326586`*^9, 
   3.886061895699357*^9}, {3.8860622756094923`*^9, 3.8860623347401624`*^9}, 
   3.8860629092400513`*^9, {3.886152285047185*^9, 3.8861523259663725`*^9}, 
   3.8861523762490544`*^9, 3.888310979206479*^9, {3.888311255213608*^9, 
   3.888311282957345*^9}, 3.8890022856520777`*^9, 3.889060337400128*^9, 
   3.889064570327097*^9, 3.8890819151049967`*^9, 3.889082751667604*^9, 
   3.889084481475959*^9, 3.889504256968684*^9, 3.8895154808895187`*^9, 
   3.8895155265896363`*^9, {3.8896687737857976`*^9, 3.8896687838826714`*^9}, 
   3.8896725629108257`*^9, {3.8896761751473627`*^9, 3.889676192632434*^9}, 
   3.889676249961451*^9, {3.8896763044816694`*^9, 3.8896763296834364`*^9}, {
   3.890203672586771*^9, 3.8902037015966415`*^9}, 3.8902037493461847`*^9, 
   3.8902037965747986`*^9, {3.890216658915124*^9, 3.8902167333765697`*^9}, {
   3.890216774140562*^9, 3.890216809078682*^9}, {3.8902174567679343`*^9, 
   3.8902174874612885`*^9}, 3.890217766852687*^9, 3.8909816129922285`*^9, 
   3.890981659451852*^9, {3.890982631522698*^9, 3.890982655851638*^9}, {
   3.890982726501892*^9, 3.8909827519660463`*^9}, 3.891416093072353*^9, 
   3.89149730439897*^9, 3.891497334536474*^9, {3.891497375192842*^9, 
   3.8914973992304735`*^9}, 3.8914975640870247`*^9, {3.8914981450974956`*^9, 
   3.8914982596763473`*^9}, 3.8914983355783367`*^9, 3.891498513742013*^9, 
   3.891498617526591*^9, 3.892613683076393*^9, 3.8926137878875275`*^9, 
   3.892614320742548*^9, 3.8926144631009235`*^9, 3.892696050709646*^9, 
   3.9020371141886473`*^9, 3.9020422033450956`*^9, {3.902293414600558*^9, 
   3.902293439245744*^9}, 3.9022934916413555`*^9, 3.902293767397822*^9, 
   3.9022938022186637`*^9, {3.9022959884699297`*^9, 3.902296000596073*^9}, 
   3.9022961900584164`*^9, 3.9022966191801615`*^9, {3.902296649643454*^9, 
   3.902296681008383*^9}, {3.9022974388816366`*^9, 3.902297539721385*^9}, 
   3.9022976000269976`*^9, {3.9022982677659383`*^9, 3.9022983044354506`*^9}, {
   3.9022983547556195`*^9, 3.902298374198013*^9}, 3.902303513746819*^9, 
   3.902388929531068*^9, {3.9023890355533333`*^9, 3.902389056035737*^9}, 
   3.902486840608371*^9, 3.9034208065085454`*^9, 3.9034300992627583`*^9, 
   3.903592083716814*^9, 3.90403446849244*^9, 3.9041104500505304`*^9, 
   3.904123933411857*^9},
 CellLabel->
  "Out[177]=",ExpressionUUID->"c4ed84c3-8cb7-483c-9d47-358f8432d81f"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2023-07_\
new_data\\\\Analysis\\\\E72 gibbsite - intensity \
weighted\\\\DataSubtracted.pdf\"\>"], "Output",
 CellChangeTimes->{{3.8527879438310833`*^9, 3.852787964921023*^9}, {
   3.8527880302138367`*^9, 3.8527880537745132`*^9}, 3.852788084697062*^9, {
   3.8527881270170593`*^9, 3.852788224333301*^9}, 3.85278831785238*^9, 
   3.852788361683811*^9, {3.852795206034478*^9, 3.852795268644823*^9}, {
   3.852795796660235*^9, 3.852795803347172*^9}, 3.852862499690114*^9, 
   3.853381367103548*^9, 3.853381477275778*^9, 3.8534022418114157`*^9, 
   3.853402534499599*^9, {3.853405270422613*^9, 3.853405324836055*^9}, 
   3.853405407395211*^9, {3.8534097505906153`*^9, 3.8534097703076878`*^9}, 
   3.853410187279647*^9, 3.8534102457215548`*^9, {3.853410571397106*^9, 
   3.853410595830978*^9}, 3.853469096590513*^9, 3.853469303037784*^9, 
   3.853496283640119*^9, 3.8534996296665163`*^9, 3.853817848440113*^9, 
   3.8538182517655993`*^9, 3.853824687596098*^9, 3.85382487471694*^9, 
   3.8538330798017387`*^9, 3.853836456463883*^9, {3.853836638285132*^9, 
   3.853836690462969*^9}, 3.853838543040962*^9, 3.854072558224156*^9, 
   3.854091678576386*^9, 3.8540984652252827`*^9, 3.8544207625736847`*^9, 
   3.854421344558304*^9, {3.8544214059054337`*^9, 3.854421491046699*^9}, 
   3.854423662477191*^9, 3.8601208220618477`*^9, 3.860120994483048*^9, 
   3.86012125099901*^9, 3.860140222318944*^9, 3.8601412086662254`*^9, 
   3.861763743975759*^9, 3.86176383617095*^9, {3.8617640582820826`*^9, 
   3.861764074747286*^9}, 3.8617641740186996`*^9, 3.861764274902935*^9, {
   3.8617643353175488`*^9, 3.861764372253722*^9}, {3.861764623510527*^9, 
   3.8617646348513403`*^9}, 3.8617647132308836`*^9, {3.861767375375707*^9, 
   3.861767457590822*^9}, 3.861941029316691*^9, 3.861950322744031*^9, 
   3.8636862718685603`*^9, 3.8636872310576773`*^9, 3.885975309403617*^9, {
   3.885975375253332*^9, 3.885975398991347*^9}, 3.885976450290474*^9, {
   3.8859766273930984`*^9, 3.885976705321181*^9}, {3.885977079657692*^9, 
   3.8859771107489624`*^9}, 3.885977602788784*^9, {3.885979327503832*^9, 
   3.885979350000666*^9}, {3.8859793893365097`*^9, 3.8859794164248023`*^9}, {
   3.885979462547427*^9, 3.8859794743961115`*^9}, {3.8859797044283705`*^9, 
   3.8859797993350043`*^9}, {3.885979917813003*^9, 3.885979931062524*^9}, {
   3.8859800636906133`*^9, 3.8859800779593983`*^9}, 3.885980312698554*^9, {
   3.8859804016551037`*^9, 3.8859804126591787`*^9}, 3.8859805640552745`*^9, {
   3.885980715872667*^9, 3.8859807602126627`*^9}, {3.8860618090326586`*^9, 
   3.886061895699357*^9}, {3.8860622756094923`*^9, 3.8860623347401624`*^9}, 
   3.8860629092400513`*^9, {3.886152285047185*^9, 3.8861523259663725`*^9}, 
   3.8861523762490544`*^9, 3.888310979206479*^9, {3.888311255213608*^9, 
   3.888311282957345*^9}, 3.8890022856520777`*^9, 3.889060337400128*^9, 
   3.889064570327097*^9, 3.8890819151049967`*^9, 3.889082751667604*^9, 
   3.889084481475959*^9, 3.889504256968684*^9, 3.8895154808895187`*^9, 
   3.8895155265896363`*^9, {3.8896687737857976`*^9, 3.8896687838826714`*^9}, 
   3.8896725629108257`*^9, {3.8896761751473627`*^9, 3.889676192632434*^9}, 
   3.889676249961451*^9, {3.8896763044816694`*^9, 3.8896763296834364`*^9}, {
   3.890203672586771*^9, 3.8902037015966415`*^9}, 3.8902037493461847`*^9, 
   3.8902037965747986`*^9, {3.890216658915124*^9, 3.8902167333765697`*^9}, {
   3.890216774140562*^9, 3.890216809078682*^9}, {3.8902174567679343`*^9, 
   3.8902174874612885`*^9}, 3.890217766852687*^9, 3.8909816129922285`*^9, 
   3.890981659451852*^9, {3.890982631522698*^9, 3.890982655851638*^9}, {
   3.890982726501892*^9, 3.8909827519660463`*^9}, 3.891416093072353*^9, 
   3.89149730439897*^9, 3.891497334536474*^9, {3.891497375192842*^9, 
   3.8914973992304735`*^9}, 3.8914975640870247`*^9, {3.8914981450974956`*^9, 
   3.8914982596763473`*^9}, 3.8914983355783367`*^9, 3.891498513742013*^9, 
   3.891498617526591*^9, 3.892613683076393*^9, 3.8926137878875275`*^9, 
   3.892614320742548*^9, 3.8926144631009235`*^9, 3.892696050709646*^9, 
   3.9020371141886473`*^9, 3.9020422033450956`*^9, {3.902293414600558*^9, 
   3.902293439245744*^9}, 3.9022934916413555`*^9, 3.902293767397822*^9, 
   3.9022938022186637`*^9, {3.9022959884699297`*^9, 3.902296000596073*^9}, 
   3.9022961900584164`*^9, 3.9022966191801615`*^9, {3.902296649643454*^9, 
   3.902296681008383*^9}, {3.9022974388816366`*^9, 3.902297539721385*^9}, 
   3.9022976000269976`*^9, {3.9022982677659383`*^9, 3.9022983044354506`*^9}, {
   3.9022983547556195`*^9, 3.902298374198013*^9}, 3.902303513746819*^9, 
   3.902388929531068*^9, {3.9023890355533333`*^9, 3.902389056035737*^9}, 
   3.902486840608371*^9, 3.9034208065085454`*^9, 3.9034300992627583`*^9, 
   3.903592083716814*^9, 3.90403446849244*^9, 3.9041104500505304`*^9, 
   3.904123936017211*^9},
 CellLabel->
  "Out[178]=",ExpressionUUID->"7cb7e6c0-16d3-44cd-87de-4f99203aa987"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Merge", " ", 
    RowBox[{"(", "relevant", ")"}], " ", "patterns"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Usually", " ", "we", " ", "only", " ", "merge", " ", "pattern", " ", "2",
      " ", "and", " ", "3"}], ",", " ", 
    RowBox[{
    "but", " ", "sometimes", " ", "we", " ", "also", " ", "use", " ", "1", 
     " ", "when", " ", "2", " ", "contains", " ", "a", " ", "weird", " ", 
     "kink", " ", "or", " ", "noise", " ", "etc"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"only", " ", "pattern", " ", "2", " ", "and", " ", "3"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"datamerged", "=", 
     RowBox[{"mergeData", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.1"}], "&"}]}], "]"}], ",",
        " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"default", ":", " ", 
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}]}], "&"}], " ", 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.06", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "2"}], "&"}]}], "]"}]}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"default", ":", " ", 
         RowBox[{"0.2", "<", 
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "2"}]}], "&"}], " ", "*)"}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"only", " ", "pattern", " ", "1", " ", "and", " ", "3"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"datamerged", "=", 
     RowBox[{"mergeData", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.1"}], "&"}]}], "]"}], ",",
        " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"default", ":", " ", 
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}]}], "&"}], " ", 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.06", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "2"}], "&"}]}], "]"}]}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"default", ":", " ", 
         RowBox[{"0.2", "<", 
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "2"}]}], "&"}], " ", "*)"}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Sequential", " ", "merging", " ", "of", " ", "first", " ", "pattern", 
     " ", "1"}], " ", "+", " ", 
    RowBox[{"2", " ", "and", " ", "then", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "2"}], ")"}]}], " ", "+", " ", "3"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"datamerged1", "=", 
     RowBox[{"mergeData", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.005", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}], "&"}]}], "]"}], ",", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"default", ":", 
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}]}], "&"}], "*)"}], 
       " ", 
       RowBox[{"(*", " ", 
        RowBox[{"0.005", "<", 
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "<", "0.2"}], " ", "*)"}], " ", 
       RowBox[{"(*", " ", 
        RowBox[{"0.02", "<", 
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "<", "0.2"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.02", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}], "&"}]}], "]"}]}], 
      " ", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"default", ":", 
         RowBox[{"0.2", "<", 
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "2"}]}], "&"}], "*)"}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datamerged", "=", 
     RowBox[{"mergeData", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Select", "[", 
        RowBox[{"datamerged1", ",", 
         RowBox[{
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}], "&"}]}], "]"}], ",", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"default", ":", 
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}]}], "&"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.05", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "2"}], "&"}]}], "]"}]}], " ", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"default", ":", 
         RowBox[{"0.2", "<", 
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "2"}]}], "&"}], "*)"}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{"0.05", "<", 
        RowBox[{"#", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "<", "1"}], " ", "*)"}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{"0.05", "<", 
        RowBox[{"#", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "<", "0.7"}], " ", "*)"}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
    RowBox[{"datamerged1", ",", "\[IndentingNewLine]", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameTicks", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
          RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", 
          RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",", 
     " ", 
     RowBox[{"(*", " ", 
      RowBox[{
      "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
       " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
       "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"LabelStyle", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
       "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameLabel", " ", "->", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
         "\"\<\!\(\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
       "}"}]}]}], "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"plotDataMerged", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
     RowBox[{"datamerged", ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<DataMerged.pdf\>\""}], "}"}], "]"}], ",", "plotDataMerged"}], 
    " ", "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Bin", " ", "data"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datamergedbinned", "=", 
     RowBox[{"binData", "[", 
      RowBox[{"datamerged", ",", "0.05"}], "]"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"default", ":", " ", "0.05"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"plotDataBinned", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
     RowBox[{"datamergedbinned", ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<DataMergedBinned.pdf\>\""}], "}"}], "]"}], ",", 
     "plotDataBinned"}], " ", "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Export", " ", "merged", " ", "and", " ", "binned", " ", "data", " ", 
     RowBox[{"(", 
      RowBox[{
      "for", " ", "plotting", " ", "in", " ", "Python", " ", "or", " ", 
       "other", " ", "software"}], ")"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"exportlist", " ", "=", " ", 
     RowBox[{"exportData", "[", "datamergedbinned", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"FileBaseName", "[", 
          RowBox[{"NotebookFileName", "[", "]"}], "]"}], "<>", 
         "\"\< SAXS data merged and binned.csv\>\""}]}], 
       "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}], ",", 
     "\[IndentingNewLine]", "exportlist"}], "\[IndentingNewLine]", 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.854423668689094*^9, 3.854423681960602*^9}, {
   3.8601210812169123`*^9, 3.8601211773702602`*^9}, {3.860121220142*^9, 
   3.860121220876803*^9}, {3.860121492525386*^9, 3.8601215079101877`*^9}, {
   3.860121718604267*^9, 3.8601217659879427`*^9}, {3.860121814486486*^9, 
   3.860121940090294*^9}, {3.860121990307417*^9, 3.860122029773138*^9}, {
   3.86012227550008*^9, 3.860122412026474*^9}, {3.860123590194846*^9, 
   3.8601236144362907`*^9}, 3.8601236508219957`*^9, {3.860139958454444*^9, 
   3.8601400142502003`*^9}, {3.8601409041122975`*^9, 
   3.8601409737863803`*^9}, {3.860141247131112*^9, 3.8601412486662936`*^9}, 
   3.860141363728487*^9, {3.861764464753133*^9, 3.8617644999883156`*^9}, {
   3.8617650690038815`*^9, 3.861765107161731*^9}, {3.8617654080879517`*^9, 
   3.8617654464808097`*^9}, {3.8617667857822647`*^9, 3.861766817572381*^9}, {
   3.861767478263466*^9, 3.8617674824174633`*^9}, {3.8617675156782837`*^9, 
   3.8617675385223627`*^9}, {3.861767600750394*^9, 3.8617678801582737`*^9}, {
   3.861768004639906*^9, 3.861768004842128*^9}, {3.8617680471976347`*^9, 
   3.8617680542883253`*^9}, 3.8617682512241673`*^9, {3.8619408859545107`*^9, 
   3.8619408879723635`*^9}, 3.8619500601432023`*^9, {3.8859755937637935`*^9, 
   3.8859756289602833`*^9}, {3.8859767824682684`*^9, 
   3.8859768072202587`*^9}, {3.885976912247283*^9, 3.885976915489427*^9}, {
   3.885977184321333*^9, 3.8859771875417037`*^9}, {3.8859772431391516`*^9, 
   3.8859772459190493`*^9}, {3.8859776946505795`*^9, 3.885977697414628*^9}, {
   3.885977754450777*^9, 3.8859777568929634`*^9}, {3.8859804425147095`*^9, 
   3.8859804438235583`*^9}, 3.8859804753994827`*^9, {3.8859807731997614`*^9, 
   3.885980782688805*^9}, 3.8860629984459877`*^9, {3.886063060466019*^9, 
   3.8860631273919067`*^9}, {3.886071125028043*^9, 3.8860711896934166`*^9}, {
   3.8860714254613867`*^9, 3.8860714550837*^9}, {3.8895154616447597`*^9, 
   3.8895154658794193`*^9}, {3.8896724114246473`*^9, 3.889672412507053*^9}, {
   3.889672471225835*^9, 3.8896725071452694`*^9}, {3.889674589350315*^9, 
   3.889674633174043*^9}, {3.889674670910601*^9, 3.889674765787591*^9}, {
   3.8896748131059356`*^9, 3.889674848516157*^9}, {3.8896748918371353`*^9, 
   3.8896749698660383`*^9}, {3.8896759808235216`*^9, 
   3.8896760211101522`*^9}, {3.8896760618397036`*^9, 3.889676134804789*^9}, {
   3.8896766120107994`*^9, 3.8896766124494815`*^9}, {3.889676755304323*^9, 
   3.889676755581999*^9}, {3.8902038545244083`*^9, 3.890203901273981*^9}, {
   3.890205930477414*^9, 3.8902059314228735`*^9}, {3.8902102550185256`*^9, 
   3.890210255342898*^9}, 3.8902167482021494`*^9, {3.8902168284956217`*^9, 
   3.89021682871568*^9}, {3.890216868216955*^9, 3.8902168763206763`*^9}, {
   3.8902172079856234`*^9, 3.8902172082346754`*^9}, {3.890981726002406*^9, 
   3.890981786213588*^9}, {3.8909822356137176`*^9, 3.8909822357713594`*^9}, {
   3.8914985305692663`*^9, 3.8914985803250184`*^9}, {3.892613758123871*^9, 
   3.892613758289031*^9}, {3.892614278506711*^9, 3.892614293126571*^9}, {
   3.892614333217201*^9, 3.892614379152516*^9}, {3.9022938086532*^9, 
   3.902293808923072*^9}, {3.90238918370833*^9, 3.902389183938918*^9}, {
   3.902389396889367*^9, 3.9023894106453295`*^9}, {3.903430125454538*^9, 
   3.903430151764394*^9}, {3.903430240062503*^9, 3.903430240867548*^9}, {
   3.9034306297683053`*^9, 3.9034306356294327`*^9}, {3.9035921415968437`*^9, 
   3.9035921633037343`*^9}, {3.90359219789857*^9, 3.903592198255517*^9}},
 CellLabel->
  "In[179]:=",ExpressionUUID->"5b3c3b75-f6f9-43b4-ae93-bf843c1633be"],

Cell[BoxData[
 TemplateBox[{
  "FindMinimum", "lstol", 
   "\"The line search decreased the step size to within the tolerance \
specified by AccuracyGoal and PrecisionGoal but was unable to find a \
sufficient decrease in the function. You may need more than \\!\\(\\*RowBox[{\
\\\"MachinePrecision\\\"}]\\) digits of working precision to meet these \
tolerances.\"", 2, 180, 9, 17038288483706631699, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.9034306393499975`*^9, 3.903592087289709*^9, {3.9035921426412153`*^9, 
   3.9035921639351006`*^9}, 3.9035921994701185`*^9, 3.9040344712607555`*^9, 
   3.9041104576302757`*^9, 3.904123936308488*^9},
 CellLabel->
  "During evaluation of \
In[179]:=",ExpressionUUID->"7430e787-cd5a-4ec3-9db6-70ddc6d1dfab"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.004583333333333334], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJwUl3c8lm8bxp+9H56pQRpKoUhGKrkvDZGsZJQGCYlkk8gMlZKRipCQljJS
IjqtSCWklKiMqF/L3uO937/6fD/HeZ3XOY77erT08IndDiQCgRBOJxD+/++k
0PhO8jwxDBoRtKjOUkhLLd7ZaFIEK98wZdYdkUIfju/51tghAmqOXMRLSynU
/UWxdEGlCJzG36YJDaVQ2EG/+EU5IijRmeglICkkPdb4qjlGBAb5rpfbMSnE
8PI9s9ZLBNNXY3/GaEshpYtbI5T3iaBm8ImmMh6vWtsmW6MrgqZr9ICz66SQ
0CFk6x8FEQjlnWIubZZCEzOZRjcEItD2Gv6Ru0EKef4dkvg4JYTKUyZyvSpS
6Fy/B1z8LoTnfuefOi2XQjs42RPlb4Vw2GqQrLxSCn3LeHzbvkQIe+SOTzXg
XNklS/fPFoLPRyfv/Xj86nOWWWOX8PNZWl+apKWQ1ZYDel8ChUCcjnHsXiiF
PvfWjKx0FoLb3Q75bQuk0JBV7nCjhRD2cxT11+KsuMa35P0WIWyj5P/REEuh
2sa+f+vWCmFpVVh/rUAK2ey75fJ9kRBu11q2egmlkH7DhPJ/bCF8XT336glT
Cp05235YZ1IADs8e1Y3jXJlsYPH1hwD+jeSUj1Kk0Ing5hP1rQJou9WleJ0r
hVYeRGYzLwSwa3HRT0mGFHrFCsjweSwAbPBd7iBZCsltLlFSvSUAg8Qr1cuI
Umj6S8n7NUkCkFhyatF/k2K0AwnTnCMFUFobclFxRowUJoqSu3wFMBhyjL5l
VIwkMs+PJTkJ4GpqoLXjsBg9bV85EmEtgKS8G9QzOJ8zSeq7ayCAHVRD/604
l93arEHfJIBul5AP6LcYxaZ+sLi6WgC2OmOK7/rFaIufT9N+WQEQm2+nmf4U
I5sDWZg5TwAR6Sde1vwRo6TQnyiAJIA9H8aJOd1ipBaYkdg4zIe6vj1hx/rE
qHiF+uiePj5AeJpNKs5yZ1XUaG186Dud3pfWJUYrl/1Z3v2aD56R/rYE/Lze
1/GH/z3nQ+KzO5x17WIUXBRaJV3IB8bz1k/RrWLE472z9rnFh5+n7tjPNYiR
ku8Hz9FrfPgU4ysX2ChG8Q3XF6Vd4IPSY6GEDq5XFf097hLKh4jkP6Qv9WIE
jt0hB3z44BeeYK6MM6ci6JSXMx8qFk+mqFWIUf2c8bn7B/gwtUC6/9dzMVod
eqidvpsPhGOWfbfL8P4Meosi9Phg9c2GPVMiRoNSlubLNvGB2m8nsa9YjMav
b5j+qsKHDcmakhsfiVHIziWzz5bzIebz7ZNTD8To3rTN/eIFfMjfuWjNtvv4
/tZXHmqW4MNbSsuNvkwx0r/n7suk8KFBXqcfuyFGxz4mmh+Y4IG1ReLX+Kti
9CZR89Cbvzw4uyPn3M0EMRKbUWl7e3jgr5xk33pRjJb/Xvl07hMPzvUf3UON
FqORfxJ/4S0Pyr7y78qdEaOHAgPZ6zU8qHy1M6ksVIw8clHVpVIeXFLSW7w+
QIyIWuGOafk8+O16ZsjNV4x8FXqjq3N4sMTfwtnZXYxWLet6TErjwd61ibnr
jotRwllLb+tEHsSdcDXlHhWjTaRje2rO8SCWlmUfcxD3y2K7n/qhPLhtFN9z
fI8YFX36BF1+PJi/c3nwLVN8vrUeYfFuPPjspu3RbCxGugWuFVYOPCAuVnB3
2SlGm0NCpdft58FRD5ptGiZGGxzJqkvNcU4ND4jdgJ/3qs9avpMHEpxPlFkt
MVq/eJGMti4PTMtMY5+piFF+c7KOkxYPdAse5dctFyNV65WPs1V4IJrm5cjL
idHjNa3KY/I82OfhvUpGGu/nTruljSwPQtNzFV4KxejaD58vTWIe9EQTPrqx
xCjs1Ge/fVweeLlvadIjiNGKepXWYQoPZF92xJfMipDFji9HdCckQVhgkrpx
XISSeiGs9IckDF8/8Tv0nwhFyXFPWX2UhBwUaH/iuwiNWy2vFtVJQqLVMYmk
ThHKO3G7dfCJJHj5/LtT1iRC/E67dQM5krBjrHHNyBsREt+W3yN5VRLEny7u
D6oToar1lc93RUuCXL9SfF25CL21/DJ5218SNqfuaZl7KEK32n9fkHOWhAmx
Qve8eyLUsU1AebZXEnxuHlohmSFC5pL8Xx47cRYUfXNLEaFFF1RG5utJwtof
evNsH4jQcLfGu22bJCFyqp185JIIBXlsM1FfLQmd1q8xhVgRWju4+ge2SBJU
/CtUhsNEyMzYZezMPEnYPtT8OTpOhD6qDRg5SeD9HLpUbO4rQlTeHPfunAQw
Z7+kNnuI0Nfz26rpAxLwPdZdb6G9CD3q/bpi+qcExPkn+V7xEiGHgUaJkC4J
yFzw4Z2XDZ7Po+aCoEUC8lMts/nmIlRpptddXiMB3t9+S/uZidDW2tW/TpRJ
AFHG//ozCxF6f9W1MOKJBFD6g86K9ERIDWll2d+RgHanU79PaotQ76ewAzYp
EvAskLpPerUIXYqnnvoQJwEWStt1NmmK0NX7g9EuFySgJVZsOrhMhD7p/G1K
CJaA9VUyvzPmi5Cz0aXv7zwkQDhqZ50uIUIkV8LjFU4SgH5TRe1iETJcdd1T
6YgExF8Jjz9BFKEwT0+FZEsJKLl/SapsVIiSEO3ZYgMJePhNcWXBiBCZeYXx
9myWAAm/OwPPcX1VfHNH6SYJOPZv3qFjP4WIKde41U1ZAhrSNC5/+SBE3pdc
sjSXSkD4h0aprgYhqpngF1iLJKDHYeqcLK4vf3vqiQjnxFnl0opqIdr8T0uT
QZeAZr/vCVtLhIiipPaZN8mFlsV/3z0vEKLszTsPK//hwmnpb1tUsoRI5+3p
lUq/uUDIc+zeVShE2nNZ0bbfcD7Ovj0/Q4gytt7h5LzjQljttsYb8ULkPzGU
S6zlQlp0g/qlKCFKjyOeqarmQqncWs8MXJeJMlvjXsKF5Ifi7i0BQqRi/3jX
YC4XIhV/FIKnEPVt5NdEZXDhjtHWMTcHIXr66OyOhWlciL9XJ5hyF6IlO/66
rb3MhawvXSNP9gpRyem91N/RXLg8f/DWgLkQufzNMC4J5ILZ5bwQ8TYh4msP
ea/yx/uLeNFXbSxEF7tlBCnuXOC5MlQ8tIVo7Pni+RePcKHV8Skzdq0QTUxN
KCRYc+H8YwZzs5wQBW74Zdm3mwsGdy3M2xSFSMLiH//uLi7cW5e85a5IiM6t
XJfSjLjgvfob04gjRF8HOuI4GlzQ9Y6yKSEI0Zvwueumylw48jXtpxVdiHiE
wUorBS44CufYTf8EqH3zrunCRVy4Wkt69fiHALkpZ3GWCrhQErsIPewQIDnj
DsODLC4Uv97s1/RdgNYzIqvSaFzIRresit4KUP2Q0cDqKQ7s3Wb2ILBegKJc
5Zxe/eOAhPHgd16FAL0aW/2A1ceB5iMMyx84T1QMj57s4cA7/XkSybkC9K7Y
00vrEwduxEt6Kd0UoLCdnDxaAwc2bW6cXZIiQDLFLt6m1Rz4TbhuJ3NDgKzC
/gvpqeSAds3w7mMJAmTi97uk6QkH3igtqDweIUAxdplqDfc5MOKjeFv2JF7P
xv/8FG9yYGjFmGV0oADl1BtXfMrggEdc9/ejTgL0q/XjxuEkDhysUf9caSNA
5bnNfotiOBCzZv8L0QEBsvjlbmoRyoEXpzXNThsKUNtE8+eEEA4cMlTtS98r
QDSd6NQUX7yfndp5I5gAObPPafW7cOCbla7jPy0BWna7eXC3HQe4bxbstFDB
z1v0jUYd4oA0vW//Yw28vgqX4ipLDrjRFKUkZARIOeetzZZdHLgw+OE6sAVo
bKSyuEGXA5NLP/u2kgUo7keIJwnjgI3ekOgKX4B0E6/cO7qeA+FlMX6yBAHi
tCrweWs4sH1hxZXHQ3zk+rTjRfUyDuQ5zjfgD/CR3JlEwZwsB1o+Oa6f+ctH
X1Zcvxs5nwO7jMoMSzr5qMW0MdlCggMay9JXpjbxkWC5g68qhQP1xm8Xb37J
R8KvF96fnGOD0zEpqaTXfLS7pFJm4SQbxNXhPUHlfJT736vjkv1siPwXvEXr
AR8d6v5swO9lg9+WL+OPc/hobnngD7dvbIhwMSvzu8tH7u+q4ha3s6ErL3D5
r+t89PpmnfzGZjb824RmO3E+VnzjP9s6NiSWtfdKRfDRcBO63lbBhvZpruXt
aD4SN3g8Tyhnw3lltzX1gXwk3fQuuPkRG2YZxS/kj/PRbEC17KJ7bPit0pOZ
u5+Ptq3bEP40kw2T64dIcQ58pK15y88rgw2auRnZKVb4fWY73N5fYcPJC3Rp
kSEfqZt+7t1ykQ3Ow/zzezA+Wn8xVJMRyYayEyPlW7bxkQZzoqY0gg0nMhNH
rmvy0WjD1X7sFBtid8ssvb0On2emYNdbDzbsWJcXuk6Zj9R8tVKqjrLh7Za9
fSw5PnLxlyl3xllofCxHRpaP9LzrVkseYoOez9+bxiw+uqAffvq5BRvUXmx1
2UHkI7cYQXLALjb8yf+bbznHQ2P788N+GLJBR++v0QyuDyxLcERb2fCoxm+K
PcxDzLt+r3gb2cD9Zbkv7DsPXRqMzPu1lg0tzU/kr3/mIblvHjLeKmyQjHr2
2fwbDxFC22YaV+L7temhDdfzUIZURwrIssEb0uZmgIdIWw28SsRsoMrYWswv
5aHp5RoB9kJ8nhRNUy9c95hZebycw4Zi35qyFfd5aLfeW8/XZDakK5/VSr3J
Q5KN3473TLLAWf7noelkHrqhsm68cIwFp54Pnl11g4d8H+rr0wZZcMS/kncx
hoeshdq/VX+yYHBy3CAwlIdUyVrbnL6xwM8q9LnoNA/Juvhz7dtZEKfFdfEK
5qH7ywmbbrWywPekZYKEDw+1R6WW/m1gQcjBivsmzjw0cfJAPnrBgumT5/fV
HeShRRPkJW4VLLCWsT+Zb8dDAQcb6dfLWGBffOUccT8PHbxYd5dQxIKKX207
Io14KGLz3ki3+yywwcIjSVt56MGeBT+ab7EgYLbrn/8WHup2eB/5PZMFFoRP
+UQdHgorbrjqkMKCG31cYYYSD7ETRXf+xrNA9E/1z8nFPGSW+XH6YgwLWOSz
cmeW8VALoTAr5BwLNp2PWpTM5yGNggF/6TAW5JYG92zm8dAyrrnw+UkWWDb7
B8eQeYj1Rqh5w5MFzTpPZoepPFShlmDn4sECx0wP16/jkogqlWO2xJkFJje7
5ml+lkTCqNKmDlsWfPje1rPkjSQqPbwyhLKXBTH0BQlWjZLIzkq9MdOaBaqh
wvwnFZLouNe9TZ6mLFgRsrO3PU8S/aP1kwz0WUCb4uzj50giryyqeBViwZuV
XqqnwyXRZDCv8CnGgt/z2nZHXpVE6h5ydpJaLFAKDfrtFSiJVloUfphVYUHj
vU0dhvaSaL6KmcPoShY8Ds3fn79bEqXHdv8rk2fBstgnzc0HJVEdp356ZDEL
qq2czlVul0S9jtIXZubh8z+19qWpuiTqsPWkcXn4fSEv7mdKSaKomhp1SQkW
LCGrbLNaKYn2cJT2LmewoCP6Vac8TxIZ57312UpggTjQ3CGEKok+CucbHRtn
gmPQI83qMQmE3ChP740wwUUz+07dHwkk//rH26v9TDiZeFwyth3XL8V3Nfxg
QsJ7x2MO9RJovL0jltPJhMmUeVTiPQm0MPp7VVwHE55GWX3IeySB2jc6PDP7
xIQjdWXM0CsSqLv26d60JiYEBhcSKJclkMSqpL2DL5kwvsiAtiFMAu27YBb5
vIYJ+5bvs7PA+WlvR65RJc6c0dJbxyXQ17br+nklTNB44x2Xshuv5yJNZmEh
E77W0xP2m+D3mZG91B4wYWvuieViYwlkleOz8Pw9JlAFBQLCagkktHTRJGfh
+lnenpwVEkiv6uLhsOtMyFlSIzfAkUCLBiY+/kpigqd4K8hIS6DCsPtxjMtM
UKYu+91GlUCP6Y8fX77AhNYugntDLxc5y1RUK0Qy4c/YfwXwhYsS9rps7AvG
71OMefPgBxcZ2dAfVp9mguq/hepaH7jI6t73o45+TCg8LKg1esFFe8s/f5dw
Z0JYcccPcRkX7by2Qn65MxP2z38ek/yYiyrjzi8oP8qE0QK3ho4sLro+UDzm
ZccEQUcEqyuYi6pn9L3X7mOCMLr70J4ALjLO1w0f2s2E0w7tp/ad4iLmjK8w
A2dVtxpzmUguorq+nF9myIRcl5Wtqie4iHJaXuHCNiaUqddKyhzE6ysqv22/
mQlTHYe/7dPjonlNfXf2azPh28Jtq70suOjyH6kYpMkEzumHJgMbucgvo7lW
ToUJ/T84wxHyXGR2utCUu4oJcQscdt5T4KIN22dSLOSZsDutdoC6Cp/XxFXp
mSW4niATYEfjotV9wYuGFjBBs/OXjC2di5aLwgz/CZjgnbPhtv4cB922t444
x2PC9dNnUpzHOKj46/vkATYTFFw3kUs6OCjt4xvCJIUJC+kTdQF1HESz+ejJ
mGXAwkS/jFvPOeig6jnNyUkG9K9db2VTz0H2a4N7ZcYYsOvAhXk6Tzioba2T
2fp+BlzY5LpN4gEH6faa3LH6yYCslz4vnmRwUFayzeHM7wyIXt93fF86B+Wt
FfYEdTEg3DbeoD6Cg5J/Z43d+cwAPc3x9dl+HHQgWdD2uYUBcq+MNP4c56AT
rfHdEY0MCDPw6OJ7cdAeeniosIEBh+4WCcCKgwzHNXpMaxkQeLpFOgpx0NH3
4eMJwIDrFktqojdz0JOoV2mppQxY1Lz/KmkHB7ladTxqf8oA/6GPOzo3cZC5
5itJpUIGGNHVFzWs56Btn/7Mnb7PgFrOb5NhWQ5qveNq+/sWAzYaPLt5azEH
vaPPnPqYzYBPaDf+n3AOCrteG7A+nQHbd0iFTs+xUaSW2lDKVQbcju44H/Ob
jRa981Fwj2fA/LLDi94PsVHd+KZ2Ks4+HT9YCxvZaN7q4dU+53G9tGAJuZ6N
olgR7T8jGPCUKxrbXsJG48cVuuxPM+D4+whm4z02Sjh/rnUlzquyGlLD8Pia
8+s1uv0YILUwiPEpg42iH0q9cfJgwJIESJifykaTo1szBo4xYHrjzKLMy2xU
7frSXYDzK/3ldqJMNuqVMLsTcoQB9V60DFIUG2kvs20WHWSA5kBbQ0oQG63Z
tEnhgRUDFF6bXqg7xkbHNU6TVCwZoNN6t//hKTbi/5RL2WXGgPwtNk9Vbdlo
y/mpxf07GRBsQeq/sZmNdBsfP7y6jQGX+jYkc9TZyOLFs9DALQwQyf9IurqH
jQr8D2zR02HA3ZVPPe5tZKPN0qzG8fUMmJoySA1WYKOjP3+a5qky4PvJjMnT
bDZ6mBUpmlRmQO7N40v/U2KjXT7aZa5KDIia+I9RJmYjTX9zrvIKBgQt6/mw
kc5GcsnxG4ZlGbB82eXykjEWUlJZUn5LmgH37z06eojGRtIbT2x8Pp8Bvw5O
pIb8YaGD690ZsQJ8Xq577Df0sJBL6Zrr9hx8voHR66wbWSi7wCInlMGA4UP9
RsxOFmqkmP3VpuHzaxB6vshgoRfrEscWEhjQyV6Xl5bHQhn8yryZCTrElSSr
ZhewUIfgw+zZETqotBXArjIWGugrEnwfosPRocaK7Yks5LvNRqrpDx2kE/6Q
pILxfK9zH1X00UE2A10PPsVCi3/qfy7vooPJy+NGFDz+Eedp7+NOOqzz6Tfx
C2IhZ72r2Xmf6VBxdObmWQ8W0tzq+9+D93S4l7NwXtVhFsJ8FocubqSDWq7y
wDJcF6248CD/LR0ebKBFjRixUIOW/K/il3Sgxa1WnsK5ve7ateoqOjxckdF3
TouFevqNC1vK6GBvdlapYCMLnf76SnAPZ2mfUKGhCQt99ihV/fmEDilrKTp2
K1noVaS9BKmADk8a+zPOLWKhTSWftiy+TwdShuXbCT4LnX1f/d72Hh3kI/0t
fiqykOqz8jp0iw4edo/W3CayUK1WxTXHG3QIOL/8134OC9k/TH14KZkOCqT0
Miau/5I6JELXcM74ODpNZaHAnbKU54l0yNOd6OzpZqL+JwvjBi7SIeGY3Gzx
Vyb6Q/Q3XXWWDtWt5MINbUw0sWwTUT+KDhYfTHTj8Hino6u07cPpsPHgqOar
j0w0b5OS8c0gOtSrO5yyr2Si2cKYkO9+dBCULZXPz2QiuaKcfj8fOvxyXaG1
FNcDmh3erPakg2HDAeaHy0zUpNmu7O9Kh8en7z6bSGSiHbNL02sd6VD54aZ3
QQQTJWeYbHprTwclODj1LYWJ8tJ95kvb0WHnkvY/6CwTna5betnThg6lr78p
/vNhol0bgyQbLOgQGPXavNeZiQ4/dlxmtJsO/Tf7bj05xUS9t/8LXWOK61/d
+u0cmOjZ1Y+9l3bS4UfW4W8q1kz0eXOF1vg2OtQISpW1dfH+okt4A4gOwwe1
5ar2MZGhjaKnPUaHfx0aI6NbmKhvWfaF5g24Xz7dbtBXYKIb4oYz29Xp0OWk
uLB3CROFrXYxLVGhQ4z3AmmWFhOp9OyyeKZMhxyCibzfPCZab9oyqqmAz1fy
jsFinF9xlzkUydGhwV+sNChmIoNqfcPbsnTQ+etMvIzzoezZ5PU4y75szflJ
ZaJllpsTyubTIZurcheGGOjZ7ZfYDiHuv8K7QfY/GOhHjm9uC5cOR3QKv/Db
Gcj38Uu3EpzzvMyyiXj8thSdBgcGHQ4iNODcxkAbA2VTJ0n4PirgS0YTA510
XSROmKHBiwWXUpY8YaB5+rb8/mka3LpWTpzfyECxybtUVcZp8GnhItmhhwz0
n3zt74ZBGpz0XVDwMZOBVjMLtnj+oUGWSx+mm8FALs1defq/abCN/aufns9A
7SOblBf8oAHDICHJLBrXt6XereqiwQVi/a64WAZKej+v0KODBsqSWurmzgy0
5p7FvarPNAisvbsAw3Xh5OgWuY80MG2pui3jzkCpe2MtPjbTYKXWf8PNrgxk
0KbTe+kNDe5MLTUrDGKgePqDQNtXNHCr1i3inWAgtWjX/l11NFjqGtc8ZclA
PkHRJzhVNFCi7Cv/ZMxAXvXsQ2/LaBBcfhjUTRhoj+twpmwpDUZuNZ5dYIbX
e9C/5HIxDXJ7DnTP28BAB/utgw4V0qB2zb5VUnIMtOkHylz9gAZCWV25gEUM
xE69e3bmLg3a7r3N/bMWz6f/euXMbRo4qB0mfJBloGVX0mlNmTSIOGsex5Nk
IP2XTptup9GA8mZjoCKFgfIkoHQ6mQY58vq/nXC9T6mtIuwaDSSMX//dwWYg
FZNHl20TaSDj8sZydT8daQ2UFujG0mAZ48iWXX/pyHSF8h3p8zR4WVbU0DBI
R0t+lovkz9GA+ezN4cUf6MhJkPCEe4YGm9tfbdnaSUfxWlJXxoNpEFpweF1c
LR1VlZt37D1FA4u9lpFmzXTEJCs/7A2ggb216G55CR1pd9ZOtfrg+2AVnDDK
p6OZ0Y/+r91pQP3C6DDIwO9jHlxW7UKDn1/cNcrP0tEhXaXexzg7mX37M5xH
RxbHbIbLHXG/bIpduvQcHW380f7fMzsalOme3Sh/l44KikeI5fvxfR04t+Fs
OB3Jhd3btA7n2Yl/L8YT6MjZCTQqrWjQydt64HMkHaVVHQx7uZsGh27an3c4
RUfSDRPd74xooPp4tL/4CB31+PidfLWLBrr8/HALLzo6nlNh2alPgzNrFdbL
muLzOv3nw8BW3G8S8SQZMzoyPF1qS8VowHp9UOfMNjoq3C5eFLYZ90teOsne
ko4ulrv3S2+kQRML6+rWoKPRtXvDNDRoEHXusvFHBTraE1cr2L2WBtH6gr8v
VtGRQI333EKZBn9Lg6xvraejT3vEaR5KNPjevI7XIqajZ9duLkmUx+u38TJU
XEZHonkfkp4upYHi9l6lDAY+/2ubBrcvxu+vfVRvKUVHrZxFM50yNPgisaZy
+wgNyaj/MuHOp4El1SnVHeeTD0vObxLSoP7LvMP+v2nIKyLBZjePBuMuVin3
RmkoZYqd6ypBg+tn2P5j72lI4ptD3g0m7odomb/mLTSkaGsR30qhAVw/NKPy
loayL095BhBpcO1TRv7sRxpSvX/chE/A9/8vOTXuBQ2lC/R7jKaocCVp15Y1
xTSUPBBudGGUCj2qO1BLDg3x5y/tKhukAl3C3TjrKQ1dvf0i6u0AFewfzVi6
ZNCQ0rnSWNEfKjTstVi/7AINDbwRHt7/gwrDq52tMiNoKG92bptMDxWE93g3
5NNoqCwscupWNxXQGb/cbSE09CGk0Xr4CxWYq55mJuLnj+9/5LutjQoeaYJV
w140pGI9aXblPRXqa2MoVVY0FCBTtOEyzvvOlPpJnaYhjrV73+9GKpxLvFvj
u5uGRC0/1ba/poJsbUYEMqGhc68w9Ru1VLiQej6MtIeGph5mn1iF8/L5NxZs
sqMhbrHp95lKvD7HWd9WaxoaCSFsO1hOBSOySCEQ0dBrNy2jiqdUeHlzMuTV
Whp69OHksffFVBgM8fGc2U5DP2X7ZuSLqDCx2ejJW0kaUvcjmMfmUWF9HNUh
fAUNSSYHGUzeo8Ka0maXLh4N/fa805FylwqmNveZa5bTkFXb/i9OOVRY4FYo
pohpKOFhhsTHm1RQTrrSuUBIQ5vv7mndmUaFn6Wh6zqJNOSYgE6cuk6FU4m1
rxQZ+D6PhmvANSrM0ehdnrNUpHkWyWtdpoLS4ciMtN9UlJ+ZeavgEhX6/ovb
tO4DFRmfX17rdZEKk2GRKL2Pijw3vCxUiaFCR3hASuQrKkq937zzYRQV/F8v
a9CtpqJS9d6jquFU2Dl+qpdeQEXvePTYiBAqxNVQzRa/oaLv75TZj0/j91Vm
0YXFVMTY1a68OYAKQw15e+NKqcjsV3jlCx88n/nCf6ZZOBsOheR6UiFifM/+
ygdU9F4v+9tuDypwXyS+MEqgoto3H/w6XakQnep96X4cFRV83HfG8ygVskvK
2fRQKjpTX7n67xEq/PNOFOdfpCLZXf40Gs4eLlpxa92o6MLFgPGUQ1R4nd69
3BHnM6fzrdVtqHCjo0BNxoiKArBREz0rKqzqtU/X8KaiF0c9lr+1pEKzW3Be
sR4VxcwK9rrupkJhsVdyhCEVjRoODbGNqZD7jlGSpk9F/RfHk4sMqGDBn56d
NaeiiAdeg7k4B2QtueKKqOj+qwmz3dupsHk6oc8Iz3c+6p/kBKJCisJnmePK
VFQ4ValwU5sKT6E/0FadinbWv3i+CefqIza3a7SoiOnWe91IiwpV+bu1b3Lw
+nY0Ok6p4brUkFmVNBVFcqYi7qlQYaCWqbGEhu/zKDXkozIV0opPNb2RoSJ/
s+/DB5So4KARtMr+DwWlP+I/EqykQlGklEHiOAWtbcF/W5ZR4WO1xn8bRijo
7LND3ueXUqHC4kTRaQIVkfRMpMJlqfCmsGO3Ti8FzYs9+UhnIRX0D/gPG/6l
IB3p+VenxVQII/kLrXsoKJsfbrdHRIW6eY39it8pqFa9ovwZnwq/ra++EDRQ
kNG0hHwwlwrbk2fayqooKMU2/dVWJhW8ypg311dT0Mu9JnPr6FRInHtX1/yK
gjKlRLksKhXS+eLS2VIKiooT1L0jUEG+3aJj6UMKeja5dWH6NAWcDVRWm92n
INZRKn3lJAWs7oteGT6gIEzRIsN1nAK76bfeP0+noG9po/u0hymQ38/VepJA
QTd827dJ9FMApZ98cOIKBd2/8wut/UOBBScPlVfEU9BSp/L9Xb8oEDKUvel3
GAWpPra6UdxHgS1tq8ULAynIZp0TN66bAvtVF/uJQyjoe6+/kfE3Ctwk58kd
9cH7U3qY4fKVAmXKTYtWHqOgha4j+/Q/U6Co7AK1zpmCiKrk9StbKRAUoErc
aUJBpMn0sZB3FJgpaTkYeAjPL5etxsA5P3ygec9mCpI0u2f8q4EC95Kl3+lv
oqAfK36eaayngEZduML4Wgpyu9EwU/uCAlttiv7kb6eg3CMarU9wDhppKw6X
paDdS46hjEoKvDsecihjJd5P0ZHnMeUUYOpfsnkpT0EHKqm7A0oosFaHWvJs
DQWdCrmzWA7nYvXTm2JWUdDcMtVR58cU6N7rm/tMSEF1fW/u2BRQQPP5qy2D
RApyN31xzOQBBXr1LnduHiajYqkdSvG5FEjMiLyUy6Yg4xr6+u13KRCrs8Vg
2QQZ9TeGcTbfosCs1Kc/f3+S0ccFSj81b+L7UKxiVP4gI6IHs06Ugc+P6ANv
BslIff9Y/bo0CpQ6n7hb8peMiuw7H65NpkDnwtIjCa1k5Ebtvbw2iQK0sJkS
xzYyij5z5MXdRAroPL6c7/eRjF4soJ5aF0+BJgXCeXIHGfn46h7QvEiBo8U7
Jv8Uk9GlHzc2ap+jgIdi+MrZR2RUkHTxP/NoCizpmY0LKCejB8qr+dsi8f6u
Jn99n0tGzKG/X4zCKHD8gWM58RYZQc1Yxt7TFKj1XFsXkElGGb2NE5KBuD/J
lbHFuC49z9raKYACWr2XK89cJKNu1eUEP18KfLaTSnfxI6MaDa8r0Z4USA01
ccr2IiOVqYO1X05QoOCBx9Ot58iomn9I5robvk/HlqdZrvh8T1Mu5B+jwHBZ
xqy0HRl9mQjrq3OkwP0LT6q0nMioIq6GAPZ4/LlH4Tu88fk8n1boOkyBA9/T
vS+5kdHWmqTdMwcpkGDeoUpyJqP4Iv9DC20oECGyyH6J61+/mp0qtKJAyWBT
fdV+Mrr787XxBpw37h2TUtclo+dHQHafOQXsLAwPEIzJqK4h7E2gCQV+C+p0
PYzIyPjSXsJTQwpUEv1bZhAZOZ7Q25uB8+PfdyQvaJFRyyoEtTvweamrgeNS
Mur1zCH0b6WAXO+hW75LyGih5eP5CxEFUly9H60WkdFaN/l9jRgF9E1+Fdcp
kFGO4x2anjYFdlz69/EHruc8f17npUUBH4/8odlZEsJmNx7IVKfAp61Hr9Ww
yOjMjRO2E2oU4MbsFG/k4v1pH6psWUuBs+vU52XOkFCYhNcofQ0F0tdLmpWP
khAp4PmYtgIFbBNisPYGEvpoofdCbRUFnP7zCtYYISH3kdhqrxUUkFT+ckL0
noSC7NbZ3F+K73dPsPXMNxL6Qxl72ruIAg3nZ2rbn5NQyC/kECxDgaiBNYuY
HSTEjV77ddlCCrjdO2Jw8y0JoX61l7ZSFPB7X2GbVUhCF1KsfW8IKKDe11hE
r8Ljm7aw23m4331JxauqSWiD9nhPpwQF3h+o/2J5m4Q8WtyEK9gUoBolJ8yP
JaHR/IWEY3T8vaBl8E2uk1DOH0aUAZUCX2jHFqc9JKFPzvvv5JEp0BHm2fHv
FgnptCRxJ+bIoHEwijmaSkKKDBWlrdNkyLg7l/3jIgmlzBk8qp0gw7Gs255Z
V0lon1UMIXacDDX/3UqsiiYh+Z3zY9qHyTCfNyOcf4GEHFN0XisNkOFwmb2S
ykkSag9iG1r+JQMHZEybAknohPrx54F/yBAZeynknA8J0RRER97+JIOa5VLj
vXtJyK0wu1iulwxfts6G33AkoeBHeatGusgg79c8tPAICXmvTSo9ibPcXGZV
3T4SOie936XpCxmsdLE7d3RIqIfl/kLxMxk250Y869MloYSvqxdntZIh1HXO
v8oEn8e9Xa/O4DzTZNDxaQMJLSh38+96Rwaq163xP5ok9JVv8Ro1kuGS4suQ
1/NwP4WF1Nx4TQZhjrl4iRQJ3U3UINrjzGzZd+f6OhJyGfQ6THpJBks7ZxM/
abxfg0cZDjVkcMm4KT/AIaE77nWh9RVkOKFRaVCM5/NmST5Qxbl/Ml1KWZaE
+g03EFXLySDNuzvBION+KImTvVZCBtezDsPfBoloHjP1NekJ3v/CDek75oho
v7dGl+RjMmwqWEC3oeH7MvFc6lZIhr074lq/9xJRsfdnyc8PyfBb93B3Th8R
saVdkgzukyH+RerzJ8NEFHbm+OmZu2SImTVldf0iIv9XRYVPb5MhbzD2kUwX
Ec0NmTkqZZOhVNtEcqiRiH53t95PyyDDNslrm+eeE1H/l13Wk+lkGPDa4Jv9
jojO1HWeEaaRAcUf7TOoxu+/w+4/m0wGmsQp/ZrHRNTmOPSTeIUM3X+Xj6uV
ERHPZp4e7TIZctXsb6x6RkQOhVqepxLIsEthwLj0JRFVCIOiRmPJcKFV92x1
ERGJ2uxXecXg+3tc+V2QS0SrMjcpLj1HhvDnM0GF9/D5yMWbD0STISB0xzLZ
JCIaaX5A9zhDBvq39nf3wolodfzhrYOhZLg5+7F0NpiIvn3RqdkZTIZ1As9V
cnFEFFRvRfU5TYYd5NIks4tE9DFz466JADLc6DKXf+ZNRFbEp1LBfrjfIhYb
ybrh+Yp/ToZ5k+HW1zabqUAi2nw6zJ6G81xN/ouHp4lo6pi+aqw7Ga61jgZd
dyaijfVlpxccJwOmw/7yYS8RHW4WZb10JsPPGej2OUpE/4yu7MzGOfbv13t6
O4jIZ8/5hHWOeD8DV4KT8Pjb382sKw6T4depYPIuA3yfeVlXzA6RoU995cHz
RkRE89ZIlsW5+mvQsrXGRDRMxUy7bcjQVHbu9W88vqytI8TXmgxcybP/ChTx
+p5jq9gWZBjM2X370mIiur5j35PQPbjfdJqT3bWI6GnX8u0ZZrjfnSQdc2WI
qJxh8kHLmAzeN6s7q4RE9O5CaFvTTjKMRBayF0oR0fdso85BAzLcHwsw78Lz
iexCTV13kCHEhv+qdCkR6ZLE6xnbyJBsVjBuRyMi6WDKhWxEhiJKNcFshoCa
5v1t98DIIDGyoCwQ1yvcF5ht24y/B4u8Fiwl4PudkA3r2UCGBWuVZPqJRLQW
OmUjNclgGnX26mZcL59dHzerTgbKcxl9xyECKhlQkVdQIwP5wdR26igBndr4
KemNChk2LmYvXP+JgKpqHpzwWk0Ggwx/1sr3BOT6PKTtqiLuT7Jw3v4vBDS8
MfzhQgVc3/f1U8ZbAporUbSoWkEGDzWjyZ4GAhrtCDh0fBn+XlzfRoh6SkDr
pG9fRkvIYJT9M3dJPQFdztv5Zv5iMqyXTP4tBgL6nO+ZWiNNhlcnalcdw++7
0fi6wWs+Gbb3FLl8SCWgGouhuyNiMnykz0UdLyQgTWd1Wzmct7/zrPK7Q0Ds
rZGmLXy8n53PInfnENDuizfSIiXIUL/edmf2TQJa3BfR9YSN+7lg3TVeCgE9
7DxssBHni6NLtZXOE9DP9Q9M/tHJYP8rI2bDSQLK+nMkL5tChpwktcdXAwhI
WfnJiigiGbq0tnhEhxOQ1PNjxw7gPNg0RhPh8a9rsgKlZknQ9H7wXv1+fF6+
E98bJ0nwUKb08ddjBBScZpodM0YCH179hy8nCKhZ29/cHmfJsczuluMEhB1O
eGowTIJly0hDGni888b7SxkDJDhTx0UGvgTEH4xsr/1DgooJvYdhVgQ0uV3N
cBfOhvvHWY9sCCg0i/cz+j8StD48cD9bn4DEpev1DPtIUNRUq2xvjPf/69eg
RA8JTth/OtemiM+Xd3RMt5sE4X4MKbkdeD1qsn/ffSPB1NFC3V0rCEihHTST
O0hwuD57QFlEQG3uta/s2kjgPiJslcd1iQo1uW2fSCCeN5FmoEpAhpXy9xVb
SbAxL+KJ9SoCOtvV8mH4HQmcP/h/rOcS0Fa5lzuhkQT5rujMSj4B6T/gl+x+
i8dvXnvUQRb3t3CaduENCR7EHJwXIU1AKsFOLJt6vB7Lj64/8HiJY7Q9irUk
2GDkjqXNzGFq1w1Sj9eQYKi96rgcHa+P975rsooE0cpuH2QZBNT4vbHoNZDg
MWPPpiUjcxg3dvxVehkJ1JNsr02MzmGFzxMfJJaSgOyVv/9Xzxx2t8dwuXcJ
CTxiTcbMS+ewlr+vygyekED7pwL5UtAc9rc74MqSRySoanX7LyVzDrtc4N1W
m0+CrQrsLqWiOeyR/P688TwSaAaP7lqI63bbvOnNuSRQca/ZZRsxh30arEu5
f5cE8ne9o4+dm8OuYPCXdpsEX77S3rZcnMM+Sti5RueQ4HjB2yuvt81hK5K3
+TtkkSBuQ8y6DMs5rPJpYPnWDBI8UlBasCZ5DjPs7/holkYC18Ny9hZH5jCl
R0IdOZw7ve6n3gmZwy7+E42SU0jAXNplYu2A998f8/37FRLsrM3SNcfzzVic
Zb9MJMGeBUHWK/znsDfR6wNv4yzh7fL4sjo+3/b5TrlxJIi1oA63zpvD9CwN
x+IvkuDUogPMvS2zWOcD1dKT50nA8Dno8Ucwh4V1pz5j4fyDTptj8+YwUW9H
vl00CfZxF5lgzDksU9K+becZEkS6nX9iOTiL2Zm9V9MII8HCa092qz+bxQ7Y
HY72DyVBjoLH23U9s1hUp0HZkmDcr3Ij3wJ/zmIiaqsPNxD3o7vK8oHrs5ii
ROL+KX8SjF7GttvFz2InYj8/HPAjQfyPAHXX8lnMZ9819/98SKC0/dUZ+dxZ
LNaMkN/miftr8lrk5axZ7Kh9t8zrEyRYbP2y0vXmLOaXpbTM140EYT6PNL9c
mcWe0g4WlruSYL3GlLR84Czm8iTGq8CZBG7JvB1DwbMYbyRmf44jCf7GpTo/
dJ/FdOfuV1MdSHCT908Q4TuLWekGHU+1J8GbDlrIaNQsFioblJ1oSwK9vYd3
DPnNYl3cXPKFA/h+Wzed9tCdxV50zgu6YUMCuSsvyXcMZ7G9F5WjIvfhfmqh
mF9eM4t9XLhcJdQK/57mvf6QoY7Pf1X+ZOAeEtTkDb8TcWax2RV2m/R2k4Dv
ccezXoTXt3Lyx0kzEjgmvVvWRJ/Fbp1aPuFnTIL7r4OWfJ+Ywfjhlop+hvj7
sZhbdV5yFjvprNQ8qk+CNiJzw58/M9hfzW4PP5z7dQSXhT0zGE0rvct/OwlI
TbSy3M8zGFb02ePUFhL0XCnsZ9fMYFu9FNcVYCT4l1x74MubGczvfaVsMM6i
uB85yY0zWMaD4B/h2iQYW/WC9OjdDP596DSc3UCCOdU6xZeRM9jtSKW3lzRJ
MPggOCczfQa7YhS0xR/nJuMNgsNpM9g+U5//rqqRwDZw1xfTuzPYP4edi2+u
JUHI77MZGd4z2HzvNtf7a0hQ3dvr7Bs4g5UWXv1PH2en70WPhDi7SFg2P1Ek
ge+de8+jbGcw9oO/xtUrSWA91qDY4zOD7c370Nm0HH9v5MqLLuycwc5l/ZFe
jrPA/zSBu28Gu2mhe+7bUhIgC+8H2zVmsJbnh3f0y+LvQZvOmCWawZQHTswn
yuD1Xv3s5Y/rpuHa95jSJPg+O+apgvN0fdq0YAH+vRim2+pozWBmHPmhFVIk
eD7l0vdu9wwGppunNgjx73H0oPVizgymq519boJPAi5yLN3AnsEWSi4SmfDw
fiweeX1tm8bWXZ3VduDivydfL3kOtU5jaWIZn0AWvv835qvXN0xj1yx7bg4x
8PPH41ZQe6axoOi80kQ6CTRi/mWXLJjBNtWNST6g4PO8lVL6LHMaswtV9qgj
kiBYbcklgxvTWFgxpWNsjgjt+1bfvFMyje1Vj//SPUsEfbMLJ97FTWNb1O2s
CNNEiF3ad+/39WmsPLutbdEEEWTudd70TprGcs40KtHGiGBdlp6YnjCNVQfp
HNUeJcKzc0fr6HnTmE/Im1mbISIkflLzFeDxA9jL1MB+IqhFmroetZvGBJbT
DrJ/ifCw3qpF328aU5X23pb2hwj8iuTzFdHTWJc2fxD+I4KnuqpRytFpDCX3
ZPf0EcGtsyjYyHQac+sdPI2+E2HLu4Jz04bT2MjAukNMnDnnyx5f1ZvG96G7
SKWLCFf/bksmrJvGQrysvlp8JQKP697apI7XO1eSFdROhIl/0sTWedNY0bpf
tq44c9M/9ccvn8boBo9cb30igvxP7Jo5dxpz/31es/EDEbCnxt9X8aaxIYPz
xKl3RAhNFFj1/JzCMulHRjNw5iY9NTwyPYVtC59+Ld9EhMPvkjqs/5vCKgIU
r5o3EMHSZw2P/2MKs2+2PRz6ighSNW2+5DdTmJ63nVpnPRF2tUvLU1umsPz/
finm1RHBeSfrgjmev7Bz/sDXGiKkrW4TT9dOYT/iNB7xqohAOL1d/Bs/P/jJ
sV+hkgh6YvezIQ+nMJ24S15bgAhhny/NtCdNYdy1J5V9yojgNC2bKQiZwiT8
sZ7bJUR4Yj+z0wBNYWQyZ1ngUyJ89rTrqY6dwmyU1BM7nhDBbt3n4p0BU9iJ
qtubhUV4vc75oU0eU9gy939fDQqIcKrAdq3vvilsdKKrsDWPCDPuihklDnj9
UjYBoQ+JUB2drxluPYU9M8U4Jffx85T72vpuU5ipS3/i0B0iDO6cXr14ahJ7
9OR5nPZtIjQQjw64b5nC/jhUCZVziLDt7WIdD6sp7NIAN9o5C+fwArMdSlNY
6Qn5gewMIpjbNfpLy01h85hPcu6m4/4rsvMMWziFRQzYG3en4f1vNIFnhCks
Q1M2fel1Ikzf2is7y5rCTt3P7bK9RoRrP8a157+dxCwWLP219AoRrgw5azhM
TmLax13mZyQRYdHKPZdY45NYp04+1pVABNvhtOGDjCnMPP6T1fI4IlS+rN1C
rZnE7KxDNG9eJMJxlZ1im+ZJ7GQYZuuEc5bUjtSSxknM7J2O9b3zRPA4rde8
mjOFMQfUsP5oIgiN7OS7iyaxhf9OiTQjieDi8u3MNr9JLP5XQbASzkwn8de3
eZOYfZR3a2A4Eeq1Kp9vMZzE9BcERlWHEKHicdS5KvtJrOn2gBz3NBHep1ts
1omZxC7vfVFYFkQE7eSEASrO9R3q9y1PEWF4j67mVvdJ7Dvp1uIMfyKce6Su
722L90e5FfTbB59PICmjRmUS+/yGDNY4S6Yb5hgcncRueyTVaHnh+RfWmFzF
9SC/T6Nn3PF9X93/xdNkElvS08RrOY5/v1viG0MPTmIXyqqSp12J8OvO8MqI
rZPYmFy3QM6FCDpRhDPnJicwbV2Pac+jRDBg6a+R/DSBrej+9rrKgQhfcyNC
o8YmMD1j/pI7R4jwYJ91lvaCSUxsdCVcbE+EvCPFBRdqJrC6A5OLj9ri/jtI
ajg0MoFFX3TPKD1ABPKv7It7509ieoWgd3A/EVSVNgzwpyewvYO2dJ4NERpn
t2yQ/jOBqWiomTlYE2GfTv/ulo4JbGmKyelSCyJsV59QyO+ewKoXE2ak9xCh
yknmdsv7CSxzTvaiwJwIC1Yefu9+cwJ73MIKOWZKhOt9Age3/9e/LMi8yogI
Fy8TogOfTGDZ5eqqXYa4f3TMNWxyJ7CyiG/0RTgn1TANlLMmsPNrblz30yfC
67Wey+0TJzBe50r+u+1EWO1oKhEVjeczyWjL20qEgKtfvDViJrCzo91HVHBG
R/67VAMTmLyV7pUYRIS3qosNNuyawAyDcnP+20yEM0HbLU+oTmAuoeUfojYR
4WfZvXaW9wT23ivpsgHOcVc9Ph60msCs3x+zvaOF73Ng5VnO9gnM8dU1OksT
9+uBxpYUiwmsgZtwzkUN98Pagg4D7QkMxekucsL5Us8F1xrjCexX54sfb9bi
+4/vnS9ePIH1LLi1VFWZCI6WPdue9o9jw8Kb6peV8N+HVQrdf8UTWMqPw6nG
OFe6jV7funwCe/p09dLJVfh7GhWwslhxAgsMLu49JE+EcNS6ZQrXT9oXR7yQ
IwJ1oz+DNj2OiR9e0NPBWU3y/Ul75gSm+id9cs1SItRt3FN/rHMcK17dvSNJ
lghHHz7sOFc1jhFKRl3mpIngr3DV5WQ3ri/+zNPEWTRfM/4AzmsemTg6L8Df
y6m5PdJfx7HvYK/ZIoV/Dw55e5WKx7Gb7DufMRER3m2d5VZkjGPZlfM/awiJ
EJGhl9NRMo4t2bTc6D6fCCafPN9+SB7HdEzUUhZI4u/PMV+ZBfj9NjqfnkVx
iHDQ5pviwofjGOv3y9TNbCKk7wnv7bw4jiVsu5g/yiTif398jqsLGseilrzy
d6QTYdUhmMx2GcfyBUxBK4UI96nTitk7xjGTXzIGRmQiLDVaNLjz+Dj2vL0i
UJ9EhASZkH+GnuPYAJwoLpkjgKMnM0wNP+8eeqF6zQwBFky//HvRchw7NeH2
5sgUAW5sMVK8ZjqOPTiUdCNjkgBte0a99ymOY9XStF1S4wTYTFhhtGXZONY0
ZP3i/AgBLPcIeozHxrDBf6lyEUMESE+VVzdQGsf2ZbIlSThbTPZ/8m8aw+4e
Tllxsp8AkbV6Ef6zY5hG7xnmwB8CrKRG3RT3jWEbHhYp3ftFALnU9mIv6jg2
c8CgxBnnLzdIYeR/Y9iA95H13T8IoMj1sxltGcOsTC1DDvQSYHg2buGxF2PY
2/OjXz51EyBW37Sw5ecYphKblvgRZzoVu7mjZAxLMSjz2tNJAPdFGypjKsYw
PZ7aoqYvBCDVSn42/4Cf/xVyybidANl6PXu3NoxhCqaeyjycY16/OzmN51fe
v+rN608EWHg/9dnQqzFMzvpes2ErASRNT/4quzGGZeyKufGqhQAjXgp+qjFj
GHW9I9sY55m+f3OTd8cwLRljzV3NBMhrbwkj3hnDwmW9E968JcAo0Xi0wmUM
u7o47InJGwIcc9DOl4wbw2QSjpxIeI33T15/rTxiDPM9NJ3RXE8AW9GbXDAf
w7zjnHZb1hFA3cO8+rrFGFbwWb+urYYA2obclovrxrB5osxN36oJ0H7UKHON
3Rh28cMKsm0VATypkrs/HBjD+DERpF4gwB+pdzpSJmPYUb9fNa7leP32cfv9
do5h2dckj6mX4fsq8pef3jSG7Y7o3DVcSoDQsiBXlY34PCX+JgU+JQBv++Pw
S1vGsEudVzOpTwhw+w51yc6pUYydd/F3bBEBTn30Y3KX4fWuP+YZ+4gAcCdg
icfIKDZZ/B9pYQEBEpV36BjPjGIlgZl7sh8SwOPacOTxz6OYrdKaosFcfJ+5
GgcezI5ieTRZJ1Wc53TWXf/RivOOng3ldwkQ36Vkq4vf13095LXhbQIU/fub
vWBsFJPcKFe+/xbuT1XJLv3OUWz72yDZtmwC7I2/GaHZPorJCp1UnDMJYGXy
31L0fhQLpdfNjt/A5+O0VbT/9ihm5FvR+SYN96eZnOK7Z6OY8sVViWdx/vjM
XiU4dhRbELe0deF1/P6QYwb3roxi8T6Kffev4X5oIvCJUaOYkHJZUe8KAXyn
Gp4cuzaKad/5l4nhvL9xy/6Pu0axDOqH1e8SCZCcFCRw8B3FLi1Is3OKx/2Y
cim4J3gU09VPtpuOJcDUsPOSisBRLPOmTEINzkfp+S0ng0axA6vSOfEXCGC8
/znIuI5ii5/9Dl11ngCXM94WtG8fxf6Ldsl4Hk2A73+XnuRKjWKqdof/GuIc
VnNodLn1KHYtKTTAKpIABAI/6bvFKEbfFSbTH06A0kv3lCqtRrH5vV5OZ0MJ
8Hb1XadFK0extGZd7FMIAZqlgl+Oo1HsVePRALlgAkg3JSWexvM/mwjQKA8k
QGrGYYnYxyOYd9HdJ3sDcD8sCU5W7BvByNlN/sdPEmCp74OSP2L8/NkVnSN+
BEjKKMwywDmi7lNjvA8BHvJ1NuW/GMGO+DGc1noRIGX4XdTjoRHsivmuiwxP
Aqx6/UApvn8EG5+4UNngTgAdowDJnIkR7ENZedVxt/9VaOXxUH5feKTta4mS
spRsIVlbKOGVrRKpKEuLImtItooka8lakhYSibJWEqWcQVmyZt+zzmYw+4wZ
M/Ob35/P57z33LPce8/zfD6v4L6Qh40Gl+kI2tYzSdwfhTY7OqE7MEtH2gok
Qkr8UOjfa2JqR7rpiNo1PLXcF4X+udk6/XM6HbFrFVa290ahWwKtE4sa6Eht
oC6NdA2Fpmq/uir5gY78UMiRc/BAoZH/Cg6nCvJz9pNKynRHobX/4bP+xtKR
PX9NGgyuoNDlmKP7CC/pSJeMZd3oJRQaJ9+T3PaFjmzJeXp7zUVBPFd2T1Rm
0JHTV1qcoi8I7DXU56ohdASfebJa1QWFLrjc1TPrTkd8f8V/+XMehQ6hrFXX
fEhHmN9/3q91RKF3l5R+q7pBR7x95kNuCvCKeLRC0HU64nX9QL/MWcH5Git9
/tuWjrCne6loexT6g9IRepMLHfH356qF2aHQ14aCvpeeoSN+kS+rfAX4dzQh
20+djvRwR/WlTgruM2FE5Y8iHQn+fd/+53EUWqw4s3ajOR05demPpo+1oN7m
pwgaenRk69t3gYcEuMYo8mrh/3Ht10IpS8F77PM0fKs2HVk4FDIGR1Hoogcj
/y5P0JDbZzd/9EdQ6Lk2xWZ9Jg1ZCTmsvUaAyWHf7//ZRkf0HcrN5EwE781I
WpIoj4b4bb8e2GokuP8JTSZfJmkIYeGc061Dgv7elx9CJOgIiuvs1WsoOK82
1i6VizQkC1U4rmYgwN196r8GaIhPlf2Oof0otK3Y3uUhNA2ZvZnPfKCPQg9c
CeO21tGQJ3/9Nn3QQ6FvlN2PPddBQ3g/Y1MO6wruA9Jth06iIeu0T/1Y0EKh
k74TqbZugu9vjRe+1kShE8xG/Uwv05CFdJps4h7BPErNt/eooCHSVi/Vz2oI
7t/PDu7D2zTkfLa9+3o1wfwTNxw4GExDfLdEGtSpoNDbhKlGwd405FPwyyhf
ZRTa7svy+dYMGlIq1d8QpIRCe5AHL9adoCF31Rbm1XYJ9ufVFrGv0ZAd27zR
EztQ6H1XyhdOB9CQmDkFHQd5FNpXoSD2rg8NWWNG2JclJ4j/xX+pTERgXxa5
YCcjuP/T2l9JKjREDomSW79NMG9WClX3HKIhp6TdFS22otCHRFP+u32ShliJ
taSBFArd2M92CxXkVyhb8eLOZhQ6gE7AbTSgIW24YucDEih0RQHqC2sXDcl/
fPXEYXEU+pi/D6VHg4bUdCeXL4uh0ObvK9+UHKEhi+ugulREMK9WDRRdg2jI
/iuaDj4bBedFNcatdQ8NyR0zfH1wvSD+N95+qxtpyJcJ5be7BdjLx+fdGxka
cv9nwYNZYRTarWztPmdxGiI2vLSzQAiFXldRdtFzlIrUxu/OaOTxgb/lguMY
ioZgUpusggR44uPafh0SFfGMTrQ2Z/Phm6aABY1RkQo7I5UmOh/u/RtylKRT
kcjAR1esyHzYEir0cF0mFZEMPnA5hsQHI82bhUZ9VKSN0NvYSuRD+YS5tD5Q
kYiLJvF2OD4oX5qLNf1BRZRQx337ZvmQRTVmvR+hIqODVmmvZ/iAjRI5rV5F
RV4WiTW09PPB7dwUMe8JFfGd65tebeaD6G/pwuthVMSIIj9u8o0P4aZT186c
oiKbRl+8elTKhznRO07eBlTkwEsDsdlcPqRZzO4hb6MiCaGb5I5l8KFkNq73
F52CpJsFffoaywc4tLupc5qCiGy8MaYfxofzCyqo0kYKsvvI/ZO13nyYxaT/
+pJNQQLIeqI2rnzw3mU8RQqiIEItmRuwtnyI+vbWY+1VChLymaCdjvAhSLwl
RNWYgpz1Lrpuvo8PTt2784TkKIh1nWcFajcfpl4obm8UoiCF4vTZtu180Fyc
SQ2cJiMxn+zYuSJ8QPRJnhuayYiSa9a/u1weBDnudiz+SEZak3bGepF4QCrQ
7t76jIw03aQvuM4KcPXF17/DyIiHTVK/yyAP9L9hdK2Pk5Hkdw7WHm08+Fpg
tiVPiYwMNNrr3frBA1bMhalwETJSu5ofk1XJA8OvTZNriCQBX87eU1/Ag20P
/fO/DpKQtjeF28lZPPA6f7zJt46EjJV5HdFJ4oHn0XmSzCsSkiqfHx92lwe3
2p9errlDQpaNTGebb/DgWfr3u6cDSEj6lQ3uyh48QO0mG3CPkZC/faV1D87z
YGO/FypAlYSMLjhyGCd40NWomg0bSQjqc+zmIBMe2C8PkkU7lpF9kSNLFD0e
GLCvatSkLSPrbinFR6vywKHoFN3iyjLia2bdKC3Dg2u55/3LTZYR2aDzL6tF
edCe/aXiP9oS8l4vjnuZzwVsnmNRbtkSsr9/18RmKheMiIXoz5FLyJb2VMsu
DBeOJVlpeNsuId2McHLmKBf+YBhHm9SXkF/MJ8vuXVzY3hiU5LmwiBh8/aZ3
pJELyhXoRrWCRaTKarZox1cu3AlICQx1X0Rm49QtN5Rw4fN/CRaTBxeRztqf
bHYuF3DmH/AxK0TkzqHVH8zHXNh56/bH5jYisrLOOYqbwAXulAxnzWMi0nPr
mo5YBBcmYtUpTGcisu8Zb0wlkAu6vNjV1xJERPhwsrWlOxcwzQNs3a4F5JnU
wYiA81zY53ZOvSZzAdl+ep1fng0XnnC38u9fXkBeVCv9N2rKhZfea0gdhxYQ
ZccOm537uTC248JAodACMqvvoeyrzgWdhjgVwyECUrziFvdTnguvLkzGn35D
QK6VOF2Vk+RCKZxzHfIhIMxj7MrotVxIQR0pj5UlINZRDyMXWauQ7FGos4uD
R86Q8Ikei6tw9d7LS8NoPHL80bvJ6elVEBOdaLmbjkfK3PrDfQZXQbfeOv6w
Ox6ZF/9gwfyzCp/3ioh8MMIj/sE3DqfBKjTNpWUeWsEhLPcUW+0vq9DcF22Y
V4dD3nlF3ex/vwqnrTLSs0JwyM6g4Zy43FVQzG2fDHfCIZ+fn2wyerIK1RY5
ypuP4BDf8ZyRlcRVSBfxyTyOxSLNpzyI6MhVUK/6XGNTjkWwXpIN6UGrsDUo
z/9OJBYRuhhxzctzFXa/bR//Z4tFynf9ard0XYXzelmPRnZikT1m6kRN+1Vo
QRR1jEcxSNMH6ncZS0H87jKMsSoMIuObrr3p8CqQWAqy2EcYRCsw/LCoziqo
Vr6gzF3DIA6njfolVFZB+KYvvlgXg2C3xFLlZVZh0/2sTa6iGCQ8X6lQV3wV
4m5VY0W+zSOuG0rLbdaswkSt3E6/2/MIt3LvzgAmB+YqsCXeZ+YRF/HXuGdE
Dhz9b8WTJzePPJ6SXN86zYGtHocKeb1ziLFw8XXUEAca3UuI1z7MIZf0syXM
OjiAG5M9WJg8h8j278UlNnDgaeiOoFc2c8jWzsaF/q8cUGItff62bQ5JNe+U
1CzjwGVUzX6NkVlErdnuWmI+B24wvQ0CS2eR733dlfhnHHj/431Hb8osEhv7
COWYwoFbm+jtf91nEZ6kkd3vGA48eoG809GdRVI3lqeY3OLAwfrXbq3EGcRL
/Ff1D38OVD+/wv37aQbRqLwJ5u4cuGu26dqnRzMC/fH9TbcTB86698pvjpxB
ah5Wnfaw44BXZ852vOoMEj0Y38w150DN+/D15JVpxPuMg0TeIQ74yVzoetw7
jTS03WdY63Bgs3rm0RPF04jnI/ckuorge06A2s4b00jlUw8okeVAaJMCm3dk
Gtlyg5/uJcGBPTZmlISd00g7u4GisY4DhdlD837TU4iizbF/ZDYbHn2Mbs74
MoUo3Tpi10BiQ/Gf2z+Mnk8h2AjXA9kYNmSNl8lfvziFuK0LSgkZZ8PhEey5
+p1TyKNzTnbne9lgdnGM9rn9HzJJtI9HWtnQ2tG9uW//P0Q/O4enU8+GQ9Yy
9Rqzk0jEh/dtql/YUNU7+evP+UnEWj5lQrGEDW94Tr3WipMIuipgn8obNtwk
bdtz/c8E8nsuFr33GRtubd2RKfFoAgktkrhvlMKG0VP5IpZqE4img5evfSwb
/k5lkJZx4wg+Dhvqd5sNnU++PDa6P44cWhR6lRzIBjUlLx0J3XFEiiWM/3yN
DdGDqh2FE2NIDrFFe8qVDQ8Yv6J0rMeQb09+hUudYcP3XIuJkIFRpKo674ft
MTaw1gV0nDs9inQ9EWMlm7DBQ3K3xsSWUSSttl3p7342lIq63jv7bgQJxJTs
26EpqA9NJZlyeATBE+NVAhTZsLHk0NV9YiMIJfXoYtM2NnCpSbfcioaR+ksD
DxXF2SAWM1S1xmgYmfR6JhwnzIYep+0dB9BDiFbfuPbCygoU3qAf78wZQl7S
VKRdSCvQpuRjr68zhFTdevK5A7MCT6dtF1qkh5Cflhf4VhMrsGhy8Gn4u0Gk
wP0n7VffCkzdOhhBVR5EjowKp5z4swIc7mr28doBZP5FQn0fWrD+pF7IlWsD
SKjLuwSPmhVo7R3puLJnAAm893eUVb4CpNs6YxsI/Uhd/NX2zMIVGNU8fvxZ
YD+it3/rngOvVmDdtVOlJsb9yPdED6HRxyvw5eOJnw8b+hDflAW7hIcrEC5h
jcxf7EPYtx02GkSvgH3at7pA6EVm0+w0iWErcGroWgU2shdpWptdXuy/ArL1
uxIO2Pci64nMZB+PFaC/LIn5jBJ8v90CdFxXIK1p6+uCh3+RrLXnj7JPr0Do
BStn9/C/SOGF+F3tx1Zg61Jq02aRv8hN20mtfNMVsNkWMaVR3oMYxQ6F3z24
AswT5jNt53oQ/b23mBe1VuB9uiE7Zl0PMlfU9d5cZQXSe0Z+nLTsRqRurMRr
y63Akzsb1qcmdiGdqJ2JOzevgEZoanPwg06k87dP0ZaNK6Bz9rNwy8lOZAdP
ekqMz4LgvVPzmdYdyNwHb20xBgssi80XcL7tyNOQkoeSiyy4ZBGB/Ub6g6wr
0+DLzrEgk3Pq8u/9f5AIZ3tPjTEWOF4wk74e3oZscExsPdLLAoqtlrwNqRVp
lzdTcWxjgZWlj8lGhTbEIIB14yaaBa/Ws2Tm5luQe/oHPmTWsODs+d0s9W0t
yCXfmLbvFSwYUnt0P8KkGeHL3GrHvGPBZY2HO7+4/EbUDlR/2J7Lgpx5bPAl
ud/Iw0dzl+2esiBZ+qI63vsXosUxZz1IZoH0u+40bmgTclbF52RLLAt0eDbe
mKxGxMO73FM0ggV79IKkx5wbkTzryaOON1kwz0m8bGTZgKj+7BrN92HBY8NB
Xl4zGnmgf2EvzU2Qrzn9YOg5NJLt7qNz0okFuyye04+JAuJ8bnay6BQL1mq+
w7LF6xEtiwbDDdYsuBHmOqCY8QPResjf72/CgmOU09LC5DrE16tjauAAC0wL
QoxHZb4jkYSRrZZaLPDDveLsEq5FltcHTXxVYQGWdvyjuVwN0k8vPagjzwKw
fy1p3VyNeNd/linZwgJ1L6dHdblfkDjVTzGaIiz4pCn770xOFWL0fOx6pRAL
Ur4kXCl69RnJ3h3Ye2iFCVwt57BO149I2rWyj80kJnR4+R9Y61QhmJfTQi44
JthLKRdfUilDMjX39C3/Y4K/a4HEfztLEAuro6uPhphQLsv5TMp+hxR+vfRI
s5sJE8bhEWltBcgUBnO7q5kJA9v6KDiLAkQ0wLYpvJ4JgTvt7E/9eI3ooNZ5
qnxlwu7dKxrWs9lIhE+aS385E3aMmuqX/HqCFAUF5CS9YwK4OZubvnyA+A5p
77HIZUL93O2mLTsTEeWj7hxUFhN+RxX639x0F8nfU7ipKYUJF8e2JK7+9oDC
v6wbSfFMeODVt4u1xwcuOh9gOdxlQiqyz6z6WBxIXwj+ohzKBPMHY3swek9A
TMP7Df06Ex5Xn3/ZvzkbUG86azo8mLD10lBj5u1saNHwZhRfYIKi2ew5m5+5
IPuG4/TAgQkK8m3inx3z4fopl2G/k0yQ6NLV8Nj7DpgjjiFnLZjwMv6/D2GB
72HscJuq6REmvHgWNskxLIHyze9WtPczYVDNgsf+XgY6wWXtSnuZsDSe7epw
rAK+cmaKZVWYUPFM8pqo/UeY8TN+JC3PhJ+fNW/a3P8Ev9M+B0pLMYE3ULW1
eW8V9BhbnZEVZYLOXPft+sNfoNuSra0kzAQnTio+9uUXWOs5gdLmMGD9vWFz
i1/V4GGKajamMkD9odJT1ze1gD8ecef0AgNGdrqLLQd+AzxXScNnlgG/3v7U
yl35Djdr8srixhjgX2HI+e9ZHTz8MCH1to8BKiveH5bcf8LiQRHX5nYGzARI
emRa1UPLRZfIxSYGYEbUrUzU6qH409pQmR8MuBnlccldFA1vTp80O/aFAfOh
refa8WiI6rs5fqeMAaqKn4YzrjaA5LFGy4+FDFCsekX2cW2EXMWUMEKOwL8C
1oZQ0whhXimRGlkMMCt3+SeU2AQXCZb7/FIZ0P5BV1dlogmIVglFlQkMqFUz
uno99BcYaHzuZ0UxIPIn598azd9wIuzgN6twBggfK45+ktQMe4zvnX4WyIA7
2/ZezvjQDMQyVDbBiwEHlEpDX0S3wPwmgyRzNwb8vGy9rpTaAktfc1ReOzHg
HM1e+8D5VgBujTvXngHsjuKxDeOtsMVX0+HKcQb8casvsSxrg2v7rf42mzFg
jvSqzeS/P7DP6wde7zADXieNZHNc/sAOUfUXr/UZQGNIeCRKt8P1/bs7JDQZ
gOtU/yH/XweMkm0q45UF+Q3/C7vt0gFemw13ceUYcHnoxnghpwM6D7axbksx
IGJx7GFAfieUujveZokyYIeQV4Zjahf0/1p3IXItA9xkQ+337+8GU2neuBCX
DqzPLXLB3G6Q21JZl0yng27UpGXAgR5wCd+wX3aJDvQ1r8ouW/TAEOonqgRD
BzisryD8vAcefk+5YvqPDpihRKsIXA9s7b8hOThEhwPaan7Xrv2F+WXyyZs9
dBh6aIvjJf4FmuEDkkQbHeyubltLR/WCNn167FMDHZJina3v6/dClrHlCafv
dLAYPqq1LrYXcsPsmPzPdMi96xSxLasXpjdKKJWV0mEH4fWDY7m94I/3TbhQ
SIcv2yVaiz36YHoH4rYplw67PSRIlQ/7YPDlx4BfWXQI8OfnEzf2C3jWjYWo
NDrE2MbcHdTphyNOz74aPaCDesaq1pecflgdvFvOjqZDW1MxT76nH3TlUkTq
b9PhdNSh8zmbBsDDLTE1/iYdDD9NcuQNBsAl5V3QKT86PLhaJOv8dABOyyyE
yHvQQaJa5de12QEoa7v6d+ECHdyCspS+bR+ExJ4TJ8CRDnUS6hbXUwbhlFy0
9DM7Olw3GfXdujAInzbfZ9ywpsOj3tNbskWGYM1m9m47hA5d2cPrc3YNwUBm
e6z2IToso78/O+I7BOHlYkRJfUE/HJdU4/uH4PGl3a+Ye+iQdWRH7r2rw+Af
q31mWpkOo+PFfa+6hmH+gNuxLnlBPLlvZUp+D0P+v01I/VY6hOzKXuq1HIEK
1vGbn8QF/XxulHjj5Aj48HPzitfTwWH5mPH7ByPwQGRxTT6fBg+kIgvq+COw
vaE8IpdFg4yi5Ku1t0ahKSYdk0OmwZ7zB3xqK0dh+K92dB6BBo89a7evyRoF
zNXy9e9maXCYHJv5lTEKDry71eXjNEg+bf2n//0YJPdz7L4N0IBKMWF5PxmD
r4f9N7Z20QBxGa+v/zgGBV7exSMtNJDszso2dx0HrwhhjyU0DdxvBBrOhI4D
/7gUb913GoRbFonvLB8HldX7HxWraMAxeNaxB8bhv65brqZlNFhqKu53PzwB
1xKcxy+/o0HsP8Vdl/MmYH9/e0DsaxroB2qZ/FmdgM7Kfb3vs2lQtqYmstJo
Es6HihztzaBByeMIBblbk1C3nxjFS6LBnJyeblXxJBjs10Rrx9FgfagR32lp
EpoNstrd7tJgv2zApeux/8Cg1HHoaRgNHJ/3dsaX/YOjuUHFHYE0eCtkKfF2
4B+Y/5sP3uAjyO9FRhJafQr0riTLWV2lgagc553J2Sl4nnE9OsGVBtNJmtmX
zkzBoy6L4VYHGvyI3YG+7DMFLtmF+E12NLh5rpW9vnQKHh9TIjhZ0+AZe0Mr
qmsKxk3uv36L0KC3UW7iEXsKXmzea0I5RAPfjw2yZurTUPJ6Z7LFPhoU2GSr
Jhyehj3U7PrsvTT41Lf4YfrKNHxdZdYuqdJAxNsnXLdgGohPOy8cV6CBev6Q
BqtyGsIX5CYKt9PAoEfU1hSm4QDGbc3azTRY8OycIE5MwwkIE/ISoYHtcyfN
DVIzsBIn+eaPMA0ML52V89s7A7pVU1L7uFTw6zM2m0Rm4Ixyl3IOgwrfb8bW
rLs5A+SuK2v+I1GB6NRapvp8BpxZVbdv46kwu7QNLfxnBrQd1esIM1Rovbd1
96v2GfgeXVPqNk4Fo7cnwl8Mz0Cr9mOtoQEqTJ6YDsjeMAtrpIaDz3RTIZuJ
SBgenoU3V9WsulqpIF62hxNlPwsSW28P2zVSwUZkw8X/wmchNf4FtbuOCvkV
fzcUZs6CwV63dsdqKjQn36oWnxPY9VrUxiuogLf8+liVMwuTDfeMvN5TQVN6
JfOxxBzsjqrupORTwfPSc6NfR+aAHEneGvuKCrq9onU1ynMwEddCkcqiAstI
OD7lzBx4VLFPvE+jwpzb785LIXOAWhw8hTykQnn2KU5EzhwM0Ne1DcdQ4cND
X4wubg4SVMuJoZFUOMIr3/kNMweG8UUxUmFUENXfOf9pzTxckCbXfQmkAmZ2
0zER/XkI7n/m4exDhf1Hx+babeaB/iaojHeVClfH7iYNRsxD6t7kO8UXqNCT
eIaR+XEexlUUK86eo8LhJ94M7+F5EHnVHYWyp0LLlu6SvePzoLEq++njcSqk
yVybPq6EgcbvdyI9zKmQpzGSInMAAwObX7+TMaZCyfjFW+9NMaArOu7ec5AK
WTPDuzieGCBd2Xz3kS4VvFWjtNWSMFCACVA9tkdwHmaaGPgSDDxJ4KquV6HC
myprM+VWDMhvav/YsoMKZ8RPbyf0YkDyblBp8jYqnBZf89FFAQsLhlWsM5JU
GHe4e++pNBZciV7tciJUuChyNMduPxaE3vy3OC9MhZrFvpcfQrHgf9smo4pL
gfyo0G92b7DAfNF/L45JgWStg/tUvmOhb3DfwjkyBUzjzmoG1mPhm6pJnuYC
BQy6FZyTF7Ewv9+1U2ieAh6+t0T7T+JgTXymy9gkBb499njgY46DyZYdGjXD
AntSw8ChBziAYbXrWb0UKNgpGX3hBQ5SAlnEsA4KXL7bwSypxkHU99f/nJsp
MPFQ5/zrDhxkmqWIm6IpMKurM5CzHg+y30ve7/5OgcVjDslC2/Cgr/M8UuIL
BV4MasjXH8YDapN8LaecAu7FT4zeWOIh4dWqBqGYAtIRjfh7bnjQ1Z3ij+ZT
gF/6MuhtBB4Mx84qdb2iQOaCQcCHN3iouiUS3JRFgT+Bagkn6vFgJxmuUpdO
AR+ZOZY4AQ9pjW2o6iRBvTa+UVig4iGUcebIpzgK4NCnX65fS4BN4gGvK6Mo
0P/krWSvGgFwLMsLH29RwPKPtciwBwGiZN1Nqm5SBPo5OvV9PgGaZTvCaq9T
wNXnX1tEDQEMpA72gCcFGK94RMJ3AjQ9i41qc6PA+mGrprJWAty4jHYfcKGA
YpnHcPc4AczTlTxnHSjg5BEjfkVlAVawztVUOwpY6/2e3uWwAKWl0bvWH6fA
2YJsdn3SAtxbVuuXM6eAPDUtJ7xwAeSbM/L0jQX9jIro1+tfgLAWrc82BhQo
vvU740L3Alg+9Rz21KPAnvozF9BzC+ASkmQep0mBM87PhxN6FyDk+MbBAlUK
jKgFjP3kL4C3w+3bvxQocGun898SKaKAzzFccDIU0Ov4+zg9nAjZf08f2yRF
gYEzui3YLCJ04OKCDMQpYPKrVYyZShTwhMSCKxso0CuiYNhaSwTssX3iqUIU
0FSz7AqbJULvs6KoOg4ZcKoRGkJsItjeyFUh0smg15CV0aO4CLc3XOxQIJHh
4cuC/qcmi9AVcLfYgUCGfa8vnznguQh2S3MvH82RoSdt24OY6EUopL1JaZok
g9uXfK7HrUUoOiZXxhsmg5Klaq/Cp0V4K8JsPtJHhgyFcSmjgUV4vzFGLLKT
DDkoc57azCKkoONtfrSQ4bFk3kODU0swpan1kd9Ahsr0ZALDbgk8Mb6iVj/I
sK7y2uhN1yXYb348OeUrGVJmJOcoMUvw0EZ02+BHMrw0vpE0mrwEHfvlnyiV
kgErmrDnfd8SmMo76Nx4RwY0L6I6ArME/y0Jf6vPI8M3CemAWeFl0E3AX5F8
SQYxydM+rswl8FOKoHk8JQPFrMfM5tgy3I0+W/AtjQzbw0430/UFmC1+eHMS
GZSXcDto/svw1lUT6xdHhqSb1jhCyjLUjntHNkeRgZBVY49JXYbRyN2qqrfJ
wCtcRN3uXIZrh7a1xgWTobQtZmPbehJclZU8Ne9PhrbJhEGf/0hQq2s5d9yb
DD6nvtLHxElQzex0qbhKBonjTUei9pLg3jb0uPRFMpya6m1nGZPgu7qrcfR5
MnB6CoJxtiSwTs4oIpwmQ26JYoCiGwnqfzcTnE6SYWzueOudmyTAbe8zaLES
1O/xnkSVByTw/mbsesiMDCFGsndOppIEeqEuttSIDBuNtLUaE0mQiA/MVjxI
BsbL6x30LBL412VFZ+uSwWaIWPToAwm2on74SGoK9nc4c4FVS4I+qwblZFUy
BI0/8etEk6AySWpswy4yTDh5nm//SwIJx+qribJksAogpRdPkyByL3N2/VZB
PcUshyirJMi/zNNP2kQGEePfV02XSHBCmXdb/D8y/Km7KlazhQykl75vMoXJ
YDpfUFV/hAz3Nwyky/NIIL4tChdkT4ZnmGOh71gkkN9xQ4VpQ4buZyYK+lQS
rJ+XPsz+f53z3nyvXySBYbXJ+t1XBH0I3SR3CkeCyU0senQ0Gehtjr7/ZkgQ
O92xV1PQpxT6vjvBEyTIOfGBdv25IK9VgcIZFtiP1IYFfyLDwnyJ/uteEiQY
aX5N/0mGYc3vQwadJDiqtL327QAZfpe7nf7bQgKz1y8NL/wjg1ZgZlxAIwl2
VL44mzwq6JMj5Ir+JEHXngcSv8hkeN61Pai0hgRf8ja+FV9HAWw6Qc3uMwl6
tn1LKJOggPCm1ExSGQm+nalcd0+LAncIejNZxSRIlRmcc9AWvJMhtnPGBSRw
1E9O6dpHAY4L/fd8DgnmsL/n7QTvUm6kw42MbBLctKJExJ+kgJpoRavxExLM
/lXpPnJJgLeQuYQUAX73sdUjkwKVOnNTLwXnBA0dfQYvKAIe7ZRrG0sC5cak
MekMCvxr3r8OFUUCmcPAEsoTvHsi2pbVt0iwOz5nifmJAt1hJ7X8g0kQt3lN
nLJgLl0p1MCrBpBAj/j4BExQ4Lgt0fafNwnONKleNhXMwc29W+NeuQvOqYL9
jyjBHP3C0gh1uUSCojE9Df9lCtQvd26UdSaBehoOnSFEhU2JLv6jZwX11w+9
1LCRCv+dNr+Za0eCpPvfOuI2U6HYoMnc/bjA/5PZvBQ1KiDiwVUaFiTQoZ++
uvckFVSZgUskExJwh01mOgQ8ZnU0sPn7IRJ8ur9d8+Z1Ktw3uOWVuF9wXn7u
9AcBT7o2fCHfQUeQX1D+P0sBfl67oUB5DwkUZS4Z62VTQS7m0hmqCglKDqv5
HCoV7Od76flvBRK4brbbPYYW8MaxP/kvZEnwWvJAmNJnKuB0m81ubCWBaR9J
ok/AG1+9YOVZS5Dg1PDmQHKngKc2vXmyS4QEdb5WlQkCnir1x86CvZYEGl5f
pWKEBLpozTeRcv4y0JU6P04JeLHxtvj1vvRl+NOhl+ajQQMZK0dbjYVliEre
xg3bTwN7+F5BmFqGs3lyMsbnaJB12jH24+AyPB768WbCgAZCokGBdzqWgVez
RajlOA1Cr9xqsWpchrWmK4nvHAU65TntgHTtMuA3nnURcxP4X68giitfhryE
G7Eh9wW6YLCW/PPtMvwwnsRRcmjwO7LVOPvFMlhtC8Q2ZNJg/Kvt05D0ZVAS
nynZItBd/o7bbB0SlsFnO41U1EgDaT9NQ4PIZXjhlFarMibYX6tZY8fNZWg7
zM5vHBborMnA0HXegvUH39vX4Glw/0J1I/niMmzmPDLkCnSkfD/Ra/rsMgRa
lxW85NFArfjff/3Hl+F3PvW9qgQdnu+t5LWZLoP82djdz3Tp8JpxeanxwDL0
BFc+o5nQwQg9uRc0l0Eq9LOe7FE6uG64fqVecRmEVyvuddvTIUyhcRK9TfCu
72MnLVymw3z044hmsWXY+rpw8+M4Orw6/HND95plOKimaSl1lw4tpG/Do6wl
IAXjGg3u06FW+Uw2fmkJrN6fdLxYSYeVnOYsztwSrDoukL5V0MEZLX9PcmwJ
KhoufLKrosPwd48Cjb9LMFnz6C39Fx00HgyVWbQsQZFGguW2JjokLrgsX/25
BJIKpyoXp+iAuqFgGle1BE0cWdRBukDH01IDij8sQUpm/+NBMQa8lLDo7spb
gk7SscoHkgzYeRe1aSVrCfZcbw07J8QA0pJepFrKEsR9acgI38KADw2dDedj
l+ByBPOOqTID3IS27H90WxB/6VqpaQcG2F3SjkAHLkHgR78P05cYcOTmXtzK
tSWQMR47lyDAiZybGgYXliD+zQ8dlSAGBF+cSA47swRO7eWsOR8G/Hpqhq05
tgRGqgXMBwK8/KRAgmsiwHcSjxqnMeCE+YtzVgeW4L2R2acQNAPazkl6ZmgK
6pO7SJ/vZYDFmhtpk4pLsLnG9fPgZwYYbh+M0t2+BKdGszTTGxiQdexeXJz4
EmgZ4FNHZhhgdeTnyVHhJehZkf1hxmfAc6dctQPsRYhElqQsRJjQ/SEIn0Fa
hDsqP7Wa1jJhSfSHLwmzCKJ3faZSNzLhbI8l8+zEIvilObd93sUEsaxZ09q+
RfCPqH0yY82ErVO6GYp/FiG/07MxyowJ0SYGz5PRi/A3o/L647NMWPvyStHK
10VI9NNzxV5gAlZ72duvXMCTDG2jNUOZ4B2toDX5dhEel7pp61xlwlt99zeO
LxfBLF7jvzshTBh91ibVlbEIWR2PR8efMwHHM7lo82AR1mp4kpaymbBu36h9
W9Qi5C2g+6zfMyF7i5/JydBF+JJovvZvAxP4VVO93X6LsL5HZAO/mwnhRycu
O11dhIobjR/kR5jg6pyQPu20CC4ZeM0wkiCf1yerAk8tgtGZgRYNChP62Q9u
8ywX4Y0JW39ghQlWcF/78ZFF0Du9u6BJjgXV/+C+2r5F8Px8r7rnAAv+PnRD
12ssgq/YbgUtQxYYbhpvdNm1CCWZnuZxVixooE1fZkovQurB1D8kWxZIp52Y
yRZbhIEpJ+fBayw4MSGzaiS8CBZ7MAmSN1jw4uHqytQKEeqtOXf/hrPgUsve
5CQSET7mleI/pLFA4Zc69wCWCDp7DQ/k5LGgp9yZPzNBBIrX+aLOryz45L71
X2Y/ERLijGG1kgUbbtmGHGsnwsizO5mWP1mgWKGUyW0ggjnmsX7MIAsMbD8k
fxXw6O6v2lOcAcH+c7/EgiuJYDIhvxIpwOFzlz30iogQf0PET2GVBfPrkhBy
DhFeLGmd0N6xAtfFhZe+ZBIhN2M69rbWChjkb9oV+YgIt6uMD3YIsIno0V2W
MUTgZfFjcEdW4N5b0TyJ20QwfWDENzAXfO89QpgIJEJfUWLt5pMrcKJEfbTC
kwhDbU3PNl9ZAXZ9vmXsRSKc0vbtORCyAvj4kHBnByJc7XXZWHlV4P9pvKK+
DREGjz/eYSmw65EH08SOEuHSpCgcSV6BTTtjggmGRFC8vcujIncFHgRc2N6u
Q4ROzTTLY+MrULC1VKdiNxFyjCSHPjasgAxGYe3THUSQyd0avvhtBaTq3964
K9ApQvkz1keHVsA70eGEtwgRJPdv0xnkrsBalbxxRyEinG0xjNkrzQafZGTM
kiXQWfoFh8w2sKEj/W6G4fICOIlZpyn8x4ad20wqtDALMNA9U58tzoa49W+i
VScWYIN5+b8nOmyo5n37qiDQWelMt4sHLdigoRnzWr59ARD7Buknx9ig9N4Q
L9e4AAW2r5LzXdgQtaV0ese3BcjX2yq6NoQNkyfsrih9XIDrvZdtV26ywUnx
h4lG8QKolWb5G95mw9C7h7/0Xy9ATmaIBaSxIbTXs9gkawH+4QN7Hj1hw970
H3q2KQLddyPJrDCDDXUv/aUuxS0Az0v9sNprNnhNf30RFLEAbSqWE2vq2LDm
S3F44s0FYK/jeGQS2SCm5Ux77bMAGx/cFw6ZZIMpC9X8zW0Bkn78eI7qYMO6
pMyDQ+cXILi8QktlHQeOWgnvYNotgNDg0XwPGQ7EhQSelbVagEnZndoOwhwI
ckxWNjUW+BsMdyqU44BjHsrMc/8CPNiirHftIAcoZy/R0jQFujSpU/GPAwfe
9oRQvysJ6qtbsOejFQd28UoT8TILsDNU8dPdkxzQ/SLsLie5ANrr2jsuu3BA
AVfXZbdBoEtNVzAiDzlAuqNbFMcjQOCuOHnP5xz4fXq2oY5OAPsBMkm6iAPr
rCb9GEQCiDQFv6t8w4EBXtK5/XME+Bx79/rGDA4U/Gn+EzxGAH/W26GGHA4U
ye6J/tJLgN0y95ySBOtl+v3qWG0EsIwl1vxs5sAR4ZMHkAYCzLaeTQ6p5cDz
s5f2PawlQIuFRELbMAfQ+5L9+ioF8Sg7n93O48D4YfPdSsUEqMWXsw7yOfC9
09n45msC/KHK7SbLroLxha6kpiwCOGennTmmswp9+UPnZFIJwEpfK71kuQrq
R1vO3YgnwJdeUweU4SokWZb9bY0kQNbB5OqWI6vAERGOVg0hwL2xUYUum1XQ
21L9LtaPIOAVDC0Rt1UwP+HDmblKgDCXhwoxkauQ0jzVYuVCgEsvPLvNU1bh
epnTfMlpAkRcE/kW8nYVXrro6Gw5ToBmwy7qbPYqzEiS8ZEIAZ5Zt8ZOvlmF
uvGyLqwBAX5w8GfX9a7CKWarynkdAqRXHrRJr1gFI+fIvObdBNC6PxpDHBXs
d3590uGdgu+vdBw3rBfE96H1WcVWAuguvw2v6VkFN/w/CTUxAkw3u1+tRHHh
l1tfSZ6wYH2mLS1mHRcGxXIq5Dl4WPl4tC9zCxfC1+DpLyh48HtoFVhpyIUt
eRkX5Ah4UNxhPHZahwv7Lc6p5U7jQW0frzJYYHefVBZXHsEDNTAw9oMjFzSe
Zp//0IOHRT+2ePVFLtQcb/m2rxUPH21IYla3ubC8XiuqHvDwSL3LSEaAgyKF
nG1r8JC+mq6qEMuFjB+5GeMVeKDkH4xZl8iFMKlrk4FFePDfJ5UQn8GFnt+J
D4Rf4+HAkEjv6zAubCWqe7/MwsNJkoeIIpoLv4UznPen4sFLbvSeTysXPo7X
5XfF4+Gy/G3HU51caN94k339Lh4cHkh73Z/ngvrUw/eioXgYuW6ftE+GB/Ur
yx7l1/GwC+26oM/lgrzLxeAzHnj40TT5/iOHC+k3ppOZrniIaJ7jWojyQFli
CyPvLB6yMGvWmKrz4PB5/xQbGzxYOu7UFzrEgwHJp5rMo3hADXKW/DR5IPEQ
K110GA/t6UoSEdY8UHg2ut5JHy/Q41v25V7hgfGH9+Yie/CgS7fZc/gOD4Zn
FmJAEQ+fQ+WOrEbyIJf1479bMng4K96Z5pnMg6Y940/0JPFw/sk/cvs9HiRk
Ie7EDXiQL1wjpBjPg+obnXolfBxoCvWtDUnhwRYPFws/Jg5Q2rkXIr7zQCuj
O0xrGQdhpyz+fnnPg+kFs0ISBge8fsy0cSsPHn2yk6qZxIHRh4FzXs08oFgZ
3Y0exEGDBEHpJFWAm+JVbLpwkBRx5cp6FB9wjGeN25pxkPrzqgVdng8h7I7c
+Z844EZ3nD+nwYeE4erAr9U42B+cSjwmx4esruQ7SeU4CF+Mvma6iw/+3DW3
L7/DQV3cdOxJaT6Yz++vOJiLg+nQFZuftnyIFwlnbcrCgRhKOTbDnQ8kquV+
QgoODgnrbTIK5sPZpsSClngctFkF15w4z4dtRSdRxXdx0L4aWpPmwAeTs84Z
D0NxUF4y6TSWyYfJ2Gkxf39BPttehGWlCOItePTtzDUcXJ+MeDKezwf5vrLT
hy/i4J6xbmleOh+mHf5IqzjiYJfjpn/VH/nQWpgxv8lWEO9aDfymLj6k5ffk
rFoI8ifevOdP5ANPeOwe8QgO7h/65K5B5sO+4x7Wk/txMNGwPfTEEh9oJ18Y
9O7Fgb2+sMg+AZYMcBRpVRHU/8iGO///z7uz4+1atDwOlvrj9mSvR6G3JsRO
fZPCwezhhasZG1Fomuy/qWpRHAgP26RrS6HQKsbD6CphHNTkb3K+tRuFfkY+
0lTFwQIHM3Ep8QgKbf5c4Xc1FQv3VUb5/odQ6NOqNW+/LWAhaCpsV4MBCv1Z
5m0+zGLBfxKO21sK/EW5RLSMYUHCGl9XaYVCp791Cvrbh4VcjMPf40dR6LwP
hshEOxYUEyvy1tqh0L+6zu9ZaMLCbgd+7w9XFPq4cjCBXYeFZ8NaxHBbFPre
cvMvsS9YKDHq2XDuHAq9gVOXpViGBesqf+Efp1Fo7JpRI4NCLOxVHp+VDUah
+Tk6DLscLHSf6AszDUOhd2Z3xnk/xcLr0VHbE7Eo9KHJwt1xKVj4KWbfoJqO
Qnt9IWS/iceCKuNphrDAfj8yYAf6LhbyzclW0RkodGZzwo3pUCwESPwqYecK
/CfN9K4NwEKZHUkosQCFLk7krdH0xEJwcnLFj5co9NIV36NnLmGh88J6p6Ac
FNrmHvF6xDlBPUwSnpvUC+oRF3zlnR0WlsQ29mr8RKF1HS9e6bXCwnPMow9r
GlBo++Q7GkKmWPDsbqGtaUahr64TY+sbYOGfH3d0VLBeY8u6J9d0sMC7d3Bd
9B8Uen3hA/0Xaljomx4+X0tCofVzi7K6FbDA/O3xo4iIQqOVvfgbtmOhntjV
GbeCQns+YO81l8CCF+si7iADhU5CTly8twEL2+xadJ5wUeg7sncDf/AxcO06
I8yVikL/CZwwW2VioFeKbmOzXgh9bkp1qykJA4f7VhjPlYTQec0j72JwGFD8
ZTYVLyyErnLOMmiZwsCWi+o73m0XQp8i8OM2jWCgRoi4d+8uIXTDtaddTn8x
YMaWPLTtkBCaRJfvL2jDwKfKKyPftYTQXueo/csNGPBy3DIeK/A/9uJxpel3
DPjaj+DUtYXQhwZTzdM/Y6D5pXVD1lEhdGrp9q7pEgxMp6o1lJwTQr8aOSFp
8BYDLZh21x1OQujZrQYnUl5hIHgvaVndRQgtm7DdcC4TA6O4qgBTRyH0c/EZ
WdMUDKh0JLz/6CGEHt9JrnwRj4Gl6oPPfvkKod1m5Q4z72KAGIA6mRcihL5K
Hw05H4aBzLjCBrFQIfRbDD6vJgADGyxi3jFuCaG/X5bPkfPCQMhl2YM9iULo
WCf3Y9GXMbD94bGIQwlCaAedk9Pz5zEwUZf4K+uJEHrhbL7GKXsMlJ7yllx8
JoRWbu+7WHsMAy89pjR964XQy9BprGqGgfR/OvNqxULoE+ypDU8OCfIf8ZLx
eieENjCRiRLSx8Dz2Fe2fblC6P8BzXmGsQ==
      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-5.465853949132478, -2.8299751174938996`},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->FrontEndValueCache[{{{{-4.605170185988092, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {2.302585092994046, 
        FormBox[
         TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {4.605170185988092, 
        FormBox[
         TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {6.907755278982137, 
        FormBox[
         TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}, {{-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}}, {
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], {{-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}}}, {{{{-4.605170185988092, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {2.302585092994046, 
        FormBox[
         TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {4.605170185988092, 
        FormBox[
         TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {6.907755278982137, 
        FormBox[
         TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}, {{-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}}, {{{-5.298317366548036, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.005\"", ShowStringCharacters -> False], 
           0.005`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-4.605170185988091, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.010\"", ShowStringCharacters -> False], 
           0.01`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.050\"", ShowStringCharacters -> False], 
           0.05`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.100\"", ShowStringCharacters -> False], 
           0.1`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.500\"", ShowStringCharacters -> False], 
           0.5`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}, {{-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontSize -> 14, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{-5.465853949132478, -0.6934821551566646}, \
{-2.8299751174938996`, 5.602558970469078}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891497436223301*^9, 
   3.8914975686949873`*^9, {3.891498532036313*^9, 3.8914985683451767`*^9}, 
   3.891498623092783*^9, 3.8926137112076287`*^9, 3.8926137597068872`*^9, 
   3.8926137904555197`*^9, {3.8926142793509655`*^9, 3.892614293785022*^9}, {
   3.8926143341300197`*^9, 3.892614379762048*^9}, 3.892614465860449*^9, 
   3.8926960604540453`*^9, 3.902037114926843*^9, 3.9020422053140135`*^9, 
   3.9022934592621293`*^9, 3.9022934952818155`*^9, 3.902293810169385*^9, 
   3.9022961961234293`*^9, 3.902296684173396*^9, 3.902297541969925*^9, 
   3.902297602521983*^9, 3.902298377775674*^9, 3.902389065137349*^9, 
   3.902389158029107*^9, {3.9023893989402933`*^9, 3.902389411383639*^9}, 
   3.9024868505876646`*^9, 3.9034208098187695`*^9, {3.9034301276579103`*^9, 
   3.9034301524294925`*^9}, 3.9034302423781786`*^9, 3.903430639512725*^9, 
   3.903592087513624*^9, {3.903592142839905*^9, 3.903592164134605*^9}, 
   3.903592199652372*^9, 3.9040344714034796`*^9, 3.9041104578519835`*^9, 
   3.9041239365475163`*^9},
 CellLabel->
  "Out[181]=",ExpressionUUID->"2590f3a7-4104-4acc-a00d-0468a983b969"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.004583333333333334], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJwUl3dcjt8bx5+9n3pmqGREVJSUhHRfdklLGmSUiJRoKZSmChkpK0SUhGiI
lHJpKCGViBQaiq9VSXv87t9fvd6vz3XOucbnnPtpytY9a7fTKBSKGpdC+f/f
QalleuI4OXZbUIyY7kpgpH/a3WJQhjNecVXnblOCd7vXfalukiEzTT3yub0S
tH7SKphQLMMd/a+TpOZKEL454PTENBnmmwy0U0AJVPqqX9TGytAsy/NMI6EE
HN99h+f4ynD4/MnvscZKoH1iWaTOBhmWdT801CHj9cob1MqWyLDmAvvAkblK
IN0euuyXpgylGjtiTy1WgoGR6xZXJTI09u35lrFACXx+/1V4PyTF4oNW6u26
SnC00xtPfJXik4Bjj3ZMU4JVgtSBotdS3OrQTdeZoQRfkh/cdM2X4jr13UNV
JBe3qLEDU6Xo/36H30YyftZR+5S+U+T6FKNPNSpK4LB008pPQVKkDse6tSor
wcf2sn8z3KXodatJY/kEJfjrkNFTbSfFjQIt0zkka83el/92qRSXM7J+zZMr
QXl1x5+5c6Q4pSS8s1yiBE4bbnh8nSjFm+X29b5SJTCtGtD5jy/Fz7PGXjzk
KsHhI41bTQYluP3x/Yp+kosTzew+f5Pgn39pRb0MJdgTUrunsl6CDTdatC4J
lWDGZrAZeSbBNZNyvytylOAF70Cy/wMJEt1vMrrpSqC+OF9b74YEzRLOlU6l
KsHwp/y3s89KUGHywYn/DcphFUiT3KMkWFAeekJrRA6aA7mJLfsk2B26i720
Vw4K14/1nd0hwfOXgxzdeuTwqHHGv0hHCZ7NvMo8TPJRq7Mdt8wkuIppHriM
5MIbi+exF0mw1SP0HfyUw8nL7+zOz5Kgs0mf1ptOOSwN8K/ZqCZBau3NJOvv
cnDalELYiiQYeWXP87Jfcjgb9h0O0CS47l0/Na1VDvpByQnVPWKs6FgXvqtD
DnnTDXrXdYgRI5KcLpOsfkRXn9Ugxo5DVzqSWuQwY+qvaa0vxegTFehMIdev
/Nx/778nYkx4nC6Y2yiHkNywEpUcMXKe1H+IqZeDSPTG0f+GGL8fTHcdq5KD
9r53Pr0XxPghdp96ULUcTlddmph0XIzaD6QKJqRekvt7t0eYGCMTf9E+VcoB
3VpDN/mLMSAi3laHZMHT4IO+7mJ8Omnwov5TOVSOWR69s0mMQxNUOn88kcOs
sC2N7LVipOyy77hZSNZn1p4buVKMDl+c+CP5cuhWsredukiMzE4XhQ15cui/
tGD4s64YFyQaKi68L4fQ1ZNHH08TY+zHm/uH7srh9rDTnbwJYsxaPXH28jvk
/OYXb6lVEONrRt3VjutyML29dx+XIcYqDZNO4qocdr1PsN00IEJHu4TPp8/L
4VWC4ZZXv0V4ZFXa0WvxcpDbMFnr20QYqHPWtf6EHKb9nPFo7IMIj3buXMeM
kcO/Pwq/8bUICz+Lb6kflsM9iZnapTIRFr9YfbYwTA7eGVByqkCEp7RXTpp/
QA5Uowi3pCwR/vQ8/Ndrnxz2abbHlKaJcHKgnbv7XjnMnNrygJYkwvVzEjLm
7pZD/BF7P8cEEcbt8bQW7pTDItqudWVHRXiSleIau5n0yySX76ZhIrxpcbpt
9zo55H74gC0BIhy/elrIDWuyv+Xe4ae9RPjRy9i71lIOS7I9nzpsFyF1kuZe
j9VyWBwapjJ3owh3erOckwg5LHCj602xJflyxIGTC8j1vpUp01aLUEHwgTFq
JIf5kyaqGi8RoXWh9cnHunLIqk002WEkwiXZ97MqpslBz3HGg1RdEcqGRWka
6nJ4MLtep09DhBu8/WaqqpD1pDfaO6mJMOxKhuZzqRwufPP/VCMXYVsM5b0X
Tw7hBz8GbBCK0Hfv0pqVFDlMr9St72GIUO150+n8URnYrfq0bcmAIkqzrS4v
7JfB2XYML/imiD2X9vwM+yODaHXhQYf3ipgGQa57vsqg32FaqaxCERMcdimc
bZZB5p6b9d0PFdHX/096YY0MxM0uc7vSFHFVX/Xsf69kIL+psU7xvCLKP5zY
GFwhg5L5xU/WxCiieqf26YoiGby2/zR4M1ARF19eVzd2TwY3Gn8eV3dXxAG5
Zuu42zJoWi5hPF6viP7XtkxXTJaBraL4h/dqkiW5X7wuymDicd1/41cq4pxv
K8c535VBT+u8N8sXKWLUUCN92ykZBHsvtzKYpYjNji8JzZMymNM96xsxURF1
A5/q9oTLwMbSo+/wOEVc8bf2Y0ycDN7rd1nsUCDr2XIqz3afDJiiMeGtMQXk
jn66XOstg8/HlpeyuxTw68m9K5VdZXC//fP04e8KGBd4dt85Xxls76pWCG1R
wOsT3r3xdSL38y47LqlTwKzL9qliWxkU26xsLSpTQL8vP1UCbGSwrHzWjz2F
CkhVDbz02E4Gb8975kQ+VEBGZ/AR2UoZ6INRimu6AjbuOPhzv7EM2j+Eb3K6
qICPg5gbVGbJ4NRp5sF3cQpop73CZJGhDM7f6Y7xOK6AdSfl1t1TZfDB5HdN
fIgCzi9R/Zk8XgbuFqe+vvFWQGmvi+MVBRnQPCkPpu9QQPjJlDXKZWA+85KP
9jYFPH0u4vQeqgzCfXw0E+0VMP/OKaXCXimcBdbjSWYKeO+L1ozsf1Kw8Q0X
rVusgAoB6V1PSH3m6dqmgkUKuOvPuC27vkuBq169zEtHAauS5p359E4Kfqc8
UgynKGDEu2qllioplA2Isx1lCti2feioGqlPe33woYzkhFGdgqelUlj8x8iQ
w1bA2oCv8cvypcDQ1v8oGhRi3aTfb55kSyF18eqtOr+EeEjly1LdFCmYvD40
Q/unECmZbq1rcqRgPJYS4/yF5N38m+OTpZC8LF2Q9kaI4eXLq6+elkLgwN8M
arkQk2KqDE5FS+FKHPVwSakQC9Tn+CSTumq0zey9+UJMvCdvXXpACrquD9Z0
ZwgxSutbDvpIoWOhuCw6WYjpFsv6vLZL4dH9I6uUk4R4+naFZGivFCav+u01
54wQUz61/Hu4Xgr5h9Yzf8YI8cz47htdtlLw+J1smR8kRJszmaHy5VIQG//1
mxlI1hf5rKPUUgonWlUlF/cKUeTJ0fU2lkLfk0njT2wTYr3bI+7JOVIYGBrQ
jHcU4rEHHO5idSkELfhh37FWiGa37GwbtKSgYPdHfGuNEG/PTVx6SyaFozPm
XqwFIfrN+sK1EEjhc1dTnGCeEJf4RTvlU6TwKmLskrWOELd9TvruwJaCiNJd
7KApRDfpGL/mjwQaF68ZzpkoxPPltBcPvknASydFMEUixPyTE+FekwTULZvM
N/OEmPdycUDNVwnM50SVJLGEmAo3HHJfS6Dyr0XXrCEBrl9uczeoUgLRnuo7
XvwRoIJl91fRUwm86Jt1l9chwNptHPtvJA887end3ybAN6bjFBIzJPAmz8fX
6IMAr55W9NW+JoHw1YJMVpUAFy2uHp18UQKqeR5+1qUC/Em55KJ6VQIO4f+F
thUL0LisZ+2ueAlYBfzMr3kowFfaE4p3R0og1uW6ftUdAf7z17qptp/MZ+F/
AVrXBPh3ep99TJAE0iotn35IFqB3XOvXnTsk8KP+/cKeswLcXGbwsdhJAkUZ
tQETYwUYO3vjM9kmCdj92GttFybAZ4cMbQ6ZS6BhoPZjfKgAt5jrdVxZLwGW
Sczli/vIelYbZ/4jJODOP2rU6SHALw5L3P4YSWDqzdrutS4CFL6asNpOl1xv
19EbvUWAKuyOjQ/mkfk99cgrsRegF0tLSUFVAjppr52WrhHg8e53l5Avgb5/
xXlVSwQ4OOXjvnq6BOK+hfrQCAE6rfwrOyeWwJKEc7d3zhdgRGFsgBpFAoJ6
TbFotgBXKD899+CvGDwfNT0rnSrATLfxZuIuMagfTpCMqQmw7oPb/JHfYvg0
/dKtqPECXGNRaJ7fLIY66+pEOwUBzpt6ZcblGjFIpm3fp8cQYKXl60mLn4tB
+vn42/1jfNyxS0np7EsxrM0vVlUe5KO8NKItuEgMGf+92K3YyceoPyFLje6K
YUvrRzNxOx8Dln7qf5AmhrFpQd+8vvAx0sOmMOCWGPa+KYmb1MjHlsygaT8u
ieHltQqNhbV8/LMIRptJ3pV39T/nCj4mFDa2K0WKoacGLjU85WPjsND+ZowY
5FXeT+KL+HhMx2t2ZZAYVGrehNTe5+MoJ++Zxm4xjB4oVZt4m48/dduuZ2wU
w/K5CyIeXefj4Py/tLjtYjA2vBHgm8xHw4zk1IsO5Hk2q7zenuPj/uNsFZm5
GAysP7YvPcFH9x7xsXWEGOafCDPkRPGxcM+/oqXLxTCPO1BWEMnHPdcT/l0y
FENv1flO4iAfT65VnXJzLtnP65I1r735uGpuZthcHTHo7zO6WLKTj6+Xru/g
qYvBI1C1yJ1kqeWuNFU1Maz0q5iluIWPK/1/X7PkieG4acShJ3Z81H+2zGMV
VQxesZLEA2v4+Cvrd5b9mAj6NmaFfzPno8nK3xYjpN41Nd4NlvHxflnAEL9H
BNxbAS9EC/ko/GG/IfyrCE51R2X+mMPHutqHGpc+ikD9i7eqny4fFaMff7T9
IgJKWMNI9Qxyvk5trJ5KESQrNV1ENT76YdLYCIqAtszMN1/OR6aqs934AhEM
T5t3wFVK9pNhaO1L6t4jM3YXCfiYt6+scPodEaxd+drnJZ2PV3SOGF2+JgLF
6i+72wZ56K7xfctwogiu6s7tz+nj4cEn3UdmXhXBvnumpqxuHm4LLBadiBWB
o9T4p953HnYP9psFhYlAj260fMcXHgY4hD2RHRKBmkeg0LWRh3FGQg/fEBHc
mUZZdKOeh/v228cr+IugMfpywe8qHoZufnrHyl0EA/s3ZcEzHg7vP7ahYrMI
Jg7QJ3s95aGjquv+LBcRHNhczb5UyEPXvHNHqRtFsPlExS1KLg+f/mhYFWUh
gsjF66O87vDQiYiIoi0Twd11E77V3uDhgdGWP4FLRdC6/W3U1+s8tKN8yKKa
iCA8r+r89os8vNohlCZri4CfIEv/fZqHsj96v/ZPEoHN9ffDJ2J5yKMfUT88
VQR1lJyU0KM8XHQsemKiWATzsrsCVcJ5mFEQ0rZYJIKpQlvpk/08tK8NDIml
i4D3Smp41YeHtSYPR3uYIniqH+/i4c1Dt+venp/7FYGplGYz2Z2HVtdaxhl+
VARpdEFNkzMP331taJv8ShEKts4IZaznYSx7QrxDtSK4OBhUX3fkoV6YNOvh
U0XY7Xt7kY81D6eHrm5vzFSEP6xOmpkpD1lDgg3iNEXwTWHKZwIPX83w1TsU
oQiDIaKcRwQPf45rWBt1XhEMvNVdFI14qB0W/NM3SBFm2OW8G9XlYfXtRU3m
roowXtdme+8MHj4Iy9qYtVYRrpxs/VOowcOpJx/W1m5WhApB5fC/STwsddhx
tHiFIrS7qRwfGUf2/+Cc59YGitDk7MMSisjzQp/dua6kCNFlZQaKCjycTNdd
7jBDEdYJtNdP4/CwKeZFs4ZIESwzX/svo/BQHmS7PZSpCO+l4y129XPRLfi+
YWmfAoAX49Htf1z0MExNr/ilABovv70+38nF/Qm7FU82kvqp0y1V37gY/9Zt
1/ZKBehvbDopaObi4MVxTOptBVCO+VoS18TFR9EO7zLvK0Djwu2PbT5wcVtF
ITfsnAK0lj9an1TDxaCQHArjjAIozDy7vvs5F/snmrEWhCvAhuM2UU/KuLhh
2gYXO5IftTdlWBSTLOgtuLFbAT43XDLNzOfivFd+cRfXkvmcYKkq53DxcyU7
fqMVeZ4N3Vf/LheXZeyZJrdUAIc0f+Vjt7nIlGRLKLMUQGrvYUhPIfUjonVp
0xVgZcmJreGXuJg2uUy9S6AAE7sG3v84y0Uf+TJUVVGAnPA7cZwzXNRhTv3Z
wFSAB+wHD84c52J9C2VvVbsQ3FWflmpGcfFX33/Z+EkI8es9FnaEkOdpxb66
+00IFk7se6WHuKj3R9nA6J0QHG5/3ekWwMWcrZJyi2dCWF/08avCXi6G5zV9
kxcKYfWF6RrT3Lm4cfyT2MQHQiiOOzahaCcXe7O9qppShHCpK6/P14WLkqZI
XkuIEEpHTP3mbOCiNKZ1y7oDQrDMWhLxdy0XD21vPLjhoBC4I/ukySTreZXZ
qkYJgen5fHyhORczPGbU6+0RAuOQhubx5VwsNChXVN1M5pdbdNN1MReHmrZ+
2bBSCONqOtI3GnPxi/LyWb52QjjzSykWDLkoOHTPqmuhEAKSa8vVdbnY+U3Q
E6khBJtDOdbCmVyMm7B99W1NISxYMXLRToOLa5PKu5gzyX4NnFcZmUzq8aoH
XFhCmNURMvHvBC4aNv9QdWYLYZos3PyPhIt+aQtumo4J4KarY+RRERcvHTp8
0b1PAHmf3yZ28bmo6bmInt8kgKT3ryiDDC4qswcqDlQIgOX03oczykHlhIDk
G08EsFnvqOHgIAc758x3cKoUgOuckHbVPg6u2XR8nMlDATTM2WEzv5ODxxd5
Lle4K4Al7VbpDt85mPLc/9nDZAGkJDptvf6VgzHzO3ZvuCKAzDnStuAWDkY4
nzarjBRA4s+UvvSPHFxp2D8/NUAAmxIlDR/rOKj+wmLer90C2FN/ujWymoPh
Zt4tYl8BrGNHhEmrOLjlVq4EHQRg3j+vzbqcg0GH6lSiQQA730b0xyMHL9lN
LotZLICH0S+SLhdwcGLtxvO0VQLwdGi63/iIg4F/369qXiQAW8MXito5HLRg
G0ysmi+A5R9+jR26w8FywU+rHjUB1Kd7Ov+8wcGFZo+v3ZgkgDfskYPvUzn4
AdaS/4QLIPxS+YH5Vzi4YpVS2PAYH6KM9P9ePM/BmzFNx2J/8mHiG3/Nvac5
OL5w68S3f/lQ0b+okUmyf9M3nnI1H8bN6pnlf4zUC7In0yv5EM2LbPweycFH
Qlnfinw+9O/WbHE9xMHdbyO51bf5EH/saP0MkmemVF0OJ+PLjs2f1xrAQSXl
YM6HZD7E3FN6tcObg5PjMX78ZT4M9i5L7trFweGFIxOvn+FDqefzvRKSX5hO
c5Fd50O7gk166DYOVvqykmnRfDCe6lwr28xBw66GqovBfJi9aJHmXQcOar60
Pl6xiw+75x2i6dpz0KT+Vue9g3wQf1e/uMaGg1lLnR7pOfNh6bGhSZ2rORhi
R+u8upgPS6of3Du/nIOnOhYkCgz4YPfscVjQUg7KNL6dPb+OD9mBm5auNOHg
rRmPvG8v5MNiFV51/3wODg2ZXQ7R5MPO79+tM/U4+HV/8uAhPh/upUTJBnU4
mHFt95T/tPmwxt+40FObg9ED/3EK5XwwDLQV6kznYPDUtncL2XxQTzy9oEeN
g9OmninK7+OBtu7kohsqHLxz+/7OLSw+qCzcs/DJeA7+2DxwOfQXDzbP38s5
KSH75bnOdUEbDzwKZl9yFZD9DYqZ61jNg9Rsu7QwDgd7tnRacJt5UM2w+W3M
IvtXJfV5lsyDZ3MT+pQpHGzmz81MyuRBsrg4c2SAjXH5iXqp2TxokrwbPfKP
jboN2bimkAddHbmSr3/ZuPNv9dMVCTzYt9xJqeYXG1Xif9GUQsj9Xmbcf9rB
RrVkuBRykAeTvpt+LGpho9Xz3RYMMv6+4FH7g2Y2zvXvtAoI5oH7yvOpmR/Z
+HTnyLUj3jwwXLbvv7tv2Xg7TXlcyVYeEP6TwiZVs1E/Q6drKqnLph+/m/Wa
jXcXsKL/WfCgykjjR95zNrLiZukMkdxYceFCaQkb701P7jhqxIO2TsucukI2
utoc0c5eyINDn19IbpOs4h8mNbfiwZ+ppw+YFLBxSKV+raoDHz56F+h9f8jG
i3MYJi4zePAiylWBls3Gh9WdyUcn8mBR/oelk+6wkZZs/3pAzIMjb0vfOt9m
o0ZUoN13LR7oPS6qgBts9Ha5P/smlQflRk8vuF1l44Fj035sFPDA9d7le6cS
2ahJu1LIJfUfSltkcIHk5Pe9w0weBK1WYzxJYGPmkoHmtlYudD5Ujus6wcb4
XeqjeZ+58IsaaD3zCBtL6+k5Cxq4MDB1EdU0mo1276yWxJHxO3bONHaNYOPC
zb2GL95zYdwibctrwWysNNh+0LWYC6M5saFfA9goKZyikXWdC+q5aZ0B/mz8
4TndaAqpH6jd/mqWDxvNqzZx353hQo1ho06gJxsfHLr1eCCBC6tGp1wpd2Nj
8btrftmRXEhMtlr02pWN2rh56MtFLmRe8R+v4sLG1ZMbf8ERLhyqmHLGx4mN
BS+/aP3x58KahcGKVXZsDIp+advuzoWtD9ymWqxlY+e1jhsPD3LhcnuIUG7D
xsfO4sVxR3jQfvO/sNnWZPxnr06X7Vx4fP59+6nVbPyWsvWLriMXPi5+atS/
nI1lkgId4yVkvTH5oi5gY89mY/WSDVwwd9LycSXY+Kdp3r/epVzomJp6vHYB
6acPN6tMNblwVV51eIUBG1t2aCm3T+ZC+CwP63xdNsb6TVDhGXFBt22N3WMd
NqZRrDQCxnFhvnVdr6Em2W/FdLNJJL8QTt2eq87GqkC5drecC2alpuY31dho
8tudeobkLamjifNJVnten/adyYWp9ovjC8ezMVWoewv/cuDxzefEKinpz5xb
wa7fOPAtbV9GnZCN20xyPokbObDvwXOvfJIzfW1SqWT88osmVds5bNwM0OXe
wIGFQWqXB2nkfJ7ip+QaDuz3nCiPH2HhswmnLk5+yIFxps7izmEW3rhQRB1f
zYGTiWv0dPtZ+EF5otrfexz4T6P8Z1U3C/fvm5D9/joHZnGzl/r8YmGKRwex
JJkDHrUtmaY/Wbic/6OTncUBtYevls4gmRpif+tsIRca/y3SmfCNhRyz+LM2
MWT88su3SlpYeJxauSbuJAfOvh2X493EQh1FIwNbdw7Mvm13u+QjC4PKb00g
SF062LtU/T0LretKbqru5cDl9Sft3teycIbRfz21nhwwazBpP/WKhelDU2xy
gjlwmn03yPkFC71Kl+SK9nBAP8azc00FC6d4xtUO2XPAPzhmj6CEhdqMDUUf
LDngW8nf8rqQhSFFW9HAigPrPHuuqxWw8N+N6iMTbMh8Nwfmn8ljYUbbptZx
CziwudMxeEsOC8tnb5ippM6BRd/g+qy7LJSqLVE/MJED/Mu3jozcYmHD7dcZ
v+aQ+5m+nDFyk4Xb9bdS3qlxYOq5K6ya6yyMPGIbJ1LkgOnzHYtuJrGQ8Wph
kBaDA5kKWDCcyMI0DdOfO0i9Q7vhafgFFipYvvy9is8BXav7Z5wTWKjq8cp+
VicbjLoKspecZOFUzrala36zIX7uzfl9x1goaXj5ev8/DlhP10lXIfl5YW5V
VTcbJn8vkmkcZSH38autk96xYYck/qHwMAsXN75YuqyZDaeNlM71h7AwLHvr
3LhyNpQU2TatP8hCu/X2UTa1bODSde61H2Chq6PsVlE+G4yby4fq/cn58LL3
WGSxYaT3feDLvSxkfuI0mSWT53E3Ty31YOH3T3vnFR1hw5Yl2u0PSN5h8+VX
TyYb7HY59RS5kX5adHLKlKNsWPit8b/HLiwsXHJkocYtNmTn/aMWbSTnt+no
giMRbFAPv71oLsmjA3+e9cezwX0Hzit2YGGzaNmmj1FsSCrZHP58LQu3XHM9
tv0gG1SqBlrfWLBQ70FvZ942NrT5B+x/sYaFS8RZEXa+bNid9tS+2ZSFh+do
zlezZoP1oV/vupaR/lM4TVO1YYP5oQJnJsFC3svNJoeXsyFnhXxi+GLSP5lX
aK72bDhRtLdTZSELa3hES+s8NvTOWR8+bx4Lo4+esXyvyYZ1ceWStXNYGGMq
+f1sJhsomunD40hm2SYEMQw5INEXPbHTYeHvgmDHG/PZ8GGdPMlbm4Vfa+eK
6uRseHzh2uQEDbIeJ19zralskI17d/bRFBZqrWjXTuaQ87iwqHvFJDKf8vuV
9kpsqBdMHGlWZeEnhdnFK/6xQNXgh5VwPAvtmTsu7yV5/738Y4ukLKz8NG5r
4E8W+EbGO60VsbDfw+Hi7V4WXBziZ3gqsPDSYX5g31sWKHzZnnmVS/ojRvW3
bR0LtJztTtczWIiXtozovmZB6pkhnwNUFl74kJw1+p4Fend2W4kppB/+JF6O
e8aCKxLTNoshJp47u2bp7DwWJHZFWBzvZWKb3iqoS2OBePyUlsJuJrIV9lqm
PGLB+ZvPol93MdH1/oi9RzILtI8WnJT9YmLVerv5U4+zoOuVdOvGb0zsmeXu
cD2SBZmjY8tV25govS26qpHEgsLwqKEbrUyEwwEZy0NZ8C602rHnExO5Mx9d
TyDX7954f9/yBiZ6J0lm9viyIP3tnhSt90ycmm+7R/MQG3QdB23OvWViZXks
o8SBBQdUcxecIXnD4YIApUMsEDju7fhZzcSjCbfK9q1lgazuu/6Kl0xUK0+O
BCsWHH1BGFwtZ+Lxy8fCaetYMHQvdc9MkqeNvzphkQsLhHnWX0eKyXzdRvfV
O7LgXyhl+eYiJlrQZZpBwIKXXkYWTx8x8fm1wdAXc1hw/93+XW/zmNgd6u8z
soIF39U6RjRymTiw2OLha0UWGARQbE9mMnF+HHN7xHQWKCYGmw3eZuLsglqP
FhELfvqkN128xURrpzvc2dNY4NCw8dOONCZO8MqRM+QsiL+XrPD+GhN1zp5r
niBlweJb6+pXJzHxe0HY3GYqC9ziYc/BS0w8mFD+QotDzndnxDy8wMQxFrvF
Z5QJhkdAw+gME7W3RiUn/WRC1vXrN7JPMbHjv7hFc98xwfLYtHLfE0wcDI+C
Kx1M8FnwPEc3lolNEQcuRr1gwuU7tavvRTMx8OXUqiWlTHicGippjGDisewj
Zk4vWVBg0L5Tj+TV/Qfb2dlMeCNin4wMZWJcGdNm0ismfH2jw39wiDy/OIUt
zWMCZ02jzuIDTPxblbk+roAJNj8iip/5k/vbKv+xTiHZ/G9ohg8TI/vXbSy+
y4S3K1O/rPVmovBZwjOLeCaUv3oX0OzJxJjLfqfuxDEh+/2Gwz47mZiaX8Rn
hzHhcGXxrN/bmPjHL0GedYIJamsCWSySvT2M4uZ4MeH4iQP9F7cw8eWV1mlu
JB8+lOVo4MTEq03Z+qoWTDhA9FqtdGDizHbXK/P8mPBsp/e01/ZMrPUKycxb
yYTYUcl6z7VMzMnzTYw0Z0Kv+d+/fEsmZrzh5CeZMqHzRH9irhkT7cTDo6O2
TIi869udQfKBlMnnPIEJd14M2KxdwcTFw/EdFuR+x6L/KA4AEy9qflTdrcOE
nKFizWvGTHyEnUHOBkxYXfnsySKSS7c53SwzYgLXq/2ShRETS7LWGl8TkPmt
qnYb0id1pb82JSpMuO9j09Uyl4l8D255uBoLogRDkbd1mdhVzp03mUXOeycz
9L0OE5PyDta8UmVCoM3Xnk3aTNw+L3im6y8GXLkvvi+ZwcTcKCWzhH4GzKkj
v01Tmfi+dN5/C/4x4MjjLX7HpjDxqd2e3EMUJtBWWilFqDHxVU7TWpN2Bow7
uf++iTITTTcF9pj/ZoCJyvjzw3ImhtMCpY5tDEgVR7iskzGxYlx1p9ZXBpQb
PC16LGbiT8fzzyRVDLAYVtAIETJxReJIQ2EJAy46X3mxjMtE30LutfmlDHi+
3mpsLpuJCWNvKmpfMOC6kiyDx2TiFbG8YLSAAdFxkoo3FCZqNNo1TbnHgMeD
y5SvDDPQ3Ux3ls0dBvB2MtkzBhnocEf2wvwuAwgtu2TPfgauZd94++QKA74k
9W4w7mFgVqfQ6GE8A67ua1yu0MlAuLL/7p5zDLiT/gPm/GLghP1bip6eZsCU
HUUbW34wMPRv6qKf4QzQe+BwNa+DgUsbZsmVgxjgzt9oM9rGwHve9lsW7mOC
09wdwrhWBm7UmxQgD2XA1/ZAC8svDLxGz1Tf6U/Wq30v2eMzAwt1aibO2MUA
Zc9/G0w/MjC38Dizwp0BVD36/Bn1DAw+oEddbcUA2uCVvtA3DBzJr9sctIUB
Tuqp+hySsyK6atctZoCizW3LH1UMvJ2o8sZ0EQO+Tf9+uLqSgfMqIjT75zDA
62rVSPkzBi5zyv2VtYIBGdvm1T8kOfhfQ16EGgPWTt4FycUMfLM7dEvyDLK+
3G1PYosYyDU95fRcgwGbiplrD+QzcI4JM//xbAYcDE2fpE5ynsGhRbEzGTA2
Va/X/QEDW9fvy3gsZUBFx6t0p2wGGj55sbSbyoC91s92Wd1lYPvKM82Le+iQ
p7RK+3QGAxOSo05l8BlgWcaev+IWA0+aLDWbOkCHzupwweIbDBxV+vDr93c6
vJ+g/d3wGjkfrRJO8Tc6UL25FbJksn9Uf3zVTQeDjX2Vc5MYWOC+51b+bzrk
ujbfm5PIwGblgm3x9XQw/8bc0XOBgR1rJB5/3pL9YLafmXOWgazwkXy3BjrE
HN727FYCA00enMkKeE+HZxOYB+eeZmCNJuUYvYkO/vuWbDI8wcCdeasGf+XR
4dS3qwuNjzLQWytixuh9OmSfPfGfbQwDJ7eNxh0oosNdnVni5VFkvecTP7/N
oAP37+9PFuEM3H3XrYh6gw5Y1pe8/hADy33mVBy4Tofk9uoBxSDSv/Tik3mk
rjLO0XHHAQYatZ8pPnyCDq160ygB+xj40UXpikcAHcrm+Z6L8WHg5TCrHam+
dNAd2lz+aQ8Ds+96P1p2lA6l4i2ql7zI+brVPUrxJPt9iHE8axcDewqTR1Vc
6PBpILyjwo2Bd44/LDHaQYencWUUdCXjj96PWOVHB68nw5otWxm46esVv1Ne
dFhWdnbtyGYGxts26dHc6XA6N3CLshMDI2V2qc9J/fNnm4M5DgzM766pLNlI
h1vfX1ouIHnh+j4lgyV0eLIN1TbYMtDFznwTxZIOX0qlMXE2pL+Ctol/GpN+
qQp/FWTFwJ+SiiXeFnSwPLWe8sicgcXUwLoRoIPbnpXrk0l+8DNd8bgRHepm
ApavIvtnoI9uU+jQ7pNG6VzGQPX2LTf2TaaDsv2D8crAwIuefvdnyegwx0tj
QzXBQFOrH3kVmnRIc0tnrTRm4KpTf95/I/W0J08qfI0Y6O+d9Xd0lAbE6MJN
1w0Y+GHZzgtlPDocvrrHeUCfgcLY1fKFQrJe4y3FdXMYeGSuwbjrIzQIV/Dt
Zc9m4JX5ijZFvTSgHXjSZ6zJQOf4WKKxigbv7VY+05/JwB3/+YbM+0eDvf9O
lvpOZ6Cizqc9src0CHaZ63RnCjnvdSGOI19o8IvR96h9IgOrjo2UNz6hQegP
2B6iysDortkTuU00EMbM+TxVmYFet7eZXXtNA+jUf+6sxMCAt0+dU3JocPyi
476rEgYadFTnskvI+Jql/EYReR/20fJmltJggXF/W7MCA99uqvxkf5MGz+Qr
7NL4DDxa/2H9uzQ6eNd5SaeTzLRIjB9/kga9WcqUXWzyfWEli60u0SDtFyfa
jMnAT6xdk5Lu0eCD+8b0TDoDm8J9mv7coIFJ3VnhwBgd522O5vZepoEWR1d7
2TAdk2+NpX47QYOLY2b3ywfouCvlpk/KeRpscIilnOynY9l/NxJKYmigsXp8
bGMPHceLRqTjj9PA7aLJS+0uOm4tdNXW3U+DxmC+uf1vOgpQ1bomiAZ7DHY/
CfpFx6iTp0KP+tOApSnb9vo7HfXtp1iuX08Dr5zUPPV2On5aNhpx1Y0GIfcz
Z/5roaNGQO1f5W008JtztmA/yepj10sqNtDgqMpGj5pPdHRYQqSnm9Cgjbf3
mdZHOi7OiHzcsYQG8Z9nTUqpp2OY51hgiRXZj9trXhwmeaTGrOnDAhpMKPIK
bHlDR6bvjf5fhjT4LLZ7CdV0PKX1PPTlONJf4aFlV1/SUZpmK5+sRINbCfOo
riRz6zakX5pLA49u362053S0d3G3ClChwTkFB7aggo4LHrwxCB1Hh0az+8nb
y+jokXxNo0tAg/S9FWGVT+m4Z16xWR65vx9P8a4eyZ2DV5R01GjQab6AqldE
RxXRrQEOnfRLfpzahXw6eh7Z3vOlmwrjuJdf0h6S/VBecGXVGBU2+s1rUXxA
x0XZE9hOLHJ+Vj5TvHLouH5VXP3Xdirk+X1U/HiPjj+XbG1N66ACX8XjrNkd
Op5+dvnJwx4qhB/efWjkFh1jR615LT+oEPgiN+fRTTpmdp+8r9pChbG/Nm7a
qXQsMLZS/FtNhZ+t9XeSkum4XPHC4rEnVOj8tMZx8Aodu3wX7Et9Q4XDFc2H
pUl0hNM7O8xKyfPT+Z1HEunIUjhoWvaACg1uf79Tz9Gx9fe0fv1CKoicxq1k
naFjhr7r1ZmPqbA9x8jnYDwd12h2WRY8p8JTaXB070k6Hq9fcqQ0lwqyBteZ
vrHkPB8Uf5VkUGHm9UVaU47SMeLJSHDObbI/6qdtu2LoeCBs1VS1s1TwcUt5
fyGKrBeooxeP0eBf7V2292E6sr80vrkdQYVZp7cu6w6j47XR9wWjIVT48smk
bHUIHedKfGaqx1EhuNKB6X+IjqvoBWdtTlDh/fWFawYO0PFqi63GYz8qOFAf
KYUEkH6MnGSh5kXul/d9MNyPjjc+NzgNBVFh8aFwVxbJY2VZz+4dosLQLlO9
k3vpeKG+N/iSOxUWVhYemrCbjoQJ/9O79VTYWitLee5Ox+8j2Oq/kwp/LM6t
TiX55O/Pt1euooL/umPxc93I+rrOhZwl429+tXF8upWOPw6G0NeYkfPNTDln
s4WOHQYzNh+zoALLb16iGsmln4OnzrGkQg+TsG51omNN4dGXP8n4woam0H2O
dBQqHvmTrUXm94SYybejY3fa2punJlHh0qoND8PWkf4zqU3ca0SFRy3TViTb
kPdhh6JbhioVijhW74ws6eh3rbS5REqFN8fDGmpW0/FfVA5fWYkKX1MtmrvN
6Hin74BtC7mfzCXM2nMVHUOdxC8KplBhQE8UpUNy/BnCeQ3p9yU0+XzOcjom
2mT3u7CooBLCOJ4KdMxllFJsRihQM+53ozdBR4V/EwqDSP3p3gk2yxeT78dE
3wlTKOT8B9TC2xbQccIcbdVOKhXmYLNalCEdraOPnF9M6kWj8+NGDejIeKJq
6vaXAvlduhqa+nSk3x1aweylwMGFH86+0qXjwkl85fkfKFBSdneP7yw6miUH
8ma8pYDnk9CG81qkf+nScRs/UaBnYcQ9ZU1S3/D5Q/JrCozla9mVTKejt77F
YFsVBXqbDmzZPZV8Xy4tp0Q/osBclZtnYDIdLVK/Z0yupMCZzNWvxk+i43zF
xJ9ypMDHLJ/LZSp0fLGnfOYu8ryr1S+rfMfTcUVbrse7yxQos/t765+cju/Z
Y9G7cyhg6G7grE7yijc+JQHpFOAvi7KuE5P1rH4ctTaNAmtPXE2KUqBj5Xzn
1anXKDCpI7LlIZ/0d/bcC6KLFLjXvNVsIckneqcYax+jQN1VTustLlkfVyl0
VjAVvs+/a/WHTUfXH8mxC/ZTIOXXtsxUBh3Tzuo/OH+AAjo6D6dHU+nYYrTU
OyaCAkpPdu3aRHJ3TR9LRsa/LEsJUhqlYc3b7tuVG8n+7Rv4Wj1Iw3uqBQ8+
76JASJJ1amwfDf1Fle8+7aFArXGgrSvJin3XW+t2U4DYGv/IrIeGU6fS/s4j
490X3pnC6aLh4QohmO2jgLg7qrH8Fw2fDqy8F+5AgcEV+uZrSDbf2M+770SB
sBTR95j/aFh/b9OdVFMKyAvmrzTvoGFuTbmOqyXZjx8/uhXaaLjH9cPRBi2y
36KdfUtaaRgRwFFSX0Xmo6/2+80XGg7tzFmyZjoFNBvRMLGJhlsrU7t0ZBRo
2Fv+wqWBhnv/Ses1SF3hqb768g80lI8bSDLTo4B5scYdrXoaLsyMfOg4kwJH
Wure9byhofu7wPeVQgosU3++GqtpmOUJh2eIKWB6V5y/9jUZv3jOzu1qFDBm
rg7ufkXDA/uXvnk3SPpfOsw6TvLd2M3jIlUooBuyg+dUSeZn/97zG7leYRdr
nVY5DRdY7CWSRsYI/Utml3eX0fBvY8ludTaZr+hty2AJDWN0vN6pcShQ/bU6
9yXS8AFn3aLJ/8YI4cn+F1cKaWhw1vnCQO8YkfMk4W5CAQ3pvlkbf7SNEbfa
zKf55dPQ+6RVn23BGFH3+0Wh2UMaGn/XpJ8KHiN+tx44N/k+DUvqvf67eH2M
OJPt11CeRcNlmvwW7dwx4r7Gxsz+TBoahvSuUSZ1l+V+7NoMGuruLVvjHDlG
fOiuuHjnFg01bvnF7Do6Rpwj8DfrJg0/fWa9rjsxRrxXcPGMSaPh7uzX514u
HyOmJy4P3J5Cw7gFsXOT7ceI4kdBRcuSaXhfU3vC7MQxwryz6b1NEg09t6q7
2m0bI7TvS03USW72vXM5PXSMOPFH1ku/SEPulBYrx+1k/Z2xX7+eo+Hq8pQl
tuR+I3ZH+M8TaLhuQrDj9MAx4lXM/KCbJCv4eTw4YzBGHLW7b/EjnoZnvtt4
9QZRQL9x/I6MOBqetGP21I8bI1bam/edPkHDgxM3cdfXjRLNd/UK9h+jIcd/
s/cvyRgR3nr5MY/kb2zWGF80Rsjam7JcYmi4QTjRiuCOEdcVXRtWH6ZhlNex
h/bdo4SLzVv9eeE0VL7wcK3B41Fik8vWmMAwGqZper+e2zZKRDebFU4OIf2s
/u9L0PdRQsas9xcGkX7dqzut69IooaWQsHEokIa9Z4gVLqdHiT0nP97rCqDh
6W8HDDyLRgn/DRf2/udPQ+0VLw5rZIwSJ20oWQ0+pN8GL0SdSRkldrq2qr7c
Q8NJjs+LPa+NEgEp2lP3edEw3P++4adzo8Qj1uacIk8azp83pKIRNEp4PIz1
zXanoVeiaNXfkFFC9C92Y5obDX/HXXa/t3eUWDJ2p5S5nYbXRH8kkftGCYcl
wbsvu9LwVRMrtDd6lAhTC05NcKbhyvVbV/0NGCVahBn045vIedcvOuS9ZJR4
1jwu+KoTDdXPPaenm48Sy+9x/YJJdnlZrqXMoMD6EzrRURtIv9UxbM/MHiXe
K0/TDXMg79+4l++SDch5zMwaDFpHw7LMnjcywSgxOt1l0cq1NBR7p/tUysh8
Zwx+229DQ7ezb6bWsEeJGwenDQRY0vDOy+DJXwdGCHGEvVaAOfneTBKWHFMc
Jfa7a9f2mtKwgcpd8OvXCPHbsNU7gOROE8kZadsIwTK60hK4goa0GlZhxscR
gsj96H1wKQ3bzuV08stGiGW+WnOzCRr+SSzf9OnVCBHwtlgthGRZ3Le0xOoR
IvluyLcIYxr2zXxGu/9mhLw/JlVHFtBwTK9C63nUCHEzSvv1KUMadt8NSbt+
ZYQ4ZxG8NJDkGssFkq1JI8QGa///zuvT0DlozSfrWyPEn+2rJ12bQ8PQn0eS
k/1GiPF+DZ53ZtOwtL3dfV/QCFGQc/4/U5J3fM29LyXZQ8G+9qEWDfel334S
7TxC8O/+tiydQUPHviqtNv8RYn3mu+aaaeR7pF6Ue3z1CBGytm7oNMkv32k2
PZeT9yXll8o0kiWBhyjCDSPENbslR79MoSHY+d1dMW+EqHuydVWnGvl+NJj0
2cMIodO1ZzxVlcz//EffQFK3jjC+zVWh4dfRPh9dkocrk4YlE8j7ZH7F2cRo
hLARaPydrkTDJ0MeHW/WjhBovXhogZS8v72bHScJRoglxqlHB8Q0FIJbwQL+
CKGsOFFmJSLrs7vv+7lhmJh7ftR4u5D8Hn0+5fO3fphIkqv6B/FIP7yynTW/
api4YN927S+HXL87bjqzbZgIjsksSGDTcF7sn9T8CSPEooo+xbsMsr83LhY8
vj5MuITpeFdQaRiiP/mU2dVhIjyP0dQ3RsXGDbOupecPE+sNTn9qHaWiqc3x
PW/ihomlBi4OlGEqnpzScfvnpWGiKLWhYeIAFVVvN1/zOztMpB2u1mb1UdGx
8ErClfhhojTYZKdxLxUfH91Zwc4cJvxDX406/aViwgf9fRIyvot4fjmok4r6
UdaeO12GiTvFjPRxf6joMm345wv1UUJiP7xd7TcV71U61JkGDBN6Kn7Lk35R
Ufw08djTmGGixVjcjf9R0cdAz+LizmECEttS2zqo6NWcG2JhPUx4tXcfgq9U
XPom++iw+TDxr2vuFi7JgmOFD86vHCbns2SibgsVz/9enkiZO0yE+jp8tvtM
RZFwb32NAZn/WH5KcCMVB/6oUOvHDRO5c384e5IsvPKh8/S0YYJtdt/zxgcq
anwnLtgKh4m9P48ZVr+jIvHI8utM0TDx1+wYdegNFcMSJA5t34eI6+xtvckk
C88+Mt82PEQsjxh+qVFDxa1vzjY5/jdEPD2gdd62ior2/rNF4m9DhGut89aw
F1RUKmvYR381RKz0c9FvrqTimkYVDWbdEJH13w+tzAoquq/mHbcl989pHt/1
uYyKSbMa5MPlQ8S3uHn3RSVUpBxaIf9Jru/+4NapWUzFlfK9R0LvDREmcad8
lyIVwz+eGmk8O0QI5+zX8S+k4o5hteuS0CGiYY7yi/58Kq6W+9Z5G44QCoFE
202SH7qOrDaDIYJOF0wNekTFjz4ubaUnhwgnbYOEpofk/OZ+zFt9YIjYU3Jz
sTSXzN89K6zGe4iYuvfPZ7NsKh7Mdp6zb8MQ0TvQklOfScWRvVrJ+dvJepSc
DoTdo2JpTJZhhOMQ8diaEOTfIdcz7hibeg0R1h6dCX/Tqdi9enjWpKFB4v7D
J3HGN6lYRd3ZtXfpEPFre4lUJ42Ky19PMvF2GCJOdQlj3FNIjsi2WaU9RBTs
0ehKTaairUt1oIr6EDGO+zDt1hXSn7kuPuHKQ0Rkl6tlaxLZj4VW+JgyRCQb
ql2ZcomKwzfWq43yhoiDdzJanC9Q8cK3fuPxrwcJuwlTfkw5R8Vzf93nbR8c
JIx3e4xPPkvFiTPWneL1DxLNJllESzwVnXuSejZzhgjb0x8cpsVRsfh5+VJm
2SDh4hhqeO0EFXfrrpY71Q4S+8MJ5x0kpyitupxfPUjYvDFxvH2Mit6HVtbO
EgwR3C59ojOGilILF43W3EHi2vOP8ukk/3Jj6962GyaU/xyUGUZR0cPjy+Hl
AYPE6R/ZIdokc3fIP7/OHCRco/3qgyKoWGlU/GSp+SBhOiEoujSUik8fRB8t
cR0kam52qQsPUfHtFbvFJrGDxJn1z3IKg6lonBjfxSS5ssngjv1BKvasW2K4
bO8g8ZV2Y1JyIBWP3jcw9XMm62XcCP7pT/YriJZcpjtIfHxFR0eSFa+Yp5nt
HCRuep8tM/Il91cuszpP6sEBH3oP7yXnf37jJx+rQWJyW42objd5v5eerg7b
PEgcLyxJHPak4o/0nhmRywaJPvVWiboHFU2iKYePDg4Qxku8h312UtGMZzpb
8cMAMb31y8uS7VT8nBEZFt03QKy0FE9O30bFuxscU4wnDBJyi3MRclcqZm7L
yz5eNkBUbBqctNOZ9ONmWtWWfwNEzIm9yQWbqEj/kXpi/fhBYmUOrty8kYp6
2gu6xMMDxPpuZ7bIiYrVo0sXqPwaIHTn6dtsd6TiBpPOtXVNA4TyyzeHYu3J
96JNderZ/UPElItWhwrsqLjCYEAzq3WAKJ1EGVFZR8WSHao3694OENfH1E5I
bKk4YcbWt3uvDRAP6nihu6ypeKlDst3r//VMDbYtsaDiiTOUmKCHA0RqkYFe
iznpLxPbeU4ZA0Rh5Bf2RJLPlnHNdFIGiGOzr14KMKXiyzk+01wTBghR8wzx
mxVUnOVmrRAdQ+5nldyQuYyKB85/8psXO0Ac6W3dpksybPvvVBkOEBoOS87F
AhVf600yW7BmgDAPzkj7bzEVDwevsN+jN0B4hBW9i15Exe+Ftxt5fgPEW9+z
Z8xIjjvv/X6zwwDh+HaXc7oROd+uGUcEKwYItxcX2DxD0s+bqusu2g0QVcL4
ox76pD/mZDeZGQ8QELdk4g6ST7Ud9yyzHCB+ND/79moO6YfT7ePlkwaItgk3
pujpUNHNvm35o85+okd6zeCMNvl9manZ+ls+QFz8tvWyJcnFXr2Xlk0bIB49
mjVlcCb5/kYfmJGnNUAEheS1b9GgYgTULx0i9Y0XPqtNJnmxbg26XSXvm2te
5DN1KjIXBnJYw/2E/N7xlSYk6yu+3e/KHSD0fl0ZnD2FihUL11Xuau4n8ma1
rjqrRsWd9+41HS3pJyj5vR5jKlQM1Dzvsb+V1Cd9FBmSLBtveHoTybPvW7m5
TyDf26GxdSqf+4mv6GpYp0Tel+2Z67Xz+olr/PSPhIyKb5aNCp8m9xOpxeM/
zpNSMTJ5ZVpTfj8xedE0iztiKlp98Hn9LrGfMLHSvzhBkXyvdu1TnUCe72Ty
4XG0gIqbnb5oKd/rJ3g/n19ezKfilXUR7c0n+on45SeyerlU8vfMx7iK4H4i
evKLQDc2FWduwcFUj34iS8KV1DOoeIc5rJW6qp+w+qFqZkGn4hSLid2rd/cT
TxqfBpnSqBivGvrH3Kef6MI9efljFHTz4Ybrk+v3hh0vnT1CwQnDz3+fsO8n
Dg54vdo2RMGrSy20Llj3E3e3nL2aPEjBhnW9fhu0+olSFdYapX4KLqZMt1g6
tZ/I/bxsXG0vBT07nlSblg4QNX8dnx37R0H7dZI2y74+ovvPZfXIvxS8clnD
wEy7n9hwna9II9lusPNDYE0fcWvrxen7OykYVb4yMnC0j5jXfpjb9YuCM5jR
1+QdfcSCe7nat39QUP1yY54vs58Y2WSW707yp6u0cPqfPqLLb9v81m8U1BIG
OPXW9REO1vahm9op2DMap7zrWR/x+ljvpw+tFDxpap1T972P0D2ZlPCeZDaT
uLYqv4+4aFbou66ZgnsnLiiOfdpHrBTpT6z5REFaueJH23fk+h+hpywbKZi6
sm39sqo+QtPaR0dEcuzLN/uHyf11Ns589fIDBZXvXH7890Ufoe54u9a8noKK
1vt/FF7tI5LXxF59UUfBf76aAXqxfQRzvhvfkuSRjj9jg7f6CCNVS8M1tRTM
bKwLp6b3ERFqfvGvXlOwl2rZ+9Sjjzg/Kfyh1SsK7tpunKUY10eoxm/bE/+S
rJ8+/0JRZB+xb8twcm0lBZ1lrzLQto+w+1G5/0wFBafN2Obl1NVP+MXtWGtP
soG3bekluz4i+6NpRUMZBY3NhXUn5vYR42TXF30ppWDjTovrs136iBPvptOd
Syjow1Rc+25THyGOjaS1IwV/Kb0xUbLqI3YG/CjzLCLrcY3bGLC6j0i9oLjL
oJCcX26gxvCiPmJtZPOangIKhhUGe+ouJPur8Pts0CMKilY8iDi1tI841Xz+
OvMhBW+mMyevHuol+Jknfp7MpeDB9wFc4dQ+wm/+Lp+T9ymI6Qcme//rJQbz
/qMpZ1MwQWeVieVIL5EfdH1d6j0Kel/oidr9sZdw1p6d251Bzjdj3qa7o71E
Jktthx7JYyZzL32rJ3lV24KiWxQ83aLtvIQ8r/VS6EvzmxTM/fM7dUJfL6G4
UL1o4w3Sr3qKLabNvcSK18FqDakUXH/6WqRhYy+hJt2h636dgg5W/02Bt71E
GLtitP8q2Z8dy2Qbb/YSFvueNr9KIv1qo6715nEvoXPifxRXdzwVXhu/Za/s
calUJCkrlShOCZUSpYgmKiRSSaVEtIQUSQlF5JedvZ8TWdl7773vdu33vn9+
P885z3nG9xlH8aMvC7cX2Kp6BjIQ8cPWNulw1vtet04khDJQ9pmAXVe+EjDP
YNfKpCwTBT1QGkv8wuJLA0F43WsGEmUPUTIMJWC3pdrsW18Y6NCvuR+IhS/V
611qP8VAURytu5s+EnDYJw+RG24M9J4YaW0XxOLr1/eew54MdOR4mPVyIAEv
0Ry2/HnKQD+iNwaXsrA91+/mxx4MdFnxG39QAAGfvgR4420Gki2Yfq7oR8Ah
UXVp3QYMNPnGMQreEPDI7NbHAhIMpG5tM3uShb1LrzLkLzDQl0/P3S1eETCB
IPxp5DwDcZ3y3kjyIeD89wm7ii0YSGr0vp3vcwKu2x1vt2kHA0U2HkEdXgTc
KOFZyTzMQFX19u5yngQs0/Dp4zOW/oIF931FTwk4IspmQ2AWHblmxmdburP4
scUzTGmMjthiGx45PSbgrW7JeTPirPu+2wfoDwn4U1R6zAkWflHRUR/0gIBT
hHUP/i6jo+sPue3U7hPwV1rT6ywqHYWanXrHfY+AFauTdwWR6Ii5EFBc60LA
usbugnELdPQPdS5suUPAB45E7XnIqp/WwqISJ2dWfZHbtVvn6AifuuErcJuA
Dx/pUW0ZoqPKaMH78bcIuHT985yOOjpSuD5BTXIg4EJhw8C0QDoyrmDbZmJH
wOXOhq9+/qGjHGdVGuk6AVOVv1oL/aKjgs3h0ma2BIx4orUCWP5euCXqG2xD
wMp9EyEN3nS0s0Hnz/5rBJw0emTPZBgd1Urp53deJuBxmXq/ygw6Egn/+Gj9
JZY917b3pLynI9Nr5RaeF1nybOpn+ft0NBF8MlPekoCjr9TWD9nQkcPfFxn/
zAn4PoV9h9IbOprPK/TKOUfA2+MTctPv0JGd/cj9uyy8IOC52cWRjm467m2W
OsviW1fC59JTdLQ40EjFJgT8a+tBeoklHd2+vaLwwJiAr7e55CWcoaNbT8LS
HVi41HMy9NYOOqpf6VQXPcmq98kOuX9b6OheqZdJ4XEC5o8LzuHWo6PTl/8p
2Ruy4q93elJRjY7EfsQ6H2DhbO0n1jH/xzlZMaL6rP5t/9FNTJmOItWm1JuO
EvDfRFmx4/4MNHXgfhccIeCfrzv6rvTQ0KOzwqm3EQEPV24pU5+noYX7Wsrr
WZj8IM/rnwQdqZslHZbWYfWnjne+fKs0dEvS0blCm9UvXpboZPTS0OTUeYuH
B1j59pJpQ4J0RFi5cLNRk8VnI0PLlBkaCiHEdCvsZ+G6ph1/W2jIPt1kY5sG
AZ/i3zXXhmlo6G7U/Gt1Am659mClIp+GghpubfilRsB3Er28z1fT0Gqht7+W
KqteUJ0x9qUhDuXTBVO7Cdg3b5p66irr/MPumEglAn55uPOW7hUamgqkEV/t
ZM2zgCgT22QaEjcI23FWkVWfhdUrbx7RkHmoiQ2nAmt+Cmi27LtHQw4iT/bn
yxGwBBtV+54dDf2+F+bhsI2AjTPmzCve01CCaPMfl60EbEtuvZR/goaeKkyN
KMiy3l/N+bl4nYY2Stjhno0EvOda0pSpEw09H96sYiZDwA6bo72f2tPQ+sOT
e0KkWfZ/4QmYRzSkcCaMy5FIwJzvRC1ty+no+RzvRWMpVr8YUM4iydGQNPKQ
5pRgza+FGPmdB2jotLjNlqNirPri8+d5dJKGDPjL34EoARc3L151ZfkbQ0z+
8liYgJ3ok+Pc+2mocjzuwl5BAk6OJmQwZWko6oP1CS0BAj52255Sr0hD2XV+
SXP8BKz3X8r3+IM0NMMBmQm8rPm3vH+LlQsNaVxTMrPnZvFJ/vnVip00FNGl
GbmPk+XPd7tby9w0lNGz7cd2Fr5pbx/7XYqGvAqjXw+xEfDVRPY9FwRoiL99
dlP0OgLmSE68dKOTinJebH9fvLoGayIXz3URaGg0oMTAhYV7UtmbVUhUdMPz
laHe4hrkKrG2rC4qSjbWliuhr8GzvrZzQnQqeuL89poBeQ1EXNe94QimIqF7
e688J62BttLdGO0mKqqcbCyumF6DpB49cXWgIvdLOi+Mx9dg2+Vhb90CKtpK
OO7QNLQGIdRDzP86qKiz1eBd5OAajHnwmu5Ip6Lg9eZSRX1r8ES45P0gJx2F
/eT/U968BlfP909/C6Iih+GmgeWyNeArFY9xfEBF2hSZbp3cNXDT7b9+5jQV
bej88vVtwhoM8z22sNtPRXvD9vMPRazBu6NDO8kSVPTSdYP0sfdrED/k0/iX
TkHqkYT9xu9Ycqm9I81GNBR42OV3lvcawIHtJTUDFMTLfadL/cEamE/JERKK
KWj7Qa+TOXZrMDQa+DcjlIKcyGp8RlZrYCd7qJ/kQkHryoO5xk6tgUfuD1t2
awq6nzapHIjWwEWg/L78IQoSXSCl3NNdgz0KXAKrgVR01u6no96eNbCo2/5t
nTQFGebfSCZsX4P+L1ski9dRUIwAfahScg2UZgYDnAfI6Plv48UI3jVA6qQb
XGVktNUqpO/pyiq4nNt+Li6VjCp8N3nfJK0CKVq5TuwTGWXH7tSQZeFjBe4d
wZ0UVHKXPmU1xJJnXoosfUBGtka+zZatq6CeO6pqeJyM/GLNDG0rVyEr+rDI
t61k1FJsovawYBWYzy/2u/GSUc5y1POQlFXQzCrpXT9NQnnW011Hf6yCXLtL
tspOCmu/D91ZFL0KEm9uR2W1klDl9xhJcsgq3DQ/XuKQT0JdiTcPqviuwo0j
IySpryQUIBP14sHTVXhY9fFK9mMSmtPWHSq7swqfAvOemjqRUOA1LptttqtA
2E7ev3KMhGROpbM3WazC1rNr78ufkVFDU0L+a/NV4G6+SXCSJ6HOqXNLjBOr
UFssHwrcJERI8xZ20VkFk7lWMl/1HNrzpGOWorYK+xetFbPfzSGOh1tfeMqv
gtnP0/Sj1+aQw2HDYnGpVbgeYX47SWcOiVUOXQSBVdjZEFE2VktCRBfzsEy+
VagKzUjmoc2i/9R8Vq6srcDYt3M/IxJnkUazbI8wdQW0p2Nw2pNZJFIVoF87
ugLHfA0U7U7NojqGGzm4cwX+jTKOlOyYRX/ng+ZsaldAstjF98bUDNqsciVp
+e8K6Fob/PdHgoT2Z+WqHSxegW3JuFghegalGwz93Ji1Ao+d/J1dbWbQkM8O
fa74FUjjeXm0d98MqskpXFyMWIFxvV8Tzxem0eMDywXzH1Zg08NHqWWV02iB
44LHyssVWOmXWlr/YRo10+LWe3qsQLj5f6oWzbOo/uF1FX73Fejx3kGZvzCN
9nxa7ZJzXgHVVe/lSMFpxKblZ6hvswKjZS2LqrVT6JPoPncn8xXYc/X8juzg
KSRpynHrm9EKBK2IrXldmUJfMrfydOquQJjdelL1gSkkukvK7qDmCljuz9UL
8p5B285VG23SWIGujRdbYtZNoSF1220OO1ZA5Y+PnGbbJIpbuOpTKLMCXy/2
vjD9Pomux1tYSwutQAKct2qzn0TzxxZTPNlXwJ9wMMmbOIkMPd48mWEug59t
jIrs0gTSenBbeAdlGbr5JHP790+jM6SJV7Yzy2D9LOxyO55Ax9/G9g4MLAM/
X0/508AJlHi12c2+dRlUiwxfaNlMoBGBX0fn/y1D2i5e3l/aE+j2vTta72AZ
SobfBR9YGEdMG/9TyhnLUNbkqfktfxyZn/+17UDyMjz0svs1RJ9EsTc97jb/
twymBu8DQ+6Po00u7eE+EcuwJaKq181iHKV9PlmiHbQMmUfDtwkfHEcO3eEd
C6+WIZDXPvj42BgqO207jZ8sw470tGyjpDE0dlPoT6DLMoi5fLv9+MkYmqzS
bL/uyLI/xfbjucwJtO6S+/WbN5Zh+4+q7r5TYyhJ9m+VvtUymKuFvO3YNIZ2
Ht4xrWSyDOVoi8qhzlFU8ouaJ6XP8s9GitGVPoqkHAKVN2gtA4m5mTj2dhTt
dnbT4lNZBvmUL5Th66No18WvBjE7l0Egy63M6vE4MjPVbhaUWwa2uw4Tcaqj
aEzEmyojtQwbvEI2WPGNIreorTGqAsvg8zBzjDd3BFlxJSQZrV+GnhzpTbce
jaCVlF2bnOaXYDh5LN7uzAiyFIgc/zS9BEd4Fm6sSo+gXSkW72bGl4BtTNXT
QWcMfegX4qwYWAIx2wMxq43D6BBbnCOhbQmKbeKnr/8aRpfVQwUPVy/BeBdx
X4zfMCI27xp/9WcJPrpudPlqNIzEaoqnmrOWYCtzNi1XYhgF6NUIKSUuwRVC
toZixxBaz4wJO/BrCXR261wU5h5FCmXG119FLcGdebv9zglDKK+pLmXi0xL8
V/BfdaP/EPL2fks4578EDzfQqxpshtCqkLZx6fMlePsFxaqoDqEA7iR/nYdL
sK8o8mrF9CC6KfA3s+D2EmR+vrbS8HsQ/eJ4dMHj1hKkmDqfsmwdRoopd0HP
ZgmeHt5w/ffbQdZ/Lu97ncUSnLVplBF+Moiy36Sb2hovwc2acMkJ+UHk2fqi
bEVvCbL/c+MkLwwguzNmgt8OLMEtqYu1HxoH0J9KL4ahyhII7wg+ciJuAJnd
tXbM2L0EDy7Kygr8GEI33tr40uVY95ecFDbdGUApH20hnrgEriWbF1cPDiCR
O2uBNwWXYKfRYcrLTQOoavEPRZFjCWJC20ZuDfSjLUbH+siLi/A21bPsfUY/
2vrwoPEf0iLE/XtUoP25Hzm/V3RtnVuEMUtuHke3QTTmbrU3dHQRQroTZRwv
9aOrHC7+97sXQatj7HzRpn709ryFsXnjIhy+1EVLq+pDvdMmL1DFIlRU1wk3
afQh9dDwVZWiRThgKFWkONSL3H/9VymfsQjpjb1//5n3oqwqtoLu9EUQPdgo
0HhyABnK+PdsiV+E76sWjYZbehFOd9oj930R7pIkdjr+60Glw95416dFeCi2
MVjwbQ9y/Snope2/CJ2no3j1FXqQktlNBxPvRWjof0+aG+9GYx3HvfGjRUi4
xyAtbO9HEz5jrrdYuCYo44O2Vzc6MLPuq5/zIihsvakiqNqNRJlsE2nXF8Gz
Vb46pqcLhU+XK/dbLcJrxl8PFcMulBv01030zCLkRRztud/SidIzvxWcOrYI
TA6n6vOmneiCqvKPJ7qLYHjZms9sfS+qDeJn+uksgq3QdsUekU70Lqdqa4MG
yx4+q2dnYzuQ82j8no1KrHjS5PwoWh1oYvqFnNOWReCOP2C9h78DUQKOzJRI
LMIK1ffh1Z/tqOhyy5stAovA/7wtfb12O9Ke3jjFxbEIgt8SNzhWdKHem5/Y
fNgWod5CsnovbkO7m7qVpxYWIOYO/XhNeBsKo8mJW5IWoHKrvYm6ShtKfxiU
Vj26AB8HTk2Vi7ehQv2LawY9CzCjs++jW2wrirYppP1tWoD+h/vcqdta0VGS
eu7V6gVgtyAt+r/rQAc72fxP/FuApZXl0OM5LWjky8uiJszSd1Lt/rXrLcjV
MvalbfYCVDR2VF/b2YKcnzV0MpMWgPRIpYtrshnlv7CuCo5ZgE6l48c/OTcj
NQ2xnXu/LgDH9dMJOoeaUa1rnYXHxwXorZqN6TVpQ3mvbNd1fliAjNQThW/+
NCEH/ynjl28WwE3QEI1cakKLj8y493sugMm73HxnaERD74yVph8swOm268lj
TxpRCXtoUtztBSAWyb7ca9KIOKfn/extF4AeFv88jdCITM1Wwi5eXoBrM0FL
y/ItaEjyKKhYLcC7ErHI6DcNKITd/Mii6QK4XjS4YOPWgGIuvpCtOrYAYrMB
JcK8Dejuqd7dUboLYCTh3q+YVI+0vdvcnu5bgPkTeoOV5+uR+q6H85d2L8B/
gZqLzznq0eMekg5dYQHsjJo4wpiNaPhn7X96cgsQWN9RcFK/DoneWXihLL0A
QY+5OANe1aIawqZXm4QXQNE1oOze6xpUU2r/U4R7AVTOprGVn6xBG1fF+/nX
mHBvV/9IsGE1Gv5lp8zPYIJ+nN7UuEMVGnn+yMOAzIS9aX70yJ569PF+/Buh
GSZcPuo+lkv6hzgSFdeIw0wIXjp9pVTjH3K/YHJDsYsJ5y4eFnd0q0Rc515V
HGxkAuXUbhkjUgWqkjksd66SCQb69jrcmyvRfifmnbuYCV85mVLDI+VI6Ymc
+7ECJmzIHr379nkNeqa+91dwNhPOmm9n7pAoR5cdnlfmJTOhTeGtl7tOGVqT
elg1GsuEK4pvNmVYliKFvZm/JCOYED4ydu+ydCl683b4ivFHJviJX9oxYfcX
7V7SY772Y4J4bN27FdcSZHBxvJbxmgkyL2O+sRtXorNy9ifLvZmgsmpkNxpS
jGztkm7wuTNhp5qLeNeFYvTNsPfIubtMGFl6dUVb/w+SL6ztjLJnwgfN1tVv
ZRi9Vr+4i3aVFQ89+j7X8xiF2tirnLRgguzRz/RjfICKxmPmT59jwlObdU2d
cqXowvmh3p+nmcCuFDu2KFCEdh/9o8llyIQ7D6xatrwvQLvfrGnc1mHCMYqp
OBs5HzncrO5v2csE3ej7hzql8tCTyQ4x/d1MuDX+dUmWLQfNcbr0ZMkxYYx2
PFVPOhsdOas4fHIrE/LGpiOFuP6gZnrCPhUZJoBJpJBhWSayK0qTihdhwo6b
Fm/zIzKQj/zv50q8TPitROw7E56OtD93OaasY4J/xstrP7+modDtzo0HFuZh
ZfeFBzVWqejd9cTUMtI8VN+8vZfdIhnRD1fZTMzOQ/9ictHTkVzWvjGwznJ8
HkxEt8VdlktEwUo7m+b65uG2VbQgz6Z4dNTgyPLbtnlIIi6lkUJjUUzW5bdK
dfPQc8jN/V1lNOofHX1UWzYPLRJNlPGj0YjP6VSJW9E8OG8yNjldEIlqIthT
5QrnIb//C8fHlt9IhcBxQy5rHrZvX1A0HApF7vbvLJuT5mFjp656/N8g9NPF
Kdw3dh7g6gU93bDXyKFNeefRiHkoGn5UIrLpFdp2xGaJEDIPpR4xt+9ueIqi
dsZsKPGfh0tdIq+WS21BKrVvmOE3DxvE9W8FPv+BYhqYd3xfzMPrm02yzJ32
cOnCXqbZ03kIQHsOZx7zAfGL9zK2uc6D3uuunaNqQcCvaPed7jgPHzLNw5qF
Q4HwvSa72nYexC63FQc/CoVyRTtG3MV52HJ46LxRYQRUex/2ucrC1+VDsi1z
nyDi9yWL12bzsFmmUiDtXBQ4nrZsv3VyHgRrVRVtd8XCfMe5+2ePzkPYC55f
D5z/gy6tSnndg/Pw5dOD3iXNeEgSjl1Q1piHVoWjq4t5iaC7tH7cctc8/MsO
0hoM+wwq9xKrtrLwbHeoldmxZMhaGowjys1D8ieh63wmqTB469BbcZl5KExT
umvk9RtK36U5i4vOw2pLuljZrnSoP2Rwhsg3DyrDdY+KtDKgTn9ReSvbPFgs
BUx4h2XAR01UMrjEAL9S7cz8kgRgv9FDUGZhzmftekf/ZoKtLqHsEJUBO95s
/Wj1PQcmjrs/Np1iQMcmG/4551yYWNmqaD/EgL8/CndHLOTB3exviT5dDLid
rLnE8ykf3vzqEf3RxAC5BbtfszaFEHxlbYBRzYDmjZ4fz3plwsw+XquyKgYM
OgnZBhsUQfklyyczJQwY7dhhoKNQBHG/2V2lChhw18P2sg0fhu+mJw8fy2DA
iGvF+aoJDB5Nd7sfJzJAfsvv9vfWf0DoWLF+agwDtqR/JdtbFUOuf/hSUCQD
xO93YbP5AojY4v9gMpz13uYxo8nsYnhw0/+JYggDDidZ9q17VQKXJvX33Apg
QNUvVVW5nhKYNnj5M+UlA3IUtK0dXf/CfsW0ZqYHA54ULvWtVyqFEw/25Rq4
MYDtWJxnkG8ZbOKW2p7hwoBz+ILpIeNi2HnomeknZwY8lth15f2vMphOJIRO
3mTA3q0Jrl88y2Fkw35fvasMKLxiyJFALYfZrHC5SAsGnKeZKO81rwBYybZZ
MWHAYnVcF1d3BYg4KJldO86Af1eL4vUTK6Hoy8eTFkcZkHUicfiwShlc1zBo
KDvMgGHS10odnn+w52bBhJoWAyJ9O0KXLP/BRr4dXyLVGUBjCNq+Eq8CR43t
1YJKDBiv2VEgw1MNnWSjlBfbWP639z14ZFkNN4U1ZVekGXCl7U53zFI1RDvz
ZT2WYIDD0hVdEfZ/ULOvkvlIlAHuM11vnKJqIMHm3CMmHwM2rrv5/lxALTT/
5bj4hJ0BV4muJhoadaArvtq9boUOzLRy6XsrdSAtkpLvR6eDqkevvtPeerB0
49IgztKBvv5r4pWj9cD+qdlbapIObPafEj5m1EAboZAQP0oH0FLfzPa5Ht7k
+V/T7aPDaNsrA/fxehBrviPU2kaHvcoKt65fb4CROfLJu/V0aHtzanz1VQPQ
NF+TBCvpYGwtwU4nNIIyfaDr9x86+HpfMPRSb4SaSV5J9SI6cI/NT1km1UPI
If0TFnl0ONp+ZDeHdyNEPDCeX0ujQ8RTC3eJkEYY4BbcmphAh42Tka+PRTTC
7QmHlxdj6JAhKVgRZ9sEAxvR1Q0RdNhuK0hKedMErWGpTn9D6OB0ey1qmrsZ
Nv/VWcZBdEhI27GW7tnI2oPvTHm8o8PzU8+ftqo0w0GLT1nar+mw4/3y7ozw
ZlhufZq06EmHypK4VZn6ZlCV9uctekQHU48D5uEbWsD26quAF3fpoPm7d0lm
fwtY+se6nL5Fh9fWP4kXPrZA8toG11I7Oigf2bLprXEzmEpN3ZexpYNgptzf
60MtkFhp3TB1kQ5XXUK25kq2wqv6EyfgHB3yBXccdfRvhdPSnuKfjOngqNPp
IDbVCr+FvRh3DOnwttFUJJS3DdYLL243RnSoDW3nDJdtA7c9O9QP6dDhpWz5
VKNUK7QEV3krH6DDHM77dNCBJU/inxZSZ+Xz3Kz8i+Y2+HB5+9f5nXQIObgx
4pl1O9z2Vj4zsI0Ond1xTV9r22Fk79VjtTIs+yJ+SMWXtkNU3wZUJEaH+7Kh
s436HWBJU+7cJkqHtHt/D1wYbYNk5vG7vwVY/Pis/erOyQ6wX4v4FsdJB7O5
Y4f+e90Br3ln1ket0eC16JPo/LUOkPyT5B7BpMH7n37WOQ87oeR54Gg4mQY7
zffa56R0QnuDsue3SRp8uJEjuT6kE3woGQYPJ2jAT2CbSi/vgFHrJM7YIRpo
kb2DsxidYLb6NDOpmwZ+pob/mv/rAr/mJePcFhpQKTpMu6AuyNK6zV1RSwNk
2V1UlNoF0Tft4jrKaSBUFxKqZ9UNN93ZbGcxDWzuOGsOunaDWytpvSYLd7G3
ft/3rgvWjouucuTRwE3/p8CmpG6QW/ZK3ZJOg6X9n6p3Qjfw1D600k2kwWxJ
XLONVg9cf3mh+0osDbz7tshe+dYDGs1VTt6RNFB33q3zb7kHalL2NP4XSoPE
9dlPUrR7Ier6Mb5rLFxbGzZvo98D5q68Rxrf0yD+g/tm6Ye9kK8x7bHqS4Nh
aTXV9Lhe2K+hhJV9aMDpqr1mMdsLZftDqq4+pYEG0emyo3cf7E841/bxAQ3O
fW6seZHYBzornkYkZxqcbmoUu8LRB0ciXOKqWfjHOn3BHy19oNc3co/LnhWP
L+998Y5+ULvmJ21gTQM+6aVYnbP98Pm9o+dLKxoM+CqFXj7TD29rj7ZXmNGg
wHsjvmLfD5ahMRMbjGlw93zFImdCPxSM3mwfMaTB57uR3j7X+uHDsa2TFiz8
aZGrglDbD906XpE/EA0ai6V73i72wxfhXTqUAzRwSP1DPLxjAOIjN/kd3UOD
aKNQ+ZdaA7CTGloUuosGv5tmfg1cG4Cs5fmcWXka8NrZu6lGD8A26+OvdGVp
cO3tfkqM7gBMf6y5eHwzDXZEtSkyUwbAbUq6J0aSBvvr+U7pwgDsHb26nl2Y
BlM3anqmewbgBDxYd5OXBqc+WyhxiQ7Cgo/Q939sNNC8fFb61q5BUE3vF92z
QoVbTYcO96JBmOGN82XOU6HX3S3UU3wQzmyr3RbOoELeXe9sjruDQK69tp6H
RIVpi4pE+c+DcIGZ/ujRBBWGZiUw279BUD63I39ykAoVz8S2f60ahDzP7ISr
3VTQ/nHC7Uv7IFQof9jd1sLSf2LAKZRrCGg++3lEGqhQss9o/hV1ENaLtt87
U0eF0HkkqKk1BN+tFQxqK6ggkLhzycNkCATFHrUbF1PBiJfrEo/bEAS8+EKt
y6dCVHIDV0zwEOzfdbXqXCYVyvweZgoMs+Rq5QrdyVSY0M/6IL80BD+qrpzz
jafC9Vi76E/VQ9D755n2zf+ooCS+EPxBcBi2e2TWUKKocOPyZ+2/B4eB/IQs
5v2VCqqNfPnZ24ahx6ecIhpCBaY22wv/M8Ngm7544r93VBi+Wlpz+f4wEGZa
T6M3VEgKPb3kHs6SWxAfXHpBhZ+RB7xIccPQQueobH9OhV9vHEZVx4fhpXzS
tOsTKhxcTdqUOzoMmi9+Phd9QAU+9U0jv9ePwEVxcn6GMxVGhzYc41UfgXvN
n2wv2FNB40jXcJXRCNC/uySuWlPBuuupb6v7CBRomDT7XqHCs3upNVe8RiBg
l9/juItUqH91hhGcOgLdcluSz56nglaQHcOufQR4v9Z5EEyoUC5SF7+rewQU
l4m/U49T4Z3U9YHjW0ehOO/xE1s9KnxT7PCX2jsKLcKRsVKHqBDffenhf7qj
cBDpVAlqUeHRfn1R/zOjoMrXbVO/jwohg+2ySzdGgXRN+OlbVSrYyXsoK/iO
QvSok/yxnSy+DZYwJuJHIejlijynHBW+pxse3lYxCjIbqlLLN1LhjICp5GTj
KAg9dUnwk6CCqcD6VMvNY6AqsNw+LUqFI693gv+WMZjSTGeeEaJCt9nTZx/F
x8Bq+maVNC8VLvEeCTfWGIN133lmRtiokD3TFPbLdQxuPzJ6n75CgSgP11zj
72Mw/6X5mc88Bfx279sjlzcGTa17ps6TKaDrc1bJuWgMXDVvHZCdo4BcqkRr
LWUMcuV1vilNUWB/3eYLfjNjMKJhVbNuhAK2Dg/5mk+Ow/oXwZZdvRTI/WD7
2l5vHHrLNypmt7Pkvn9aDrweB2hXcAxppED0JiHPi1/Gwd+ZOf2gmgJXnlbP
x2eOw8zvmGex/yjQcctuo3vFOHjkRfZdKKNAzxsV88jqcQg+7C+giykwpKrS
Es45AcS8+P+251Fg5piZ3zqJCVBX+fxEMIMCX1oVZYq0JoCwQSZnKYkCNnFB
2t/1J+Dl12XFyTgKiLsXTzy7OgEeNzzVnv1kyRXT7R6FToCqav9aZxQF1hLC
XH64T4Bm19mttV8pEDy13+nX9wlIf8h7rySEAv+cFV6eKJoAYyE3ufxACthL
DTMFJifgXXElIdOXFV/u75unqBPgyjhz8LcPBcaxaRgn+yQo9e1hxHlTwPwI
2zutG5OwQcApMsWDAs1BP4QaFSZhnKl/MfUhBfT/GfK2206CB9FGJ/0uBUze
eQb8FzUJZcTqBzmOFLCy76t0z56E/aL76uEGBRhfV6cn8yah5JO3R+VVCnC2
G5QkVkxC7C/ufVtZ+OukgcW7A1Nw5wq2abGkwJZE2/a67knQC9x6Y8iMAha2
zwWuyU3BwtiFTKoxBQzVSgdkzaYgIcFTlvM4Bc5Ghy4W+U7BszmFZmk9CshQ
34W7xUyBTNn7b+qHWHzwcG9Wa56CSxPn/hs/SAH5R5szOPmm4UH57jSj/RSI
e1j6/mLdFOh/vNF+Q40CO4vOXMTDU2B531fPR4kCZy58bn/ZOAX3j3O3Rsuz
8q/g1FW4NgV2Zo8e/d1MgYebLjTEi04Df3L24rIUBUT6pHgKOqZZ+zfDcpyF
1aobPgS6TUNog+mxDaIUaDmjWj4WMg3V4z4u+wUooPO3gn8+YJq1h72KvsZF
gUbezZoVOdMwdmyPQMA6Cigp6Nc+GJqGxk8/PfKXyDAu7664bpH1XtMG5iUG
GcK75NDG2Bk4dSdCbppOBrU/Ie/rt8zAI65L1ZtJZHgTFt38UWcGap2explN
kmFP5JUze2/MgPHscNjbYTLUv5N4/dxzBmJo3/1LeslwNSNqxfbhDPw8Jp24
2k6GrfryjZt/z8C/01FKXM1k2JT0tiD/wSz84J0vO9hEhvebu0W1W2bgP+7n
/E9qWPYQ9FYVBmfAH78wKignwwehb2/2n56FfqXdqWt/yJAS6DfJMJ6FG6MO
fAYFZOBIud5512oWNPSO+/lnkcF/UGiY8nwWaBrzzou/WfZNpmhxHJ6DN0Z8
Eq2pZAg7dMe3028WqjVkgrYmkGGM7+XO/5pmQVfGTOVOLBnwqnum++gs8Myy
5RZ9I0OuoLjTENscqL6cuCYURgZ+IVN7q/lZuLXVnWb7kQyUw/WHjY7NwY89
39/ve0+G7+yzOY7sJHjqeTY69x0ZJB+YltHV5+DpooCWsC8Zts2Ob6TdZp23
Uhq75UMG37uG45P+c5DTbfekzIMMkyHZJqMBc9D5ZLu8/CMyrMbMEB7VzMH1
AxIVPvfIkFD5nLuSkwRf77x0z3Ymg58F+HI5kMCaKHR65DYZKntfttrzkCBH
VX/4uB0Z7E9n0bsESJA5X2OZbE0GweMlBz12keCZBO4Wv0SG0/2NVcxDJMjb
YXXI05wMS/XR98ZPkcDQ7/3PSVMyRMRvcdpylQSJSRZtz4zJsECNnjWqIUFR
admkxUkydA0fr3h8lwTjkk37yw1Y8f+w85XcaxLY5R6yOnCYDPe1iY9PBpBY
/8d87wRtMnBrK+8ufkWCVxPOoVv2kYER5lhNDyHB7fwQz1BVMhi1Tf98+4sE
dN6w7293k+Gyfnx3tRoZxAgF9kJKLPvMzlxk5pCgyeDPNj95Mrh0B92qwSRI
8RXt4pIlQ4/FDfOqBhIInsu0fkUkg4ETKTBugARPds0PcYqx4s+v30ZZJkHU
lVV13w1k4D1Uaq07SwId+d9FHXxkOLazojwuhAwntq0+EuAhw798a/5sETKQ
why+B7ORQXckOr3oIBm8uFoCZVZJICDhMe5iQoZPo8dcY5kkkNl4R27eiAx1
n3Q2q1NJwDkirrX4/7x8+55XNEMCzUwdzu3XyBBjlKzpOEWCfU4NbsnzrLy6
bpA+PU6C3g1MuqcnGeiV5xz6BkngPVC9S4mVd3/6nsf3ekgQfuIXzfEzy+9l
1o+4nSU/mPPgHovnUyPx6pGNJHiprZQVWEiGdqW8tv2sPB3ZKpnzo4V1/ta/
Rp0qErhEn+U3s6BAadJV04ZyEhyODNO82EeG3c7BPk7FJNiY8uWsXycr7+cg
gq+QBLU7Xwv+JZPhc62kS0I2CTK+cf8Q4KDAWOCkgnEaCeolcl8mClKAbUNA
MCmRBLlnUjie7Wb1JVlStGkCCb4bRsVG5VDg8aTaYEgcCQKkWofNlFlz4P6p
4UPRJDin7udfu4cCS5b00pFwEgyPlY4Ys/pqxBOzO+9DSXDXgOL+4iQFFPiS
Kw4FkWCoQa7u4GUWFiGvTPqzcGxqhW0wBdrJ3b+i/Uiw+sdBcFmKCikqw/1h
LB5iqG7a/4XC+jdZRJzyJsG2Yt8u8fcU6CvT4CB4kEBKC5jrvrH6OK+yfuZD
Emx/ET47/5sCdQ9O7r59jwQ+wut9trHm9LUYxQl5JxKoTX84AT0USN66c27P
bRK8JkmHcz6jwvFT06f67EhwpkT+ii5rbxBuFPP5asOqi80mBR6sPSSDqehq
eZkEP7vUFG+z9o6iuRpu4gUS7Hg3jt+vo8KGV5a3O8+y8qfuevkPNxV4TPXu
RhiTwNcrt9pHmArVCXqfCCwc2MdOH2Pt3YFD91/yqrB4rCw6WXKEBmZiKlMm
giTgt3S78Cqa9S/Y87jy28AcrN00ub2FQIeW8FEz0dg50LoowPX9Kh0WL2U4
Me3ngFera3QvpsNUhGSYsfIcENBJEW5ZBqxnk9cWpszCi+2DfVu8GGDMFjtw
JHsWfMu9hvb0MiD6oEtKz9NZWJqxFGBH85CvWXB8SI/Vlxc5friGz8MrlR61
MzyzQJLZwnN5dR6E1IpkFOpn4EZL5PbRS0x4dmfU6FroDPT1q2z0y2ICI6Tx
+eqVGVirSD3XKbEAbjq3bdYUZiBHtlIy9N4CyPgdLbSem4bJ5sEs3qoF+GLB
QZVjzTnSN97OcfVFiLipOaj/fBpWVAPdOz8vggdzx/ESo2mQ3fdppI+xCOaz
HIKRYtPAK3/dqsR0CRTF/dKbeqdgUljr6/uUJfCRdN1t+2sK3kHsnx38yxAz
Fm9y0nUK+mfGLA0dl0HwpOVmPzQFEQJjX0prluGveaDKVr4pMJeRoxbsXoHz
ypX+/G2TQGr8fbPy5QqcapfZfurHJHT//OcRMLwCjA2XBPruTIL4497Ud3qr
IKYTQCk5NAlbjPTfKH1dBQeOP7QFnkmIvrBbY+fiKhxzExHzapuAm1nTSuEW
a3CWY+HR+dgJyGnskj+ftgbrzE1HHt2fgLgofRFbbgK2o7W9nTgyAXTB2Yft
+wg4P7P6yU+hCRBdbPqrbkfA6/Y+Iyf3jQP7SXPRgU8E7M5egteljIPe+dZ1
E6UEfHuz1a7IZ+PgfDjwrM48AX/Op5v5nB6Hdrms9eyK6/AJCUWf1M3j4HWF
GWhjsQ5LjEh/k58bA/N+BVPZV+uwooUgsxfG4OidMUJj+jpsR0+F3vdjoHXZ
fvjbwDpsdlRjl5zNGPSjj6fYRNZjWpfhxwTWHr+nzPNBo956/PFeCs2NYwxO
NfyNbHZZjwedFxJftI0Cu5rRu+mI9bi5PnWt6dcoyJXpXtxUux5zbW47e/3p
KGxtjjQ7ubIemwnfSt5rMgqBub4Oo7vYcOKJtGf620bhE//F5gOX2DAbxVkk
mD4CgpbDlcOv2XB975F82coR2Im6nkE2G574+q1mInwEenrvNdVOsGFm2Ik+
kssIWM75luVJseNk/pJqDYMR8IlZGy0wYMfdnB7qacQRmOUakU28z46PtHy7
7Tg7DGmJSmPPYtlx8Fh335WSYShsrArjbGbHX3Wt5/w+D8OaphN2Z+PAiRoV
6yhOw3D1gtq8iBoH/h26wev90WGQ0jvjy7jKgfOsngnbEYchQr214coHDuwo
fT/BdW4I/Is7iTOYA3915VvMKR2CYB1d004yB2YrM7mjET4Evp92+pBlOTG3
vrPn0L0hSFO+r+d1mhO/paZ8rzgxBH85V03kPDmx5qjTycEtQxC4tsd7KJkT
nyrgXFRlDgLpxstZl25OzL/ibPO7bhBE+nO/3ObnwmNOroE34gbhg8mjED0d
Ltz6WfngKc9BSHNwiuF24cLi7glj1y0GIXGcVV5RXJg22CSVojoInSrfWthq
ufCQ04VzStyDsPVGvAVe5ML88UlbW/sHQMvwd4jhTm689HQ9b1ruAJQl3edk
u8KN38dG1xUGDYCq+iWRwnfcOKBlLZDpOACi2kp/HhdyY79ampCNwQB0r8uw
OkHixonfjw0ubB4AjpWHx/k38uA7701DgNkPCW2Tj9RMeXBCBKUgrbEfWjb4
2Z3y4sGV+z/ONCb2g/Px/TMTqTx4UUKqUPZ1P6j+Lk6+28uD67y0mZ+t+2H0
i4mSBA8vFn2QX61zqB80OByoarq8mNWueTdI9rPmjfXvY8682JCZ+0VkuA8M
Y4pzz8fw4scWJOsrYX1A+Fa//WojL7Zct/Rr1bQPtlc9T1pYz4dpHxipFK4+
KPAKlnqqwYcFVD7kaEEvKD7StnG8yYezhlbZm9x64W2l4VuOMD4s8t+zo0Uq
vZA+GvzzaikfbuP6Orcw2gMD1ZGXSub5sFlGZ/7Lbz1glPzPvmAHP2YoSDOu
XeiBw0a2Ewet+HGS5cvZt8I9YPW62FQqkB/bhwbMr6/qht+e8dqdhfzY50Xf
jYoX3cDPSKmrIvPj2MuW7zt1u2GtZzWGtEMAb2NIaGgtdAH1ucbKhLkAXi8Z
NziY3gVqNcknhF4L4MbO0qttzl1QcNq5Pi9XALva5PFIKHXBgXeEhvfDAnjD
j7ojkSOdkBveeUFDegPuqzvpeCeqExIe2BskGG/AIWS7qTeXO0Fe9moyh88G
LBt/bOcksRN6FDM6/PM2YD+zspmg1g44uWQj4za7AStsyxp6HtwBb96vGiRu
EcS0Vfb2LNMOyD9gmSRkLohnRtW11Dd0QPS4dSLJVxAb53g+JFW1Q9mvFhmH
TEG8NDnDTvNthwhbBcOuYUGs76x+/uDxdjD6D93xERTCmxKSeko520FdQ004
QkEIy9pq3gsubYNRldvh5kgIJ2/ybYh+0QYCXadd2S2E8Bc/4Sbq0Tb4RbQ/
8ey+ENaujqe8ZGsDS/afHchPCF/0LUi6UNIKVjyqru4JQri3eJ+Po08r9C3V
s+0oEsIncl9RC4+2gpcMu2tfqxB2YIR5mbC3goZRzMYTM0JYLfsP15bSFjAN
1X3gzy2M/7R/slR51QLVXS9jgrYI4/Mm4ebux1pgycF8dZeWMI60vvuKjacF
JI0kt7iYCWP3h2L3Kv81w7j67/yVh8LYo7LnR5V/MyxLdhaNBwjjLUrucTwm
zcBxWzs0O1oYc4+P8PgIN0PcnduqUnnCuKLCzlKzuQlMtmS5O7UK47OvHj5V
CG0C2/5/FmcZwtixOee8iVUTsHdm3/0lKoL37Lpf+3tTE/zne/PRn20ieLB6
9LHxQCM4Xbe8F6wtgvUzX01vjW2EtFa2aBsLEey4kZav4tAIXZt90gVcRLDN
hsVn95UbISuFOL7phQi2kvStmSM3QDSykDSLEsEmZ2RCfmQ1gNTffRxG+SJY
T+tPWcCTBvjVkHwm5J8Ifmz6+Gzy4Qa4JqY7lDghgt/e/N7MztkAhdYNapqc
ovjkqZjJ91X1wL3Iu1VHRhRzU9b2nP1QD1zdgzbtB0Sxfqim8XGLerCZSla/
cU4U5/K1dNzbVA+vOawDXB1E8Z3Yzs8/yuvgnFSPFJeXKL73+pJhxbk6KE/6
XDb6QxTr5vbFmQ3WQlCqMnm0QBR/5LjEaeBSCy/LNYl7mkRxVU1q4tfVGvCI
mhzsnBbF5JORY+YBNZD5gHj1xoIo/kop4nDbWAMPhSldIeJiuH3Cy4KZUA1q
+7kEO/eKYZP4rNqeg9VQJP3Z/+wpMYzDf3nKV1cB5eC5PQL2YphP7PC16ktV
YJVYHFr0RAw3bmaWN8/8A4b/mMRuPzGMgtiFdDz/wenDA0k9sWI4eOexYHbh
f9C33aOPJ08Mk4qMkpV+VEK4wusfbwfFcEe4DiTvq4TIgB+ToTNiuNRM/8/7
igpwrbAUuCgmjlXL3vXWXqyAQ7Gz4myS4ljoMVncYa4ciOjDou8ecXzJm1x1
xaec9alIYfqZiON06/CbKZLloNQkmk+7II53dnsbWyWWwVE7kZ/Pnorj4Jn0
iStHymCYMh7mGSyOW2uzYwtaS+GIRVTjn0xxzNDoeXH/dimkjZUYhvwVx5VD
zqXP15fCO5EbmecqxPHTQlHnsc9/wduVuNlmUhwPFnPP/VD9C808ErVK3BI4
2Gs6N6usBJYOfTkYLyuBrd/mHZG9UgJbk6vO+26TwKq85Yvd9GJw+H5Gxx1J
4IpreVZzAcVQ3C55+dhFCeza7t9+XqEYvCT7iM+vsPS5+3kKwR9Ief7bY9MD
Cczplxu96cIf+JCFxxfeSWDtmhumHmQMAdhrQ2+MBHb2jGRX9cNAO7nrUkOW
BBbWTzq0ZzuGrQ8avkuVSGCbOwqz/J4Ap47c2/C0RQK37Oa1M88ogqHz+1bK
miSw0EDtCJoshAT9m5nWUxK4/fadgMothZBxZHxEllcSv9n0bzvJogDqTNUY
d9Uksf0Z87b0wHxwCO7UlTssiVXVRZJEK/KAI/w/X2FNSfz0jGbGhnV5cErn
kEHdIUlsWK6x/EM7F3JHulTC7SQxj8WPT42uObA+epVS/VwSaxYdD/2Skg0h
fFzu//lIYtlUwu6FySwo9HQUNgySxG9bVw/OKmSBTlPAJVKiJOZ+Lb/4yDYT
ZGd129cKJTFVO9D78/cM0OgqwiVNkviGsS31ZG86rCutNzhVI4k/tJfeDtqY
Di8LMwsfD0nik/GtQo4X06Dj3lrCmTlJrGcSz9YS9hvYkwL3nuaQwre0U5/W
d6YCLRS2K7CwZIaal5VMKvg8dU19LC6FdWVufRzNSQZwdtOnckvhmakW/r2H
kuCXQH6c2w4prJCZ+vcrToCzRxKa1E5IYcZIgvRGw3iIpi9NkA5L4T4seje9
+j9oVW2gfTouhdOL/ypfOxcHLxJ9Dp+wkcJNfg/rt/XEwnf9w1mL16Uwz962
UPrNGMivlLy+0UAKc5oL83eQo0FDvJOt47YUPmve/b3KIwoqlCOCU19K4ZeC
p2qqeL/D7hfuJ9i+S+EatfeSqeoRoPY1uPAhS25qxZ7RYxIGGmhcA0JY+t06
7m5yCYVHFv+IflFS2FfG1vJ20Eew1TRuuf5TCpMfq/pVZX2ADfR9N7NBCntP
Kk9dzQuAjc8XwzdgKVzruuPDPr43oNJgJGhaKMXa91aMRK55g97XBtkdJaz4
qW+q67/7GOSvtfofrZDCXeRFzp0Wt+HyD11FNYoUvpT2kyPG4Rh8pjxVFpmU
wjJdxTmuQdeQeIGb5K8WKewlRRYeengfzds+aHVjSuHUHWG+OPIZEt4edNqf
dX7ToQ/Vs70vUOaBpoNx64j4YM6QZ/Sttyjtc5HXzJgUpu7QTfeiBKKstENm
NStSWGqS58Kx/CAkz8O8cmU9Ec8THnXaPwlBio6zuuvnpHDgbKV7nNZn9KWG
yvaWdf7nqm8NByMMFRtzskdvImIoXrR+lRqBNlmu5LARifhYjshAyN7vqORe
3OXX7ETcwOWqtRwYhSpM7n9fz9I/OLP92/3JaCTm/cDEbzcRHyA3cHHoxyDz
WopprQ4RRzi31SeFx6LeyMdX/tMi4snNH/fcof1EfHu8fd/KEXHGPoqN0cn/
kIu0zNmFLUT8b8Y55HDUL/R7aBZ+yBBx69qWpbOMeFTBGbVwWYKIP7JBsbdR
ItLxqvMOViXi9vxYqYaIJFRNPs4vg1j2GfcqIFIy+vW9rHfzNpZ96kG8Y1tS
Ea8DBy2C9V79JrcXqDIVxTgmFN9n3e8wzQjaefc3Gmnlmv+mScQjjhWlsVJp
KKlW6Vgly54Pe0WTMiAN3aPbO9gpEHHMg55W85vpqFBf+N1zIyLm0JtmvOXP
QCXduxWqThNxgJGL8fm0DAQvlYf7dhEx70L72wyLTGRyN0+1neV/88FdWr+W
M9HMfjt3hZNEfKvPekAjKgtdy/GI4TlBxNQDLnznDbLR8OdXDTrKRKxZoa8r
MJGNXJZrnHhZ7+1rqFq75J+DTNTPF2WqEfHdGXKzvmouukv876fTZiKWDfl5
pLQhFzGq7c+Lsu7rfe+t6L2fh3zO5ZQRdIl4HD5NfxDPR4mlDjtGz7HiOdei
3JeVj2bfhml0sfSv70vhL7coQMGIx/86Kx7nzh3jNmIWoCff7TlFDxJx3av6
SPvPheje0IuN6SpErHMv2FjuQBE6PRB15//5nKfyVj1qK0L9Spd1m3YS8aXj
AbJOboD6KF9UNssS8UyyuacnL0atMxd2B6gTcckT/ruhlhhFnrz//ZoJEac7
nI569h9G4wbrqstZ8VlwED21bx6j4DDB0mwWP92FhxPzDf4g+/Wrqb8NiXj2
Z9eq8Mc/aGb581HmHSJuUf719MDgH+SiFrL5pg0Razm/v6aqVowCAtX/Y54n
YrOFW8MMj2KkZHXR0fICERN3/ToSWFWMkBLvsRes/GFFs99MqRKkGPi7W4Vl
D+rmua1xswRNXohtVWDxa3CaKx6ll6ADyjUPPrP0DWds+7GJ8BclvH2w6a8l
Ece9NM+oPvUX1a++MiiwIOIjRRv/nf7yF1HDzLf1XmXxFSse/jHyF70p2edm
cYiIJcX+nvqnXoqW77Xd4tYn4sfBbdv/epSiR0m7e7uOEvHJc9OED5WlKDvP
f63/IhGvvd4tqi5ehk7LnUxbOM7y/+L1DzHXylCVg101rwERP21dnzqVUIZC
m52qyk2J+M9v6R+c82Wocpl7IJ0l/6FhG0k/Uo7G7akHDzoSsS+bVkuOfzla
qJqo3G/N4vtKpLtpWznil5HNO2JFxPZs6E/B1gp0vXjgrp45K1//bnWtOFYg
26Bb55qciNjr18Yl0awK1FRS1/flOhEfnrb1XF2rQF47YyNqWPdxhBqCE5Xo
6pLjrn9mRMz9wOnz+eBKRB0ziU9yYeVDHPL/dFciniN8dfOPibgs3K2DTeEf
8nRY/P3Ul8V326CtG+/8Q/XPL5T03ifi2qyiEt6cf8iIdtL1gj+rHj+Zz9UR
qtDpvQe2Sb8nYlXH602OJ6qQcF1C/7q7LHsLoiN7P1ShO3WNDTG3iHh57Kmn
YmcV2pxWckWLhTXrBWNObKtG2YLcuw59YNXreyVtvVvVaLl6b3fIDyLu2WFy
RyStGsXRDj9Ye0TEb5TSXfIWqpFW7su7Os6serM/7Kh9pAZpzSPLVXsW/z6F
+AW9qUG5C/szvr4gYvGLmhrFdTXo7ZCd6Od0Iu5uRfJVErUocMuWA49SiNij
WhUSL9eiI6e/Vte/YtUrwUvVLqYWWbx2eJMTxLp/2vr74mQt+ndIzFSfZQ8+
VnjITr0O0ZPDbZK/sfjSsF816WEdumvPzmUWT8TlBUrR1YV1iJ3jTzghn/We
Wnvf4Lp6pKPPn/5/OZKpuVAtX4+aztlyR8Sw6m1Pfn30sXpkEu1Q353I6tep
xy7dvFWPXsqp3f6DiVjgEENQMqAeGemG1xmUEfGVPTsJmSn1yM998t/gXyIW
m9t65HBjPbomc2FH1z8iXhJZN5ZDq0fnU/pGmblE/Fy27MdmyQa0T6qm3baU
iIsnX5nc02pAx/18TK63ErGoXO3X9IsNSPrCOqebeUTMo3kofNCjAQUmSzEC
WfoFNM5eX/vWgDTf/tjbOcSKN/s9Lt7iBuT/StmytYLVT3J7P68fbkALfgMx
m2P/3y8Ldk1wNCLuyJTZmRwifnlMpKlwRyPa9Ju93KqeNT/3lUd5nWhEOVua
YuYmiJiZFhuv7tiImiT7e5TZpLG5gRWhwb8R/Y3RnPOoY9kj4pp5JbkRtb8f
jD49TcTGm250d9Y1Ij6FiWQ2Fq585f3agNyIgl/davvDL40LS9krI0WaEMMn
e7iSQcQ/h7nSRzWakMP7usUj/Sx+V08yN55vQpkHH/EnCkuz9h/2W3puTSho
d5+pyiIRBykY5ZqHNiHtyh5RYRbeq+/AtMxpQmxXdhe6cEhj4gDlwKmOJpSv
uLTPXlQa9+lc9ldebELCm/JOZ8pL483Axr4q3Ywm4E7AeWlpfF1+x+/Cg80o
7a5jh912afytaCbm9qVm9EJ/JSjwmDQm/LQl8Xo0I+59YR11mtLYas495nNE
M+LRVd1tISaNZ/v5GsWLmpFWgeRlg8PSOE+hxde7txl9veklO2oijfU4n3b3
rjYje+mEmTNnpXHTB//O/zVQ5fFUrl1URFLqdCU573nfN8qcutIgYZdEA4lU
FJmiQYXUjVIiVzKTDCVTGUoK9d2i1NakIkOGg3McZ1QZwkVxU33nz/Xbe69n
rbV/+9Gn26DMw2jjjyAm2nFCUn2hDW7LLPbt3yPVEzn+LNm9DfhjVm8uSPV4
HkKN0jBpPaC08fgBJl6UMwx8nNMGvbVUXV4IE8f32FY/eN4GO0c32+dI+Qfc
1Bbk9LSBautk7TsHab+xf+yZ322w71d6rpIbEzVsSUNruh10tet0uP5MPJLT
oiQL7TAtc9MUU4qfsJeuvLe/HWQW7hxuPcPE1RfuPt56vh36k1wv/3mFibtW
PC9i32iHCDm1J/dPSPN+WcXYVd0OmvoRKvfDpPv158m+lB7xQ1r3s1cuE+WV
dsZrTLUDU+69qnkcE4klBs8DCDb4npC5nxDKREUz76IyUzZ8vTre0FrAxGhb
uSm+CxuOBkTVPL7NxI1Jr87JhrDht+NUlPxTJkbschbOz2DDjZ1yHs0ZTLQ9
ecBk4SM2jNxyqtctYeLtiyEJs9vZwGf0sPr/YWK5rMroyBgbxtO2OBcnMHF5
ePrJtyodUP/98LOsfCb21zprJK3ogEdfKO30aibGyaTO2OLQAYOqcQbP2NK8
ugNXjfp3QPCoAI0GmbjpuUJlQkIHVO6xrun4xMQ+nmMuUdoBoln98YYdTHwX
YDmZWdcBN0wGxcrdTDxeX9o8s68D3qg6m8g1MPFbsssaP8VOGEmouv2Zw8TD
jd/WPNPuBGJDheG9tQTWaC0WyG7qBNMRzcd3KQLVuI59Jt6dgGqSLIYigXVN
Dsqe4Z1QoJJm3ChPoPKZTdPO5nSC9tBgm+MvJm77M6wlqroTBJ+m+qwXEfgt
xTw5ktMJVAL0ntAjML7krs3JyU6YWesRcMCAQHtGr9xutS446xS4g5TiXIWR
j3qruuBu1v5oFkHg4oIXNUOOXaCmcu+lzp8EhoybdxcFdEEWy1lvkSuBqLpy
hWNCF7z06bBviyTwkcuBD19LusBzFne5rT+BOX6hT86964LKnx3uT2cT+OHo
wpm/e7vg0X3SMlA6P6L68sWJ6RwYWdtYyYkhcB57fKxDgwOTkW3pu44Q2PMl
xNkIODBq7Poldx+BdmKlvFBXDhS2Bmxbup/AqBK9S1UhHKiDc01Xo6T12llq
/Wkc4Dpc9Ss9SmDQH+2ucx5yINLe9n/HownU7Mw6sKSZA6b7xI6ejwkc+OZt
aviVAyu33+YUvCYwZYzq053FBYbTZevZeQRGa5WHqelyQfTd1LWqncBVrwcV
Jq24EGq+KmbgjTRflYzYD55cCPt2xrsgjUBOkLf61fNcUJ60db2CBGr9PfrE
/joXCubO9m6+LdVryT3/8xEXNiiVKy/jEkiS+ceyW7lw6vW96Q+bCFy7sOrK
ihEuTFvzy32vkED3KouSSuVuMAuyVlkyj4Vrvq/3WqnfDUHrI43Lh6T+qjNO
5Ft3w8WF1YqlzwmUO3L+k5x3N9ydZ8tolc6bBhH1zmHdMHfzxhPxc1hIXowx
yLveDXvaBUFuXwi8nMxmdD/qBsd97y0r+gic9et31OzWbpjmWryudZDA9Nv/
Ziwf7oa83ZeM+WosHJmb5GA9mwcp/bo3dBRY2O9x58kOXR6EjiXdSqJZeChT
XrjdigcyHuQCGxUW6mbtaVzvwQP5eo+0k64s9Ni6OUE7lAfr3sVHjrmwUD0r
UE8mgwfFPzJj3LxY6P7YveTDAx5URLmkam5n4UrlZCqxkQf076g9RrtZ+GVu
uIVVPw9mWYQc8zzIwvy6nAeDCj2wbKLweVQ6C2ddNFgbq9kD2rZjD6MOsZBb
crSTZdEDUTnKAxctWXjtdHZ2vksPPHb212gqZaFn39cU1qkeeFE0S+Z7FQvD
Rs5jTFIPWAsrsha9ZGFriJfRYEkPZGx3Psl7ysJ5UblDG2t74Kzpe7vk5yx8
amUsnyjsgeI3XSVuUj4FbcXQhp89cLBZttn+PQufT/xeFj6bD0rhp2dCMQtr
jp3eq8rkg3xiQK+VEom2dttf39Thg++31i0+HSy0tvA6uXQVH45+T/OOb2Zh
RXXM0fuWfKipNvNU/8pCu1jduKU7+FCot7rjDpuF03dNLLnlxoddxu/zqD4W
siMsVBf48eFSipXB6gEWHnSo8owI5sP0BfKvq4ZYmKigNffL33wYvX02I6lH
6v+HkebWK3yIStu2vrJSqr8wIacglw8as6OuyEv1pN4Uxv4o5cNWne+E4TwS
X9U09m97wod8C/6lVgaJ2Yr/vkx7y4eVhVmxB3ksnPGqZyG3jQ9fUnxrxZtJ
3BSvN0SI+LDzxwz/tQSJR5z2bts9zIfIf2Yuz9AjseTwd6PYn3yI2PtL+M6Z
xIKoC0VVSgIIY1+SU9xCYjLbv0ysJoBCXpD+jTlS3PDaYKaWAJat08kvtyQx
x/XLId0VAlAajP6vKYzEVXlobQkCCDAuYxYmkfj34P13u20FUGWxSTvqAYnm
KxZ883ERgMHxFl9OHol2inZN/r4C2HsaDEU3SEyrLHY9GSSA/4rmLak+SWLC
luCcoAsCiLm1uLEslcT35+RvHIsXwLTKR7d8o0g815vq4nVNAFCnXavtRmJv
r0+nQ5EAfNZmV2Z+ILGoumKR2UMBvMocrgw4S+L8+DJjjRoBPFS609p6nERf
78QF0xoEoM/1vwlS/gHLMx84XQIoW3Nt1Wl3Ekn9dNfyTwJoGBDeWif1d4uY
8TZ8TAA6RwMTf2eSeMg+YMh2mhAMrocMZVaTaKMhplXmCCHwY6DOWD+JZ72G
TVqZQrDItyt40Exi1ql8iyQdIUwG1tiHt5NY8Vl2lc1KIXx/Zd7rN51CXqjq
osn1QriW5F2vziFx3LBTrtBOCLa+4VYtEhKVTTeL7fYKIV0/3kN9iMQJXefX
w75CWFt+j3KYReE/LZN3EoKEsNQ3JFd9jMQmP/VMnQtCuKNaH7zJicKyiOwr
T+KE8HFn18HUSRK7GEezt2YKobnx0/roJhINz3lUtxYIYc7b2Kl7VhT+vLlr
zKVCCCm+aW4TshSu4S2y6XomhHEt9ZqUPygMTJFJ21UnBM9jwcFa6ynE/lGD
erYQpmTNp9QWUzg/RvOLuVgI7lPlru57KEz7Zd98Z1gIeXcOduonSPWErPv8
x08hXA2iDtmbU9jenGP010wRpMTe3bPBhMINMcblraoiyJQ9LRMjfT+zs/jI
Mk0RyMV+330JKMwoK/W8uEwEHlynDapGFF7H/swWUxGc/iz4/vgwhcsjFNVo
GxG0tiaVhy2j8O91BVyfnSJ4766x08OOQrGC+9cidxFYG+52gHMUzuxssJf4
icBrnyN/9z8Unr90eToVLIKPj3S13d9QKGmgGY6RIqieWDBzQRCFf7pQf4Un
ieD+kyB9870U9s/1VLubJYK5zTkJ9qkUVqi3mH0sFgH/kEri+TgKR3TW1Y4+
FIG7t+rAYAWFQWzVKkaNlJ/nFD47mkJuE2eh3gcRyDKifbb2UZjTMO2TWacI
TrHuPnWT9g/kT+jYSkQgrPHceKKTwlRzw57dIyKI+GR2uINNYWe5IsPtpwh+
24gma3gUWpoNV++fKYY3BsFm4m8UOm3eNLBPVQzK8tMZMiMU2v3lk+2kIYaq
+Q3VT3sobMy9w95sKIZ6p2z9nz8oPCc8ct1krRjezffbcrZDur/rEwOLN4mh
7Biram2TNJ/T+Y1KDtL58GllZl8pXHirdcmgqxg0Ruw2bFal0eBGrnHdITHI
JJu5ffsk3XfJ/u5bJ8UwyLqhlfMvhbt427XOXBBDsDibNbyNRpU7pXO2xYlh
n7Xg/ONjNIYOPchSyxDDtaJipslGGqd+p33suSmGbZkHX5jfp5F5M/rBzfti
UPH4dcacSeNd4pGl9xMxuBOl+/O5FE4stbtI1Yph9CDDQ7CIxi76RHDbRzFE
V6W1abygsbN2i1Y0TwxXqBU7807RaBQ9Fre6TwxKaFWYJ0cjxzmxgj8uBgb1
1YeaojCizjgzapoErMzQ5cdSGoMZExt1lSWAl9cL1JbT6F/dmvp6oQToPsZo
himNgW/Vm/cvkcDHFs+G+s00diwo7RpdLoH67t2V23Vp3BWZ/jBynQS2HRT1
jUn5jt3kec6zkcAIz1tVayeN5i8iJZmOEshwPm7NCaVRbyjaktovAe9aBqlk
Q+Pln71nsw9LYMqhi2NjRaNdTHoq85QETObnUkE5NKbLJCWmXJBAfK6Zqlkm
jTuyX/grxEnAoCbb/nUFjfeDKZO/0iVQV6ZzvkVar76Q2C/Il4BmcaUFZ8Yi
bLn0K27LPQm8ehnKsLajUcHKgS6tlMCsHbff7VhPY5rTkYLZryVwt6tp7X/e
NNpb62keapJI/9O+Aa8oGstvqwU/50jguviZ6/N7NHItsO+PTxJIbo5XO5pK
40rGdVevfyVQfGfHgN8SGmXjzjaV/pQA64APQ2At5V+8Ysu4Yi9I/Fb/itxL
4xn7uHcm83vhVKFyXNgwjflXnJyC6V7Qfbb8qIIUp150HHig3wtriC1MhWQa
/w9qoZvy
      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-5.524213717155397, -9.081022816730908},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->{{{{
       NCache[-Log[10000], -9.210340371976184], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[10000], -9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5000], -8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 3]], -8.111728083308073], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2500], -7.824046010856292], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2000], -7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5000, 3]], -7.418580902748128], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 7]], -7.264430222920869], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[1250], -7.1308988302963465`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 9]], -7.013115794639964], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2000], 7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3000], 8.006367567650246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4000], 8.294049640102028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5000], 8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6000], 8.699514748210191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7000], 8.85366542803745], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8000], 8.987196820661973], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9000], 9.104979856318357], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[10000], -9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10000], -9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5000], -8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 3]], -8.111728083308073], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2500], -7.824046010856292], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2000], -7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5000, 3]], -7.418580902748128], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 7]], -7.264430222920869], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[1250], -7.1308988302963465`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 9]], -7.013115794639964], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2000], 7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3000], 8.006367567650246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4000], 8.294049640102028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5000], 8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6000], 8.699514748210191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7000], 8.85366542803745], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8000], 8.987196820661973], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9000], 9.104979856318357], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}, {{{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontSize -> 14, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{-5.524213717155397, 0.6927127471609418}, {-9.081022816730908, 
   5.602558970469078}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891497436223301*^9, 
   3.8914975686949873`*^9, {3.891498532036313*^9, 3.8914985683451767`*^9}, 
   3.891498623092783*^9, 3.8926137112076287`*^9, 3.8926137597068872`*^9, 
   3.8926137904555197`*^9, {3.8926142793509655`*^9, 3.892614293785022*^9}, {
   3.8926143341300197`*^9, 3.892614379762048*^9}, 3.892614465860449*^9, 
   3.8926960604540453`*^9, 3.902037114926843*^9, 3.9020422053140135`*^9, 
   3.9022934592621293`*^9, 3.9022934952818155`*^9, 3.902293810169385*^9, 
   3.9022961961234293`*^9, 3.902296684173396*^9, 3.902297541969925*^9, 
   3.902297602521983*^9, 3.902298377775674*^9, 3.902389065137349*^9, 
   3.902389158029107*^9, {3.9023893989402933`*^9, 3.902389411383639*^9}, 
   3.9024868505876646`*^9, 3.9034208098187695`*^9, {3.9034301276579103`*^9, 
   3.9034301524294925`*^9}, 3.9034302423781786`*^9, 3.903430639512725*^9, 
   3.903592087513624*^9, {3.903592142839905*^9, 3.903592164134605*^9}, 
   3.903592199652372*^9, 3.9040344714034796`*^9, 3.9041104578519835`*^9, 
   3.904123937488302*^9},
 CellLabel->
  "Out[182]=",ExpressionUUID->"c38efa27-a7b3-4548-ab6c-8833fe933325"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2023-07_\
new_data\\\\Analysis\\\\E72 gibbsite - intensity weighted\\\\DataMerged.pdf\"\
\>"], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891497436223301*^9, 
   3.8914975686949873`*^9, {3.891498532036313*^9, 3.8914985683451767`*^9}, 
   3.891498623092783*^9, 3.8926137112076287`*^9, 3.8926137597068872`*^9, 
   3.8926137904555197`*^9, {3.8926142793509655`*^9, 3.892614293785022*^9}, {
   3.8926143341300197`*^9, 3.892614379762048*^9}, 3.892614465860449*^9, 
   3.8926960604540453`*^9, 3.902037114926843*^9, 3.9020422053140135`*^9, 
   3.9022934592621293`*^9, 3.9022934952818155`*^9, 3.902293810169385*^9, 
   3.9022961961234293`*^9, 3.902296684173396*^9, 3.902297541969925*^9, 
   3.902297602521983*^9, 3.902298377775674*^9, 3.902389065137349*^9, 
   3.902389158029107*^9, {3.9023893989402933`*^9, 3.902389411383639*^9}, 
   3.9024868505876646`*^9, 3.9034208098187695`*^9, {3.9034301276579103`*^9, 
   3.9034301524294925`*^9}, 3.9034302423781786`*^9, 3.903430639512725*^9, 
   3.903592087513624*^9, {3.903592142839905*^9, 3.903592164134605*^9}, 
   3.903592199652372*^9, 3.9040344714034796`*^9, 3.9041104578519835`*^9, 
   3.9041239387688837`*^9},
 CellLabel->
  "Out[183]=",ExpressionUUID->"b371cd9e-a0dc-4c20-85d9-fe325dc14688"],

Cell[BoxData[
 GraphicsBox[{{
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-5.258743426770615, 5.597844623441722}, {-5.258743426770615,
          5.600203186567693}}], 
        LineBox[{{-5.258743426770615, 5.600203186567693}, {-5.258743426770615,
          5.602556199960476}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-5.203084196874979, 5.573300622702098}, {-5.203084196874979,
          5.579035065707947}}], 
        LineBox[{{-5.203084196874979, 5.579035065707947}, {-5.203084196874979,
          5.584736812283935}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-5.15036080988166, 5.562364895098768}, {-5.15036080988166, 
         5.562434169636619}}], 
        LineBox[{{-5.15036080988166, 5.562434169636619}, {-5.15036080988166, 
         5.562503439375841}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-5.100278926838792, 5.559129715206269}, {-5.100278926838792,
          5.560903789695175}}], 
        LineBox[{{-5.100278926838792, 5.560903789695175}, {-5.100278926838792,
          5.562674722416695}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-5.05258633461702, 5.549338007796623}, {-5.05258633461702, 
         5.5547371389911735`}}], 
        LineBox[{{-5.05258633461702, 5.5547371389911735`}, {-5.05258633461702,
          5.5601072760412045`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.996102795196214, 5.540196622807694}, {-4.996102795196214,
          5.546218583038257}}], 
        LineBox[{{-4.996102795196214, 5.546218583038257}, {-4.996102795196214,
          5.552204496229358}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.94244887201582, 5.538261425243643}, {-4.94244887201582, 
         5.5385684920323355`}}], 
        LineBox[{{-4.94244887201582, 5.5385684920323355`}, {-4.94244887201582,
          5.5388754645599585`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.901580180665056, 5.527159049445207}, {-4.901580180665056,
          5.531338353655565}}], 
        LineBox[{{-4.901580180665056, 5.531338353655565}, {-4.901580180665056,
          5.535500263951488}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.852812691601468, 5.524635553140583}, {-4.852812691601468,
          5.525176791254943}}], 
        LineBox[{{-4.852812691601468, 5.525176791254943}, {-4.852812691601468,
          5.525717736589064}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.797177742009224, 5.51864266135113}, {-4.797177742009224, 
         5.519350317822124}}], 
        LineBox[{{-4.797177742009224, 5.519350317822124}, {-4.797177742009224,
          5.520057473869545}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.744476194802894, 5.506433509012956}, {-4.744476194802894,
          5.508025265529128}}], 
        LineBox[{{-4.744476194802894, 5.508025265529128}, {-4.744476194802894,
          5.5096144923825685`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.694413992516303, 5.505602347436833}, {-4.694413992516303,
          5.5083398939211285`}}], 
        LineBox[{{-4.694413992516303, 
         5.5083398939211285`}, {-4.694413992516303, 5.511069966699632}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.6467394805583355`, 
         5.496014281166543}, {-4.6467394805583355`, 5.4977918494548}}], 
        LineBox[{{-4.6467394805583355`, 
         5.4977918494548}, {-4.6467394805583355`, 5.499566263599913}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.601235108633844, 5.488729032235689}, {-4.601235108633844,
          5.489315537266454}}], 
        LineBox[{{-4.601235108633844, 5.489315537266454}, {-4.601235108633844,
          5.48990169851069}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.550696626771872, 5.480701491933811}, {-4.550696626771872,
          5.483070464506541}}], 
        LineBox[{{-4.550696626771872, 5.483070464506541}, {-4.550696626771872,
          5.485433838308942}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.495837254035044, 
         5.4746258783738115`}, {-4.495837254035044, 5.476673757131799}}], 
        LineBox[{{-4.495837254035044, 5.476673757131799}, {-4.495837254035044,
          5.4787174506517795`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.443832202221532, 5.464434649397088}, {-4.443832202221532,
          5.4671270199106035`}}], 
        LineBox[{{-4.443832202221532, 
         5.4671270199106035`}, {-4.443832202221532, 5.469812161025002}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.394399014142127, 5.450154957129999}, {-4.394399014142127,
          5.4513164465512}}], 
        LineBox[{{-4.394399014142127, 5.4513164465512}, {-4.394399014142127, 
         5.452476588479673}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.347295176465693, 5.437003164916507}, {-4.347295176465693,
          5.439688470202282}}], 
        LineBox[{{-4.347295176465693, 5.439688470202282}, {-4.347295176465693,
          5.442366583930796}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.2968724726031855`, 
         5.422849366927474}, {-4.2968724726031855`, 5.4255499354862335`}}], 
        LineBox[{{-4.2968724726031855`, 
         5.4255499354862335`}, {-4.2968724726031855`, 5.428243230612447}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.248785529261093, 5.398835328579635}, {-4.248785529261093,
          5.402432424216868}}], 
        LineBox[{{-4.248785529261093, 5.402432424216868}, {-4.248785529261093,
          5.406016627119625}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.198062234336449, 5.373749866389136}, {-4.198062234336449,
          5.37734225182199}}], 
        LineBox[{{-4.198062234336449, 5.37734225182199}, {-4.198062234336449, 
         5.380921778202639}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.144956928235059, 5.3435563239265}, {-4.144956928235059, 
         5.3485623823062385`}}], 
        LineBox[{{-4.144956928235059, 
         5.3485623823062385`}, {-4.144956928235059, 5.353543504843939}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.099048093674063, 
         5.3149668645758705`}, {-4.099048093674063, 5.319349846475541}}], 
        LineBox[{{-4.099048093674063, 5.319349846475541}, {-4.099048093674063,
          5.323713701646499}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.050903467748433, 5.280987212789569}, {-4.050903467748433,
          5.286386646500453}}], 
        LineBox[{{-4.050903467748433, 5.286386646500453}, {-4.050903467748433,
          5.291757082826328}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.00086172133975, 5.2380115202824635`}, {-4.00086172133975,
          5.243263347349138}}], 
        LineBox[{{-4.00086172133975, 5.243263347349138}, {-4.00086172133975, 
         5.2484877367633445`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.9493673644807528`, 
         5.1853440304763865`}, {-3.9493673644807528`, 5.19247357416942}}], 
        LineBox[{{-3.9493673644807528`, 
         5.19247357416942}, {-3.9493673644807528`, 5.199552647090483}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.896950458764108, 5.133248395314574}, {-3.896950458764108,
          5.139654694388467}}], 
        LineBox[{{-3.896950458764108, 5.139654694388467}, {-3.896950458764108,
          5.146020213902015}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.8481464471539684`, 
         5.07243529478744}, {-3.8481464471539684`, 5.079327369054249}}], 
        LineBox[{{-3.8481464471539684`, 
         5.079327369054249}, {-3.8481464471539684`, 5.086172267586562}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.7994515835339397`, 
         5.002315553537143}, {-3.7994515835339397`, 5.0097976801912445`}}], 
        LineBox[{{-3.7994515835339397`, 
         5.0097976801912445`}, {-3.7994515835339397`, 5.017224240126007}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.7503197687122154`, 
         4.923314698238383}, {-3.7503197687122154`, 4.930551899384259}}], 
        LineBox[{{-3.7503197687122154`, 
         4.930551899384259}, {-3.7503197687122154`, 4.937737099565807}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.699053781538707, 4.836012226549871}, {-3.699053781538707,
          4.844656474996933}}], 
        LineBox[{{-3.699053781538707, 4.844656474996933}, {-3.699053781538707,
          4.8532266403481135`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.648015493807286, 4.738724897837194}, {-3.648015493807286,
          4.747413922453393}}], 
        LineBox[{{-3.648015493807286, 4.747413922453393}, {-3.648015493807286,
          4.756028097820911}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.5975261795058113`, 
         4.6377890082318665`}, {-3.5975261795058113`, 4.647321152173751}}], 
        LineBox[{{-3.5975261795058113`, 
         4.647321152173751}, {-3.5975261795058113`, 4.656763291608365}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.547390827893857, 4.534843256029669}, {-3.547390827893857,
          4.544067207251172}}], 
        LineBox[{{-3.547390827893857, 4.544067207251172}, {-3.547390827893857,
          4.5532068542225685`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.4997134491987065`, 
         4.435240127290906}, {-3.4997134491987065`, 4.443932681643636}}], 
        LineBox[{{-3.4997134491987065`, 
         4.443932681643636}, {-3.4997134491987065`, 4.452550326185178}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.44886128475706, 4.319794749815371}, {-3.44886128475706, 
         4.328634907544648}}], 
        LineBox[{{-3.44886128475706, 4.328634907544648}, {-3.44886128475706, 
         4.337397601180005}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.398825125104665, 4.204767287568042}, {-3.398825125104665,
          4.213773736705799}}], 
        LineBox[{{-3.398825125104665, 4.213773736705799}, {-3.398825125104665,
          4.222699793230888}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.3495492883792926`, 
         4.0929356298227635`}, {-3.3495492883792926`, 4.101453200841681}}], 
        LineBox[{{-3.3495492883792926`, 
         4.101453200841681}, {-3.3495492883792926`, 4.109898835139432}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.2979725252280643`, 
         3.972487858945226}, {-3.2979725252280643`, 3.9807462541574625`}}], 
        LineBox[{{-3.2979725252280643`, 
         3.9807462541574625`}, {-3.2979725252280643`, 3.9889370065183245`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.247477183168992, 
         3.8600803505464087`}, {-3.247477183168992, 3.8683986670068493`}}], 
        LineBox[{{-3.247477183168992, 
         3.8683986670068493`}, {-3.247477183168992, 3.8766483595218153`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.198128924305424, 3.747565872529656}, {-3.198128924305424,
          3.755287573094235}}], 
        LineBox[{{-3.198128924305424, 3.755287573094235}, {-3.198128924305424,
          3.762950105585614}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.1483452380310095`, 
         3.6409548774799214`}, {-3.1483452380310095`, 3.648084134642474}}], 
        LineBox[{{-3.1483452380310095`, 
         3.648084134642474}, {-3.1483452380310095`, 3.6551629250753908`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.098548042583462, 3.537488623774353}, {-3.098548042583462,
          3.5444960124240006`}}], 
        LineBox[{{-3.098548042583462, 
         3.5444960124240006`}, {-3.098548042583462, 3.5514546390741004`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.048627928798489, 3.432061921285006}, {-3.048627928798489,
          3.438788716557057}}], 
        LineBox[{{-3.048627928798489, 3.438788716557057}, {-3.048627928798489,
          3.4454705642393537`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.9978155251742797`, 
         3.3304247270343805`}, {-2.9978155251742797`, 3.337256897311196}}], 
        LineBox[{{-2.9978155251742797`, 
         3.337256897311196}, {-2.9978155251742797`, 3.3440427056111224`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.947960382532211, 3.237920004699391}, {-2.947960382532211,
          3.2473612150506415`}}], 
        LineBox[{{-2.947960382532211, 
         3.2473612150506415`}, {-2.947960382532211, 3.2567141219902958`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.8977164895308016`, 
         3.1391860341331967`}, {-2.8977164895308016`, 3.1480551344613596`}}], 
        LineBox[{{-2.8977164895308016`, 
         3.1480551344613596`}, {-2.8977164895308016`, 3.1568462648653677`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.8479987080032334`, 
         3.0418760512696634`}, {-2.8479987080032334`, 3.050392674029378}}], 
        LineBox[{{-2.8479987080032334`, 
         3.050392674029378}, {-2.8479987080032334`, 3.058837376016901}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.7979177910955517`, 
         2.9462177694057106`}, {-2.7979177910955517`, 2.9547552240921706`}}], 
        LineBox[{{-2.7979177910955517`, 
         2.9547552240921706`}, {-2.7979177910955517`, 2.9632204072259527`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.7479400527911535`, 
         2.839583537471307}, {-2.7479400527911535`, 2.846309777095533}}], 
        LineBox[{{-2.7479400527911535`, 
         2.846309777095533}, {-2.7479400527911535`, 2.852991076530458}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.69773295934073, 2.7365752130936443`}, {-2.69773295934073,
          2.7434033955768795`}}], 
        LineBox[{{-2.69773295934073, 2.7434033955768795`}, {-2.69773295934073,
          2.7501852700052374`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.6475469932021087`, 
         2.6287071811704377`}, {-2.6475469932021087`, 2.6352196500010816`}}], 
        LineBox[{{-2.6475469932021087`, 
         2.6352196500010816`}, {-2.6475469932021087`, 2.641689980855744}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.597641443992788, 
         2.5284798047773283`}, {-2.597641443992788, 2.5355856117663857`}}], 
        LineBox[{{-2.597641443992788, 
         2.5355856117663857`}, {-2.597641443992788, 2.542641282312891}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.5475694106833053`, 
         2.421323774449135}, {-2.5475694106833053`, 2.427254706895537}}], 
        LineBox[{{-2.5475694106833053`, 
         2.427254706895537}, {-2.5475694106833053`, 2.433150670677143}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.4975225280867095`, 
         2.3142087607757027`}, {-2.4975225280867095`, 2.3204830705271506`}}], 
        LineBox[{{-2.4975225280867095`, 
         2.3204830705271506`}, {-2.4975225280867095`, 2.3267182586494197`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.447763087774165, 2.212859183504275}, {-2.447763087774165,
          2.2197496304436606`}}], 
        LineBox[{{-2.447763087774165, 
         2.2197496304436606`}, {-2.447763087774165, 2.2265929238476687`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.3976803743808155`, 
         2.108084254417355}, {-2.3976803743808155`, 2.114251749328254}}], 
        LineBox[{{-2.3976803743808155`, 
         2.114251749328254}, {-2.3976803743808155`, 2.1203814392884177`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.348368371350231, 2.001248342903831}, {-2.348368371350231,
          2.0067007784986037`}}], 
        LineBox[{{-2.348368371350231, 
         2.0067007784986037`}, {-2.348368371350231, 2.0121236461837295`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.298783468558108, 1.897517429556216}, {-2.298783468558108,
          1.903645472714538}}], 
        LineBox[{{-2.298783468558108, 1.903645472714538}, {-2.298783468558108,
          1.9097361915687647`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.2483624298374023`, 
         1.7902721420175565`}, {-2.2483624298374023`, 1.7960162206687456`}}], 
        LineBox[{{-2.2483624298374023`, 
         1.7960162206687456`}, {-2.2483624298374023`, 1.8017274932314498`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.197944747614582, 
         1.6783373953323928`}, {-2.197944747614582, 1.6841466845554618`}}], 
        LineBox[{{-2.197944747614582, 
         1.6841466845554618`}, {-2.197944747614582, 1.6899224207626107`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.1480770922972092`, 
         1.5717973850445908`}, {-2.1480770922972092`, 1.577180590328926}}], 
        LineBox[{{-2.1480770922972092`, 
         1.577180590328926}, {-2.1480770922972092`, 1.5825349718093473`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.097981645186187, 
         1.4611102002418785`}, {-2.097981645186187, 1.4662326614040324`}}], 
        LineBox[{{-2.097981645186187, 
         1.4662326614040324`}, {-2.097981645186187, 1.4713290166276913`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.047332843362554, 1.348361194103855}, {-2.047332843362554,
          1.3530970125937565`}}], 
        LineBox[{{-2.047332843362554, 
         1.3530970125937565`}, {-2.047332843362554, 1.3578105087797447`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.0041427289642564`, 
         1.2528701769838237`}, {-2.0041427289642564`, 1.2574092636815433`}}], 
        LineBox[{{-2.0041427289642564`, 
         1.2574092636815433`}, {-2.0041427289642564`, 1.2619278401339393`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.948989751513443, 
         1.1327678865272564`}, {-1.948989751513443, 1.1443137894464046`}}], 
        LineBox[{{-1.948989751513443, 
         1.1443137894464046`}, {-1.948989751513443, 1.1557279046521711`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.89757230615388, 1.0150947474341576`}, {-1.89757230615388,
          1.025537626921304}}], 
        LineBox[{{-1.89757230615388, 1.025537626921304}, {-1.89757230615388, 
         1.0358725787809901`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.847489450082524, 
         0.8987740151280526}, {-1.847489450082524, 0.9083123526140632}}], 
        LineBox[{{-1.847489450082524, 
         0.9083123526140632}, {-1.847489450082524, 0.91776056914535}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.7974573150500959`, 
         0.7826267194019005}, {-1.7974573150500959`, 0.7914585721108804}}], 
        LineBox[{{-1.7974573150500959`, 
         0.7914585721108804}, {-1.7974573150500959`, 0.8002131055716157}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.7475262070870057`, 
         0.6654747567544406}, {-1.7475262070870057`, 0.6742621017546803}}], 
        LineBox[{{-1.7475262070870057`, 
         0.6742621017546803}, {-1.7475262070870057`, 0.6829729014643826}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.6977536082142044`, 
         0.5479819946925054}, {-1.6977536082142044`, 0.5566388188174729}}], 
        LineBox[{{-1.6977536082142044`, 
         0.5566388188174729}, {-1.6977536082142044`, 0.5652213450621819}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.6473199749706375`, 
         0.426677127391245}, {-1.6473199749706375`, 0.43539274853927007`}}], 
        LineBox[{{-1.6473199749706375`, 
         0.43539274853927007`}, {-1.6473199749706375`, 0.4440330635028922}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.5972819325405316`, 
         0.30494626094462846`}, {-1.5972819325405316`, 
         0.31290504871669855`}}], 
        LineBox[{{-1.5972819325405316`, 
         0.31290504871669855`}, {-1.5972819325405316`, 
         0.32080099400684914`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.5478913316690934`, 
         0.1857102224197438}, {-1.5478913316690934`, 0.19395204830923662`}}], 
        LineBox[{{-1.5478913316690934`, 
         0.19395204830923662`}, {-1.5478913316690934`, 
         0.20212650140134805`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.4980782463617393`, 
         0.06268799883485462}, {-1.4980782463617393`, 0.07049103520239025}}], 
        LineBox[{{-1.4980782463617393`, 
         0.07049103520239025}, {-1.4980782463617393`, 0.07823365531939837}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.4481453140697378`, -0.06086172655089208}, \
{-1.4481453140697378`, -0.053565800442898805`}}], 
        LineBox[{{-1.4481453140697378`, -0.053565800442898805`}, \
{-1.4481453140697378`, -0.046322719550606344`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.398191903523388, -0.1885155090124537}, \
{-1.398191903523388, -0.1815030707057571}}], 
        LineBox[{{-1.398191903523388, -0.1815030707057571}, \
{-1.398191903523388, -0.174539464456985}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.3483031572416584`, -0.3156525600328104}, \
{-1.3483031572416584`, -0.3089428977439817}}], 
        LineBox[{{-1.3483031572416584`, -0.3089428977439817}, \
{-1.3483031572416584`, -0.302277955135881}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.2979069974706638`, -0.4479419922930737}, \
{-1.2979069974706638`, -0.4413014948584804}}], 
        LineBox[{{-1.2979069974706638`, -0.4413014948584804}, \
{-1.2979069974706638`, -0.4347048028998244}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.247855238603403, -0.5805986343329628}, \
{-1.247855238603403, -0.5742239258850526}}], 
        LineBox[{{-1.247855238603403, -0.5742239258850526}, \
{-1.247855238603403, -0.5678895970724116}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.1975794586010302`, -0.7152838356120086}, \
{-1.1975794586010302`, -0.7086823856160954}}], 
        LineBox[{{-1.1975794586010302`, -0.7086823856160954}, \
{-1.1975794586010302`, -0.7021242291185592}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.1478293349254551`, -0.8493731528095251}, \
{-1.1478293349254551`, -0.8432238664551491}}], 
        LineBox[{{-1.1478293349254551`, -0.8432238664551491}, \
{-1.1478293349254551`, -0.8371121628341563}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.0980911772212536`, -0.9875693106004991}, \
{-1.0980911772212536`, -0.9809986992123712}}], 
        LineBox[{{-1.0980911772212536`, -0.9809986992123712}, \
{-1.0980911772212536`, -0.9744709790897236}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.0478986909613914`, -1.1282037280320547`}, \
{-1.0478986909613914`, -1.121514325016335}}], 
        LineBox[{{-1.0478986909613914`, -1.121514325016335}, \
{-1.0478986909613914`, -1.1148693729278116`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.0052991306415568`, -1.2898648919210907`}, \
{-1.0052991306415568`, -1.2672994540992866`}}], 
        LineBox[{{-1.0052991306415568`, -1.2672994540992866`}, \
{-1.0052991306415568`, -1.2452319987335942`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-0.9457645191321252, -1.4949418495336062`}, \
{-0.9457645191321252, -1.4758511604422213`}}], 
        LineBox[{{-0.9457645191321252, -1.4758511604422213`}, \
{-0.9457645191321252, -1.4571181088722989`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-0.8975684168950352, -1.6568738990437721`}, \
{-0.8975684168950352, -1.6375169370541725`}}], 
        LineBox[{{-0.8975684168950352, -1.6375169370541725`}, \
{-0.8975684168950352, -1.6185275629174607`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-0.8484100242674611, -1.8311171124324104`}, \
{-0.8484100242674611, -1.8109863815695573`}}], 
        LineBox[{{-0.8484100242674611, -1.8109863815695573`}, \
{-0.8484100242674611, -1.7912529130021724`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-0.7984816622456004, -2.012935384611139}, \
{-0.7984816622456004, -1.9929163232211045`}}], 
        LineBox[{{-0.7984816622456004, -1.9929163232211045`}, \
{-0.7984816622456004, -1.9732901718249019`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-0.7480539136387332, -2.2112308507893266`}, \
{-0.7480539136387332, -2.189938835485349}}], 
        LineBox[{{-0.7480539136387332, -2.189938835485349}, \
{-0.7480539136387332, -2.169090734683407}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-0.6972695317151648, -2.417642260463314}, \
{-0.6972695317151648, -2.3964700086373645`}}], 
        LineBox[{{-0.6972695317151648, -2.3964700086373645`}, \
{-0.6972695317151648, -2.3757367427951195`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-0.6489405459698597, -2.6245321982338625`}, \
{-0.6489405459698597, -2.60332836224349}}], 
        LineBox[{{-0.6489405459698597, -2.60332836224349}, \
{-0.6489405459698597, -2.5825648093758544`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-0.5978882338370656, -2.859151859492409}, \
{-0.5978882338370656, -2.835525777801304}}], 
        LineBox[{{-0.5978882338370656, -2.835525777801304}, \
{-0.5978882338370656, -2.8124450285578058`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-0.5468859788019935, -3.1038361279938065`}, \
{-0.5468859788019935, -3.080912614307733}}], 
        LineBox[{{-0.5468859788019935, -3.080912614307733}, \
{-0.5468859788019935, -3.058502833529973}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-0.49839709091981343`, -3.353223380570041}, \
{-0.49839709091981343`, -3.3289472387859402`}}], 
        LineBox[{{-0.49839709091981343`, -3.3289472387859402`}, \
{-0.49839709091981343`, -3.3052464873904968`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-0.4478548616633693, -3.6312182751192106`}, \
{-0.4478548616633693, -3.6055527117125172`}}], 
        LineBox[{{-0.4478548616633693, -3.6055527117125172`}, \
{-0.4478548616633693, -3.5805294195700386`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-0.3976867065294305, -3.9284963098767776`}, \
{-0.3976867065294305, -3.902144474478934}}], 
        LineBox[{{-0.3976867065294305, -3.902144474478934}, \
{-0.3976867065294305, -3.8764692660948024`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-0.34799002447990274`, -4.237483139851521}, \
{-0.34799002447990274`, -4.210382370228636}}], 
        LineBox[{{-0.34799002447990274`, -4.210382370228636}, \
{-0.34799002447990274`, -4.183996714786856}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-0.2969531008468749, -4.574143084464733}, \
{-0.2969531008468749, -4.546541316527105}}], 
        LineBox[{{-0.2969531008468749, -4.546541316527105}, \
{-0.2969531008468749, -4.519680986978777}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-0.24662569878989188`, -4.919017711901526}, \
{-0.24662569878989188`, -4.8910812457734565`}}], 
        LineBox[{{-0.24662569878989188`, -4.8910812457734565`}, \
{-0.24662569878989188`, -4.863904062152695}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-0.1970546615297671, -5.260019215338914}, \
{-0.1970546615297671, -5.233446148750229}}], 
        LineBox[{{-0.1970546615297671, -5.233446148750229}, \
{-0.1970546615297671, -5.207560970164635}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-0.14822236829741636`, -5.582530984466024}, \
{-0.14822236829741636`, -5.5596065388023135`}}], 
        LineBox[{{-0.14822236829741636`, -5.5596065388023135`}, \
{-0.14822236829741636`, -5.537195867353996}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-0.09866073056278395, -5.866231334795912}, \
{-0.09866073056278395, -5.844786771316505}}], 
        LineBox[{{-0.09866073056278395, -5.844786771316505}, \
{-0.09866073056278395, -5.823792439020066}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-0.04853598517739491, -6.083724376948064}, \
{-0.04853598517739491, -6.070572462776747}}], 
        LineBox[{{-0.04853598517739491, -6.070572462776747}, \
{-0.04853598517739491, -6.057591278456455}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{0.0019108702384332597`, -6.226140445902484}, {
         0.0019108702384332597`, -6.218405866418743}}], 
        LineBox[{{0.0019108702384332597`, -6.218405866418743}, {
         0.0019108702384332597`, -6.21073065178631}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{0.052559248334694046`, -6.2924503239232425`}, {
         0.052559248334694046`, -6.288202917411738}}], 
        LineBox[{{0.052559248334694046`, -6.288202917411738}, {
         0.052559248334694046`, -6.283973475087992}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{0.10199283687143391`, -6.3079708675054516`}, {
         0.10199283687143391`, -6.304353365563357}}], 
        LineBox[{{0.10199283687143391`, -6.304353365563357}, {
         0.10199283687143391`, -6.300748902786526}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{0.15145476833695506`, -6.330365457477086}, {
         0.15145476833695506`, -6.326739455417579}}], 
        LineBox[{{0.15145476833695506`, -6.326739455417579}, {
         0.15145476833695506`, -6.323126553761221}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{0.20193926815404056`, -6.363246376696179}, {
         0.20193926815404056`, -6.358476949836614}}], 
        LineBox[{{0.20193926815404056`, -6.358476949836614}, {
         0.20193926815404056`, -6.353730162474901}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{0.2521462765774717, -6.428199900146532}, {
         0.2521462765774717, -6.422453241058921}}], 
        LineBox[{{0.2521462765774717, -6.422453241058921}, {
         0.2521462765774717, -6.416739417457482}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{0.3019632878192566, -6.509571436677595}, {
         0.3019632878192566, -6.5009012399531105`}}], 
        LineBox[{{0.3019632878192566, -6.5009012399531105`}, {
         0.3019632878192566, -6.492305569842312}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{0.35231722643795, -6.631041667880051}, {
         0.35231722643795, -6.623930307881013}}], 
        LineBox[{{0.35231722643795, -6.623930307881013}, {
         0.35231722643795, -6.61686916243934}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{0.402090971208213, -6.790179303832907}, {
         0.402090971208213, -6.7790739409951914`}}], 
        LineBox[{{0.402090971208213, -6.7790739409951914`}, {
         0.402090971208213, -6.768090553896218}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{0.4521151691768005, -6.973726367591347}, {
         0.4521151691768005, -6.962349673929426}}], 
        LineBox[{{0.4521151691768005, -6.962349673929426}, {
         0.4521151691768005, -6.951100954863179}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{0.5022526147099476, -7.198470913552531}, {
         0.5022526147099476, -7.187095267475676}}], 
        LineBox[{{0.5022526147099476, -7.187095267475676}, {
         0.5022526147099476, -7.1758475725596345`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{0.552357383861411, -7.41001463223403}, {
         0.552357383861411, -7.398043986529712}}], 
        LineBox[{{0.552357383861411, -7.398043986529712}, {
         0.552357383861411, -7.386214943776135}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{0.6023298299247067, -7.618125527200668}, {
         0.6023298299247067, -7.60482861435157}}], 
        LineBox[{{0.6023298299247067, -7.60482861435157}, {
         0.6023298299247067, -7.591706191749361}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{0.6520606514627489, -7.823362773906829}, {
         0.6520606514627489, -7.810378788163256}}], 
        LineBox[{{0.6520606514627489, -7.810378788163256}, {
         0.6520606514627489, -7.797561227749427}}]}},
      Antialiasing->False]}}, 
   {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.009166666666666668], 
    AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJwVx3k81PkfwPEZV2PMMLcrkmujpqG087PF99Pl6GCkyNK61aL7mIdVlJ/0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     "]]}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-5.507592383189282, -8.874017126103118},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->{{{{
       NCache[-Log[10000], -9.210340371976184], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[10000], -9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5000], -8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 3]], -8.111728083308073], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2500], -7.824046010856292], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2000], -7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5000, 3]], -7.418580902748128], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 7]], -7.264430222920869], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[1250], -7.1308988302963465`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 9]], -7.013115794639964], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2000], 7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3000], 8.006367567650246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4000], 8.294049640102028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5000], 8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6000], 8.699514748210191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7000], 8.85366542803745], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8000], 8.987196820661973], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9000], 9.104979856318357], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[10000], -9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10000], -9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5000], -8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 3]], -8.111728083308073], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2500], -7.824046010856292], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2000], -7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5000, 3]], -7.418580902748128], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 7]], -7.264430222920869], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[1250], -7.1308988302963465`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 9]], -7.013115794639964], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2000], 7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3000], 8.006367567650246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4000], 8.294049640102028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5000], 8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6000], 8.699514748210191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7000], 8.85366542803745], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8000], 8.987196820661973], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9000], 9.104979856318357], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}, {{{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontSize -> 14, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{-5.507592383189282, 0.6520606514627489}, {-8.874017126103118, 
   5.602556199960476}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891497436223301*^9, 
   3.8914975686949873`*^9, {3.891498532036313*^9, 3.8914985683451767`*^9}, 
   3.891498623092783*^9, 3.8926137112076287`*^9, 3.8926137597068872`*^9, 
   3.8926137904555197`*^9, {3.8926142793509655`*^9, 3.892614293785022*^9}, {
   3.8926143341300197`*^9, 3.892614379762048*^9}, 3.892614465860449*^9, 
   3.8926960604540453`*^9, 3.902037114926843*^9, 3.9020422053140135`*^9, 
   3.9022934592621293`*^9, 3.9022934952818155`*^9, 3.902293810169385*^9, 
   3.9022961961234293`*^9, 3.902296684173396*^9, 3.902297541969925*^9, 
   3.902297602521983*^9, 3.902298377775674*^9, 3.902389065137349*^9, 
   3.902389158029107*^9, {3.9023893989402933`*^9, 3.902389411383639*^9}, 
   3.9024868505876646`*^9, 3.9034208098187695`*^9, {3.9034301276579103`*^9, 
   3.9034301524294925`*^9}, 3.9034302423781786`*^9, 3.903430639512725*^9, 
   3.903592087513624*^9, {3.903592142839905*^9, 3.903592164134605*^9}, 
   3.903592199652372*^9, 3.9040344714034796`*^9, 3.9041104578519835`*^9, 
   3.904123939209942*^9},
 CellLabel->
  "Out[185]=",ExpressionUUID->"0fd523b3-481e-4854-8eaa-9aa2a0909464"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2023-07_\
new_data\\\\Analysis\\\\E72 gibbsite - intensity \
weighted\\\\DataMergedBinned.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891497436223301*^9, 
   3.8914975686949873`*^9, {3.891498532036313*^9, 3.8914985683451767`*^9}, 
   3.891498623092783*^9, 3.8926137112076287`*^9, 3.8926137597068872`*^9, 
   3.8926137904555197`*^9, {3.8926142793509655`*^9, 3.892614293785022*^9}, {
   3.8926143341300197`*^9, 3.892614379762048*^9}, 3.892614465860449*^9, 
   3.8926960604540453`*^9, 3.902037114926843*^9, 3.9020422053140135`*^9, 
   3.9022934592621293`*^9, 3.9022934952818155`*^9, 3.902293810169385*^9, 
   3.9022961961234293`*^9, 3.902296684173396*^9, 3.902297541969925*^9, 
   3.902297602521983*^9, 3.902298377775674*^9, 3.902389065137349*^9, 
   3.902389158029107*^9, {3.9023893989402933`*^9, 3.902389411383639*^9}, 
   3.9024868505876646`*^9, 3.9034208098187695`*^9, {3.9034301276579103`*^9, 
   3.9034301524294925`*^9}, 3.9034302423781786`*^9, 3.903430639512725*^9, 
   3.903592087513624*^9, {3.903592142839905*^9, 3.903592164134605*^9}, 
   3.903592199652372*^9, 3.9040344714034796`*^9, 3.9041104578519835`*^9, 
   3.9041239409100385`*^9},
 CellLabel->
  "Out[186]=",ExpressionUUID->"11d1ef2e-365e-4115-b798-d0ad0f4e2fa9"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2023-07_\
new_data\\\\Analysis\\\\E72 gibbsite - intensity weighted\\\\Sample \
playground LH-ESRF-E72 NEW SAXS data merged and binned.csv\"\>"], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891497436223301*^9, 
   3.8914975686949873`*^9, {3.891498532036313*^9, 3.8914985683451767`*^9}, 
   3.891498623092783*^9, 3.8926137112076287`*^9, 3.8926137597068872`*^9, 
   3.8926137904555197`*^9, {3.8926142793509655`*^9, 3.892614293785022*^9}, {
   3.8926143341300197`*^9, 3.892614379762048*^9}, 3.892614465860449*^9, 
   3.8926960604540453`*^9, 3.902037114926843*^9, 3.9020422053140135`*^9, 
   3.9022934592621293`*^9, 3.9022934952818155`*^9, 3.902293810169385*^9, 
   3.9022961961234293`*^9, 3.902296684173396*^9, 3.902297541969925*^9, 
   3.902297602521983*^9, 3.902298377775674*^9, 3.902389065137349*^9, 
   3.902389158029107*^9, {3.9023893989402933`*^9, 3.902389411383639*^9}, 
   3.9024868505876646`*^9, 3.9034208098187695`*^9, {3.9034301276579103`*^9, 
   3.9034301524294925`*^9}, 3.9034302423781786`*^9, 3.903430639512725*^9, 
   3.903592087513624*^9, {3.903592142839905*^9, 3.903592164134605*^9}, 
   3.903592199652372*^9, 3.9040344714034796`*^9, 3.9041104578519835`*^9, 
   3.9041239411344748`*^9},
 CellLabel->
  "Out[188]=",ExpressionUUID->"360a8f54-d981-4105-a564-ad3018d78f67"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Plot", " ", "slopes"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"plotSlopes", "=", " ", 
    RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"slope", "[", 
       RowBox[{"datamerged", ",", "0.15"}], "]"}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"default", ":", " ", "0.15"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", " ", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}]}], ",", " ", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "8"}], ",", "2"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"PowerTicks", "[", "True", "]"}], "[", 
            RowBox[{
             RowBox[{"10", "^", 
              RowBox[{"-", "2"}]}], ",", " ", 
             RowBox[{"10", "^", "0"}]}], "]"}], ",", 
           RowBox[{
            RowBox[{"PowerTicks", "[", "False", "]"}], "[", 
            RowBox[{
             RowBox[{"10", "^", 
              RowBox[{"-", "2"}]}], ",", " ", 
             RowBox[{"10", "^", "0"}]}], "]"}]}], "}"}]}], "}"}]}], ",", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Slope\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<Slopes.pdf\>\""}], "}"}], "]"}], ",", "plotSlopes"}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"slope", "[", 
    RowBox[{"datamerged", ",", "0.15"}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Export", " ", "slopes", " ", 
     RowBox[{"(", 
      RowBox[{
      "for", " ", "plotting", " ", "in", " ", "Python", " ", "or", " ", 
       "other", " ", "software"}], ")"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"exportlist", " ", "=", " ", 
     RowBox[{"exportData", "[", 
      RowBox[{"slope", "[", 
       RowBox[{"datamerged", ",", "0.15"}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"FileBaseName", "[", 
          RowBox[{"NotebookFileName", "[", "]"}], "]"}], "<>", 
         "\"\< SAXS slopes.csv\>\""}]}], "\[IndentingNewLine]", "}"}], 
      "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
     "exportlist"}], "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
   RowBox[{"NotebookFileName", "[", "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.852797516969694*^9, {3.852797632109549*^9, 3.852797683131383*^9}, {
   3.852797796480151*^9, 3.852797853718195*^9}, {3.8527978838837643`*^9, 
   3.852797901227326*^9}, {3.852797980320817*^9, 3.852798038102087*^9}, 
   3.852798223135673*^9, {3.852798406664549*^9, 3.852798409306513*^9}, {
   3.852798512004775*^9, 3.852798555547234*^9}, {3.85279858828354*^9, 
   3.852798831366269*^9}, {3.852798896028565*^9, 3.852799007753936*^9}, {
   3.852799080350028*^9, 3.852799084748775*^9}, {3.8527992586158037`*^9, 
   3.8527992606884203`*^9}, {3.852801934781908*^9, 3.85280197103442*^9}, {
   3.852802103164875*^9, 3.852802118419861*^9}, {3.852862635200562*^9, 
   3.8528626398081703`*^9}, {3.85286268207966*^9, 3.85286275183375*^9}, {
   3.852862799533414*^9, 3.852862876114451*^9}, {3.8528629338179607`*^9, 
   3.852862985846582*^9}, {3.852863040437448*^9, 3.852863051004711*^9}, {
   3.852868510428824*^9, 3.852868602768145*^9}, {3.852868644287572*^9, 
   3.85286868020261*^9}, {3.852868718724351*^9, 3.85286873785894*^9}, {
   3.852868770378528*^9, 3.8528689132597523`*^9}, {3.852868965432905*^9, 
   3.852868981650947*^9}, 3.852870677134739*^9, {3.8528710993603067`*^9, 
   3.852871145669981*^9}, {3.8528716178560038`*^9, 3.852871618411791*^9}, {
   3.852874052533587*^9, 3.852874070324737*^9}, {3.8533820192129173`*^9, 
   3.853382032526078*^9}, {3.853403584226432*^9, 3.853403584753387*^9}, {
   3.8534051467395353`*^9, 3.853405196243081*^9}, {3.853405235261485*^9, 
   3.8534052353804817`*^9}, {3.853405414194544*^9, 3.85340541704944*^9}, {
   3.854423706814918*^9, 3.854423713174549*^9}, {3.8601401065322495`*^9, 
   3.8601401162752795`*^9}, {3.8617652315248656`*^9, 3.861765245785426*^9}, {
   3.861765486245756*^9, 3.861765500810083*^9}, {3.8617668960181065`*^9, 
   3.861766896503375*^9}, {3.861766959391518*^9, 3.861766970643777*^9}, {
   3.861768170754223*^9, 3.861768171551543*^9}, {3.861768267366991*^9, 
   3.8617682678668547`*^9}, 3.861940907625001*^9, {3.861941874731223*^9, 
   3.8619418752572*^9}, {3.863686273326891*^9, 3.86368627384243*^9}, 
   3.863687238834276*^9, {3.8895154361670246`*^9, 3.889515452084921*^9}, {
   3.889672427830373*^9, 3.8896724458079796`*^9}, {3.8896763888939342`*^9, 
   3.8896765605915513`*^9}, 3.889676629643072*^9, {3.88967679120571*^9, 
   3.88967681543388*^9}, {3.889676858823769*^9, 3.889676888283419*^9}, {
   3.8926137291399455`*^9, 3.8926137292831807`*^9}, 3.902042275559038*^9, {
   3.902042306429104*^9, 3.9020423363791375`*^9}, {3.9023894250958447`*^9, 
   3.902389439127889*^9}, 3.9035921080605135`*^9, {3.903592180668458*^9, 
   3.9035922069356966`*^9}, {3.9040348060931754`*^9, 3.904034806250553*^9}},
 CellLabel->
  "In[189]:=",ExpressionUUID->"8edd1d77-e6da-4feb-ad70-9ef9a39ee410"],

Cell[BoxData[
 GraphicsBox[{{{
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-5.123034184766466, -0.2201218571656044}, \
{-5.123034184766466, -0.17098429098736334`}}], 
         LineBox[{{-5.123034184766466, -0.17098429098736334`}, \
{-5.123034184766466, -0.12184672480912229`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.967181077761888, -0.176781163057047}, \
{-4.967181077761888, -0.14757731323541276`}}], 
         LineBox[{{-4.967181077761888, -0.14757731323541276`}, \
{-4.967181077761888, -0.11837346341377852`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.818856286804701, -0.15018532766785203`}, \
{-4.818856286804701, -0.1282870690857387}}], 
         LineBox[{{-4.818856286804701, -0.1282870690857387}, \
{-4.818856286804701, -0.10638881050362536`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.670013501954605, -0.17001545012026967`}, \
{-4.670013501954605, -0.14961519000368198`}}], 
         LineBox[{{-4.670013501954605, -0.14961519000368198`}, \
{-4.670013501954605, -0.1292149298870943}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.519680258799651, -0.18900525602334892`}, \
{-4.519680258799651, -0.1621621415555407}}], 
         LineBox[{{-4.519680258799651, -0.1621621415555407}, \
{-4.519680258799651, -0.1353190270877325}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.371140329140415, -0.32555401659982774`}, \
{-4.371140329140415, -0.2872357787037704}}], 
         LineBox[{{-4.371140329140415, -0.2872357787037704}, \
{-4.371140329140415, -0.24891754080771297`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.224058037685349, -0.5478951323923785}, \
{-4.224058037685349, -0.493391598357171}}], 
         LineBox[{{-4.224058037685349, -0.493391598357171}, \
{-4.224058037685349, -0.4388880643219635}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.074108840082289, -0.8102632402461973}, \
{-4.074108840082289, -0.7332012136118203}}], 
         LineBox[{{-4.074108840082289, -0.7332012136118203}, \
{-4.074108840082289, -0.6561391869774433}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.922067600553084, -1.1834024282247162`}, \
{-3.922067600553084, -1.0861657639052011`}}], 
         LineBox[{{-3.922067600553084, -1.0861657639052011`}, \
{-3.922067600553084, -0.9889290995856862}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.7720092973771315`, -1.7009548810049169`}, \
{-3.7720092973771315`, -1.5827297167877001`}}], 
         LineBox[{{-3.7720092973771315`, -1.5827297167877001`}, \
{-3.7720092973771315`, -1.4645045525704834`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.6229039399776495`, -2.097751169745222}, \
{-3.6229039399776495`, -1.9628236867910245`}}], 
         LineBox[{{-3.6229039399776495`, -1.9628236867910245`}, \
{-3.6229039399776495`, -1.827896203836827}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.473107630425919, -2.356582100442014}, \
{-3.473107630425919, -2.2163982631409476`}}], 
         LineBox[{{-3.473107630425919, -2.2163982631409476`}, \
{-3.473107630425919, -2.076214425839881}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.322443366822524, -2.425942626780616}, \
{-3.322443366822524, -2.2911697747995206`}}], 
         LineBox[{{-3.322443366822524, -2.2911697747995206`}, \
{-3.322443366822524, -2.156396922818425}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.1718741504045256`, -2.2909018354938744`}, \
{-3.1718741504045256`, -2.170309655252529}}], 
         LineBox[{{-3.1718741504045256`, -2.170309655252529}, \
{-3.1718741504045256`, -2.049717475011184}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.02130909833606, -2.0895067971516395`}, \
{-3.02130909833606, -1.9857159250162983`}}], 
         LineBox[{{-3.02130909833606, -1.9857159250162983`}, \
{-3.02130909833606, -1.8819250528809572`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.87096894506321, -2.057845897067193}, \
{-2.87096894506321, -1.9611043104181256`}}], 
         LineBox[{{-2.87096894506321, -1.9611043104181256`}, \
{-2.87096894506321, -1.8643627237690585`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.721145075876202, -2.1715563954129795`}, \
{-2.721145075876202, -2.0791450770119213`}}], 
         LineBox[{{-2.721145075876202, -2.0791450770119213`}, \
{-2.721145075876202, -1.986733758610863}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.5709963488539205`, -2.1896091499144523`}, \
{-2.5709963488539205`, -2.103772429483101}}], 
         LineBox[{{-2.5709963488539205`, -2.103772429483101}, \
{-2.5709963488539205`, -2.0179357090517493`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.4211353388266255`, -2.185654604318142}, \
{-2.4211353388266255`, -2.105039951029776}}], 
         LineBox[{{-2.4211353388266255`, -2.105039951029776}, \
{-2.4211353388266255`, -2.0244252977414097`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.2716139079969997`, -2.2244294199012034`}, \
{-2.2716139079969997`, -2.148025053063049}}], 
         LineBox[{{-2.2716139079969997`, -2.148025053063049}, \
{-2.2716139079969997`, -2.071620686224895}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.1254341200141758`, -2.277943810904531}, \
{-2.1254341200141758`, -2.203594972823604}}], 
         LineBox[{{-2.1254341200141758`, -2.203594972823604}, \
{-2.1254341200141758`, -2.129246134742677}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.9755948746527598`, -2.2949941384160324`}, \
{-1.9755948746527598`, -2.1942510768893886`}}], 
         LineBox[{{-1.9755948746527598`, -2.1942510768893886`}, \
{-1.9755948746527598`, -2.093508015362745}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.8216071914518728`, -2.4660845955425614`}, \
{-1.8216071914518728`, -2.3396092299298012`}}], 
         LineBox[{{-1.8216071914518728`, -2.3396092299298012`}, \
{-1.8216071914518728`, -2.213133864317041}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.671138824657271, -2.5184538185623238`}, \
{-1.671138824657271, -2.399580234013731}}], 
         LineBox[{{-1.671138824657271, -2.399580234013731}, \
{-1.671138824657271, -2.280706649465138}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.5213321583671762`, -2.5845574439902155`}, \
{-1.5213321583671762`, -2.471129661921223}}], 
         LineBox[{{-1.5213321583671762`, -2.471129661921223}, \
{-1.5213321583671762`, -2.3577018798522307`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.3715137632177803`, -2.685229211964117}, \
{-1.3715137632177803`, -2.5767879400320886`}}], 
         LineBox[{{-1.3715137632177803`, -2.5767879400320886`}, \
{-1.3715137632177803`, -2.46834666810006}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.2213807164489634`, -2.7873424182059408`}, \
{-1.2213807164489634`, -2.6831786444651864`}}], 
         LineBox[{{-1.2213807164489634`, -2.6831786444651864`}, \
{-1.2213807164489634`, -2.579014870724432}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.0874991910481322`, -3.05085060958091}, \
{-1.0874991910481322`, -2.884358495879268}}], 
         LineBox[{{-1.0874991910481322`, -2.884358495879268}, \
{-1.0874991910481322`, -2.7178663821776263`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-0.9374071571979093, -3.6671230315412506`}, \
{-0.9374071571979093, -3.468656271293329}}], 
         LineBox[{{-0.9374071571979093, -3.468656271293329}, \
{-0.9374071571979093, -3.270189511045407}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-0.7720464422576496, -4.211117633842184}, \
{-0.7720464422576496, -3.888046555607982}}], 
         LineBox[{{-0.7720464422576496, -3.888046555607982}, \
{-0.7720464422576496, -3.56497547737378}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-0.6229189729343597, -4.906952708363342}, \
{-0.6229189729343597, -4.558019278340775}}], 
         LineBox[{{-0.6229189729343597, -4.558019278340775}, \
{-0.6229189729343597, -4.2090858483182085`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-0.47212320595543156`, -5.891916706460125}, \
{-0.47212320595543156`, -5.503539689314685}}], 
         LineBox[{{-0.47212320595543156`, -5.503539689314685}, \
{-0.47212320595543156`, -5.115162672169245}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-0.32110780271295286`, -6.948999555603375}, \
{-0.32110780271295286`, -6.5267290454480005`}}], 
         LineBox[{{-0.32110780271295286`, -6.5267290454480005`}, \
{-0.32110780271295286`, -6.104458535292626}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-0.1710807924853121, -6.654775494566006}, \
{-0.1710807924853121, -6.280186003034156}}], 
         LineBox[{{-0.1710807924853121, -6.280186003034156}, \
{-0.1710807924853121, -5.9055965115023055`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-0.02171441970671745, -3.1265965042194073`}, \
{-0.02171441970671745, -2.911136662109476}}], 
         LineBox[{{-0.02171441970671745, -2.911136662109476}, \
{-0.02171441970671745, -2.695676819999545}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{0.12818230659515714`, -0.7161553215235539}, {
          0.12818230659515714`, -0.6624026803163366}}], 
         LineBox[{{0.12818230659515714`, -0.6624026803163366}, {
          0.12818230659515714`, -0.6086500391091194}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{0.27837926332300866`, -1.8845065204355744`}, {
          0.27837926332300866`, -1.7840618704475313`}}], 
         LineBox[{{0.27837926332300866`, -1.7840618704475313`}, {
          0.27837926332300866`, -1.6836172204594881`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{0.4286507618355071, -3.826109491016144}, {
          0.4286507618355071, -3.6644574164066284`}}], 
         LineBox[{{0.4286507618355071, -3.6644574164066284`}, {
          0.4286507618355071, -3.502805341797113}}]}},
       Antialiasing->False]}}, {
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-5.123034184766466, -0.12184672480912229`}, 
            Offset[{3, 
             0}, {-5.123034184766466, -0.12184672480912229`}]}, \
{{-5.123034184766466, -0.12184672480912229`}, 
            Offset[{-3, 
             0}, {-5.123034184766466, -0.12184672480912229`}]}, \
{{-5.123034184766466, -0.2201218571656044}, 
            Offset[{3, 
             0}, {-5.123034184766466, -0.2201218571656044}]}, \
{{-5.123034184766466, -0.2201218571656044}, 
            Offset[{-3, 0}, {-5.123034184766466, -0.2201218571656044}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.967181077761888, -0.11837346341377852`}, 
            Offset[{3, 
             0}, {-4.967181077761888, -0.11837346341377852`}]}, \
{{-4.967181077761888, -0.11837346341377852`}, 
            Offset[{-3, 
             0}, {-4.967181077761888, -0.11837346341377852`}]}, \
{{-4.967181077761888, -0.176781163057047}, 
            Offset[{3, 
             0}, {-4.967181077761888, -0.176781163057047}]}, \
{{-4.967181077761888, -0.176781163057047}, 
            Offset[{-3, 0}, {-4.967181077761888, -0.176781163057047}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.818856286804701, -0.10638881050362536`}, 
            Offset[{3, 
             0}, {-4.818856286804701, -0.10638881050362536`}]}, \
{{-4.818856286804701, -0.10638881050362536`}, 
            Offset[{-3, 
             0}, {-4.818856286804701, -0.10638881050362536`}]}, \
{{-4.818856286804701, -0.15018532766785203`}, 
            Offset[{3, 
             0}, {-4.818856286804701, -0.15018532766785203`}]}, \
{{-4.818856286804701, -0.15018532766785203`}, 
            Offset[{-3, 
             0}, {-4.818856286804701, -0.15018532766785203`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.670013501954605, -0.1292149298870943}, 
            Offset[{3, 
             0}, {-4.670013501954605, -0.1292149298870943}]}, \
{{-4.670013501954605, -0.1292149298870943}, 
            Offset[{-3, 
             0}, {-4.670013501954605, -0.1292149298870943}]}, \
{{-4.670013501954605, -0.17001545012026967`}, 
            Offset[{3, 
             0}, {-4.670013501954605, -0.17001545012026967`}]}, \
{{-4.670013501954605, -0.17001545012026967`}, 
            Offset[{-3, 
             0}, {-4.670013501954605, -0.17001545012026967`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.519680258799651, -0.1353190270877325}, 
            Offset[{3, 
             0}, {-4.519680258799651, -0.1353190270877325}]}, \
{{-4.519680258799651, -0.1353190270877325}, 
            Offset[{-3, 
             0}, {-4.519680258799651, -0.1353190270877325}]}, \
{{-4.519680258799651, -0.18900525602334892`}, 
            Offset[{3, 
             0}, {-4.519680258799651, -0.18900525602334892`}]}, \
{{-4.519680258799651, -0.18900525602334892`}, 
            Offset[{-3, 
             0}, {-4.519680258799651, -0.18900525602334892`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.371140329140415, -0.24891754080771297`}, 
            Offset[{3, 
             0}, {-4.371140329140415, -0.24891754080771297`}]}, \
{{-4.371140329140415, -0.24891754080771297`}, 
            Offset[{-3, 
             0}, {-4.371140329140415, -0.24891754080771297`}]}, \
{{-4.371140329140415, -0.32555401659982774`}, 
            Offset[{3, 
             0}, {-4.371140329140415, -0.32555401659982774`}]}, \
{{-4.371140329140415, -0.32555401659982774`}, 
            Offset[{-3, 
             0}, {-4.371140329140415, -0.32555401659982774`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.224058037685349, -0.4388880643219635}, 
            Offset[{3, 
             0}, {-4.224058037685349, -0.4388880643219635}]}, \
{{-4.224058037685349, -0.4388880643219635}, 
            Offset[{-3, 
             0}, {-4.224058037685349, -0.4388880643219635}]}, \
{{-4.224058037685349, -0.5478951323923785}, 
            Offset[{3, 
             0}, {-4.224058037685349, -0.5478951323923785}]}, \
{{-4.224058037685349, -0.5478951323923785}, 
            Offset[{-3, 0}, {-4.224058037685349, -0.5478951323923785}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.074108840082289, -0.6561391869774433}, 
            Offset[{3, 
             0}, {-4.074108840082289, -0.6561391869774433}]}, \
{{-4.074108840082289, -0.6561391869774433}, 
            Offset[{-3, 
             0}, {-4.074108840082289, -0.6561391869774433}]}, \
{{-4.074108840082289, -0.8102632402461973}, 
            Offset[{3, 
             0}, {-4.074108840082289, -0.8102632402461973}]}, \
{{-4.074108840082289, -0.8102632402461973}, 
            Offset[{-3, 0}, {-4.074108840082289, -0.8102632402461973}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.922067600553084, -0.9889290995856862}, 
            Offset[{3, 
             0}, {-3.922067600553084, -0.9889290995856862}]}, \
{{-3.922067600553084, -0.9889290995856862}, 
            Offset[{-3, 
             0}, {-3.922067600553084, -0.9889290995856862}]}, \
{{-3.922067600553084, -1.1834024282247162`}, 
            Offset[{3, 
             0}, {-3.922067600553084, -1.1834024282247162`}]}, \
{{-3.922067600553084, -1.1834024282247162`}, 
            Offset[{-3, 
             0}, {-3.922067600553084, -1.1834024282247162`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.7720092973771315`, -1.4645045525704834`}, 
            Offset[{3, 
             0}, {-3.7720092973771315`, -1.4645045525704834`}]}, \
{{-3.7720092973771315`, -1.4645045525704834`}, 
            Offset[{-3, 
             0}, {-3.7720092973771315`, -1.4645045525704834`}]}, \
{{-3.7720092973771315`, -1.7009548810049169`}, 
            Offset[{3, 
             0}, {-3.7720092973771315`, -1.7009548810049169`}]}, \
{{-3.7720092973771315`, -1.7009548810049169`}, 
            Offset[{-3, 
             0}, {-3.7720092973771315`, -1.7009548810049169`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.6229039399776495`, -1.827896203836827}, 
            Offset[{3, 
             0}, {-3.6229039399776495`, -1.827896203836827}]}, \
{{-3.6229039399776495`, -1.827896203836827}, 
            Offset[{-3, 
             0}, {-3.6229039399776495`, -1.827896203836827}]}, \
{{-3.6229039399776495`, -2.097751169745222}, 
            Offset[{3, 
             0}, {-3.6229039399776495`, -2.097751169745222}]}, \
{{-3.6229039399776495`, -2.097751169745222}, 
            Offset[{-3, 
             0}, {-3.6229039399776495`, -2.097751169745222}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.473107630425919, -2.076214425839881}, 
            Offset[{3, 
             0}, {-3.473107630425919, -2.076214425839881}]}, \
{{-3.473107630425919, -2.076214425839881}, 
            Offset[{-3, 
             0}, {-3.473107630425919, -2.076214425839881}]}, \
{{-3.473107630425919, -2.356582100442014}, 
            Offset[{3, 
             0}, {-3.473107630425919, -2.356582100442014}]}, \
{{-3.473107630425919, -2.356582100442014}, 
            Offset[{-3, 0}, {-3.473107630425919, -2.356582100442014}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.322443366822524, -2.156396922818425}, 
            Offset[{3, 
             0}, {-3.322443366822524, -2.156396922818425}]}, \
{{-3.322443366822524, -2.156396922818425}, 
            Offset[{-3, 
             0}, {-3.322443366822524, -2.156396922818425}]}, \
{{-3.322443366822524, -2.425942626780616}, 
            Offset[{3, 
             0}, {-3.322443366822524, -2.425942626780616}]}, \
{{-3.322443366822524, -2.425942626780616}, 
            Offset[{-3, 0}, {-3.322443366822524, -2.425942626780616}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.1718741504045256`, -2.049717475011184}, 
            Offset[{3, 
             0}, {-3.1718741504045256`, -2.049717475011184}]}, \
{{-3.1718741504045256`, -2.049717475011184}, 
            Offset[{-3, 
             0}, {-3.1718741504045256`, -2.049717475011184}]}, \
{{-3.1718741504045256`, -2.2909018354938744`}, 
            Offset[{3, 
             0}, {-3.1718741504045256`, -2.2909018354938744`}]}, \
{{-3.1718741504045256`, -2.2909018354938744`}, 
            Offset[{-3, 
             0}, {-3.1718741504045256`, -2.2909018354938744`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.02130909833606, -1.8819250528809572`}, 
            Offset[{3, 
             0}, {-3.02130909833606, -1.8819250528809572`}]}, \
{{-3.02130909833606, -1.8819250528809572`}, 
            Offset[{-3, 
             0}, {-3.02130909833606, -1.8819250528809572`}]}, \
{{-3.02130909833606, -2.0895067971516395`}, 
            Offset[{3, 
             0}, {-3.02130909833606, -2.0895067971516395`}]}, \
{{-3.02130909833606, -2.0895067971516395`}, 
            Offset[{-3, 0}, {-3.02130909833606, -2.0895067971516395`}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.87096894506321, -1.8643627237690585`}, 
            Offset[{3, 
             0}, {-2.87096894506321, -1.8643627237690585`}]}, \
{{-2.87096894506321, -1.8643627237690585`}, 
            Offset[{-3, 
             0}, {-2.87096894506321, -1.8643627237690585`}]}, \
{{-2.87096894506321, -2.057845897067193}, 
            Offset[{3, 
             0}, {-2.87096894506321, -2.057845897067193}]}, \
{{-2.87096894506321, -2.057845897067193}, 
            Offset[{-3, 0}, {-2.87096894506321, -2.057845897067193}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.721145075876202, -1.986733758610863}, 
            Offset[{3, 
             0}, {-2.721145075876202, -1.986733758610863}]}, \
{{-2.721145075876202, -1.986733758610863}, 
            Offset[{-3, 
             0}, {-2.721145075876202, -1.986733758610863}]}, \
{{-2.721145075876202, -2.1715563954129795`}, 
            Offset[{3, 
             0}, {-2.721145075876202, -2.1715563954129795`}]}, \
{{-2.721145075876202, -2.1715563954129795`}, 
            Offset[{-3, 
             0}, {-2.721145075876202, -2.1715563954129795`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.5709963488539205`, -2.0179357090517493`}, 
            Offset[{3, 
             0}, {-2.5709963488539205`, -2.0179357090517493`}]}, \
{{-2.5709963488539205`, -2.0179357090517493`}, 
            Offset[{-3, 
             0}, {-2.5709963488539205`, -2.0179357090517493`}]}, \
{{-2.5709963488539205`, -2.1896091499144523`}, 
            Offset[{3, 
             0}, {-2.5709963488539205`, -2.1896091499144523`}]}, \
{{-2.5709963488539205`, -2.1896091499144523`}, 
            Offset[{-3, 
             0}, {-2.5709963488539205`, -2.1896091499144523`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.4211353388266255`, -2.0244252977414097`}, 
            Offset[{3, 
             0}, {-2.4211353388266255`, -2.0244252977414097`}]}, \
{{-2.4211353388266255`, -2.0244252977414097`}, 
            Offset[{-3, 
             0}, {-2.4211353388266255`, -2.0244252977414097`}]}, \
{{-2.4211353388266255`, -2.185654604318142}, 
            Offset[{3, 
             0}, {-2.4211353388266255`, -2.185654604318142}]}, \
{{-2.4211353388266255`, -2.185654604318142}, 
            Offset[{-3, 
             0}, {-2.4211353388266255`, -2.185654604318142}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.2716139079969997`, -2.071620686224895}, 
            Offset[{3, 
             0}, {-2.2716139079969997`, -2.071620686224895}]}, \
{{-2.2716139079969997`, -2.071620686224895}, 
            Offset[{-3, 
             0}, {-2.2716139079969997`, -2.071620686224895}]}, \
{{-2.2716139079969997`, -2.2244294199012034`}, 
            Offset[{3, 
             0}, {-2.2716139079969997`, -2.2244294199012034`}]}, \
{{-2.2716139079969997`, -2.2244294199012034`}, 
            Offset[{-3, 
             0}, {-2.2716139079969997`, -2.2244294199012034`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.1254341200141758`, -2.129246134742677}, 
            Offset[{3, 
             0}, {-2.1254341200141758`, -2.129246134742677}]}, \
{{-2.1254341200141758`, -2.129246134742677}, 
            Offset[{-3, 
             0}, {-2.1254341200141758`, -2.129246134742677}]}, \
{{-2.1254341200141758`, -2.277943810904531}, 
            Offset[{3, 
             0}, {-2.1254341200141758`, -2.277943810904531}]}, \
{{-2.1254341200141758`, -2.277943810904531}, 
            Offset[{-3, 
             0}, {-2.1254341200141758`, -2.277943810904531}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.9755948746527598`, -2.093508015362745}, 
            Offset[{3, 
             0}, {-1.9755948746527598`, -2.093508015362745}]}, \
{{-1.9755948746527598`, -2.093508015362745}, 
            Offset[{-3, 
             0}, {-1.9755948746527598`, -2.093508015362745}]}, \
{{-1.9755948746527598`, -2.2949941384160324`}, 
            Offset[{3, 
             0}, {-1.9755948746527598`, -2.2949941384160324`}]}, \
{{-1.9755948746527598`, -2.2949941384160324`}, 
            Offset[{-3, 
             0}, {-1.9755948746527598`, -2.2949941384160324`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.8216071914518728`, -2.213133864317041}, 
            Offset[{3, 
             0}, {-1.8216071914518728`, -2.213133864317041}]}, \
{{-1.8216071914518728`, -2.213133864317041}, 
            Offset[{-3, 
             0}, {-1.8216071914518728`, -2.213133864317041}]}, \
{{-1.8216071914518728`, -2.4660845955425614`}, 
            Offset[{3, 
             0}, {-1.8216071914518728`, -2.4660845955425614`}]}, \
{{-1.8216071914518728`, -2.4660845955425614`}, 
            Offset[{-3, 
             0}, {-1.8216071914518728`, -2.4660845955425614`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.671138824657271, -2.280706649465138}, 
            Offset[{3, 
             0}, {-1.671138824657271, -2.280706649465138}]}, \
{{-1.671138824657271, -2.280706649465138}, 
            Offset[{-3, 
             0}, {-1.671138824657271, -2.280706649465138}]}, \
{{-1.671138824657271, -2.5184538185623238`}, 
            Offset[{3, 
             0}, {-1.671138824657271, -2.5184538185623238`}]}, \
{{-1.671138824657271, -2.5184538185623238`}, 
            Offset[{-3, 
             0}, {-1.671138824657271, -2.5184538185623238`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.5213321583671762`, -2.3577018798522307`}, 
            Offset[{3, 
             0}, {-1.5213321583671762`, -2.3577018798522307`}]}, \
{{-1.5213321583671762`, -2.3577018798522307`}, 
            Offset[{-3, 
             0}, {-1.5213321583671762`, -2.3577018798522307`}]}, \
{{-1.5213321583671762`, -2.5845574439902155`}, 
            Offset[{3, 
             0}, {-1.5213321583671762`, -2.5845574439902155`}]}, \
{{-1.5213321583671762`, -2.5845574439902155`}, 
            Offset[{-3, 
             0}, {-1.5213321583671762`, -2.5845574439902155`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.3715137632177803`, -2.46834666810006}, 
            Offset[{3, 
             0}, {-1.3715137632177803`, -2.46834666810006}]}, \
{{-1.3715137632177803`, -2.46834666810006}, 
            Offset[{-3, 
             0}, {-1.3715137632177803`, -2.46834666810006}]}, \
{{-1.3715137632177803`, -2.685229211964117}, 
            Offset[{3, 
             0}, {-1.3715137632177803`, -2.685229211964117}]}, \
{{-1.3715137632177803`, -2.685229211964117}, 
            Offset[{-3, 
             0}, {-1.3715137632177803`, -2.685229211964117}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.2213807164489634`, -2.579014870724432}, 
            Offset[{3, 
             0}, {-1.2213807164489634`, -2.579014870724432}]}, \
{{-1.2213807164489634`, -2.579014870724432}, 
            Offset[{-3, 
             0}, {-1.2213807164489634`, -2.579014870724432}]}, \
{{-1.2213807164489634`, -2.7873424182059408`}, 
            Offset[{3, 
             0}, {-1.2213807164489634`, -2.7873424182059408`}]}, \
{{-1.2213807164489634`, -2.7873424182059408`}, 
            Offset[{-3, 
             0}, {-1.2213807164489634`, -2.7873424182059408`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.0874991910481322`, -2.7178663821776263`}, 
            Offset[{3, 
             0}, {-1.0874991910481322`, -2.7178663821776263`}]}, \
{{-1.0874991910481322`, -2.7178663821776263`}, 
            Offset[{-3, 
             0}, {-1.0874991910481322`, -2.7178663821776263`}]}, \
{{-1.0874991910481322`, -3.05085060958091}, 
            Offset[{3, 
             0}, {-1.0874991910481322`, -3.05085060958091}]}, \
{{-1.0874991910481322`, -3.05085060958091}, 
            Offset[{-3, 0}, {-1.0874991910481322`, -3.05085060958091}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-0.9374071571979093, -3.270189511045407}, 
            Offset[{3, 
             0}, {-0.9374071571979093, -3.270189511045407}]}, \
{{-0.9374071571979093, -3.270189511045407}, 
            Offset[{-3, 
             0}, {-0.9374071571979093, -3.270189511045407}]}, \
{{-0.9374071571979093, -3.6671230315412506`}, 
            Offset[{3, 
             0}, {-0.9374071571979093, -3.6671230315412506`}]}, \
{{-0.9374071571979093, -3.6671230315412506`}, 
            Offset[{-3, 
             0}, {-0.9374071571979093, -3.6671230315412506`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-0.7720464422576496, -3.56497547737378}, 
            Offset[{3, 
             0}, {-0.7720464422576496, -3.56497547737378}]}, \
{{-0.7720464422576496, -3.56497547737378}, 
            Offset[{-3, 
             0}, {-0.7720464422576496, -3.56497547737378}]}, \
{{-0.7720464422576496, -4.211117633842184}, 
            Offset[{3, 
             0}, {-0.7720464422576496, -4.211117633842184}]}, \
{{-0.7720464422576496, -4.211117633842184}, 
            Offset[{-3, 0}, {-0.7720464422576496, -4.211117633842184}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-0.6229189729343597, -4.2090858483182085`}, 
            Offset[{3, 
             0}, {-0.6229189729343597, -4.2090858483182085`}]}, \
{{-0.6229189729343597, -4.2090858483182085`}, 
            Offset[{-3, 
             0}, {-0.6229189729343597, -4.2090858483182085`}]}, \
{{-0.6229189729343597, -4.906952708363342}, 
            Offset[{3, 
             0}, {-0.6229189729343597, -4.906952708363342}]}, \
{{-0.6229189729343597, -4.906952708363342}, 
            Offset[{-3, 0}, {-0.6229189729343597, -4.906952708363342}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-0.47212320595543156`, -5.115162672169245}, 
            Offset[{3, 
             0}, {-0.47212320595543156`, -5.115162672169245}]}, \
{{-0.47212320595543156`, -5.115162672169245}, 
            Offset[{-3, 
             0}, {-0.47212320595543156`, -5.115162672169245}]}, \
{{-0.47212320595543156`, -5.891916706460125}, 
            Offset[{3, 
             0}, {-0.47212320595543156`, -5.891916706460125}]}, \
{{-0.47212320595543156`, -5.891916706460125}, 
            Offset[{-3, 
             0}, {-0.47212320595543156`, -5.891916706460125}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-0.32110780271295286`, -6.104458535292626}, 
            Offset[{3, 
             0}, {-0.32110780271295286`, -6.104458535292626}]}, \
{{-0.32110780271295286`, -6.104458535292626}, 
            Offset[{-3, 
             0}, {-0.32110780271295286`, -6.104458535292626}]}, \
{{-0.32110780271295286`, -6.948999555603375}, 
            Offset[{3, 
             0}, {-0.32110780271295286`, -6.948999555603375}]}, \
{{-0.32110780271295286`, -6.948999555603375}, 
            Offset[{-3, 
             0}, {-0.32110780271295286`, -6.948999555603375}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-0.1710807924853121, -5.9055965115023055`}, 
            Offset[{3, 
             0}, {-0.1710807924853121, -5.9055965115023055`}]}, \
{{-0.1710807924853121, -5.9055965115023055`}, 
            Offset[{-3, 
             0}, {-0.1710807924853121, -5.9055965115023055`}]}, \
{{-0.1710807924853121, -6.654775494566006}, 
            Offset[{3, 
             0}, {-0.1710807924853121, -6.654775494566006}]}, \
{{-0.1710807924853121, -6.654775494566006}, 
            Offset[{-3, 0}, {-0.1710807924853121, -6.654775494566006}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-0.02171441970671745, -2.695676819999545}, 
            Offset[{3, 
             0}, {-0.02171441970671745, -2.695676819999545}]}, \
{{-0.02171441970671745, -2.695676819999545}, 
            Offset[{-3, 
             
             0}, {-0.02171441970671745, -2.695676819999545}]}, \
{{-0.02171441970671745, -3.1265965042194073`}, 
            Offset[{3, 
             0}, {-0.02171441970671745, -3.1265965042194073`}]}, \
{{-0.02171441970671745, -3.1265965042194073`}, 
            Offset[{-3, 
             0}, {-0.02171441970671745, -3.1265965042194073`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{0.12818230659515714`, -0.6086500391091194}, 
            Offset[{3, 0}, {0.12818230659515714`, -0.6086500391091194}]}, {{
            0.12818230659515714`, -0.6086500391091194}, 
            Offset[{-3, 0}, {0.12818230659515714`, -0.6086500391091194}]}, {{
            0.12818230659515714`, -0.7161553215235539}, 
            Offset[{3, 0}, {0.12818230659515714`, -0.7161553215235539}]}, {{
            0.12818230659515714`, -0.7161553215235539}, 
            Offset[{-3, 0}, {
             0.12818230659515714`, -0.7161553215235539}]}}], {{{1., 0.}, {0., 
          1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{0.27837926332300866`, -1.6836172204594881`}, 
            Offset[{3, 0}, {0.27837926332300866`, -1.6836172204594881`}]}, {{
            0.27837926332300866`, -1.6836172204594881`}, 
            Offset[{-3, 0}, {0.27837926332300866`, -1.6836172204594881`}]}, {{
            0.27837926332300866`, -1.8845065204355744`}, 
            Offset[{3, 0}, {0.27837926332300866`, -1.8845065204355744`}]}, {{
            0.27837926332300866`, -1.8845065204355744`}, 
            Offset[{-3, 0}, {
             0.27837926332300866`, -1.8845065204355744`}]}}], {{{1., 0.}, {0.,
           1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{0.4286507618355071, -3.502805341797113}, 
            Offset[{3, 0}, {0.4286507618355071, -3.502805341797113}]}, {{
            0.4286507618355071, -3.502805341797113}, 
            Offset[{-3, 0}, {0.4286507618355071, -3.502805341797113}]}, {{
            0.4286507618355071, -3.826109491016144}, 
            Offset[{3, 0}, {0.4286507618355071, -3.826109491016144}]}, {{
            0.4286507618355071, -3.826109491016144}, 
            Offset[{-3, 0}, {0.4286507618355071, -3.826109491016144}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}}}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJwBcQKO/SFib1JlAgAAACYAAAACAAAArnJfrPx9FMAQ0vUw0OLFv3owabdk
3hPAfyP9OtDjwr/+zC9DgkYTwE+JHO+1a8C/Bhj7BBiuEsBhewYulybDv26v
zw8nFBLA9q9Qo7rBxL/+id81DHwRwLqF8SwSYtK/3A5heG/lEMCDLMRaupPf
v+D9ETDjSxDAezU7ZGJ2578OnWj6ZGAPwIYfIFrvYPG/sIrjNRMtDsARK0Bl
3FL5v0YHlg+1+wzAOU5pz7ln/7/KVkGn7MgLwAXQOAMvuwHA3IQaMF2UCsDw
x6LRUFQCwC0f+I3/XwnAbAX8TstcAcBdr8MapCsIwFV20Q9+xf+/XQb3kL73
BsDQpdTprmD/v1J6pLXnxAXArT5r0BaiAMA3tKOIZpEEwODZtqOG1ADAFZpb
NHxeA8AVkpMvH9cAwA7jn+lDLALA2ydPwicvAcB+G5qa4wABwFVCr2b2oAHA
D3YMXwmc/78knzOC040BwHYbF5VNJf2/9b4/C4W3AsBmqW8Q/Lz6v2u8KR9X
MgPAT6SoY2BX+L98BNGg38QDwE6McGq48fW/+1HZ/kKdBMBF0JGBxorzv79t
el0mdwXApKY/jWVm8b/+7Q2MKhMHwHlxZks9/+2/RSny286/C8AYrI+9mrTo
vzhLDSe4Gg/AlfMZxfPu479rC9xnaTsSwFa4UEBEN96/2GCH6J8DFsCVH8m9
B43Uv7g14NteGxrA5l1ZtPnlxb+LUF8U6R4ZwNHG9wlOPJa/DZOvBAJKB8AD
Q2AfR2jAP5+5FxtnMuW/XNf2QffQ0T/Ezbl1hIv8v5RL35oDb9s/s2jIDM9Q
DcDu2DWn
      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-6.907755278982122, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Slope\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {{{
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontSize -> 14, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{-6.907755278982137, 0.6931471805599453}, {-8., 2.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->FrontEndValueCache[{
     Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
      15.954589770191003`, RotateLabel -> 0], 
     Automatic}, {{{-6.907755278982137, 
       FormBox["0.001`", TraditionalForm], {0.01, 0.}}, {-5.298317366548036, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.005\"", ShowStringCharacters -> False], 
          0.005`15.954589770191003, AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
       0.}}, {-4.605170185988091, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.010\"", ShowStringCharacters -> False], 
          0.01`15.954589770191003, AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
       0.}}, {-2.995732273553991, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.050\"", ShowStringCharacters -> False], 
          0.05`15.954589770191003, AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
       0.}}, {-2.3025850929940455`, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.100\"", ShowStringCharacters -> False], 
          0.1`15.954589770191003, AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
       0.}}, {-0.6931471805599453, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.500\"", ShowStringCharacters -> False], 
          0.5`15.954589770191003, AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 0.}}, {0., 
       FormBox["1", TraditionalForm], {0.01, 0.}}, {-7.600902459542082, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.418580902748128, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.264430222920869, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.1308988302963465`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.013115794639964, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-6.214608098422191, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-5.809142990314028, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-5.521460917862246, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-5.115995809754082, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-4.961845129926823, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-4.8283137373023015`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-4.710530701645918, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.912023005428146, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.506557897319982, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.2188758248682006`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.8134107167600364`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.659260036932778, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.5257286443082556`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.4079456086518722`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-1.6094379124341003`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-1.2039728043259361`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.916290731874155, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.5108256237659907, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.35667494393873245`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.2231435513142097, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.10536051565782628`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.6931471805599453, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.0986122886681098`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.3862943611198906`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.6094379124341003`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.791759469228055, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.9459101490553132`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.0794415416798357`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.1972245773362196`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.302585092994046, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.995732273553991, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      3.4011973816621555`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      3.6888794541139363`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      3.912023005428146, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}, 
     Automatic}]]], "Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, 3.891497449054066*^9, 
   3.891497575048091*^9, 3.891498633347803*^9, 3.8914990390695996`*^9, 
   3.892613730066387*^9, {3.8926137664245377`*^9, 3.8926137937077703`*^9}, {
   3.8926142852401514`*^9, 3.8926143002994194`*^9}, {3.892614340901927*^9, 
   3.892614358607253*^9}, 3.892614471834504*^9, 3.892696073832374*^9, 
   3.90203711736994*^9, 3.9020422080653267`*^9, 3.9020422780029826`*^9, {
   3.902042309103794*^9, 3.902042338473694*^9}, 3.9022934677601023`*^9, 
   3.902293500826844*^9, 3.902293816575324*^9, 3.9022962202790785`*^9, 
   3.902296689468522*^9, 3.9022975455583563`*^9, 3.9022976074891615`*^9, 
   3.902298382383033*^9, {3.9023894179597816`*^9, 3.9023894398366013`*^9}, 
   3.902486857817336*^9, 3.9034208138985806`*^9, 3.9035921090238457`*^9, {
   3.903592151434375*^9, 3.9035922076768627`*^9}, 3.904034476260992*^9, 
   3.9040349113126383`*^9, 3.9041104646597624`*^9, 3.9041239416824636`*^9},
 CellLabel->
  "Out[189]=",ExpressionUUID->"762e3694-c50e-4276-a960-5b5b5d3daf54"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2023-07_\
new_data\\\\Analysis\\\\E72 gibbsite - intensity \
weighted\\\\Slopes.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, 3.891497449054066*^9, 
   3.891497575048091*^9, 3.891498633347803*^9, 3.8914990390695996`*^9, 
   3.892613730066387*^9, {3.8926137664245377`*^9, 3.8926137937077703`*^9}, {
   3.8926142852401514`*^9, 3.8926143002994194`*^9}, {3.892614340901927*^9, 
   3.892614358607253*^9}, 3.892614471834504*^9, 3.892696073832374*^9, 
   3.90203711736994*^9, 3.9020422080653267`*^9, 3.9020422780029826`*^9, {
   3.902042309103794*^9, 3.902042338473694*^9}, 3.9022934677601023`*^9, 
   3.902293500826844*^9, 3.902293816575324*^9, 3.9022962202790785`*^9, 
   3.902296689468522*^9, 3.9022975455583563`*^9, 3.9022976074891615`*^9, 
   3.902298382383033*^9, {3.9023894179597816`*^9, 3.9023894398366013`*^9}, 
   3.902486857817336*^9, 3.9034208138985806`*^9, 3.9035921090238457`*^9, {
   3.903592151434375*^9, 3.9035922076768627`*^9}, 3.904034476260992*^9, 
   3.9040349113126383`*^9, 3.9041104646597624`*^9, 3.9041239429465237`*^9},
 CellLabel->
  "Out[190]=",ExpressionUUID->"f336c7d7-4e78-4a6c-93ed-c7c3b878c3da"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.005957918018034692`", ",", 
     InterpretationBox[
      TemplateBox[{"-0.17", "0.05"},
       "Around"],
      Around[-0.17098429098736334`, 0.04913756617824106]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.006962747841330222`", ",", 
     InterpretationBox[
      TemplateBox[{"-0.148", "0.029"},
       "Around"],
      Around[-0.14757731323541276`, 0.02920384982163423]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.008076018508007207`", ",", 
     InterpretationBox[
      TemplateBox[{"-0.128", "0.022"},
       "Around"],
      Around[-0.1282870690857387, 0.021898258582113337`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.009372142983902649`", ",", 
     InterpretationBox[
      TemplateBox[{"-0.150", "0.020"},
       "Around"],
      Around[-0.14961519000368198`, 0.020400260116587694`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.010892505894728777`", ",", 
     InterpretationBox[
      TemplateBox[{"-0.162", "0.027"},
       "Around"],
      Around[-0.1621621415555407, 0.026843114467808207`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.012636822212121306`", ",", 
     InterpretationBox[
      TemplateBox[{"-0.29", "0.04"},
       "Around"],
      Around[-0.2872357787037704, 0.03831823789605739]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.014639117714246157`", ",", 
     InterpretationBox[
      TemplateBox[{"-0.49", "0.05"},
       "Around"],
      Around[-0.493391598357171, 0.0545035340352075]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.01700736420692666`", ",", 
     InterpretationBox[
      TemplateBox[{"-0.73", "0.08"},
       "Around"],
      Around[-0.7332012136118203, 0.07706202663437699]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.019800113666751825`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.09", "0.10"},
       "Around"],
      Around[-1.0861657639052011`, 0.09723666431951494]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.023005791339544352`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.58", "0.12"},
       "Around"],
      Around[-1.5827297167877001`, 0.11822516421721671`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.026705014025810277`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.96", "0.13"},
       "Around"],
      Around[-1.9628236867910245`, 0.13492748295419757`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.031020480528580613`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.22", "0.14"},
       "Around"],
      Around[-2.2163982631409476`, 0.14018383730106648`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.03606460495351006`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.29", "0.13"},
       "Around"],
      Around[-2.2911697747995206`, 0.1347728519810953]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.041924950564934255`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.17", "0.12"},
       "Around"],
      Around[-2.170309655252529, 0.12059218024134526`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.04873737456627855`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.99", "0.10"},
       "Around"],
      Around[-1.9857159250162983`, 0.10379087213534108`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.056644015042275855`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.96", "0.10"},
       "Around"],
      Around[-1.9611043104181256`, 0.09674158664906711]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.06579936600522719`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.08", "0.09"},
       "Around"],
      Around[-2.0791450770119213`, 0.09241131840105817]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.07645932729717103`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.10", "0.09"},
       "Around"],
      Around[-2.103772429483101, 0.08583672043135136]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.08882071858260272`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.11", "0.08"},
       "Around"],
      Around[-2.105039951029776, 0.08061465328836613]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.10314557820569005`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.15", "0.08"},
       "Around"],
      Around[-2.148025053063049, 0.07640436683815442]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.11938113127739398`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.20", "0.07"},
       "Around"],
      Around[-2.203594972823604, 0.07434883808092706]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.1386787912027893`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.19", "0.10"},
       "Around"],
      Around[-2.1942510768893886`, 0.10074306152664388`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.1617655536814054`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.34", "0.13"},
       "Around"],
      Around[-2.3396092299298012`, 0.12647536561276013`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.18803280726325536`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.40", "0.12"},
       "Around"],
      Around[-2.399580234013731, 0.11887358454859279`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2184207220639411`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.47", "0.11"},
       "Around"],
      Around[-2.471129661921223, 0.11342778206899237`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2537225927775879`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.58", "0.11"},
       "Around"],
      Around[-2.5767879400320886`, 0.10844127193202839`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2948228190569755`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.68", "0.10"},
       "Around"],
      Around[-2.6831786444651864`, 0.10416377374075415`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.33705835915753324`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.88", "0.17"},
       "Around"],
      Around[-2.884358495879268, 0.16649211370164171`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.3916419861283247`", ",", 
     InterpretationBox[
      TemplateBox[{"-3.47", "0.20"},
       "Around"],
      Around[-3.468656271293329, 0.19846676024792187`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.46206650767357993`", ",", 
     InterpretationBox[
      TemplateBox[{"-3.89", "0.32"},
       "Around"],
      Around[-3.888046555607982, 0.32307107823420167`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5363764818646165`", ",", 
     InterpretationBox[
      TemplateBox[{"-4.56", "0.35"},
       "Around"],
      Around[-4.558019278340775, 0.3489334300225667]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6236766675042428`", ",", 
     InterpretationBox[
      TemplateBox[{"-5.5", "0.4"},
       "Around"],
      Around[-5.503539689314685, 0.38837701714544026`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7253450526107198`", ",", 
     InterpretationBox[
      TemplateBox[{"-6.5", "0.4"},
       "Around"],
      Around[-6.5267290454480005`, 0.4222705101553744]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.842753482572678`", ",", 
     InterpretationBox[
      TemplateBox[{"-6.3", "0.4"},
       "Around"],
      Around[-6.280186003034156, 0.37458949153184984`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9785196410789655`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.91", "0.22"},
       "Around"],
      Around[-2.911136662109476, 0.2154598421099312]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.1367602226934097`", ",", 
     InterpretationBox[
      TemplateBox[{"-0.66", "0.05"},
       "Around"],
      Around[-0.6624026803163366, 0.053752641207217206`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.3209871041740517`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.78", "0.10"},
       "Around"],
      Around[-1.7840618704475313`, 0.10044464998804321`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.5351847956450924`", ",", 
     InterpretationBox[
      TemplateBox[{"-3.66", "0.16"},
       "Around"],
      Around[-3.6644574164066284`, 0.16165207460951544`]]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, 3.891497449054066*^9, 
   3.891497575048091*^9, 3.891498633347803*^9, 3.8914990390695996`*^9, 
   3.892613730066387*^9, {3.8926137664245377`*^9, 3.8926137937077703`*^9}, {
   3.8926142852401514`*^9, 3.8926143002994194`*^9}, {3.892614340901927*^9, 
   3.892614358607253*^9}, 3.892614471834504*^9, 3.892696073832374*^9, 
   3.90203711736994*^9, 3.9020422080653267`*^9, 3.9020422780029826`*^9, {
   3.902042309103794*^9, 3.902042338473694*^9}, 3.9022934677601023`*^9, 
   3.902293500826844*^9, 3.902293816575324*^9, 3.9022962202790785`*^9, 
   3.902296689468522*^9, 3.9022975455583563`*^9, 3.9022976074891615`*^9, 
   3.902298382383033*^9, {3.9023894179597816`*^9, 3.9023894398366013`*^9}, 
   3.902486857817336*^9, 3.9034208138985806`*^9, 3.9035921090238457`*^9, {
   3.903592151434375*^9, 3.9035922076768627`*^9}, 3.904034476260992*^9, 
   3.9040349113126383`*^9, 3.9041104646597624`*^9, 3.904123942981962*^9},
 CellLabel->
  "Out[191]=",ExpressionUUID->"f04f4978-d720-42fe-a56d-43a27441a5b9"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2023-07_\
new_data\\\\Analysis\\\\E72 gibbsite - intensity weighted\\\\Sample \
playground LH-ESRF-E72 NEW SAXS slopes.csv\"\>"], "Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, 3.891497449054066*^9, 
   3.891497575048091*^9, 3.891498633347803*^9, 3.8914990390695996`*^9, 
   3.892613730066387*^9, {3.8926137664245377`*^9, 3.8926137937077703`*^9}, {
   3.8926142852401514`*^9, 3.8926143002994194`*^9}, {3.892614340901927*^9, 
   3.892614358607253*^9}, 3.892614471834504*^9, 3.892696073832374*^9, 
   3.90203711736994*^9, 3.9020422080653267`*^9, 3.9020422780029826`*^9, {
   3.902042309103794*^9, 3.902042338473694*^9}, 3.9022934677601023`*^9, 
   3.902293500826844*^9, 3.902293816575324*^9, 3.9022962202790785`*^9, 
   3.902296689468522*^9, 3.9022975455583563`*^9, 3.9022976074891615`*^9, 
   3.902298382383033*^9, {3.9023894179597816`*^9, 3.9023894398366013`*^9}, 
   3.902486857817336*^9, 3.9034208138985806`*^9, 3.9035921090238457`*^9, {
   3.903592151434375*^9, 3.9035922076768627`*^9}, 3.904034476260992*^9, 
   3.9040349113126383`*^9, 3.9041104646597624`*^9, 3.904123943172165*^9},
 CellLabel->
  "Out[193]=",ExpressionUUID->"f84c7ca4-b2ec-45f3-b904-000452a5b201"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2023-07_\
new_data\\\\Analysis\\\\E72 gibbsite - intensity weighted\\\\Sample \
playground LH-ESRF-E72 NEW.nb\"\>"], "Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, 3.891497449054066*^9, 
   3.891497575048091*^9, 3.891498633347803*^9, 3.8914990390695996`*^9, 
   3.892613730066387*^9, {3.8926137664245377`*^9, 3.8926137937077703`*^9}, {
   3.8926142852401514`*^9, 3.8926143002994194`*^9}, {3.892614340901927*^9, 
   3.892614358607253*^9}, 3.892614471834504*^9, 3.892696073832374*^9, 
   3.90203711736994*^9, 3.9020422080653267`*^9, 3.9020422780029826`*^9, {
   3.902042309103794*^9, 3.902042338473694*^9}, 3.9022934677601023`*^9, 
   3.902293500826844*^9, 3.902293816575324*^9, 3.9022962202790785`*^9, 
   3.902296689468522*^9, 3.9022975455583563`*^9, 3.9022976074891615`*^9, 
   3.902298382383033*^9, {3.9023894179597816`*^9, 3.9023894398366013`*^9}, 
   3.902486857817336*^9, 3.9034208138985806`*^9, 3.9035921090238457`*^9, {
   3.903592151434375*^9, 3.9035922076768627`*^9}, 3.904034476260992*^9, 
   3.9040349113126383`*^9, 3.9041104646597624`*^9, 3.9041239433165197`*^9},
 CellLabel->
  "Out[194]=",ExpressionUUID->"fd84d854-ec63-43a3-a536-4ba168e782a4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fitting slopes using L + R (thickness + radius)", "Subsubsection",
 CellChangeTimes->{{3.8890831159415197`*^9, 3.889083129907494*^9}, {
  3.8895043397252035`*^9, 
  3.889504346042064*^9}},ExpressionUUID->"c264222d-eedd-4632-bf2a-\
25682c9a5ec9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fitSlopeLRResult", "=", 
  RowBox[{"fitSlopeLR", "[", 
   RowBox[{
   "datamerged", ",", " ", "2", ",", " ", "0.2", ",", " ", "6", ",", " ", 
    "0.5"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8890831508560247`*^9, 3.889083186178582*^9}, {
  3.889083221328817*^9, 3.889083280853166*^9}, {3.890210231443339*^9, 
  3.8902102343651667`*^9}, {3.9041242295931053`*^9, 3.904124243817976*^9}},
 CellLabel->
  "In[221]:=",ExpressionUUID->"245caa09-fb84-4947-ab47-dd7c0b5b4707"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.9853134242942687`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.21843807908006596`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.996411215050442`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5103229813791272`"}],
  SequenceForm[
  "\[Mu]l = ", 1.9853134242942687`, " \[Sigma]l = ", 0.21843807908006596`, 
   " \[Mu]r = ", 5.996411215050442 " \[Sigma]r = ", 0.5103229813791272],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.902298398870573*^9, 3.9023894709517956`*^9, 
  3.9024869026176157`*^9, 3.902487076801288*^9, 3.903420828287627*^9, 
  3.903592314904027*^9, 3.9040345149899654`*^9, 3.904123955778119*^9, 
  3.9041242579941654`*^9},
 CellLabel->
  "During evaluation of \
In[221]:=",ExpressionUUID->"22262ffb-76cb-4e98-9a89-67975f72c171"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.9870307181432705`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.2093685175772237`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.995048027000268`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5142150432559603`"}],
  SequenceForm[
  "\[Mu]l = ", 1.9870307181432705`, " \[Sigma]l = ", 0.2093685175772237, 
   " \[Mu]r = ", 5.995048027000268 " \[Sigma]r = ", 0.5142150432559603],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.902298398870573*^9, 3.9023894709517956`*^9, 
  3.9024869026176157`*^9, 3.902487076801288*^9, 3.903420828287627*^9, 
  3.903592314904027*^9, 3.9040345149899654`*^9, 3.904123955778119*^9, 
  3.904124259960211*^9},
 CellLabel->
  "During evaluation of \
In[221]:=",ExpressionUUID->"1a000d7f-abd5-4fe2-8c7f-d6e41870f5d0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.9821233639750995`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.19662963809177147`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.988781395216772`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5321553780562863`"}],
  SequenceForm[
  "\[Mu]l = ", 1.9821233639750995`, " \[Sigma]l = ", 0.19662963809177147`, 
   " \[Mu]r = ", 5.988781395216772 " \[Sigma]r = ", 0.5321553780562863],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.902298398870573*^9, 3.9023894709517956`*^9, 
  3.9024869026176157`*^9, 3.902487076801288*^9, 3.903420828287627*^9, 
  3.903592314904027*^9, 3.9040345149899654`*^9, 3.904123955778119*^9, 
  3.904124261989401*^9},
 CellLabel->
  "During evaluation of \
In[221]:=",ExpressionUUID->"bca89c25-47e9-4812-b445-e38a36c9e4b7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.96850112193234`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.18641433314108274`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.976745577074058`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5666460275231785`"}],
  SequenceForm[
  "\[Mu]l = ", 1.96850112193234, " \[Sigma]l = ", 0.18641433314108274`, 
   " \[Mu]r = ", 5.976745577074058 " \[Sigma]r = ", 0.5666460275231785],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.902298398870573*^9, 3.9023894709517956`*^9, 
  3.9024869026176157`*^9, 3.902487076801288*^9, 3.903420828287627*^9, 
  3.903592314904027*^9, 3.9040345149899654`*^9, 3.904123955778119*^9, 
  3.904124264044343*^9},
 CellLabel->
  "During evaluation of \
In[221]:=",ExpressionUUID->"5f4868ca-431f-426b-855f-3d9cc2e6c295"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.9171041253435066`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.16404939741356828`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.929875639611761`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.70097427874194`"}],
  SequenceForm[
  "\[Mu]l = ", 1.9171041253435066`, " \[Sigma]l = ", 0.16404939741356828`, 
   " \[Mu]r = ", 5.929875639611761 " \[Sigma]r = ", 0.70097427874194],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.902298398870573*^9, 3.9023894709517956`*^9, 
  3.9024869026176157`*^9, 3.902487076801288*^9, 3.903420828287627*^9, 
  3.903592314904027*^9, 3.9040345149899654`*^9, 3.904123955778119*^9, 
  3.904124266235399*^9},
 CellLabel->
  "During evaluation of \
In[221]:=",ExpressionUUID->"dec86d4a-e812-47ea-9a88-f250588f9c16"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.9343848681365685`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.17578007644852497`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.936793231654844`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.6811020360951221`"}],
  SequenceForm[
  "\[Mu]l = ", 1.9343848681365685`, " \[Sigma]l = ", 0.17578007644852497`, 
   " \[Mu]r = ", 5.936793231654844 " \[Sigma]r = ", 0.6811020360951221],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.902298398870573*^9, 3.9023894709517956`*^9, 
  3.9024869026176157`*^9, 3.902487076801288*^9, 3.903420828287627*^9, 
  3.903592314904027*^9, 3.9040345149899654`*^9, 3.904123955778119*^9, 
  3.9041242686100216`*^9},
 CellLabel->
  "During evaluation of \
In[221]:=",ExpressionUUID->"0e468ec3-5b66-40b5-8efa-403b5483a5ba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.9460148894252935`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.18520047222572203`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.92633878789674`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.7104597016386509`"}],
  SequenceForm[
  "\[Mu]l = ", 1.9460148894252935`, " \[Sigma]l = ", 0.18520047222572203`, 
   " \[Mu]r = ", 5.92633878789674 " \[Sigma]r = ", 0.7104597016386509],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.902298398870573*^9, 3.9023894709517956`*^9, 
  3.9024869026176157`*^9, 3.902487076801288*^9, 3.903420828287627*^9, 
  3.903592314904027*^9, 3.9040345149899654`*^9, 3.904123955778119*^9, 
  3.9041242711120615`*^9},
 CellLabel->
  "During evaluation of \
In[221]:=",ExpressionUUID->"24326a90-30e9-486a-b4ee-0cb5e01dc035"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.9564827957428128`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.18836065947629207`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.9107964266712445`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.7533145512327919`"}],
  SequenceForm[
  "\[Mu]l = ", 1.9564827957428128`, " \[Sigma]l = ", 0.18836065947629207`, 
   " \[Mu]r = ", 5.9107964266712445` " \[Sigma]r = ", 0.7533145512327919],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.902298398870573*^9, 3.9023894709517956`*^9, 
  3.9024869026176157`*^9, 3.902487076801288*^9, 3.903420828287627*^9, 
  3.903592314904027*^9, 3.9040345149899654`*^9, 3.904123955778119*^9, 
  3.904124273645065*^9},
 CellLabel->
  "During evaluation of \
In[221]:=",ExpressionUUID->"c17593c2-964d-4190-812e-4018618b3eab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.959675994331508`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.1868893666092529`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.907062584511968`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.7622468202884057`"}],
  SequenceForm[
  "\[Mu]l = ", 1.959675994331508, " \[Sigma]l = ", 0.1868893666092529, 
   " \[Mu]r = ", 5.907062584511968 " \[Sigma]r = ", 0.7622468202884057],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.902298398870573*^9, 3.9023894709517956`*^9, 
  3.9024869026176157`*^9, 3.902487076801288*^9, 3.903420828287627*^9, 
  3.903592314904027*^9, 3.9040345149899654`*^9, 3.904123955778119*^9, 
  3.904124276029028*^9},
 CellLabel->
  "During evaluation of \
In[221]:=",ExpressionUUID->"0af0bc6a-beb4-4db7-b839-05fd8a644d3f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.9595255415096082`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.18552913815212557`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.905685433845725`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.7642581509363844`"}],
  SequenceForm[
  "\[Mu]l = ", 1.9595255415096082`, " \[Sigma]l = ", 0.18552913815212557`, 
   " \[Mu]r = ", 5.905685433845725 " \[Sigma]r = ", 0.7642581509363844],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.902298398870573*^9, 3.9023894709517956`*^9, 
  3.9024869026176157`*^9, 3.902487076801288*^9, 3.903420828287627*^9, 
  3.903592314904027*^9, 3.9040345149899654`*^9, 3.904123955778119*^9, 
  3.904124278326659*^9},
 CellLabel->
  "During evaluation of \
In[221]:=",ExpressionUUID->"9be8ed6c-d4bf-404d-a036-14481318a827"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.9589719748266503`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.1850906323580226`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.904881731742975`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.7647311427697535`"}],
  SequenceForm[
  "\[Mu]l = ", 1.9589719748266503`, " \[Sigma]l = ", 0.1850906323580226, 
   " \[Mu]r = ", 5.904881731742975 " \[Sigma]r = ", 0.7647311427697535],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.902298398870573*^9, 3.9023894709517956`*^9, 
  3.9024869026176157`*^9, 3.902487076801288*^9, 3.903420828287627*^9, 
  3.903592314904027*^9, 3.9040345149899654`*^9, 3.904123955778119*^9, 
  3.9041242806635633`*^9},
 CellLabel->
  "During evaluation of \
In[221]:=",ExpressionUUID->"971eedf7-5414-4922-8bdc-a14d044aba27"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.9579796834842442`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.18445147148027988`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.902682225265451`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.7651100704563217`"}],
  SequenceForm[
  "\[Mu]l = ", 1.9579796834842442`, " \[Sigma]l = ", 0.18445147148027988`, 
   " \[Mu]r = ", 5.902682225265451 " \[Sigma]r = ", 0.7651100704563217],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.902298398870573*^9, 3.9023894709517956`*^9, 
  3.9024869026176157`*^9, 3.902487076801288*^9, 3.903420828287627*^9, 
  3.903592314904027*^9, 3.9040345149899654`*^9, 3.904123955778119*^9, 
  3.9041242830099916`*^9},
 CellLabel->
  "During evaluation of \
In[221]:=",ExpressionUUID->"bde527b3-90ae-478e-bc6a-91c07d761b93"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.9567607100980324`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.18370152032670994`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.8977672641269985`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.7649273535008476`"}],
  SequenceForm[
  "\[Mu]l = ", 1.9567607100980324`, " \[Sigma]l = ", 0.18370152032670994`, 
   " \[Mu]r = ", 5.8977672641269985` " \[Sigma]r = ", 0.7649273535008476],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.902298398870573*^9, 3.9023894709517956`*^9, 
  3.9024869026176157`*^9, 3.902487076801288*^9, 3.903420828287627*^9, 
  3.903592314904027*^9, 3.9040345149899654`*^9, 3.904123955778119*^9, 
  3.9041242854875174`*^9},
 CellLabel->
  "During evaluation of \
In[221]:=",ExpressionUUID->"a5ccc910-1197-4673-b547-544335f83dae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.9545782902164823`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.18237960871012354`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.882386261168202`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.7628426869967257`"}],
  SequenceForm[
  "\[Mu]l = ", 1.9545782902164823`, " \[Sigma]l = ", 0.18237960871012354`, 
   " \[Mu]r = ", 5.882386261168202 " \[Sigma]r = ", 0.7628426869967257],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.902298398870573*^9, 3.9023894709517956`*^9, 
  3.9024869026176157`*^9, 3.902487076801288*^9, 3.903420828287627*^9, 
  3.903592314904027*^9, 3.9040345149899654`*^9, 3.904123955778119*^9, 
  3.904124287811364*^9},
 CellLabel->
  "During evaluation of \
In[221]:=",ExpressionUUID->"84dd4790-a9a6-4602-8f4b-6c5137bbeb87"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.9512616493932258`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.1804047511131258`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.841544685509312`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.7550380745774038`"}],
  SequenceForm[
  "\[Mu]l = ", 1.9512616493932258`, " \[Sigma]l = ", 0.1804047511131258, 
   " \[Mu]r = ", 5.841544685509312 " \[Sigma]r = ", 0.7550380745774038],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.902298398870573*^9, 3.9023894709517956`*^9, 
  3.9024869026176157`*^9, 3.902487076801288*^9, 3.903420828287627*^9, 
  3.903592314904027*^9, 3.9040345149899654`*^9, 3.904123955778119*^9, 
  3.9041242901971083`*^9},
 CellLabel->
  "During evaluation of \
In[221]:=",ExpressionUUID->"4dc69255-f523-461d-b6d8-874020ce1aa5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.945914189522858`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.17731912898331387`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.726847590269315`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.7292870409818477`"}],
  SequenceForm[
  "\[Mu]l = ", 1.945914189522858, " \[Sigma]l = ", 0.17731912898331387`, 
   " \[Mu]r = ", 5.726847590269315 " \[Sigma]r = ", 0.7292870409818477],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.902298398870573*^9, 3.9023894709517956`*^9, 
  3.9024869026176157`*^9, 3.902487076801288*^9, 3.903420828287627*^9, 
  3.903592314904027*^9, 3.9040345149899654`*^9, 3.904123955778119*^9, 
  3.904124292519653*^9},
 CellLabel->
  "During evaluation of \
In[221]:=",ExpressionUUID->"0bcfe795-7787-4848-ab8a-92bd9d9b1a5a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.9376528044163543`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.17287460043636724`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.412792572412896`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.6508717431637125`"}],
  SequenceForm[
  "\[Mu]l = ", 1.9376528044163543`, " \[Sigma]l = ", 0.17287460043636724`, 
   " \[Mu]r = ", 5.412792572412896 " \[Sigma]r = ", 0.6508717431637125],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.902298398870573*^9, 3.9023894709517956`*^9, 
  3.9024869026176157`*^9, 3.902487076801288*^9, 3.903420828287627*^9, 
  3.903592314904027*^9, 3.9040345149899654`*^9, 3.904123955778119*^9, 
  3.904124294833941*^9},
 CellLabel->
  "During evaluation of \
In[221]:=",ExpressionUUID->"dd911c8a-b913-4941-a33a-1470e57f3efb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.9336898530517272`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.17127138586669446`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.083334380358438`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5566412146684013`"}],
  SequenceForm[
  "\[Mu]l = ", 1.9336898530517272`, " \[Sigma]l = ", 0.17127138586669446`, 
   " \[Mu]r = ", 5.083334380358438 " \[Sigma]r = ", 0.5566412146684013],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.902298398870573*^9, 3.9023894709517956`*^9, 
  3.9024869026176157`*^9, 3.902487076801288*^9, 3.903420828287627*^9, 
  3.903592314904027*^9, 3.9040345149899654`*^9, 3.904123955778119*^9, 
  3.9041242994600563`*^9},
 CellLabel->
  "During evaluation of \
In[221]:=",ExpressionUUID->"5db5ed27-07eb-4521-8736-34c17a6c8503"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.9343077112477018`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.1727874805608981`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.768372555869459`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.44681211443914803`"}],
  SequenceForm[
  "\[Mu]l = ", 1.9343077112477018`, " \[Sigma]l = ", 0.1727874805608981, 
   " \[Mu]r = ", 4.768372555869459 " \[Sigma]r = ", 0.44681211443914803`],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.902298398870573*^9, 3.9023894709517956`*^9, 
  3.9024869026176157`*^9, 3.902487076801288*^9, 3.903420828287627*^9, 
  3.903592314904027*^9, 3.9040345149899654`*^9, 3.904123955778119*^9, 
  3.904124304074123*^9},
 CellLabel->
  "During evaluation of \
In[221]:=",ExpressionUUID->"4dc85b07-72ef-4ced-88cc-a01ee57eb4be"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.9471202466088506`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.18239166650016828`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.513102392497585`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.3030573134812009`"}],
  SequenceForm[
  "\[Mu]l = ", 1.9471202466088506`, " \[Sigma]l = ", 0.18239166650016828`, 
   " \[Mu]r = ", 4.513102392497585 " \[Sigma]r = ", 0.3030573134812009],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.902298398870573*^9, 3.9023894709517956`*^9, 
  3.9024869026176157`*^9, 3.902487076801288*^9, 3.903420828287627*^9, 
  3.903592314904027*^9, 3.9040345149899654`*^9, 3.904123955778119*^9, 
  3.904124306397891*^9},
 CellLabel->
  "During evaluation of \
In[221]:=",ExpressionUUID->"6958c986-f404-46ef-80ce-399965c07357"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.9816118144438994`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.20442974766610966`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.697812013927794`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.22663842825953023`"}],
  SequenceForm[
  "\[Mu]l = ", 1.9816118144438994`, " \[Sigma]l = ", 0.20442974766610966`, 
   " \[Mu]r = ", 4.697812013927794 " \[Sigma]r = ", 0.22663842825953023`],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.902298398870573*^9, 3.9023894709517956`*^9, 
  3.9024869026176157`*^9, 3.902487076801288*^9, 3.903420828287627*^9, 
  3.903592314904027*^9, 3.9040345149899654`*^9, 3.904123955778119*^9, 
  3.9041243087436633`*^9},
 CellLabel->
  "During evaluation of \
In[221]:=",ExpressionUUID->"504ade65-b71f-4ae5-911d-e14a77667f5d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.9721613645545877`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.19666904375689898`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.543773075641749`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.1857902804752714`"}],
  SequenceForm[
  "\[Mu]l = ", 1.9721613645545877`, " \[Sigma]l = ", 0.19666904375689898`, 
   " \[Mu]r = ", 4.543773075641749 " \[Sigma]r = ", 0.1857902804752714],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.902298398870573*^9, 3.9023894709517956`*^9, 
  3.9024869026176157`*^9, 3.902487076801288*^9, 3.903420828287627*^9, 
  3.903592314904027*^9, 3.9040345149899654`*^9, 3.904123955778119*^9, 
  3.9041243110635185`*^9},
 CellLabel->
  "During evaluation of \
In[221]:=",ExpressionUUID->"ca6915e7-1e8a-42df-96cd-b7aa1426ac04"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.965674450057659`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.19216575002537445`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.597074366854059`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.2039531805237011`"}],
  SequenceForm[
  "\[Mu]l = ", 1.965674450057659, " \[Sigma]l = ", 0.19216575002537445`, 
   " \[Mu]r = ", 4.597074366854059 " \[Sigma]r = ", 0.2039531805237011],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.902298398870573*^9, 3.9023894709517956`*^9, 
  3.9024869026176157`*^9, 3.902487076801288*^9, 3.903420828287627*^9, 
  3.903592314904027*^9, 3.9040345149899654`*^9, 3.904123955778119*^9, 
  3.904124313399207*^9},
 CellLabel->
  "During evaluation of \
In[221]:=",ExpressionUUID->"7fe6f5f5-2067-401e-b2a2-2eaba2ee01bf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.9644094625954718`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.1928325528922604`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.573835295282008`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.15398036052531083`"}],
  SequenceForm[
  "\[Mu]l = ", 1.9644094625954718`, " \[Sigma]l = ", 0.1928325528922604, 
   " \[Mu]r = ", 4.573835295282008 " \[Sigma]r = ", 0.15398036052531083`],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.902298398870573*^9, 3.9023894709517956`*^9, 
  3.9024869026176157`*^9, 3.902487076801288*^9, 3.903420828287627*^9, 
  3.903592314904027*^9, 3.9040345149899654`*^9, 3.904123955778119*^9, 
  3.904124315755191*^9},
 CellLabel->
  "During evaluation of \
In[221]:=",ExpressionUUID->"5bf67ea6-2b81-4581-bd8b-d7498c0135f2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.965189858501346`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.19250233384257717`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.561846589742049`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.14428666907551213`"}],
  SequenceForm[
  "\[Mu]l = ", 1.965189858501346, " \[Sigma]l = ", 0.19250233384257717`, 
   " \[Mu]r = ", 4.561846589742049 " \[Sigma]r = ", 0.14428666907551213`],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.902298398870573*^9, 3.9023894709517956`*^9, 
  3.9024869026176157`*^9, 3.902487076801288*^9, 3.903420828287627*^9, 
  3.903592314904027*^9, 3.9040345149899654`*^9, 3.904123955778119*^9, 
  3.904124318048455*^9},
 CellLabel->
  "During evaluation of \
In[221]:=",ExpressionUUID->"78eaee15-86bd-451f-8508-54b4c3b2c22b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.964998569358673`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.19261437183601865`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.565836816845075`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.14730526496002322`"}],
  SequenceForm[
  "\[Mu]l = ", 1.964998569358673, " \[Sigma]l = ", 0.19261437183601865`, 
   " \[Mu]r = ", 4.565836816845075 " \[Sigma]r = ", 0.14730526496002322`],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.902298398870573*^9, 3.9023894709517956`*^9, 
  3.9024869026176157`*^9, 3.902487076801288*^9, 3.903420828287627*^9, 
  3.903592314904027*^9, 3.9040345149899654`*^9, 3.904123955778119*^9, 
  3.904124320376772*^9},
 CellLabel->
  "During evaluation of \
In[221]:=",ExpressionUUID->"f65d1354-c442-4b17-8694-9961d39c6157"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.9649715872783438`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.19260825405227325`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.56555067541887`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.14715455308190784`"}],
  SequenceForm[
  "\[Mu]l = ", 1.9649715872783438`, " \[Sigma]l = ", 0.19260825405227325`, 
   " \[Mu]r = ", 4.56555067541887 " \[Sigma]r = ", 0.14715455308190784`],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.902298398870573*^9, 3.9023894709517956`*^9, 
  3.9024869026176157`*^9, 3.902487076801288*^9, 3.903420828287627*^9, 
  3.903592314904027*^9, 3.9040345149899654`*^9, 3.904123955778119*^9, 
  3.9041243227464952`*^9},
 CellLabel->
  "During evaluation of \
In[221]:=",ExpressionUUID->"aa8fd02a-0aff-4aad-b9f4-a61ee5adb8f2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.9649826177662206`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.19261002359303886`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.565592556554901`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.1471545435225505`"}],
  SequenceForm[
  "\[Mu]l = ", 1.9649826177662206`, " \[Sigma]l = ", 0.19261002359303886`, 
   " \[Mu]r = ", 4.565592556554901 " \[Sigma]r = ", 0.1471545435225505],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.902298398870573*^9, 3.9023894709517956`*^9, 
  3.9024869026176157`*^9, 3.902487076801288*^9, 3.903420828287627*^9, 
  3.903592314904027*^9, 3.9040345149899654`*^9, 3.904123955778119*^9, 
  3.9041243250853777`*^9},
 CellLabel->
  "During evaluation of \
In[221]:=",ExpressionUUID->"94339b8e-d5b1-4722-9563-24a49071791c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.9649819684576149`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.19260978461273723`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.565595437269363`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.1471592492948033`"}],
  SequenceForm[
  "\[Mu]l = ", 1.9649819684576149`, " \[Sigma]l = ", 0.19260978461273723`, 
   " \[Mu]r = ", 4.565595437269363 " \[Sigma]r = ", 0.1471592492948033],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.902298398870573*^9, 3.9023894709517956`*^9, 
  3.9024869026176157`*^9, 3.902487076801288*^9, 3.903420828287627*^9, 
  3.903592314904027*^9, 3.9040345149899654`*^9, 3.904123955778119*^9, 
  3.904124327442386*^9},
 CellLabel->
  "During evaluation of \
In[221]:=",ExpressionUUID->"950a2cb2-988e-40dc-800a-d22f59ca1261"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.964982016489735`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.1926098279551906`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.56559495674159`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.14715865133217096`"}],
  SequenceForm[
  "\[Mu]l = ", 1.964982016489735, " \[Sigma]l = ", 0.1926098279551906, 
   " \[Mu]r = ", 4.56559495674159 " \[Sigma]r = ", 0.14715865133217096`],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.902298398870573*^9, 3.9023894709517956`*^9, 
  3.9024869026176157`*^9, 3.902487076801288*^9, 3.903420828287627*^9, 
  3.903592314904027*^9, 3.9040345149899654`*^9, 3.904123955778119*^9, 
  3.9041243297434053`*^9},
 CellLabel->
  "During evaluation of \
In[221]:=",ExpressionUUID->"028e0274-c41b-4853-9a29-b24d102aff96"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "FindMinimum", "lstol", 
   "\"The line search decreased the step size to within the tolerance \
specified by AccuracyGoal and PrecisionGoal but was unable to find a \
sufficient decrease in the function. You may need more than \\!\\(\\*RowBox[{\
\\\"MachinePrecision\\\"}]\\) digits of working precision to meet these \
tolerances.\"", 2, 221, 16, 17038288483706631699, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.9024873626545725`*^9, 3.9034211313478656`*^9, 
  3.9035925803470507`*^9, 3.9040348419921074`*^9, 3.9041240091421905`*^9, 
  3.904124362904939*^9},
 CellLabel->
  "During evaluation of \
In[221]:=",ExpressionUUID->"65af52d8-e2f0-40e0-afec-00473164f161"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Mu]l", "\[Rule]", "1.9649820163962382`"}], ",", 
   RowBox[{"\[Sigma]l", "\[Rule]", "0.1926098278444925`"}], ",", 
   RowBox[{"\[Mu]r", "\[Rule]", "4.565594956472659`"}], ",", 
   RowBox[{"\[Sigma]r", "\[Rule]", "0.1471586508638847`"}], ",", 
   RowBox[{"\[Mu]lx", "\[Rule]", "7.268364417595763`"}], ",", 
   RowBox[{"\[Sigma]lx", "\[Rule]", "1.4130434376612693`"}], ",", 
   RowBox[{"\[Mu]rx", "\[Rule]", "97.16618798717042`"}], ",", 
   RowBox[{"\[Sigma]rx", "\[Rule]", "14.376608288840957`"}]}], 
  "}"}]], "Output",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBuKIvA9p136+cTz15ls2iBb84MB7HUj/undPesmvN452
xg9jvgDpVWe3F4DoZaK7fv38/cYxZGL80V9A2mrO+ct/gLTH3f3MDH/eOKYF
sWiD6JcvbjSAaKd+jb7Sv28c3xzbfQBEf/qdwFoGpBPvHJ0Aol+sVpoFov+k
K2wH0fxP/faC6AvmRw6BaKPyxeJe/944PnmnuwBEn5NQqy4E0jcYul6D6BSh
xJxJDG8d16wt2Aaia2bcW7cLSE/xvj2vW+it44o9pWc5hN86ZvSs+Qeiv9z7
r8wFpK85VaeDaA9Wib0g2nXdrDsg+t6h1cbcQPqxw7bt5kDa6VeDYzqQrokK
ywDRs+pzIvVF3zouPdsj0AykBS85MEeLvXW8/M22tw1IKz2I3QmiAY1Jvhk=

  "],
 CellLabel->
  "Out[221]=",ExpressionUUID->"5cbac3f1-f94f-4d82-93d5-1b06ceebdf38"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"plotIntensityFitPlatelets", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"datamerged", "[", 
         RowBox[{"[", 
          RowBox[{"1", ";;", 
           RowBox[{"-", "1"}]}], "]"}], "]"}], ",", 
        RowBox[{
         RowBox[{"calculateIntensitiesLR", "[", 
          RowBox[{
          "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r"}], 
          "]"}], "/.", "fitSlopeLRResult"}]}], "}"}], ",", " ", 
      RowBox[{"(*", 
       RowBox[{"Optional", ":", " ", 
        RowBox[{
        "Plot", " ", "every", " ", "2", "nd", " ", "point", " ", "only", " ", 
         "for", " ", "readibility"}], ":", " ", 
        RowBox[{"datamerged", "[", 
         RowBox[{"[", 
          RowBox[{"1", ";;", 
           RowBox[{"-", "1"}], ";;", "2"}], "]"}], "]"}]}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"5", " ", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}]}], ",", " ", 
           RowBox[{"10", "^", "0"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"10", "^", 
            RowBox[{"-", "6"}]}], ",", " ", 
           RowBox[{"10", "^", "4"}]}], "}"}]}], "}"}]}], ",", " ", 
      "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"False", ",", "True"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Black", ",", " ", 
           RowBox[{"PointSize", "[", "0.04", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.004", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           
           TemplateBox[<|
            "color" -> RGBColor[
              0.6745098039215687, 0.07450980392156863, 0.043137254901960784`]|>,
            "RGBColorSwatchTemplate"], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}]}], "}"}]}], ",", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
        "third", " ", "color", " ", "not", " ", "currently", " ", "used"}], 
        ",", " ", 
        RowBox[{
        "but", " ", "left", " ", "here", " ", "for", " ", "reference", " ", 
         "as", " ", "it", " ", "has", " ", "a", " ", "pretty", " ", "decent", 
         " ", "contrast", " ", "with", " ", "the", " ", "first", " ", 
         "color"}]}], " ", "*)"}], 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"ColorData", "[", "9", "]"}], "[", "i", "]"}], ",", 
            RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
            RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"i", ",", 
            RowBox[{"Length", "[", "datamerged", "]"}]}], "}"}]}], "]"}], 
        ","}], "*)"}], 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "Automatic"}], "}"}], ","}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}]}], "]"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"slopeFitParams", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
      "1.96", ",", " ", "0.193", ",", " ", "4.57", ",", " ", "0.147"}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"FitToPlot", " ", "=", " ", 
      RowBox[{
       RowBox[{"calculateIntensitiesLR", "[", 
        RowBox[{"\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r"}],
         "]"}], "/.", "fitSlopeLRResult"}]}], ";"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"FitToPlot", " ", "=", " ", 
     RowBox[{"calculateIntensitiesLR", "[", 
      RowBox[{
       RowBox[{"slopeFitParams", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
       RowBox[{"slopeFitParams", "[", 
        RowBox[{"[", "2", "]"}], "]"}], ",", 
       RowBox[{"slopeFitParams", "[", 
        RowBox[{"[", "3", "]"}], "]"}], ",", 
       RowBox[{"slopeFitParams", "[", 
        RowBox[{"[", "4", "]"}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotIntensityFitPlateletsA", " ", "=", " ", 
     RowBox[{"ListLogLogPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"datamerged", "[", 
         RowBox[{"[", 
          RowBox[{"1", ";;", 
           RowBox[{"-", "1"}]}], "]"}], "]"}], "}"}], ",", " ", 
       RowBox[{"(*", 
        RowBox[{"Optional", ":", " ", 
         RowBox[{
         "Plot", " ", "every", " ", "2", "nd", " ", "point", " ", "only", " ",
           "for", " ", "readibility"}], ":", " ", 
         RowBox[{"datamerged", "[", 
          RowBox[{"[", 
           RowBox[{"1", ";;", 
            RowBox[{"-", "1"}], ";;", "2"}], "]"}], "]"}]}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"5", " ", 
             RowBox[{"10", "^", 
              RowBox[{"-", "3"}]}]}], ",", " ", 
            RowBox[{"10", "^", "0"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}], ",", " ", 
            RowBox[{"10", "^", "4"}]}], "}"}]}], "}"}]}], ",", " ", 
       "\[IndentingNewLine]", 
       RowBox[{"Joined", "\[Rule]", 
        RowBox[{"{", "False", "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
       RowBox[{"FrameTicks", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
            RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
            RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"FrameLabel", " ", "->", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
           "\"\<\!\(\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
         "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotLegends", "->", 
        RowBox[{"{", "\"\<Binned data\>\"", "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"PlotStyle", "->", " ", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.01", "]"}]}], "}"}], "}"}]}], ",", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{
         "third", " ", "color", " ", "not", " ", "currently", " ", "used"}], 
         ",", " ", 
         RowBox[{
         "but", " ", "left", " ", "here", " ", "for", " ", "reference", " ", 
          "as", " ", "it", " ", "has", " ", "a", " ", "pretty", " ", "decent",
           " ", "contrast", " ", "with", " ", "the", " ", "first", " ", 
          "color"}]}], " ", "*)"}], 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"ColorData", "[", "9", "]"}], "[", "i", "]"}], ",", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
             RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"i", ",", 
             RowBox[{"Length", "[", "datamerged", "]"}]}], "}"}]}], "]"}], 
         ","}], "*)"}], 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", "Automatic"}], "}"}], ","}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"LabelStyle", "\[Rule]", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"FontSize", " ", "->", "  ", "14"}], ",", " ", "Black"}], 
         "}"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotIntensityFitPlateletsB", " ", "=", " ", 
     RowBox[{"ListLogLogPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"FitToPlot", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "300"}], "}"}]}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"(*", 
        RowBox[{"Optional", ":", " ", 
         RowBox[{
         "Plot", " ", "every", " ", "2", "nd", " ", "point", " ", "only", " ",
           "for", " ", "readibility"}], ":", " ", 
         RowBox[{"datamerged", "[", 
          RowBox[{"[", 
           RowBox[{"1", ";;", 
            RowBox[{"-", "1"}], ";;", "2"}], "]"}], "]"}]}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"Joined", "\[Rule]", 
        RowBox[{"{", "True", "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotStyle", "->", " ", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"Black", ",", " ", 
           RowBox[{"PointSize", "[", "0.04", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.006", "]"}]}], "}"}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"PlotLegends", "->", 
        RowBox[{"{", "\"\<Form factor fit\>\"", "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"LabelStyle", "\[Rule]", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"FontSize", " ", "->", "  ", "14"}], ",", " ", "Black"}], 
         "}"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"plotIntensityFitPlatelets", " ", "=", " ", 
    RowBox[{"Show", "[", 
     RowBox[{
     "plotIntensityFitPlateletsA", ",", " ", "plotIntensityFitPlateletsB"}], 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Export", "[", 
     RowBox[{
      RowBox[{"FileNameJoin", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
         "\"\<PlateletsIntensityFit.pdf\>\""}], "}"}], "]"}], ",", 
      "plotIntensityFitPlatelets"}], "]"}], "*)"}], "\n", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsIntensityFit.pdf\>\""}], "}"}], "]"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{"plotIntensityFitPlatelets", ",", " ", 
       RowBox[{"ImageSize", " ", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"8", " ", "cm"}], ",", " ", 
          RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"plotPlateletsFit", " ", "=", " ", 
     RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"slope", "[", 
          RowBox[{"datamerged", ",", "0.1"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{"slope", "[", 
           RowBox[{
            RowBox[{"calculateIntensitiesLR", "[", 
             RowBox[{
             "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r"}], 
             "]"}], "/.", "fitSlopeLRResult"}], "]"}], "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"slope", "[", 
          RowBox[{"calculateIntensitiesLR", "[", 
           RowBox[{
            RowBox[{"slopeFitParams", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
            RowBox[{"slopeFitParams", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ",", 
            RowBox[{"slopeFitParams", "[", 
             RowBox[{"[", "3", "]"}], "]"}], ",", 
            RowBox[{"slopeFitParams", "[", 
             RowBox[{"[", "4", "]"}], "]"}]}], "]"}], "]"}]}], 
        "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
       RowBox[{"FrameTicks", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
            RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"FrameLabel", " ", "->", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"\"\<Slope\>\"", ",", " ", "None"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
           "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
         "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotLegends", "->", 
        RowBox[{"{", 
         RowBox[{"\"\<Binned data\>\"", ",", " ", "\"\<Form factor fit\>\""}],
          "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"LabelStyle", "\[Rule]", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"FontSize", " ", "->", " ", "8"}], ",", " ", "Black"}], 
         "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotStyle", "->", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
            RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
            RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}],
            "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Black", ",", " ", 
            RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
            RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}],
            "}"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{
            
            TemplateBox[<|
             "color" -> RGBColor[
               0.6745098039215687, 0.07450980392156863, 
                0.043137254901960784`]|>,
             "RGBColorSwatchTemplate"], ",", 
            RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
            RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}],
            "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Joined", "->", 
        RowBox[{"{", 
         RowBox[{"False", ",", "True"}], "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotMarkers", "->", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "\"\<\>\"", ",", "\"\<\>\""}], "}"}]}]}], 
      "\[IndentingNewLine]", "]"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotPlateletsFitA", " ", "=", " ", 
     RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{"slope", "[", 
         RowBox[{"datamerged", ",", "0.15"}], "]"}], "\[IndentingNewLine]", 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"5", " ", 
             RowBox[{"10", "^", 
              RowBox[{"-", "3"}]}]}], ",", " ", 
            RowBox[{"10", "^", "1"}]}], "}"}], ",", "Automatic"}], "}"}]}], 
       ",", " ", "\[IndentingNewLine]", 
       RowBox[{"FrameTicks", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
            RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"FrameLabel", " ", "->", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"\"\<Slope\>\"", ",", " ", "None"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
           "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
         "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotLegends", "->", 
        RowBox[{"{", 
         RowBox[{"\"\<Binned data\>\"", ",", " ", "\"\<Form factor fit\>\""}],
          "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"LabelStyle", "\[Rule]", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
         "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotStyle", "->", " ", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Joined", "->", "False"}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotMarkers", "->", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "\"\<\>\"", ",", "\"\<\>\""}], "}"}]}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotPlateletsFitB", " ", "=", " ", 
     RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{"slope", "[", 
         RowBox[{"calculateIntensitiesLR", "[", 
          RowBox[{
           RowBox[{"slopeFitParams", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
           RowBox[{"slopeFitParams", "[", 
            RowBox[{"[", "2", "]"}], "]"}], ",", 
           RowBox[{"slopeFitParams", "[", 
            RowBox[{"[", "3", "]"}], "]"}], ",", 
           RowBox[{"slopeFitParams", "[", 
            RowBox[{"[", "4", "]"}], "]"}]}], "]"}], "]"}], 
        "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotLegends", "->", 
        RowBox[{"{", "\"\<Form factor fit\>\"", "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"LabelStyle", "\[Rule]", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
         "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotStyle", "->", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Black", ",", " ", 
            RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
            RowBox[{"Thickness", "[", "0.006", "]"}], ",", " ", "Automatic"}],
            "}"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{
            
            TemplateBox[<|
             "color" -> RGBColor[
               0.6745098039215687, 0.07450980392156863, 
                0.043137254901960784`]|>,
             "RGBColorSwatchTemplate"], ",", 
            RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
            RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}],
            "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Joined", "->", 
        RowBox[{"{", "True", "}"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Export", "[", 
     RowBox[{
      RowBox[{"FileNameJoin", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
         "\"\<PlateletsSlopeFit.pdf\>\""}], "}"}], "]"}], ",", 
      "plotPlateletsFit"}], "]"}], "*)"}], "\n", 
   RowBox[{"plotPlateletsFit", "=", " ", 
    RowBox[{"Show", "[", 
     RowBox[{"plotPlateletsFitA", ",", "plotPlateletsFitB"}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsSlopeFit.pdf\>\""}], "}"}], "]"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{"plotPlateletsFit", ",", " ", 
       RowBox[{"ImageSize", " ", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"8", "cm"}], ",", " ", 
          RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"10", " ", "cm"}], ",", " ", 
      RowBox[{"7", " ", "cm"}]}], "}"}], "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.9047023338026543`*^9, 3.904702351804372*^9}},
 CellLabel->
  "In[455]:=",ExpressionUUID->"a081bf6d-fc75-4d61-8275-b9a7a9751d2e"],

Cell[BoxData[
 TemplateBox[{
  "General", "munfl", 
   "\"\\!\\(\\*RowBox[{\\\"3.612357612415927`*^-307\\\", \\\" \\\", \
\\\"0.00671622684418331`\\\"}]\\) is too small to represent as a normalized \
machine number; precision may be lost.\"", 2, 456, 280, 17041620183885439602, 
   "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.904702357499141*^9},
 CellLabel->
  "During evaluation of \
In[455]:=",ExpressionUUID->"d93372e8-3f03-4912-984e-d56187165e73"],

Cell[BoxData[
 TemplateBox[{
  "General", "munfl", 
   "\"\\!\\(\\*RowBox[{\\\"3.1812392053683963`*^-308\\\", \\\" \\\", \
\\\"0.006413946842233205`\\\"}]\\) is too small to represent as a normalized \
machine number; precision may be lost.\"", 2, 456, 281, 17041620183885439602, 
   "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.904702357514942*^9},
 CellLabel->
  "During evaluation of \
In[455]:=",ExpressionUUID->"54fa59f3-145d-4a73-aa34-cdf9a7f3032e"],

Cell[BoxData[
 TemplateBox[{
  "General", "munfl", 
   "\"\\!\\(\\*RowBox[{\\\"6.892476780876325`*^-308\\\", \\\" \\\", \
\\\"0.001`\\\"}]\\) is too small to represent as a normalized machine number; \
precision may be lost.\"", 2, 456, 282, 17041620183885439602, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.904702357533103*^9},
 CellLabel->
  "During evaluation of \
In[455]:=",ExpressionUUID->"6af8eea8-0065-4d49-abeb-59d332f2b606"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"General\\\", \
\\\"::\\\", \\\"munfl\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 456, 283, 17041620183885439602, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.9047023575553255`*^9},
 CellLabel->
  "During evaluation of \
In[455]:=",ExpressionUUID->"26700b7d-df4f-4c1c-a3fd-6dab5868db91"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{}, {{{
         Directive[
          AbsoluteThickness[1.6], 
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01]], 
         PointBox[CompressedData["
1:eJwUl3dcjt8bx5+9n3pmqGREVJSUhHRfdklLGmSUiJRoKZSmChkpK0SUhGiI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